/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.audit;

import org.dcm4che3.audit.ActiveParticipant;
import org.dcm4che3.audit.AuditMessages;

public class ActiveParticipantBuilder {
    private final String userID;
    private AuditMessages.UserIDTypeCode userIDTypeCode;
    private String userTypeCode;
    private final String napID;
    private String napTypeCode;
    private String altUserID;
    private String userName;
    private boolean requester;
    private AuditMessages.MediaType mediaType;
    private AuditMessages.RoleIDCode[] roleIDCode = new AuditMessages.RoleIDCode[0];

    public ActiveParticipantBuilder(String userID, String napID) {
        this.userID = userID;
        this.napID = napID;
        this.napTypeCode = napID != null ? (AuditMessages.isIP(napID) ? "2" : "1") : null;
    }

    public ActiveParticipantBuilder userIDTypeCode(AuditMessages.UserIDTypeCode val) {
        this.userIDTypeCode = val;
        this.userTypeCode = ActiveParticipantBuilder.userTypeCode(val);
        return this;
    }

    public ActiveParticipantBuilder altUserID(String val) {
        this.altUserID = val;
        return this;
    }

    public ActiveParticipantBuilder userName(String val) {
        this.userName = val;
        return this;
    }

    public ActiveParticipantBuilder isRequester() {
        this.requester = true;
        return this;
    }

    public ActiveParticipantBuilder mediaType(AuditMessages.MediaType val) {
        this.mediaType = val;
        return this;
    }

    public ActiveParticipantBuilder roleIDCode(AuditMessages.RoleIDCode ... val) {
        this.roleIDCode = val;
        return this;
    }

    public ActiveParticipant build() {
        ActiveParticipant ap = new ActiveParticipant();
        ap.setUserID(this.userID);
        ap.setUserIDTypeCode(this.userIDTypeCode);
        ap.setUserTypeCode(this.userTypeCode);
        ap.setAlternativeUserID(this.altUserID);
        ap.setUserName(this.userName);
        ap.setUserIsRequestor(this.requester);
        ap.setNetworkAccessPointID(this.napID);
        ap.setNetworkAccessPointTypeCode(this.napTypeCode);
        ap.setMediaType(this.mediaType);
        for (AuditMessages.RoleIDCode roleID : this.roleIDCode) {
            ap.getRoleIDCode().add(roleID);
        }
        return ap;
    }

    private static String userTypeCode(AuditMessages.UserIDTypeCode userIDTypeCode) {
        return userIDTypeCode == AuditMessages.UserIDTypeCode.NodeID || userIDTypeCode == AuditMessages.UserIDTypeCode.PersonID ? "1" : "2";
    }
}

