/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.audit;

import java.util.Calendar;
import org.dcm4che3.audit.AuditMessages;
import org.dcm4che3.audit.EventIdentification;
import org.dcm4che3.audit.EventTypeCode;

public class EventIdentificationBuilder {
    private final AuditMessages.EventID eventID;
    private final String eventActionCode;
    private final Calendar eventDateTime;
    private final String outcome;
    private String outcomeDesc;
    private EventTypeCode[] eventTypeCode = new EventTypeCode[0];

    public EventIdentificationBuilder(AuditMessages.EventID eventID, String eventActionCode, Calendar eventDateTime, String outcome) {
        this.eventID = eventID;
        this.eventActionCode = eventActionCode;
        this.eventDateTime = eventDateTime;
        this.outcome = outcome;
    }

    public EventIdentificationBuilder outcomeDesc(String val) {
        this.outcomeDesc = val;
        return this;
    }

    public EventIdentificationBuilder eventTypeCode(EventTypeCode ... val) {
        this.eventTypeCode = val;
        return this;
    }

    public EventIdentification build() {
        EventIdentification ei = new EventIdentification();
        ei.setEventID(this.eventID);
        ei.setEventActionCode(this.eventActionCode);
        ei.setEventDateTime(this.eventDateTime);
        ei.setEventOutcomeIndicator(this.outcome);
        ei.setEventOutcomeDescription(this.outcomeDesc);
        for (EventTypeCode type : this.eventTypeCode) {
            ei.getEventTypeCode().add(type);
        }
        return ei;
    }
}

