/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.audit;

import java.util.HashSet;
import org.dcm4che3.audit.Accession;
import org.dcm4che3.audit.MPPS;
import org.dcm4che3.audit.ParticipantObjectContainsStudy;
import org.dcm4che3.audit.ParticipantObjectDescription;
import org.dcm4che3.audit.SOPClass;
import org.dcm4che3.audit.StudyIDs;

public class ParticipantObjectDescriptionBuilder {
    private Boolean encrypted;
    private Boolean anonymized;
    private String[] pocsStudyUIDs = new String[0];
    private String[] accNumbers = new String[0];
    private String[] mppsUIDs = new String[0];
    private SOPClass[] sopClasses = new SOPClass[0];

    public ParticipantObjectDescriptionBuilder acc(String ... val) {
        this.accNumbers = val;
        return this;
    }

    public ParticipantObjectDescriptionBuilder mpps(String ... val) {
        this.mppsUIDs = val;
        return this;
    }

    public ParticipantObjectDescriptionBuilder sopC(SOPClass ... val) {
        this.sopClasses = val;
        return this;
    }

    public ParticipantObjectDescriptionBuilder pocsStudyUIDs(String ... val) {
        this.pocsStudyUIDs = val;
        return this;
    }

    public ParticipantObjectDescriptionBuilder encrypted(Boolean val) {
        this.encrypted = val;
        return this;
    }

    ParticipantObjectDescriptionBuilder ParticipantObjectDescriptionBuilder(Boolean val) {
        this.anonymized = val;
        return this;
    }

    public ParticipantObjectDescription build() {
        ParticipantObjectDescription pod = new ParticipantObjectDescription();
        for (String acc : this.accNumbers) {
            pod.getAccession().add(ParticipantObjectDescriptionBuilder.createAccession(acc));
        }
        for (String mpps : this.mppsUIDs) {
            pod.getMPPS().add(ParticipantObjectDescriptionBuilder.createMPPS(mpps));
        }
        for (SOPClass sopC : this.sopClasses) {
            pod.getSOPClass().add(sopC);
        }
        pod.setEncrypted(this.encrypted);
        pod.setAnonymized(this.anonymized);
        if (this.pocsStudyUIDs.length > 1) {
            pod.setParticipantObjectContainsStudy(ParticipantObjectDescriptionBuilder.createParticipantObjectContainsStudy(ParticipantObjectDescriptionBuilder.createStudyIDs(this.pocsStudyUIDs)));
        }
        return pod;
    }

    private static Accession createAccession(String accessionNumber) {
        Accession accession = new Accession();
        accession.setNumber(accessionNumber);
        return accession;
    }

    private static MPPS createMPPS(String uid) {
        MPPS mpps = new MPPS();
        mpps.setUID(uid);
        return mpps;
    }

    private static ParticipantObjectContainsStudy createParticipantObjectContainsStudy(StudyIDs ... studyIDs) {
        ParticipantObjectContainsStudy study = new ParticipantObjectContainsStudy();
        for (StudyIDs studyID : studyIDs) {
            study.getStudyIDs().add(studyID);
        }
        return study;
    }

    private static StudyIDs[] createStudyIDs(String ... studyUIDs) {
        HashSet<StudyIDs> set = new HashSet<StudyIDs>();
        for (String s : studyUIDs) {
            StudyIDs sID = new StudyIDs();
            sID.setUID(s);
            set.add(sID);
        }
        return set.toArray(new StudyIDs[set.size()]);
    }
}

