/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.audit;

import org.dcm4che3.audit.AuditMessages;
import org.dcm4che3.audit.ParticipantObjectDescription;
import org.dcm4che3.audit.ParticipantObjectDetail;
import org.dcm4che3.audit.ParticipantObjectIdentification;

public class ParticipantObjectIdentificationBuilder {
    private final String id;
    private final AuditMessages.ParticipantObjectIDTypeCode idType;
    private String name;
    private byte[] query;
    private String type;
    private String role;
    private String lifeCycle;
    private String sensitivity;
    private ParticipantObjectDescription desc;
    private ParticipantObjectDetail[] detail = new ParticipantObjectDetail[0];

    public ParticipantObjectIdentificationBuilder(String id, AuditMessages.ParticipantObjectIDTypeCode idType, String type, String role) {
        this.id = id;
        this.idType = idType;
        this.type = type;
        this.role = role;
    }

    public ParticipantObjectIdentificationBuilder name(String val) {
        this.name = val;
        return this;
    }

    public ParticipantObjectIdentificationBuilder query(byte[] val) {
        this.query = val;
        return this;
    }

    public ParticipantObjectIdentificationBuilder lifeCycle(String val) {
        this.lifeCycle = val;
        return this;
    }

    public ParticipantObjectIdentificationBuilder sensitivity(String val) {
        this.sensitivity = val;
        return this;
    }

    public ParticipantObjectIdentificationBuilder desc(ParticipantObjectDescription val) {
        this.desc = val;
        return this;
    }

    public ParticipantObjectIdentificationBuilder detail(ParticipantObjectDetail ... val) {
        this.detail = val;
        return this;
    }

    public ParticipantObjectIdentification build() {
        ParticipantObjectIdentification poi = new ParticipantObjectIdentification();
        poi.setParticipantObjectID(this.id);
        poi.setParticipantObjectIDTypeCode(this.idType);
        poi.setParticipantObjectName(this.name);
        poi.setParticipantObjectQuery(this.query);
        poi.setParticipantObjectTypeCode(this.type);
        poi.setParticipantObjectTypeCodeRole(this.role);
        poi.setParticipantObjectDataLifeCycle(this.lifeCycle);
        poi.setParticipantObjectSensitivity(this.sensitivity);
        if (this.desc != null) {
            poi.setParticipantObjectDescription(this.desc);
        }
        for (ParticipantObjectDetail participantObjectDetail : this.detail) {
            poi.getParticipantObjectDetail().add(participantObjectDetail);
        }
        return poi;
    }
}

