/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.conf.api;

import org.dcm4che3.conf.api.ConfigurationCache;
import org.dcm4che3.conf.api.ConfigurationException;
import org.dcm4che3.conf.api.ConfigurationNotFoundException;
import org.dcm4che3.conf.api.DicomConfiguration;
import org.dcm4che3.conf.api.IApplicationEntityCache;
import org.dcm4che3.net.ApplicationEntity;

public class ApplicationEntityCache
extends ConfigurationCache<DicomConfiguration, ApplicationEntity>
implements IApplicationEntityCache {
    public ApplicationEntityCache(DicomConfiguration conf) {
        super(conf);
    }

    @Override
    protected ApplicationEntity find(DicomConfiguration conf, String key) throws ConfigurationException {
        return conf.findApplicationEntity(key);
    }

    @Override
    public ApplicationEntity findApplicationEntity(String aet) throws ConfigurationException {
        ApplicationEntity ae = (ApplicationEntity)this.get(aet);
        if (ae == null) {
            throw new ConfigurationNotFoundException("Unknown AE: " + aet);
        }
        if (!ae.isInstalled()) {
            throw new ConfigurationNotFoundException("AE: " + aet + " not installed");
        }
        return ae;
    }
}

