/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.conf.api;

import java.io.Serializable;
import java.util.Arrays;
import org.dcm4che3.net.Dimse;
import org.dcm4che3.net.TransferCapability;
import org.dcm4che3.util.StringUtils;
import org.dcm4che3.util.UIDUtils;

public class AttributeCoercion
implements Serializable,
Comparable<AttributeCoercion> {
    private static final long serialVersionUID = 7799241531490684097L;
    private final String commonName;
    private final Condition condition;
    private final String uri;

    public AttributeCoercion(String commonName, String[] sopClasses, Dimse dimse, TransferCapability.Role role, String[] aeTitles, String uri) {
        if (commonName == null) {
            throw new NullPointerException("commonName");
        }
        if (commonName.isEmpty()) {
            throw new IllegalArgumentException("commonName cannot be empty");
        }
        this.commonName = commonName;
        this.condition = new Condition(StringUtils.maskNull((String[])sopClasses), dimse, role, StringUtils.maskNull((String[])aeTitles));
        this.uri = uri;
    }

    public final String getCommonName() {
        return this.commonName;
    }

    public final String[] getSOPClasses() {
        return this.condition.sopClasses;
    }

    public final Dimse getDIMSE() {
        return this.condition.dimse;
    }

    public final TransferCapability.Role getRole() {
        return this.condition.role;
    }

    public final String[] getAETitles() {
        return this.condition.aeTitles;
    }

    public final String getURI() {
        return this.uri;
    }

    public boolean matchesCondition(String sopClass, Dimse dimse, TransferCapability.Role role, String aeTitle) {
        return this.condition.matches(sopClass, dimse, role, aeTitle);
    }

    @Override
    public int compareTo(AttributeCoercion o) {
        return this.condition.compareTo(o.condition);
    }

    public String toString() {
        return this.promptTo(new StringBuilder(64), "").toString();
    }

    public StringBuilder promptTo(StringBuilder sb, String indent) {
        String indent2 = indent + "  ";
        StringUtils.appendLine((StringBuilder)sb, (Object[])new Object[]{indent, "AttributeCoercion[cn: ", this.commonName});
        StringUtils.appendLine((StringBuilder)sb, (Object[])new Object[]{indent2, "dimse: ", this.condition.dimse});
        StringUtils.appendLine((StringBuilder)sb, (Object[])new Object[]{indent2, "role: ", this.condition.role});
        AttributeCoercion.promptCUIDsTo(sb, indent2, this.condition.sopClasses);
        AttributeCoercion.promptAETsTo(sb, indent2, this.condition.aeTitles);
        StringUtils.appendLine((StringBuilder)sb, (Object[])new Object[]{indent2, "cuids: ", Arrays.toString(this.condition.sopClasses)});
        StringUtils.appendLine((StringBuilder)sb, (Object[])new Object[]{indent2, "aets: ", Arrays.toString(this.condition.aeTitles)});
        StringUtils.appendLine((StringBuilder)sb, (Object[])new Object[]{indent2, "uri: ", this.uri});
        return sb.append(indent).append(']');
    }

    private static void promptCUIDsTo(StringBuilder sb, String indent, String[] cuids) {
        if (cuids.length == 0) {
            return;
        }
        sb.append(indent).append("cuids: ");
        for (String cuid : cuids) {
            UIDUtils.promptTo((String)cuid, (StringBuilder)sb).append(',');
        }
        sb.setLength(sb.length() - 1);
        sb.append(StringUtils.LINE_SEPARATOR);
    }

    private static void promptAETsTo(StringBuilder sb, String indent, String[] aets) {
        if (aets.length == 0) {
            return;
        }
        sb.append(indent).append("aets: ");
        for (String aet : aets) {
            sb.append(aet).append(',');
        }
        sb.setLength(sb.length() - 1);
        sb.append(StringUtils.LINE_SEPARATOR);
    }

    private static class Condition
    implements Serializable,
    Comparable<Condition> {
        private static final long serialVersionUID = -8993828886666689060L;
        final String[] sopClasses;
        final Dimse dimse;
        final TransferCapability.Role role;
        final String[] aeTitles;
        final int weight;

        public Condition(String[] sopClasses, Dimse dimse, TransferCapability.Role role, String[] aeTitles) {
            if (dimse == null) {
                throw new NullPointerException("dimse");
            }
            if (role == null) {
                throw new NullPointerException("role");
            }
            this.sopClasses = sopClasses;
            this.dimse = dimse;
            this.role = role;
            this.aeTitles = aeTitles;
            this.weight = (aeTitles.length != 0 ? 2 : 0) + (sopClasses.length != 0 ? 1 : 0);
        }

        @Override
        public int compareTo(Condition o) {
            return o.weight - this.weight;
        }

        public boolean matches(String sopClass, Dimse dimse, TransferCapability.Role role, String aeTitle) {
            return this.dimse == dimse && this.role == role && Condition.isEmptyOrContains(this.aeTitles, aeTitle) && Condition.isEmptyOrContains(this.sopClasses, sopClass);
        }

        private static boolean isEmptyOrContains(Object[] a, Object o) {
            if (o == null || a.length == 0) {
                return true;
            }
            for (int i = 0; i < a.length; ++i) {
                if (!o.equals(a[i])) continue;
                return true;
            }
            return false;
        }
    }
}

