/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.conf.api;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.dcm4che3.conf.api.AttributeCoercion;
import org.dcm4che3.net.Dimse;
import org.dcm4che3.net.TransferCapability;

public class AttributeCoercions
implements Iterable<AttributeCoercion>,
Serializable {
    private static final long serialVersionUID = -1960600890844978686L;
    private final ArrayList<AttributeCoercion> list = new ArrayList();

    public void add(AttributeCoercion ac) {
        if (this.findByCommonName(ac.getCommonName()) != null) {
            throw new IllegalStateException("AttributeCoercion with cn: '" + ac.getCommonName() + "' already exists");
        }
        int index = Collections.binarySearch(this.list, ac);
        if (index < 0) {
            index = -(index + 1);
        }
        this.list.add(index, ac);
    }

    public void add(AttributeCoercions acs) {
        for (AttributeCoercion ac : acs.list) {
            this.add(ac);
        }
    }

    public boolean remove(AttributeCoercion ac) {
        return this.list.remove(ac);
    }

    public void clear() {
        this.list.clear();
    }

    public AttributeCoercion findByCommonName(String commonName) {
        for (AttributeCoercion ac : this.list) {
            if (!commonName.equals(ac.getCommonName())) continue;
            return ac;
        }
        return null;
    }

    public AttributeCoercion findAttributeCoercion(String sopClass, Dimse dimse, TransferCapability.Role role, String aeTitle) {
        for (AttributeCoercion ac : this.list) {
            if (!ac.matchesCondition(sopClass, dimse, role, aeTitle)) continue;
            return ac;
        }
        return null;
    }

    @Override
    public Iterator<AttributeCoercion> iterator() {
        return this.list.iterator();
    }
}

