/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.conf.api;

import java.util.ArrayList;
import java.util.List;

public class ConfigurationChanges {
    private final List<ModifiedObject> objects = new ArrayList<ModifiedObject>();
    private final boolean verbose;

    public ConfigurationChanges(boolean verbose) {
        this.verbose = verbose;
    }

    public static <T> T nullifyIfNotVerbose(ConfigurationChanges diffs, T obj) {
        return diffs != null && diffs.isVerbose() ? (T)obj : null;
    }

    public static ModifiedObject addModifiedObjectIfVerbose(ConfigurationChanges diffs, String dn, ChangeType changeType) {
        if (diffs == null || !diffs.isVerbose()) {
            return null;
        }
        ModifiedObject object = new ModifiedObject(dn, changeType);
        diffs.add(object);
        return object;
    }

    public static ModifiedObject addModifiedObject(ConfigurationChanges diffs, String dn, ChangeType changeType) {
        if (diffs == null) {
            return null;
        }
        ModifiedObject object = new ModifiedObject(dn, changeType);
        diffs.add(object);
        return object;
    }

    public static void removeLastIfEmpty(ConfigurationChanges diffs, ModifiedObject obj) {
        if (obj != null && obj.isEmpty()) {
            diffs.removeLast();
        }
    }

    private void removeLast() {
        this.objects.remove(this.objects.size() - 1);
    }

    public List<ModifiedObject> modifiedObjects() {
        return this.objects;
    }

    public void add(ModifiedObject object) {
        this.objects.add(object);
    }

    public boolean isEmpty() {
        return this.objects.isEmpty();
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder(this.objects.size() * 64);
        for (ModifiedObject obj : this.objects) {
            sb.append((Object)obj.changeType).append(' ').append(obj.dn).append('\n');
            if (obj.attributes == null) continue;
            for (ModifiedAttribute attr : obj.attributes) {
                sb.append("  ").append(attr.name).append(": ").append(attr.removedValues).append("=>").append(attr.addedValues).append('\n');
            }
        }
        return sb.toString();
    }

    public static class ModifiedObject {
        private final String dn;
        private final ChangeType changeType;
        private final List<ModifiedAttribute> attributes = new ArrayList<ModifiedAttribute>();

        public ModifiedObject(String dn, ChangeType changeType) {
            this.dn = dn;
            this.changeType = changeType;
        }

        public String dn() {
            return this.dn;
        }

        public ChangeType changeType() {
            return this.changeType;
        }

        public boolean isEmpty() {
            return this.attributes.isEmpty();
        }

        public List<ModifiedAttribute> modifiedAttributes() {
            return this.attributes;
        }

        public void add(ModifiedAttribute attribute) {
            this.attributes.add(attribute);
        }
    }

    public static enum ChangeType {
        C,
        U,
        D;

    }

    public static class ModifiedAttribute {
        private final String name;
        private final List<Object> addedValues = new ArrayList<Object>(1);
        private final List<Object> removedValues = new ArrayList<Object>(1);

        public ModifiedAttribute(String name) {
            this.name = name;
        }

        public ModifiedAttribute(String name, Object prev, Object val) {
            this.name = name;
            this.removeValue(prev);
            this.addValue(val);
        }

        public String name() {
            return this.name;
        }

        public List<Object> addedValues() {
            return this.addedValues;
        }

        public List<Object> removedValues() {
            return this.removedValues;
        }

        public void addValue(Object value) {
            if (value != null && !this.removedValues.remove(value)) {
                this.addedValues.add(value);
            }
        }

        public void removeValue(Object value) {
            if (value != null && !this.addedValues.remove(value)) {
                this.removedValues.add(value);
            }
        }
    }
}

