/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.conf.api;

import org.dcm4che3.conf.api.ConfigurationCache;
import org.dcm4che3.conf.api.ConfigurationException;
import org.dcm4che3.conf.api.ConfigurationNotFoundException;
import org.dcm4che3.conf.api.DicomConfiguration;
import org.dcm4che3.conf.api.IDeviceCache;
import org.dcm4che3.net.Device;

public class DeviceCache
extends ConfigurationCache<DicomConfiguration, Device>
implements IDeviceCache {
    public DeviceCache(DicomConfiguration conf) {
        super(conf);
    }

    @Override
    protected Device find(DicomConfiguration conf, String key) throws ConfigurationException {
        return conf.findDevice(key);
    }

    @Override
    public Device findDevice(String deviceName) throws ConfigurationException {
        Device device = (Device)this.get(deviceName);
        if (device == null) {
            throw new ConfigurationNotFoundException("Unknown Device: " + deviceName);
        }
        if (!device.isInstalled()) {
            throw new ConfigurationNotFoundException("Device: " + deviceName + " not installed");
        }
        return device;
    }
}

