/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.conf.api;

import java.io.Closeable;
import java.security.cert.X509Certificate;
import java.util.EnumSet;
import org.dcm4che3.conf.api.ConfigurationChanges;
import org.dcm4che3.conf.api.ConfigurationException;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.net.ApplicationEntityInfo;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.DeviceInfo;
import org.dcm4che3.net.WebApplication;
import org.dcm4che3.net.WebApplicationInfo;

public interface DicomConfiguration
extends Closeable {
    public WebApplicationInfo[] listWebApplicationInfos(WebApplicationInfo var1) throws ConfigurationException;

    public boolean configurationExists() throws ConfigurationException;

    public boolean purgeConfiguration() throws ConfigurationException;

    public boolean registerAETitle(String var1) throws ConfigurationException;

    public boolean registerWebAppName(String var1) throws ConfigurationException;

    public void unregisterAETitle(String var1) throws ConfigurationException;

    public void unregisterWebAppName(String var1) throws ConfigurationException;

    public ApplicationEntity findApplicationEntity(String var1) throws ConfigurationException;

    public WebApplication findWebApplication(String var1) throws ConfigurationException;

    public Device findDevice(String var1) throws ConfigurationException;

    public DeviceInfo[] listDeviceInfos(DeviceInfo var1) throws ConfigurationException;

    public ApplicationEntityInfo[] listAETInfos(ApplicationEntityInfo var1) throws ConfigurationException;

    public String[] listDeviceNames() throws ConfigurationException;

    public String[] listRegisteredAETitles() throws ConfigurationException;

    public String[] listRegisteredWebAppNames() throws ConfigurationException;

    public ConfigurationChanges persist(Device var1, EnumSet<Option> var2) throws ConfigurationException;

    public ConfigurationChanges merge(Device var1, EnumSet<Option> var2) throws ConfigurationException;

    public ConfigurationChanges removeDevice(String var1, EnumSet<Option> var2) throws ConfigurationException;

    public byte[][] loadDeviceVendorData(String var1) throws ConfigurationException;

    public ConfigurationChanges updateDeviceVendorData(String var1, byte[] ... var2) throws ConfigurationException;

    public String deviceRef(String var1);

    public void persistCertificates(String var1, X509Certificate ... var2) throws ConfigurationException;

    public void removeCertificates(String var1) throws ConfigurationException;

    public X509Certificate[] findCertificates(String var1) throws ConfigurationException;

    @Override
    public void close();

    public void sync() throws ConfigurationException;

    public <T> T getDicomConfigurationExtension(Class<T> var1);

    public static enum Option {
        REGISTER,
        PRESERVE_VENDOR_DATA,
        PRESERVE_CERTIFICATE,
        CONFIGURATION_CHANGES,
        CONFIGURATION_CHANGES_VERBOSE;

    }
}

