/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.conf.api;

import org.dcm4che3.conf.api.ConfigurationCache;
import org.dcm4che3.conf.api.ConfigurationException;
import org.dcm4che3.conf.api.ConfigurationNotFoundException;
import org.dcm4che3.conf.api.DicomConfiguration;
import org.dcm4che3.conf.api.IWebApplicationCache;
import org.dcm4che3.net.WebApplication;

public class WebApplicationCache
extends ConfigurationCache<DicomConfiguration, WebApplication>
implements IWebApplicationCache {
    public WebApplicationCache(DicomConfiguration conf) {
        super(conf);
    }

    @Override
    protected WebApplication find(DicomConfiguration conf, String key) throws ConfigurationException {
        return conf.findWebApplication(key);
    }

    @Override
    public WebApplication findWebApplication(String name) throws ConfigurationException {
        WebApplication webApp = (WebApplication)this.get(name);
        if (webApp == null) {
            throw new ConfigurationNotFoundException("Unknown WebApplication: " + name);
        }
        if (!webApp.isInstalled()) {
            throw new ConfigurationNotFoundException("WebApplication: " + name + " not installed");
        }
        return webApp;
    }
}

