/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.conf.ldap;

import java.io.ByteArrayInputStream;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.dcm4che3.conf.api.AETitleAlreadyExistsException;
import org.dcm4che3.conf.api.AttributeCoercion;
import org.dcm4che3.conf.api.AttributeCoercions;
import org.dcm4che3.conf.api.ConfigurationAlreadyExistsException;
import org.dcm4che3.conf.api.ConfigurationChanges;
import org.dcm4che3.conf.api.ConfigurationException;
import org.dcm4che3.conf.api.ConfigurationNotFoundException;
import org.dcm4che3.conf.api.DicomConfiguration;
import org.dcm4che3.conf.api.WebAppAlreadyExistsException;
import org.dcm4che3.conf.ldap.LdapDicomConfigurationExtension;
import org.dcm4che3.conf.ldap.LdapUtils;
import org.dcm4che3.conf.ldap.ReconnectDirContext;
import org.dcm4che3.conf.ldap.ResourceManager;
import org.dcm4che3.data.AttributeSelector;
import org.dcm4che3.data.Code;
import org.dcm4che3.io.BasicBulkDataDescriptor;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.net.ApplicationEntityInfo;
import org.dcm4che3.net.Connection;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.DeviceInfo;
import org.dcm4che3.net.Dimse;
import org.dcm4che3.net.KeycloakClient;
import org.dcm4che3.net.QueryOption;
import org.dcm4che3.net.StorageOptions;
import org.dcm4che3.net.TransferCapability;
import org.dcm4che3.net.WebApplication;
import org.dcm4che3.net.WebApplicationInfo;
import org.dcm4che3.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LdapDicomConfiguration
implements DicomConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(LdapDicomConfiguration.class);
    private static final String CN_UNIQUE_AE_TITLES_REGISTRY = "cn=Unique AE Titles Registry,";
    private static final String CN_UNIQUE_WEB_APP_NAMES_REGISTRY = "cn=Unique Web Application Names Registry,";
    private static final String CN_DEVICES = "cn=Devices,";
    private static final String DICOM_CONFIGURATION = "DICOM Configuration";
    private static final String DICOM_CONFIGURATION_ROOT = "dicomConfigurationRoot";
    private static final String PKI_USER = "pkiUser";
    private static final String USER_CERTIFICATE_BINARY = "userCertificate;binary";
    private static final X509Certificate[] EMPTY_X509_CERTIFICATES = new X509Certificate[0];
    private final ReconnectDirContext ctx;
    private final String baseDN;
    private String configurationDN;
    private String devicesDN;
    private String aetsRegistryDN;
    private String webAppsRegistryDN;
    private String configurationCN = "DICOM Configuration";
    private String configurationRoot = "dicomConfigurationRoot";
    private String pkiUser = "pkiUser";
    private String userCertificate = "userCertificate;binary";
    private boolean extended = true;
    private final List<LdapDicomConfigurationExtension> extensions = new ArrayList<LdapDicomConfigurationExtension>();
    private ThreadLocal<Map<String, Device>> currentlyLoadedDevicesLocal = new ThreadLocal();
    static final String[] AE_ATTRS = new String[]{"dicomDeviceName", "dicomAETitle", "dcmOtherAETitle", "dicomDescription", "dicomAssociationInitiator", "dicomAssociationAcceptor", "dicomApplicationCluster", "dicomInstalled", "hl7ApplicationName", "dicomNetworkConnectionReference"};
    static final String[] WEBAPP_ATTRS = new String[]{"dicomDeviceName", "dcmWebAppName", "dcmWebServicePath", "dcmWebServiceClass", "dcmKeycloakClientID", "dicomAETitle", "dicomDescription", "dicomApplicationCluster", "dcmProperty", "dicomInstalled", "dicomNetworkConnectionReference"};

    public LdapDicomConfiguration() throws ConfigurationException {
        this(ResourceManager.getInitialEnvironment());
    }

    public LdapDicomConfiguration(Hashtable<?, ?> env) throws ConfigurationException {
        Hashtable<String, String> map = new Hashtable<String, String>();
        for (Map.Entry<?, ?> entry : env.entrySet()) {
            map.put((String)entry.getKey(), StringUtils.replaceSystemProperties((String)((String)entry.getValue())));
        }
        try {
            String s = (String)map.get("java.naming.provider.url");
            int end = s.lastIndexOf(47);
            map.put("java.naming.provider.url", s.substring(0, end));
            this.baseDN = s.substring(end + 1);
            this.ctx = new ReconnectDirContext(map);
        }
        catch (Exception e) {
            throw new ConfigurationException((Throwable)e);
        }
    }

    public final boolean isExtended() {
        return this.extended;
    }

    public final void setExtended(boolean extended) {
        this.extended = extended;
    }

    public final void setConfigurationCN(String configurationCN) {
        this.configurationCN = configurationCN;
    }

    public final String getConfigurationCN() {
        return this.configurationCN;
    }

    public final void setConfigurationRoot(String configurationRoot) {
        this.configurationRoot = configurationRoot;
    }

    public final String getConfigurationRoot() {
        return this.configurationRoot;
    }

    public void setPkiUser(String pkiUser) {
        this.pkiUser = pkiUser;
    }

    public String getPkiUser() {
        return this.pkiUser;
    }

    public void setUserCertificate(String userCertificate) {
        this.userCertificate = userCertificate;
    }

    public String getUserCertificate() {
        return this.userCertificate;
    }

    public void addDicomConfigurationExtension(LdapDicomConfigurationExtension ext) {
        ext.setDicomConfiguration(this);
        this.extensions.add(ext);
    }

    public boolean removeDicomConfigurationExtension(LdapDicomConfigurationExtension ext) {
        if (!this.extensions.remove(ext)) {
            return false;
        }
        ext.setDicomConfiguration(null);
        return true;
    }

    public <T> T getDicomConfigurationExtension(Class<T> clazz) {
        for (LdapDicomConfigurationExtension ext : this.extensions) {
            if (!clazz.isInstance(ext)) continue;
            return (T)ext;
        }
        return null;
    }

    public synchronized void close() {
        this.ctx.close();
    }

    public synchronized boolean configurationExists() throws ConfigurationException {
        return this.configurationDN != null || this.findConfiguration();
    }

    public boolean exists(String dn) throws NamingException {
        try {
            this.ctx.getAttributes(dn);
            return true;
        }
        catch (NameNotFoundException e) {
            return false;
        }
    }

    public synchronized boolean purgeConfiguration() throws ConfigurationException {
        if (!this.configurationExists()) {
            return false;
        }
        try {
            this.destroySubcontextWithChilds(this.configurationDN);
            LOG.info("Purge DICOM Configuration at {}", (Object)this.configurationDN);
            this.clearConfigurationDN();
        }
        catch (NamingException e) {
            throw new ConfigurationException((Throwable)e);
        }
        return true;
    }

    public synchronized boolean registerAETitle(String aet) throws ConfigurationException {
        this.ensureConfigurationExists();
        try {
            this.registerAET(aet);
            return true;
        }
        catch (AETitleAlreadyExistsException e) {
            return false;
        }
    }

    public synchronized boolean registerWebAppName(String webAppName) throws ConfigurationException {
        this.ensureConfigurationExists();
        try {
            this.registerWebApp(webAppName);
            return true;
        }
        catch (WebAppAlreadyExistsException e) {
            return false;
        }
    }

    private String registerAET(String aet) throws ConfigurationException {
        try {
            String dn = LdapDicomConfiguration.aetDN(aet, this.aetsRegistryDN);
            this.createSubcontext(dn, LdapUtils.attrs("dicomUniqueAETitle", "dicomAETitle", aet));
            return dn;
        }
        catch (NameAlreadyBoundException e) {
            throw new AETitleAlreadyExistsException("AE Title '" + aet + "' already exists");
        }
        catch (NamingException e) {
            throw new ConfigurationException((Throwable)e);
        }
    }

    private String registerWebApp(String webAppName) throws ConfigurationException {
        try {
            String dn = LdapDicomConfiguration.webAppDN(webAppName, this.webAppsRegistryDN);
            this.createSubcontext(dn, LdapUtils.attrs("dcmUniqueWebAppName", "dcmWebAppName", webAppName));
            return dn;
        }
        catch (NameAlreadyBoundException e) {
            throw new WebAppAlreadyExistsException("Web Application '" + webAppName + "' already exists");
        }
        catch (NamingException e) {
            throw new ConfigurationException((Throwable)e);
        }
    }

    public synchronized void unregisterAETitle(String aet) throws ConfigurationException {
        if (this.configurationExists()) {
            try {
                this.ctx.destroySubcontext(LdapDicomConfiguration.aetDN(aet, this.aetsRegistryDN));
            }
            catch (NameNotFoundException nameNotFoundException) {
            }
            catch (NamingException e) {
                throw new ConfigurationException((Throwable)e);
            }
        }
    }

    public synchronized void unregisterWebAppName(String webAppName) throws ConfigurationException {
        if (this.configurationExists()) {
            try {
                this.ctx.destroySubcontext(LdapDicomConfiguration.webAppDN(webAppName, this.webAppsRegistryDN));
            }
            catch (NameNotFoundException nameNotFoundException) {
            }
            catch (NamingException e) {
                throw new ConfigurationException((Throwable)e);
            }
        }
    }

    public synchronized ApplicationEntity findApplicationEntity(String aet) throws ConfigurationException {
        return this.findDevice("(&(objectclass=dicomNetworkAE)(dicomAETitle=" + aet + "))", aet).getApplicationEntity(aet);
    }

    public synchronized WebApplication findWebApplication(String name) throws ConfigurationException {
        return this.findDevice("(&(objectclass=dcmWebApp)(dcmWebAppName=" + name + "))", name).getWebApplication(name);
    }

    public synchronized Device findDevice(String filter, String childName) throws ConfigurationException {
        String childDN;
        if (!this.configurationExists()) {
            throw new ConfigurationNotFoundException();
        }
        SearchControls ctls = this.searchControlSubtreeScope(1, StringUtils.EMPTY_STRING, false);
        NamingEnumeration<SearchResult> ne = null;
        try {
            ne = this.ctx.search(this.devicesDN, filter, ctls);
            if (!ne.hasMore()) {
                throw new ConfigurationNotFoundException(childName);
            }
            childDN = ne.next().getNameInNamespace();
        }
        catch (NamingException e) {
            throw new ConfigurationException((Throwable)e);
        }
        finally {
            LdapUtils.safeClose(ne);
        }
        String deviceDN = childDN.substring(childDN.indexOf(44) + 1);
        return this.loadDevice(deviceDN);
    }

    public Connection findConnection(String connDN, Map<String, Connection> cache) throws NamingException, ConfigurationException {
        Connection conn = cache.get(connDN);
        if (conn == null) {
            try {
                String[] attrIds = new String[]{"dicomHostname", "dicomPort", "dicomTLSCipherSuite", "dicomInstalled"};
                Attributes attrs = this.ctx.getAttributes(connDN, attrIds);
                conn = new Connection();
                cache.put(connDN, conn);
                this.loadFrom(conn, attrs, false);
            }
            catch (NameNotFoundException e) {
                throw new ConfigurationException((Throwable)e);
            }
        }
        return conn;
    }

    private SearchControls searchControlSubtreeScope(int countLimit, String[] returningAttrs, boolean returningObjFlag) {
        SearchControls ctls = new SearchControls();
        ctls.setSearchScope(2);
        ctls.setCountLimit(countLimit);
        ctls.setReturningAttributes(returningAttrs);
        ctls.setReturningObjFlag(returningObjFlag);
        return ctls;
    }

    public synchronized Device findDevice(String name) throws ConfigurationException {
        if (!this.configurationExists()) {
            throw new ConfigurationNotFoundException();
        }
        return this.loadDevice(this.deviceRef(name));
    }

    public synchronized DeviceInfo[] listDeviceInfos(DeviceInfo keys) throws ConfigurationException {
        if (!this.configurationExists()) {
            return new DeviceInfo[0];
        }
        ArrayList<DeviceInfo> results = new ArrayList<DeviceInfo>();
        NamingEnumeration<SearchResult> ne = null;
        try {
            ne = this.search(this.devicesDN, this.toFilter(keys), "dicomDeviceName", "dicomDescription", "dicomManufacturer", "dicomManufacturerModelName", "dicomSoftwareVersion", "dicomStationName", "dicomInstitutionName", "dicomInstitutionDepartmentName", "dicomPrimaryDeviceType", "dicomInstalled", "objectClass");
            while (ne.hasMore()) {
                DeviceInfo deviceInfo = new DeviceInfo();
                this.loadFrom(deviceInfo, ne.next().getAttributes());
                results.add(deviceInfo);
            }
        }
        catch (NamingException e) {
            throw new ConfigurationException((Throwable)e);
        }
        finally {
            LdapUtils.safeClose(ne);
        }
        return results.toArray(new DeviceInfo[results.size()]);
    }

    private String toFilter(DeviceInfo keys) {
        if (keys == null) {
            return "(objectclass=dicomDevice)";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("(&(objectclass=dicomDevice)");
        LdapDicomConfiguration.appendFilter("dicomDeviceName", keys.getDeviceName(), sb);
        LdapDicomConfiguration.appendFilter("dicomDescription", keys.getDescription(), sb);
        LdapDicomConfiguration.appendFilter("dicomManufacturer", keys.getManufacturer(), sb);
        LdapDicomConfiguration.appendFilter("dicomManufacturerModelName", keys.getManufacturerModelName(), sb);
        LdapDicomConfiguration.appendFilter("dicomSoftwareVersion", keys.getSoftwareVersions(), sb);
        LdapDicomConfiguration.appendFilter("dicomStationName", keys.getStationName(), sb);
        LdapDicomConfiguration.appendFilter("dicomInstitutionName", keys.getInstitutionNames(), sb);
        LdapDicomConfiguration.appendFilter("dicomInstitutionDepartmentName", keys.getInstitutionalDepartmentNames(), sb);
        LdapDicomConfiguration.appendFilter("dicomPrimaryDeviceType", keys.getPrimaryDeviceTypes(), sb);
        LdapDicomConfiguration.appendFilter("dicomInstalled", keys.getInstalled(), sb);
        sb.append(")");
        return sb.toString();
    }

    private static <T> void appendFilter(String attrid, T value, StringBuilder sb) {
        if (value == null) {
            return;
        }
        sb.append('(').append(attrid).append('=').append(LdapUtils.toString(value)).append(')');
    }

    private static <T> void appendFilter(String attrid, T[] values, StringBuilder sb) {
        if (values.length == 0) {
            return;
        }
        if (values.length == 1) {
            LdapDicomConfiguration.appendFilter(attrid, values[0], sb);
            return;
        }
        sb.append("(|");
        for (T value : values) {
            LdapDicomConfiguration.appendFilter(attrid, value, sb);
        }
        sb.append(")");
    }

    private void loadFrom(DeviceInfo deviceInfo, Attributes attrs) throws NamingException {
        deviceInfo.setDeviceName(LdapUtils.stringValue(attrs.get("dicomDeviceName"), null));
        deviceInfo.setDescription(LdapUtils.stringValue(attrs.get("dicomDescription"), null));
        deviceInfo.setManufacturer(LdapUtils.stringValue(attrs.get("dicomManufacturer"), null));
        deviceInfo.setManufacturerModelName(LdapUtils.stringValue(attrs.get("dicomManufacturerModelName"), null));
        deviceInfo.setSoftwareVersions(LdapUtils.stringArray(attrs.get("dicomSoftwareVersion"), new String[0]));
        deviceInfo.setStationName(LdapUtils.stringValue(attrs.get("dicomStationName"), null));
        deviceInfo.setInstitutionNames(LdapUtils.stringArray(attrs.get("dicomInstitutionName"), new String[0]));
        deviceInfo.setInstitutionalDepartmentNames(LdapUtils.stringArray(attrs.get("dicomInstitutionDepartmentName"), new String[0]));
        deviceInfo.setPrimaryDeviceTypes(LdapUtils.stringArray(attrs.get("dicomPrimaryDeviceType"), new String[0]));
        deviceInfo.setInstalled(Boolean.valueOf(LdapUtils.booleanValue(attrs.get("dicomInstalled"), true)));
        deviceInfo.setArcDevExt(Boolean.valueOf(LdapUtils.hasObjectClass(attrs, "dcmArchiveDevice")));
    }

    private void loadFrom(ApplicationEntityInfo aetInfo, Attributes attrs, String deviceName, Map<String, Connection> connCache) throws NamingException, ConfigurationException {
        aetInfo.setDeviceName(deviceName);
        aetInfo.setAETitle(LdapUtils.stringValue(attrs.get("dicomAETitle"), null));
        aetInfo.setOtherAETitle(LdapUtils.stringArray(attrs.get("dcmOtherAETitle"), new String[0]));
        aetInfo.setDescription(LdapUtils.stringValue(attrs.get("dicomDescription"), null));
        aetInfo.setAssociationInitiator(Boolean.valueOf(LdapUtils.booleanValue(attrs.get("dicomAssociationInitiator"), true)));
        aetInfo.setAssociationAcceptor(Boolean.valueOf(LdapUtils.booleanValue(attrs.get("dicomAssociationAcceptor"), true)));
        aetInfo.setInstalled(LdapUtils.booleanValue(attrs.get("dicomInstalled"), null));
        aetInfo.setApplicationClusters(LdapUtils.stringArray(attrs.get("dicomApplicationCluster"), new String[0]));
        aetInfo.setHl7ApplicationName(LdapUtils.stringValue(attrs.get("hl7ApplicationName"), null));
        for (String connDN : LdapUtils.stringArray(attrs.get("dicomNetworkConnectionReference"), new String[0])) {
            aetInfo.getConnections().add(this.findConnection(connDN, connCache));
        }
    }

    private void loadFrom(WebApplicationInfo webappInfo, Attributes attrs, String deviceName, Map<String, Connection> connCache, Map<String, KeycloakClient> keycloakClientCache) throws NamingException, ConfigurationException {
        webappInfo.setDeviceName(deviceName);
        webappInfo.setApplicationName(LdapUtils.stringValue(attrs.get("dcmWebAppName"), null));
        webappInfo.setDescription(LdapUtils.stringValue(attrs.get("dicomDescription"), null));
        webappInfo.setServicePath(LdapUtils.stringValue(attrs.get("dcmWebServicePath"), null));
        webappInfo.setServiceClasses((WebApplication.ServiceClass[])LdapUtils.enumArray(WebApplication.ServiceClass.class, (Attribute)attrs.get("dcmWebServiceClass")));
        webappInfo.setAETitle(LdapUtils.stringValue(attrs.get("dicomAETitle"), null));
        webappInfo.setApplicationClusters(LdapUtils.stringArray(attrs.get("dicomApplicationCluster"), new String[0]));
        webappInfo.setProperties(LdapUtils.stringArray(attrs.get("dcmProperty"), new String[0]));
        String keycloakClientID = LdapUtils.stringValue(attrs.get("dcmKeycloakClientID"), null);
        webappInfo.setKeycloakClientID(keycloakClientID);
        webappInfo.setInstalled(LdapUtils.booleanValue(attrs.get("dicomInstalled"), null));
        for (String connDN : LdapUtils.stringArray(attrs.get("dicomNetworkConnectionReference"), new String[0])) {
            webappInfo.getConnections().add(this.findConnection(connDN, connCache));
        }
        if (keycloakClientID != null) {
            webappInfo.setKeycloakClient(this.findKeycloakClient(keycloakClientID, deviceName, keycloakClientCache));
        }
    }

    private KeycloakClient findKeycloakClient(String clientID, String deviceName, Map<String, KeycloakClient> cache) throws NamingException, ConfigurationException {
        String keycloakClientDN = LdapDicomConfiguration.keycloakClientDN(clientID, this.deviceRef(deviceName));
        KeycloakClient keycloakClient = cache.get(keycloakClientDN);
        if (keycloakClient == null) {
            try {
                Attributes attrs = this.ctx.getAttributes(keycloakClientDN);
                keycloakClient = new KeycloakClient(clientID);
                cache.put(keycloakClientDN, keycloakClient);
                this.loadFrom(keycloakClient, attrs);
            }
            catch (NameNotFoundException e) {
                throw new ConfigurationException((Throwable)e);
            }
        }
        return keycloakClient;
    }

    public synchronized String[] listDeviceNames() throws ConfigurationException {
        if (!this.configurationExists()) {
            return StringUtils.EMPTY_STRING;
        }
        return this.list(this.devicesDN, "(objectclass=dicomDevice)", "dicomDeviceName");
    }

    public synchronized String[] listRegisteredAETitles() throws ConfigurationException {
        if (!this.configurationExists()) {
            return StringUtils.EMPTY_STRING;
        }
        return this.list(this.aetsRegistryDN, "(objectclass=dicomUniqueAETitle)", "dicomAETitle");
    }

    public synchronized String[] listRegisteredWebAppNames() throws ConfigurationException {
        if (!this.configurationExists()) {
            return StringUtils.EMPTY_STRING;
        }
        return this.list(this.webAppsRegistryDN, "(objectclass=dcmUniqueWebAppName)", "dcmWebAppName");
    }

    public synchronized String[] list(String dn, String filter, String attrID) throws ConfigurationException {
        ArrayList<String> values = new ArrayList<String>();
        NamingEnumeration<SearchResult> ne = null;
        try {
            ne = this.search(dn, filter, attrID);
            while (ne.hasMore()) {
                SearchResult sr = ne.next();
                Attributes attrs = sr.getAttributes();
                values.add(LdapUtils.stringValue(attrs.get(attrID), null));
            }
        }
        catch (NamingException e) {
            throw new ConfigurationException((Throwable)e);
        }
        finally {
            LdapUtils.safeClose(ne);
        }
        return values.toArray(new String[values.size()]);
    }

    public synchronized ConfigurationChanges persist(Device device, EnumSet<DicomConfiguration.Option> options) throws ConfigurationException {
        this.ensureConfigurationExists();
        String deviceName = device.getDeviceName();
        String deviceDN = this.deviceRef(deviceName);
        boolean rollback = false;
        ArrayList<String> destroyDNs = new ArrayList<String>();
        try {
            if (options != null && options.contains(DicomConfiguration.Option.REGISTER)) {
                this.register(device, destroyDNs);
            }
            ConfigurationChanges diffs = this.configurationChangesOf(options);
            ConfigurationChanges.ModifiedObject ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)deviceDN, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
            this.createSubcontext(deviceDN, this.storeTo((ConfigurationChanges.ModifiedObject)ConfigurationChanges.nullifyIfNotVerbose((ConfigurationChanges)diffs, (Object)ldapObj), device, (Attributes)new BasicAttributes(true)));
            rollback = true;
            this.storeChilds((ConfigurationChanges)ConfigurationChanges.nullifyIfNotVerbose((ConfigurationChanges)diffs, (Object)diffs), deviceDN, device);
            if (options == null || !options.contains(DicomConfiguration.Option.PRESERVE_CERTIFICATE)) {
                this.updateCertificates(device);
            }
            rollback = false;
            destroyDNs.clear();
            ConfigurationChanges configurationChanges = diffs;
            return configurationChanges;
        }
        catch (NameAlreadyBoundException e) {
            throw new ConfigurationAlreadyExistsException(deviceName);
        }
        catch (NamingException e) {
            throw new ConfigurationException((Throwable)e);
        }
        catch (CertificateException e) {
            throw new ConfigurationException((Throwable)e);
        }
        finally {
            if (rollback) {
                try {
                    this.destroySubcontextWithChilds(deviceDN);
                }
                catch (NamingException e) {
                    LOG.warn("Rollback failed:", (Throwable)e);
                }
            }
            this.unregister(destroyDNs);
        }
    }

    private ConfigurationChanges configurationChangesOf(EnumSet<DicomConfiguration.Option> options) {
        return options != null && (options.contains(DicomConfiguration.Option.CONFIGURATION_CHANGES) || options.contains(DicomConfiguration.Option.CONFIGURATION_CHANGES_VERBOSE)) ? new ConfigurationChanges(options.contains(DicomConfiguration.Option.CONFIGURATION_CHANGES_VERBOSE)) : null;
    }

    private void unregister(ArrayList<String> destroyDNs) {
        for (String dn : destroyDNs) {
            try {
                this.destroySubcontext(dn);
            }
            catch (NamingException e) {
                LOG.warn("Unregister {} failed:", (Object)dn, (Object)e);
            }
        }
    }

    private void register(Device device, List<String> dns) throws ConfigurationException {
        for (String aet : device.getApplicationAETitles()) {
            if (aet.equals("*")) continue;
            dns.add(this.registerAET(aet));
        }
        for (String webAppName : device.getWebApplicationNames()) {
            if (webAppName.equals("*")) continue;
            dns.add(this.registerWebApp(webAppName));
        }
        for (LdapDicomConfigurationExtension ext : this.extensions) {
            ext.register(device, dns);
        }
    }

    private void updateCertificates(Device device) throws CertificateException, NamingException {
        for (String dn : device.getAuthorizedNodeCertificateRefs()) {
            this.updateCertificates(dn, this.loadCertificates(dn), device.getAuthorizedNodeCertificates(dn));
        }
        for (String dn : device.getThisNodeCertificateRefs()) {
            this.updateCertificates(dn, this.loadCertificates(dn), device.getThisNodeCertificates(dn));
        }
    }

    private void updateCertificates(String dn, X509Certificate[] prev, X509Certificate[] certs) throws CertificateEncodingException, NamingException {
        if (!LdapUtils.equals(prev, certs)) {
            this.storeCertificates(dn, certs);
        }
    }

    private void storeChilds(ConfigurationChanges diffs, String deviceDN, Device device) throws NamingException, ConfigurationException {
        for (Connection conn : device.listConnections()) {
            String dn = LdapUtils.dnOf(conn, deviceDN);
            ConfigurationChanges.ModifiedObject ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
            this.createSubcontext(dn, this.storeTo(ldapObj, conn, (Attributes)new BasicAttributes(true)));
        }
        for (ApplicationEntity ae : device.getApplicationEntities()) {
            this.store(diffs, ae, deviceDN);
        }
        if (this.extended) {
            for (WebApplication webapp : device.getWebApplications()) {
                this.store(diffs, webapp, deviceDN);
            }
            for (KeycloakClient client : device.getKeycloakClients()) {
                this.store(diffs, client, deviceDN);
            }
            for (LdapDicomConfigurationExtension ext : this.extensions) {
                ext.storeChilds(diffs, deviceDN, device);
            }
        }
    }

    private void store(ConfigurationChanges diffs, ApplicationEntity ae, String deviceDN) throws NamingException {
        String aeDN = LdapDicomConfiguration.aetDN(ae.getAETitle(), deviceDN);
        ConfigurationChanges.ModifiedObject ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)aeDN, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
        this.createSubcontext(aeDN, this.storeTo((ConfigurationChanges.ModifiedObject)ConfigurationChanges.nullifyIfNotVerbose((ConfigurationChanges)diffs, (Object)ldapObj), ae, deviceDN, (Attributes)new BasicAttributes(true)));
        this.storeChilds((ConfigurationChanges)ConfigurationChanges.nullifyIfNotVerbose((ConfigurationChanges)diffs, (Object)diffs), aeDN, ae);
    }

    private void store(ConfigurationChanges diffs, WebApplication webapp, String deviceDN) throws NamingException {
        String webappDN = LdapDicomConfiguration.webAppDN(webapp.getApplicationName(), deviceDN);
        ConfigurationChanges.ModifiedObject ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)webappDN, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
        this.createSubcontext(webappDN, this.storeTo((ConfigurationChanges.ModifiedObject)ConfigurationChanges.nullifyIfNotVerbose((ConfigurationChanges)diffs, (Object)ldapObj), webapp, deviceDN, (Attributes)new BasicAttributes(true)));
    }

    private void store(ConfigurationChanges diffs, KeycloakClient client, String deviceDN) throws NamingException {
        String clientDN = LdapDicomConfiguration.keycloakClientDN(client.getKeycloakClientID(), deviceDN);
        ConfigurationChanges.ModifiedObject ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)clientDN, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
        this.createSubcontext(clientDN, this.storeTo((ConfigurationChanges.ModifiedObject)ConfigurationChanges.nullifyIfNotVerbose((ConfigurationChanges)diffs, (Object)ldapObj), client, (Attributes)new BasicAttributes(true)));
    }

    private void storeChilds(ConfigurationChanges diffs, String aeDN, ApplicationEntity ae) throws NamingException {
        for (TransferCapability tc : ae.getTransferCapabilities()) {
            ConfigurationChanges.ModifiedObject ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)aeDN, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
            this.createSubcontext(LdapDicomConfiguration.dnOf(tc, aeDN), this.storeTo(ldapObj, tc, (Attributes)new BasicAttributes(true)));
        }
        if (this.extended) {
            for (LdapDicomConfigurationExtension ext : this.extensions) {
                ext.storeChilds(diffs, aeDN, ae);
            }
        }
    }

    public ConfigurationChanges merge(Device device, EnumSet<DicomConfiguration.Option> options) throws ConfigurationException {
        ConfigurationChanges diffs = this.configurationChangesOf(options);
        this.merge(device, options, diffs);
        return diffs;
    }

    private synchronized void merge(Device device, EnumSet<DicomConfiguration.Option> options, ConfigurationChanges diffs) throws ConfigurationException {
        if (!this.configurationExists()) {
            throw new ConfigurationNotFoundException();
        }
        String deviceDN = this.deviceRef(device.getDeviceName());
        Device prev = this.loadDevice(deviceDN);
        ArrayList<String> destroyDNs = new ArrayList<String>();
        try {
            boolean preserveVendorData;
            boolean register = options != null && options.contains(DicomConfiguration.Option.REGISTER);
            boolean bl = preserveVendorData = options != null && options.contains(DicomConfiguration.Option.PRESERVE_VENDOR_DATA);
            if (register) {
                this.registerDiff(prev, device, destroyDNs);
            }
            ConfigurationChanges.ModifiedObject ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)deviceDN, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.U);
            this.modifyAttributes(deviceDN, this.storeDiffs(ldapObj, prev, device, new ArrayList<ModificationItem>(), preserveVendorData));
            ConfigurationChanges.removeLastIfEmpty((ConfigurationChanges)diffs, (ConfigurationChanges.ModifiedObject)ldapObj);
            this.mergeChilds(diffs, prev, device, deviceDN, preserveVendorData);
            destroyDNs.clear();
            if (register) {
                this.markForUnregister(prev, device, destroyDNs);
            }
            if (options == null || !options.contains(DicomConfiguration.Option.PRESERVE_CERTIFICATE)) {
                this.updateCertificates(prev, device);
            }
        }
        catch (NameNotFoundException e) {
            throw new ConfigurationNotFoundException((Throwable)e);
        }
        catch (NamingException e) {
            throw new ConfigurationException((Throwable)e);
        }
        catch (CertificateException e) {
            throw new ConfigurationException((Throwable)e);
        }
        finally {
            this.unregister(destroyDNs);
        }
    }

    private void registerDiff(Device prev, Device device, List<String> dns) throws ConfigurationException {
        for (String aet : device.getApplicationAETitles()) {
            if (aet.equals("*") || prev.getApplicationEntity(aet) != null) continue;
            dns.add(this.registerAET(aet));
        }
        for (String webAppName : device.getWebApplicationNames()) {
            if (webAppName.equals("*") || prev.getWebApplication(webAppName) != null) continue;
            dns.add(this.registerWebApp(webAppName));
        }
        for (LdapDicomConfigurationExtension ext : this.extensions) {
            ext.registerDiff(prev, device, dns);
        }
    }

    private void markForUnregister(Device prev, Device device, List<String> dns) {
        for (String aet : prev.getApplicationAETitles()) {
            if (aet.equals("*") || device.getApplicationEntity(aet) != null) continue;
            dns.add(LdapDicomConfiguration.aetDN(aet, this.aetsRegistryDN));
        }
        for (String webAppName : prev.getWebApplicationNames()) {
            if (webAppName.equals("*") || device.getWebApplication(webAppName) != null) continue;
            dns.add(LdapDicomConfiguration.webAppDN(webAppName, this.webAppsRegistryDN));
        }
        for (LdapDicomConfigurationExtension ext : this.extensions) {
            ext.markForUnregister(prev, device, dns);
        }
    }

    private void updateCertificates(Device prev, Device device) throws CertificateException, NamingException {
        X509Certificate[] prevCerts;
        String dn;
        int n;
        String[] stringArray = device.getAuthorizedNodeCertificateRefs();
        int n2 = stringArray.length;
        for (n = 0; n < n2; ++n) {
            prevCerts = prev.getAuthorizedNodeCertificates(dn = stringArray[n]);
            this.updateCertificates(dn, prevCerts != null ? prevCerts : this.loadCertificates(dn), device.getAuthorizedNodeCertificates(dn));
        }
        stringArray = device.getThisNodeCertificateRefs();
        n2 = stringArray.length;
        for (n = 0; n < n2; ++n) {
            prevCerts = prev.getThisNodeCertificates(dn = stringArray[n]);
            this.updateCertificates(dn, prevCerts != null ? prevCerts : this.loadCertificates(dn), device.getThisNodeCertificates(dn));
        }
    }

    private void mergeChilds(ConfigurationChanges diffs, Device prev, Device device, String deviceDN, boolean preserveVendorData) throws NamingException, ConfigurationException {
        this.mergeConnections(diffs, prev, device, deviceDN);
        this.mergeAEs(diffs, prev, device, deviceDN, preserveVendorData);
        this.mergeWebApps(diffs, prev, device, deviceDN);
        this.mergeKeycloakClients(diffs, prev, device, deviceDN);
        for (LdapDicomConfigurationExtension ext : this.extensions) {
            ext.mergeChilds(diffs, prev, device, deviceDN);
        }
    }

    public synchronized ConfigurationChanges removeDevice(String name, EnumSet<DicomConfiguration.Option> options) throws ConfigurationException {
        if (!this.configurationExists()) {
            throw new ConfigurationNotFoundException();
        }
        String dn = this.deviceRef(name);
        this.removeDeviceWithDN(dn, options != null && options.contains(DicomConfiguration.Option.REGISTER));
        ConfigurationChanges diffs = new ConfigurationChanges(false);
        ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.D);
        return diffs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markForUnregister(String deviceDN, List<String> dns) throws NamingException, ConfigurationException {
        NamingEnumeration<SearchResult> aets = this.search(deviceDN, "(objectclass=dicomNetworkAE)", StringUtils.EMPTY_STRING);
        try {
            while (aets.hasMore()) {
                String rdn = aets.next().getName();
                if (rdn.equals("dicomAETitle=*")) continue;
                dns.add(rdn + ',' + this.aetsRegistryDN);
            }
        }
        finally {
            LdapUtils.safeClose(aets);
        }
        NamingEnumeration<SearchResult> webApps = this.search(deviceDN, "(objectclass=dcmWebApp)", StringUtils.EMPTY_STRING);
        try {
            while (webApps.hasMore()) {
                String rdn = webApps.next().getName();
                dns.add(rdn + ',' + this.webAppsRegistryDN);
            }
        }
        finally {
            LdapUtils.safeClose(webApps);
        }
        for (LdapDicomConfigurationExtension ext : this.extensions) {
            ext.markForUnregister(deviceDN, dns);
        }
    }

    private void removeDeviceWithDN(String deviceDN, boolean unregister) throws ConfigurationException {
        try {
            ArrayList<String> destroyDNs = new ArrayList<String>();
            if (unregister) {
                this.markForUnregister(deviceDN, destroyDNs);
            }
            this.destroySubcontextWithChilds(deviceDN);
            this.unregister(destroyDNs);
        }
        catch (NameNotFoundException e) {
            throw new ConfigurationNotFoundException((Throwable)e);
        }
        catch (NamingException e) {
            throw new ConfigurationException((Throwable)e);
        }
    }

    public synchronized void createSubcontext(String name, Attributes attrs) throws NamingException {
        this.ctx.createSubcontextAndClose(name, attrs);
    }

    public synchronized void destroySubcontext(String dn) throws NamingException {
        this.ctx.destroySubcontext(dn);
    }

    public synchronized void destroySubcontextWithChilds(String name) throws NamingException {
        NamingEnumeration<NameClassPair> list = this.ctx.list(name);
        try {
            while (list.hasMore()) {
                this.destroySubcontextWithChilds(list.next().getNameInNamespace());
            }
        }
        finally {
            LdapUtils.safeClose(list);
        }
        this.ctx.destroySubcontext(name);
    }

    private void setConfigurationDN(String configurationDN) {
        this.configurationDN = configurationDN;
        this.devicesDN = CN_DEVICES + configurationDN;
        this.aetsRegistryDN = CN_UNIQUE_AE_TITLES_REGISTRY + configurationDN;
        this.webAppsRegistryDN = CN_UNIQUE_WEB_APP_NAMES_REGISTRY + configurationDN;
    }

    public String getConfigurationDN() {
        return this.configurationDN;
    }

    private void clearConfigurationDN() {
        this.configurationDN = null;
        this.devicesDN = null;
        this.aetsRegistryDN = null;
        this.webAppsRegistryDN = null;
    }

    public void ensureConfigurationExists() throws ConfigurationException {
        if (!this.configurationExists()) {
            this.initConfiguration();
        }
    }

    private void initConfiguration() throws ConfigurationException {
        this.setConfigurationDN("cn=" + this.configurationCN + ',' + this.baseDN);
        try {
            this.createSubcontext(this.configurationDN, LdapUtils.attrs(this.configurationRoot, "cn", this.configurationCN));
            this.createSubcontext(this.devicesDN, LdapUtils.attrs("dicomDevicesRoot", "cn", "Devices"));
            this.createSubcontext(this.aetsRegistryDN, LdapUtils.attrs("dicomUniqueAETitlesRegistryRoot", "cn", "Unique AE Titles Registry"));
            this.createSubcontext(this.webAppsRegistryDN, LdapUtils.attrs("dcmUniqueWebAppNamesRegistryRoot", "cn", "Unique Web Application Names Registry"));
            LOG.info("Create DICOM Configuration at {}", (Object)this.configurationDN);
        }
        catch (NamingException e) {
            this.clearConfigurationDN();
            throw new ConfigurationException((Throwable)e);
        }
    }

    private boolean findConfiguration() throws ConfigurationException {
        NamingEnumeration<SearchResult> ne = null;
        try {
            SearchControls ctls = this.searchControlSubtreeScope(1, StringUtils.EMPTY_STRING, false);
            ne = this.ctx.search(this.baseDN, "(&(objectclass=" + this.configurationRoot + ")(cn=" + this.configurationCN + "))", ctls);
            if (!ne.hasMore()) {
                boolean bl = false;
                return bl;
            }
            this.setConfigurationDN(ne.next().getName() + "," + this.baseDN);
            boolean bl = true;
            return bl;
        }
        catch (NamingException e) {
            throw new ConfigurationException((Throwable)e);
        }
        finally {
            LdapUtils.safeClose(ne);
        }
    }

    private Attributes storeTo(ConfigurationChanges.ModifiedObject ldapObj, Device device, Attributes attrs) {
        BasicAttribute objectclass = new BasicAttribute("objectclass", "dicomDevice");
        attrs.put(objectclass);
        LdapUtils.storeNotNullOrDef(ldapObj, attrs, "dicomDeviceName", device.getDeviceName(), null);
        LdapUtils.storeNotNullOrDef(ldapObj, attrs, "dicomDescription", device.getDescription(), null);
        LdapUtils.storeNotNullOrDef(ldapObj, attrs, "dicomDeviceUID", device.getDeviceUID(), null);
        LdapUtils.storeNotNullOrDef(ldapObj, attrs, "dicomManufacturer", device.getManufacturer(), null);
        LdapUtils.storeNotNullOrDef(ldapObj, attrs, "dicomManufacturerModelName", device.getManufacturerModelName(), null);
        LdapUtils.storeNotEmpty(ldapObj, attrs, "dicomSoftwareVersion", device.getSoftwareVersions(), new String[0]);
        LdapUtils.storeNotNullOrDef(ldapObj, attrs, "dicomStationName", device.getStationName(), null);
        LdapUtils.storeNotNullOrDef(ldapObj, attrs, "dicomDeviceSerialNumber", device.getDeviceSerialNumber(), null);
        LdapUtils.storeNotNullOrDef(ldapObj, attrs, "dicomIssuerOfPatientID", device.getIssuerOfPatientID(), null);
        LdapUtils.storeNotNullOrDef(ldapObj, attrs, "dicomIssuerOfAccessionNumber", device.getIssuerOfAccessionNumber(), null);
        LdapUtils.storeNotNullOrDef(ldapObj, attrs, "dicomOrderPlacerIdentifier", device.getOrderPlacerIdentifier(), null);
        LdapUtils.storeNotNullOrDef(ldapObj, attrs, "dicomOrderFillerIdentifier", device.getOrderFillerIdentifier(), null);
        LdapUtils.storeNotNullOrDef(ldapObj, attrs, "dicomIssuerOfAdmissionID", device.getIssuerOfAdmissionID(), null);
        LdapUtils.storeNotNullOrDef(ldapObj, attrs, "dicomIssuerOfServiceEpisodeID", device.getIssuerOfServiceEpisodeID(), null);
        LdapUtils.storeNotNullOrDef(ldapObj, attrs, "dicomIssuerOfContainerIdentifier", device.getIssuerOfContainerIdentifier(), null);
        LdapUtils.storeNotNullOrDef(ldapObj, attrs, "dicomIssuerOfSpecimenIdentifier", device.getIssuerOfSpecimenIdentifier(), null);
        LdapUtils.storeNotEmpty(ldapObj, attrs, "dicomInstitutionName", device.getInstitutionNames(), new String[0]);
        LdapUtils.storeNotEmpty(ldapObj, attrs, "dicomInstitutionCode", device.getInstitutionCodes(), new Code[0]);
        LdapUtils.storeNotEmpty(ldapObj, attrs, "dicomInstitutionAddress", device.getInstitutionAddresses(), new String[0]);
        LdapUtils.storeNotEmpty(ldapObj, attrs, "dicomInstitutionDepartmentName", device.getInstitutionalDepartmentNames(), new String[0]);
        LdapUtils.storeNotEmpty(ldapObj, attrs, "dicomPrimaryDeviceType", device.getPrimaryDeviceTypes(), new String[0]);
        LdapUtils.storeNotEmpty(ldapObj, attrs, "dicomRelatedDeviceReference", device.getRelatedDeviceRefs(), new String[0]);
        LdapUtils.storeNotEmpty(ldapObj, attrs, "dicomAuthorizedNodeCertificateReference", device.getAuthorizedNodeCertificateRefs(), new String[0]);
        LdapUtils.storeNotEmpty(ldapObj, attrs, "dicomThisNodeCertificateReference", device.getThisNodeCertificateRefs(), new String[0]);
        LdapDicomConfiguration.storeNotEmpty(ldapObj, attrs, "dicomVendorData", device.getVendorData());
        LdapUtils.storeBoolean(ldapObj, attrs, "dicomInstalled", device.isInstalled());
        if (!this.extended) {
            return attrs;
        }
        objectclass.add("dcmDevice");
        LdapUtils.storeNotDef(ldapObj, attrs, "dcmRoleSelectionNegotiationLenient", device.isRoleSelectionNegotiationLenient(), false);
        LdapUtils.storeNotDef(ldapObj, attrs, "dcmLimitOpenAssociations", device.getLimitOpenAssociations(), 0);
        LdapUtils.storeNotEmpty(ldapObj, attrs, "dcmLimitAssociationsInitiatedBy", device.getLimitAssociationsInitiatedBy(), new String[0]);
        LdapUtils.storeNotNullOrDef(ldapObj, attrs, "dcmTrustStoreURL", device.getTrustStoreURL(), null);
        LdapUtils.storeNotNullOrDef(ldapObj, attrs, "dcmTrustStoreType", device.getTrustStoreType(), null);
        LdapUtils.storeNotNullOrDef(ldapObj, attrs, "dcmTrustStorePin", device.getTrustStorePin(), null);
        LdapUtils.storeNotNullOrDef(ldapObj, attrs, "dcmTrustStorePinProperty", device.getTrustStorePinProperty(), null);
        LdapUtils.storeNotNullOrDef(ldapObj, attrs, "dcmKeyStoreURL", device.getKeyStoreURL(), null);
        LdapUtils.storeNotNullOrDef(ldapObj, attrs, "dcmKeyStoreType", device.getKeyStoreType(), null);
        LdapUtils.storeNotNullOrDef(ldapObj, attrs, "dcmKeyStorePin", device.getKeyStorePin(), null);
        LdapUtils.storeNotNullOrDef(ldapObj, attrs, "dcmKeyStorePinProperty", device.getKeyStorePinProperty(), null);
        LdapUtils.storeNotNullOrDef(ldapObj, attrs, "dcmKeyStoreKeyPin", device.getKeyStoreKeyPin(), null);
        LdapUtils.storeNotNullOrDef(ldapObj, attrs, "dcmKeyStoreKeyPinProperty", device.getKeyStoreKeyPinProperty(), null);
        LdapUtils.storeNotNullOrDef(ldapObj, attrs, "dcmTimeZoneOfDevice", device.getTimeZoneOfDevice(), null);
        for (LdapDicomConfigurationExtension ext : this.extensions) {
            ext.storeTo(ldapObj, device, attrs);
        }
        return attrs;
    }

    private Attributes storeTo(ConfigurationChanges.ModifiedObject ldapObj, Connection conn, Attributes attrs) {
        BasicAttribute objectclass = new BasicAttribute("objectclass", "dicomNetworkConnection");
        attrs.put(objectclass);
        LdapUtils.storeNotNullOrDef(ldapObj, attrs, "cn", conn.getCommonName(), null);
        LdapUtils.storeNotNullOrDef(ldapObj, attrs, "dicomHostname", conn.getHostname(), null);
        LdapUtils.storeNotDef(ldapObj, attrs, "dicomPort", conn.getPort(), -1);
        LdapUtils.storeNotEmpty(ldapObj, attrs, "dicomTLSCipherSuite", conn.getTlsCipherSuites(), new String[0]);
        LdapUtils.storeNotNullOrDef(ldapObj, attrs, "dicomInstalled", conn.getInstalled(), null);
        if (!this.extended) {
            return attrs;
        }
        objectclass.add("dcmNetworkConnection");
        LdapUtils.storeNotNullOrDef(ldapObj, attrs, "dcmProtocol", conn.getProtocol(), Connection.Protocol.DICOM);
        LdapUtils.storeNotNullOrDef(ldapObj, attrs, "dcmHTTPProxy", conn.getHttpProxy(), null);
        LdapUtils.storeNotEmpty(ldapObj, attrs, "dcmBlacklistedHostname", conn.getBlacklist(), new String[0]);
        LdapUtils.storeNotDef(ldapObj, attrs, "dcmTCPBacklog", conn.getBacklog(), 50);
        LdapUtils.storeNotDef(ldapObj, attrs, "dcmTCPConnectTimeout", conn.getConnectTimeout(), 0);
        LdapUtils.storeNotDef(ldapObj, attrs, "dcmAARQTimeout", conn.getRequestTimeout(), 0);
        LdapUtils.storeNotDef(ldapObj, attrs, "dcmAAACTimeout", conn.getAcceptTimeout(), 0);
        LdapUtils.storeNotDef(ldapObj, attrs, "dcmARRPTimeout", conn.getReleaseTimeout(), 0);
        LdapUtils.storeNotDef(ldapObj, attrs, "dcmSendTimeout", conn.getSendTimeout(), 0);
        LdapUtils.storeNotDef(ldapObj, attrs, "dcmStoreTimeout", conn.getStoreTimeout(), 0);
        LdapUtils.storeNotDef(ldapObj, attrs, "dcmResponseTimeout", conn.getResponseTimeout(), 0);
        LdapUtils.storeNotDef(ldapObj, attrs, "dcmRetrieveTimeout", conn.getRetrieveTimeout(), 0);
        LdapUtils.storeNotDef(ldapObj, attrs, "dcmRetrieveTimeoutTotal", conn.isRetrieveTimeoutTotal(), false);
        LdapUtils.storeNotDef(ldapObj, attrs, "dcmIdleTimeout", conn.getIdleTimeout(), 0);
        LdapUtils.storeNotDef(ldapObj, attrs, "dcmAATimeout", conn.getAbortTimeout(), 1000);
        LdapUtils.storeNotDef(ldapObj, attrs, "dcmTCPCloseDelay", conn.getSocketCloseDelay(), 50);
        LdapUtils.storeNotDef(ldapObj, attrs, "dcmTCPSendBufferSize", conn.getSendBufferSize(), 0);
        LdapUtils.storeNotDef(ldapObj, attrs, "dcmTCPReceiveBufferSize", conn.getReceiveBufferSize(), 0);
        LdapUtils.storeNotDef(ldapObj, attrs, "dcmTCPNoDelay", conn.isTcpNoDelay(), true);
        LdapUtils.storeNotNullOrDef(ldapObj, attrs, "dcmBindAddress", conn.getBindAddress(), null);
        LdapUtils.storeNotNullOrDef(ldapObj, attrs, "dcmClientBindAddress", conn.getClientBindAddress(), null);
        LdapUtils.storeNotDef(ldapObj, attrs, "dcmSendPDULength", conn.getSendPDULength(), 16378);
        LdapUtils.storeNotDef(ldapObj, attrs, "dcmReceivePDULength", conn.getReceivePDULength(), 16378);
        LdapUtils.storeNotDef(ldapObj, attrs, "dcmMaxOpsPerformed", conn.getMaxOpsPerformed(), 1);
        LdapUtils.storeNotDef(ldapObj, attrs, "dcmMaxOpsInvoked", conn.getMaxOpsInvoked(), 1);
        LdapUtils.storeNotDef(ldapObj, attrs, "dcmPackPDV", conn.isPackPDV(), true);
        LdapUtils.storeNotEmpty(ldapObj, attrs, "dcmTLSProtocol", conn.getTlsProtocols(), Connection.DEFAULT_TLS_PROTOCOLS);
        LdapUtils.storeNotDef(ldapObj, attrs, "dcmTLSNeedClientAuth", conn.isTlsNeedClientAuth(), true);
        LdapUtils.storeNotNullOrDef(ldapObj, attrs, "dcmTLSEndpointIdentificationAlgorithm", conn.getTlsEndpointIdentificationAlgorithm(), null);
        return attrs;
    }

    private Attributes storeTo(ConfigurationChanges.ModifiedObject ldapObj, ApplicationEntity ae, String deviceDN, Attributes attrs) {
        BasicAttribute objectclass = new BasicAttribute("objectclass", "dicomNetworkAE");
        attrs.put(objectclass);
        LdapUtils.storeNotNullOrDef(ldapObj, attrs, "dicomAETitle", ae.getAETitle(), null);
        LdapUtils.storeNotNullOrDef(ldapObj, attrs, "dicomDescription", ae.getDescription(), null);
        LdapDicomConfiguration.storeNotEmpty(ldapObj, attrs, "dicomVendorData", ae.getVendorData());
        LdapUtils.storeNotEmpty(ldapObj, attrs, "dicomApplicationCluster", ae.getApplicationClusters(), new String[0]);
        LdapUtils.storeNotEmpty(ldapObj, attrs, "dicomPreferredCallingAETitle", ae.getPreferredCallingAETitles(), new String[0]);
        LdapUtils.storeNotEmpty(ldapObj, attrs, "dicomPreferredCalledAETitle", ae.getPreferredCalledAETitles(), new String[0]);
        LdapUtils.storeBoolean(ldapObj, attrs, "dicomAssociationInitiator", ae.isAssociationInitiator());
        LdapUtils.storeBoolean(ldapObj, attrs, "dicomAssociationAcceptor", ae.isAssociationAcceptor());
        LdapUtils.storeConnRefs(ldapObj, attrs, ae.getConnections(), deviceDN);
        LdapUtils.storeNotEmpty(ldapObj, attrs, "dicomSupportedCharacterSet", ae.getSupportedCharacterSets(), new String[0]);
        LdapUtils.storeNotNullOrDef(ldapObj, attrs, "dicomInstalled", ae.getInstalled(), null);
        if (!this.extended) {
            return attrs;
        }
        objectclass.add("dcmNetworkAE");
        LdapUtils.storeNotNullOrDef(ldapObj, attrs, "dcmRoleSelectionNegotiationLenient", ae.getRoleSelectionNegotiationLenient(), null);
        LdapUtils.storeNotEmpty(ldapObj, attrs, "dcmPreferredTransferSyntax", LdapUtils.addOrdinalPrefix(ae.getPreferredTransferSyntaxes()), new String[0]);
        LdapUtils.storeNotNullOrDef(ldapObj, attrs, "dcmShareTransferCapabilitiesFromAETitle", ae.getShareTransferCapabilitiesFromAETitle(), null);
        LdapUtils.storeNotNullOrDef(ldapObj, attrs, "hl7ApplicationName", ae.getHl7ApplicationName(), null);
        LdapUtils.storeNotEmpty(ldapObj, attrs, "dcmAcceptedCallingAETitle", ae.getAcceptedCallingAETitles(), new String[0]);
        LdapUtils.storeNotEmpty(ldapObj, attrs, "dcmOtherAETitle", ae.getOtherAETitles(), new String[0]);
        LdapUtils.storeNotEmpty(ldapObj, attrs, "dcmNoAsyncModeCalledAETitle", ae.getNoAsyncModeCalledAETitles(), new String[0]);
        LdapUtils.storeNotEmpty(ldapObj, attrs, "dcmMasqueradeCallingAETitle", ae.getMasqueradeCallingAETitles(), new String[0]);
        LdapUtils.storeNotEmpty(ldapObj, attrs, "dcmMasqueradeCalledAETitle", ae.getMasqueradeCalledAETitles(), new String[0]);
        for (LdapDicomConfigurationExtension ext : this.extensions) {
            ext.storeTo(ldapObj, ae, attrs);
        }
        return attrs;
    }

    private Attributes storeTo(ConfigurationChanges.ModifiedObject ldapObj, WebApplication webapp, String deviceDN, Attributes attrs) {
        BasicAttribute objectclass = new BasicAttribute("objectclass", "dcmWebApp");
        attrs.put(objectclass);
        LdapUtils.storeNotNullOrDef(ldapObj, attrs, "dcmWebAppName", webapp.getApplicationName(), null);
        LdapUtils.storeNotNullOrDef(ldapObj, attrs, "dicomDescription", webapp.getDescription(), null);
        LdapUtils.storeNotNullOrDef(ldapObj, attrs, "dcmWebServicePath", webapp.getServicePath(), null);
        LdapUtils.storeNotNullOrDef(ldapObj, attrs, "dcmKeycloakClientID", webapp.getKeycloakClientID(), null);
        LdapUtils.storeNotEmpty(ldapObj, attrs, "dcmWebServiceClass", webapp.getServiceClasses(), new WebApplication.ServiceClass[0]);
        LdapUtils.storeNotNullOrDef(ldapObj, attrs, "dicomAETitle", webapp.getAETitle(), null);
        LdapUtils.storeNotEmpty(ldapObj, attrs, "dicomApplicationCluster", webapp.getApplicationClusters(), new String[0]);
        LdapUtils.storeNotEmpty(ldapObj, attrs, "dcmProperty", webapp.getProperties());
        LdapUtils.storeConnRefs(ldapObj, attrs, webapp.getConnections(), deviceDN);
        LdapUtils.storeNotNullOrDef(ldapObj, attrs, "dicomInstalled", webapp.getInstalled(), null);
        return attrs;
    }

    private Attributes storeTo(ConfigurationChanges.ModifiedObject ldapObj, KeycloakClient client, Attributes attrs) {
        attrs.put("objectclass", "dcmKeycloakClient");
        attrs.put("dcmKeycloakClientID", client.getKeycloakClientID());
        LdapUtils.storeNotNullOrDef(ldapObj, attrs, "dcmURI", client.getKeycloakServerURL(), null);
        LdapUtils.storeNotNullOrDef(ldapObj, attrs, "dcmKeycloakRealm", client.getKeycloakRealm(), null);
        LdapUtils.storeNotNullOrDef(ldapObj, attrs, "dcmKeycloakGrantType", client.getKeycloakGrantType(), KeycloakClient.GrantType.client_credentials);
        LdapUtils.storeNotNullOrDef(ldapObj, attrs, "dcmKeycloakClientSecret", client.getKeycloakClientSecret(), null);
        LdapUtils.storeNotDef(ldapObj, attrs, "dcmTLSAllowAnyHostname", client.isTLSAllowAnyHostname(), false);
        LdapUtils.storeNotDef(ldapObj, attrs, "dcmTLSDisableTrustManager", client.isTLSDisableTrustManager(), false);
        LdapUtils.storeNotNullOrDef(ldapObj, attrs, "uid", client.getUserID(), null);
        LdapUtils.storeNotNullOrDef(ldapObj, attrs, "userPassword", client.getPassword(), null);
        return attrs;
    }

    private Attributes storeTo(ConfigurationChanges.ModifiedObject ldapObj, TransferCapability tc, Attributes attrs) {
        StorageOptions storageOpts;
        BasicAttribute objectclass = new BasicAttribute("objectclass", "dicomTransferCapability");
        attrs.put(objectclass);
        LdapUtils.storeNotNullOrDef(ldapObj, attrs, "cn", tc.getCommonName(), null);
        LdapUtils.storeNotNullOrDef(ldapObj, attrs, "dicomSOPClass", tc.getSopClass(), null);
        LdapUtils.storeNotNullOrDef(ldapObj, attrs, "dicomTransferRole", tc.getRole(), null);
        LdapUtils.storeNotEmpty(ldapObj, attrs, "dicomTransferSyntax", tc.getTransferSyntaxes(), new String[0]);
        if (!this.extended) {
            return attrs;
        }
        objectclass.add("dcmTransferCapability");
        LdapUtils.storeNotEmpty(ldapObj, attrs, "dcmPreferredTransferSyntax", LdapUtils.addOrdinalPrefix(tc.getPreferredTransferSyntaxes()), new String[0]);
        EnumSet queryOpts = tc.getQueryOptions();
        if (queryOpts != null) {
            LdapUtils.storeNotDef(ldapObj, attrs, "dcmRelationalQueries", queryOpts.contains(QueryOption.RELATIONAL), false);
            LdapUtils.storeNotDef(ldapObj, attrs, "dcmCombinedDateTimeMatching", queryOpts.contains(QueryOption.DATETIME), false);
            LdapUtils.storeNotDef(ldapObj, attrs, "dcmFuzzySemanticMatching", queryOpts.contains(QueryOption.FUZZY), false);
            LdapUtils.storeNotDef(ldapObj, attrs, "dcmTimezoneQueryAdjustment", queryOpts.contains(QueryOption.TIMEZONE), false);
        }
        if ((storageOpts = tc.getStorageOptions()) != null) {
            LdapUtils.storeInt(ldapObj, attrs, "dcmStorageConformance", storageOpts.getLevelOfSupport().ordinal());
            LdapUtils.storeInt(ldapObj, attrs, "dcmDigitalSignatureSupport", storageOpts.getDigitalSignatureSupport().ordinal());
            LdapUtils.storeInt(ldapObj, attrs, "dcmDataElementCoercion", storageOpts.getElementCoercion().ordinal());
        }
        return attrs;
    }

    public synchronized void persistCertificates(String dn, X509Certificate ... certs) throws ConfigurationException {
        try {
            this.storeCertificates(dn, certs);
        }
        catch (NameNotFoundException e) {
            throw new ConfigurationNotFoundException((Throwable)e);
        }
        catch (NamingException e) {
            throw new ConfigurationException((Throwable)e);
        }
        catch (CertificateEncodingException e) {
            throw new ConfigurationException((Throwable)e);
        }
    }

    private void storeCertificates(String dn, X509Certificate ... certs) throws CertificateEncodingException, NamingException {
        ModificationItem[] modificationItemArray;
        byte[][] vals = new byte[certs.length][];
        for (int i = 0; i < vals.length; ++i) {
            vals[i] = certs[i].getEncoded();
        }
        Attributes attrs = this.ctx.getAttributes(dn, new String[]{"objectClass"});
        ModificationItem replaceCert = new ModificationItem(2, LdapDicomConfiguration.attr(this.userCertificate, vals));
        if (LdapUtils.hasObjectClass(attrs, this.pkiUser)) {
            ModificationItem[] modificationItemArray2 = new ModificationItem[1];
            modificationItemArray = modificationItemArray2;
            modificationItemArray2[0] = replaceCert;
        } else {
            ModificationItem[] modificationItemArray3 = new ModificationItem[2];
            modificationItemArray3[0] = new ModificationItem(1, LdapUtils.attr("objectClass", this.pkiUser));
            modificationItemArray = modificationItemArray3;
            modificationItemArray3[1] = replaceCert;
        }
        this.ctx.modifyAttributes(dn, modificationItemArray);
    }

    public synchronized void removeCertificates(String dn) throws ConfigurationException {
        try {
            ModificationItem removeCert = new ModificationItem(3, new BasicAttribute(this.userCertificate));
            this.ctx.modifyAttributes(dn, removeCert);
        }
        catch (NameNotFoundException e) {
            throw new ConfigurationNotFoundException((Throwable)e);
        }
        catch (NamingException e) {
            throw new ConfigurationException((Throwable)e);
        }
    }

    public synchronized X509Certificate[] findCertificates(String dn) throws ConfigurationException {
        try {
            return this.loadCertificates(dn);
        }
        catch (NameNotFoundException e) {
            throw new ConfigurationNotFoundException((Throwable)e);
        }
        catch (NamingException e) {
            throw new ConfigurationException((Throwable)e);
        }
        catch (CertificateException e) {
            throw new ConfigurationException((Throwable)e);
        }
    }

    private X509Certificate[] loadCertificates(String dn) throws NamingException, CertificateException {
        Attributes attrs = this.ctx.getAttributes(dn, new String[]{this.userCertificate});
        Attribute attr = attrs.get(this.userCertificate);
        if (attr == null) {
            return EMPTY_X509_CERTIFICATES;
        }
        CertificateFactory cf = CertificateFactory.getInstance("X509");
        X509Certificate[] certs = new X509Certificate[attr.size()];
        for (int i = 0; i < certs.length; ++i) {
            certs[i] = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream((byte[])attr.get(i)));
        }
        return certs;
    }

    public byte[][] loadDeviceVendorData(String deviceName) throws ConfigurationException {
        if (!this.configurationExists()) {
            throw new ConfigurationNotFoundException();
        }
        try {
            Attributes attrs = this.getAttributes(this.deviceRef(deviceName), new String[]{"dicomVendorData"});
            return LdapDicomConfiguration.byteArrays(attrs.get("dicomVendorData"));
        }
        catch (NameNotFoundException e) {
            throw new ConfigurationNotFoundException("Device with specified name not found", (Throwable)e);
        }
        catch (NamingException e) {
            throw new ConfigurationException((Throwable)e);
        }
    }

    public ConfigurationChanges updateDeviceVendorData(String deviceName, byte[] ... vendorData) throws ConfigurationException {
        String deviceRef = this.deviceRef(deviceName);
        if (!this.configurationExists()) {
            throw new ConfigurationNotFoundException();
        }
        ConfigurationChanges diffs = new ConfigurationChanges(false);
        try {
            Attributes attrs = this.getAttributes(deviceRef, new String[]{"dicomVendorData"});
            byte[][] prev = LdapDicomConfiguration.byteArrays(attrs.get("dicomVendorData"));
            ConfigurationChanges.ModifiedObject ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)deviceRef, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
            ArrayList<ModificationItem> mods = new ArrayList<ModificationItem>(1);
            LdapDicomConfiguration.storeDiff(ldapObj, mods, "dicomVendorData", prev, vendorData);
            this.modifyAttributes(deviceRef, mods);
        }
        catch (NameNotFoundException e) {
            throw new ConfigurationNotFoundException("Device with specified name not found", (Throwable)e);
        }
        catch (NamingException e) {
            throw new ConfigurationException((Throwable)e);
        }
        return diffs;
    }

    public Device loadDevice(String deviceDN) throws ConfigurationException {
        Map<String, Device> deviceCache = this.currentlyLoadedDevicesLocal.get();
        boolean doCleanUpCache = false;
        if (deviceCache == null) {
            doCleanUpCache = true;
            deviceCache = new HashMap<String, Device>();
            this.currentlyLoadedDevicesLocal.set(deviceCache);
        }
        if (deviceCache.containsKey(deviceDN)) {
            return deviceCache.get(deviceDN);
        }
        try {
            Attributes attrs = this.getAttributes(deviceDN);
            Device device = new Device(LdapUtils.stringValue(attrs.get("dicomDeviceName"), null));
            deviceCache.put(deviceDN, device);
            this.loadFrom(device, attrs);
            this.loadChilds(device, deviceDN);
            Device device2 = device;
            return device2;
        }
        catch (NameNotFoundException e) {
            throw new ConfigurationNotFoundException("Device with specified name not found", (Throwable)e);
        }
        catch (NamingException e) {
            throw new ConfigurationException((Throwable)e);
        }
        catch (CertificateException e) {
            throw new ConfigurationException((Throwable)e);
        }
        finally {
            if (doCleanUpCache) {
                this.currentlyLoadedDevicesLocal.remove();
            }
        }
    }

    public Attributes getAttributes(String name) throws NamingException {
        return this.ctx.getAttributes(name);
    }

    public Attributes getAttributes(String name, String[] attrIDs) throws NamingException {
        return this.ctx.getAttributes(name, attrIDs);
    }

    private void loadChilds(Device device, String deviceDN) throws NamingException, ConfigurationException {
        this.loadConnections(device, deviceDN);
        this.loadApplicationEntities(device, deviceDN);
        this.loadWebApplications(device, deviceDN);
        this.loadKeycloakClients(device, deviceDN);
        for (LdapDicomConfigurationExtension ext : this.extensions) {
            ext.loadChilds(device, deviceDN);
        }
    }

    private void loadFrom(TransferCapability tc, Attributes attrs) throws NamingException {
        tc.setCommonName(LdapUtils.stringValue(attrs.get("cn"), null));
        tc.setSopClass(LdapUtils.stringValue(attrs.get("dicomSOPClass"), null));
        tc.setRole(TransferCapability.Role.valueOf((String)LdapUtils.stringValue(attrs.get("dicomTransferRole"), null)));
        tc.setTransferSyntaxes(LdapUtils.stringArray(attrs.get("dicomTransferSyntax"), new String[0]));
        if (!LdapUtils.hasObjectClass(attrs, "dcmTransferCapability")) {
            return;
        }
        tc.setPreferredTransferSyntaxes(LdapUtils.removeOrdinalPrefix(LdapUtils.stringArray(attrs.get("dcmPreferredTransferSyntax"), new String[0])));
        tc.setQueryOptions(LdapDicomConfiguration.toQueryOptions(attrs));
        tc.setStorageOptions(LdapDicomConfiguration.toStorageOptions(attrs));
    }

    private static EnumSet<QueryOption> toQueryOptions(Attributes attrs) throws NamingException {
        Attribute relational = attrs.get("dcmRelationalQueries");
        Attribute datetime = attrs.get("dcmCombinedDateTimeMatching");
        Attribute fuzzy = attrs.get("dcmFuzzySemanticMatching");
        Attribute timezone = attrs.get("dcmTimezoneQueryAdjustment");
        if (relational == null && datetime == null && fuzzy == null && timezone == null) {
            return null;
        }
        EnumSet<QueryOption> opts = EnumSet.noneOf(QueryOption.class);
        if (LdapUtils.booleanValue(relational, false)) {
            opts.add(QueryOption.RELATIONAL);
        }
        if (LdapUtils.booleanValue(datetime, false)) {
            opts.add(QueryOption.DATETIME);
        }
        if (LdapUtils.booleanValue(fuzzy, false)) {
            opts.add(QueryOption.FUZZY);
        }
        if (LdapUtils.booleanValue(timezone, false)) {
            opts.add(QueryOption.TIMEZONE);
        }
        return opts;
    }

    private static StorageOptions toStorageOptions(Attributes attrs) throws NamingException {
        Attribute levelOfSupport = attrs.get("dcmStorageConformance");
        Attribute signatureSupport = attrs.get("dcmDigitalSignatureSupport");
        Attribute coercion = attrs.get("dcmDataElementCoercion");
        if (levelOfSupport == null && signatureSupport == null && coercion == null) {
            return null;
        }
        StorageOptions opts = new StorageOptions();
        opts.setLevelOfSupport(StorageOptions.LevelOfSupport.valueOf((int)LdapUtils.intValue(levelOfSupport, 3)));
        opts.setDigitalSignatureSupport(StorageOptions.DigitalSignatureSupport.valueOf((int)LdapUtils.intValue(signatureSupport, 0)));
        opts.setElementCoercion(StorageOptions.ElementCoercion.valueOf((int)LdapUtils.intValue(coercion, 2)));
        return opts;
    }

    private void loadFrom(Device device, Attributes attrs) throws NamingException, CertificateException {
        device.setDescription(LdapUtils.stringValue(attrs.get("dicomDescription"), null));
        device.setDeviceUID(LdapUtils.stringValue(attrs.get("dicomDeviceUID"), null));
        device.setManufacturer(LdapUtils.stringValue(attrs.get("dicomManufacturer"), null));
        device.setManufacturerModelName(LdapUtils.stringValue(attrs.get("dicomManufacturerModelName"), null));
        device.setSoftwareVersions(LdapUtils.stringArray(attrs.get("dicomSoftwareVersion"), new String[0]));
        device.setStationName(LdapUtils.stringValue(attrs.get("dicomStationName"), null));
        device.setDeviceSerialNumber(LdapUtils.stringValue(attrs.get("dicomDeviceSerialNumber"), null));
        device.setIssuerOfPatientID(LdapUtils.issuerValue(attrs.get("dicomIssuerOfPatientID")));
        device.setIssuerOfAccessionNumber(LdapUtils.issuerValue(attrs.get("dicomIssuerOfAccessionNumber")));
        device.setOrderPlacerIdentifier(LdapUtils.issuerValue(attrs.get("dicomOrderPlacerIdentifier")));
        device.setOrderFillerIdentifier(LdapUtils.issuerValue(attrs.get("dicomOrderFillerIdentifier")));
        device.setIssuerOfAdmissionID(LdapUtils.issuerValue(attrs.get("dicomIssuerOfAdmissionID")));
        device.setIssuerOfServiceEpisodeID(LdapUtils.issuerValue(attrs.get("dicomIssuerOfServiceEpisodeID")));
        device.setIssuerOfContainerIdentifier(LdapUtils.issuerValue(attrs.get("dicomIssuerOfContainerIdentifier")));
        device.setIssuerOfSpecimenIdentifier(LdapUtils.issuerValue(attrs.get("dicomIssuerOfSpecimenIdentifier")));
        device.setInstitutionNames(LdapUtils.stringArray(attrs.get("dicomInstitutionName"), new String[0]));
        device.setInstitutionCodes(LdapUtils.codeArray(attrs.get("dicomInstitutionCode")));
        device.setInstitutionAddresses(LdapUtils.stringArray(attrs.get("dicomInstitutionAddress"), new String[0]));
        device.setInstitutionalDepartmentNames(LdapUtils.stringArray(attrs.get("dicomInstitutionDepartmentName"), new String[0]));
        device.setPrimaryDeviceTypes(LdapUtils.stringArray(attrs.get("dicomPrimaryDeviceType"), new String[0]));
        device.setRelatedDeviceRefs(LdapUtils.stringArray(attrs.get("dicomRelatedDeviceReference"), new String[0]));
        for (String dn : LdapUtils.stringArray(attrs.get("dicomAuthorizedNodeCertificateReference"), new String[0])) {
            device.setAuthorizedNodeCertificates(dn, this.loadCertificates(dn));
        }
        for (String dn : LdapUtils.stringArray(attrs.get("dicomThisNodeCertificateReference"), new String[0])) {
            device.setThisNodeCertificates(dn, this.loadCertificates(dn));
        }
        device.setVendorData(LdapDicomConfiguration.byteArrays(attrs.get("dicomVendorData")));
        device.setInstalled(LdapUtils.booleanValue(attrs.get("dicomInstalled"), true));
        if (!LdapUtils.hasObjectClass(attrs, "dcmDevice")) {
            return;
        }
        device.setRoleSelectionNegotiationLenient(LdapUtils.booleanValue(attrs.get("dcmRoleSelectionNegotiationLenient"), false));
        device.setLimitOpenAssociations(LdapUtils.intValue(attrs.get("dcmLimitOpenAssociations"), 0));
        device.setLimitAssociationsInitiatedBy(LdapUtils.stringArray(attrs.get("dcmLimitAssociationsInitiatedBy"), new String[0]));
        device.setTrustStoreURL(LdapUtils.stringValue(attrs.get("dcmTrustStoreURL"), null));
        device.setTrustStoreType(LdapUtils.stringValue(attrs.get("dcmTrustStoreType"), null));
        device.setTrustStorePin(LdapUtils.stringValue(attrs.get("dcmTrustStorePin"), null));
        device.setTrustStorePinProperty(LdapUtils.stringValue(attrs.get("dcmTrustStorePinProperty"), null));
        device.setKeyStoreURL(LdapUtils.stringValue(attrs.get("dcmKeyStoreURL"), null));
        device.setKeyStoreType(LdapUtils.stringValue(attrs.get("dcmKeyStoreType"), null));
        device.setKeyStorePin(LdapUtils.stringValue(attrs.get("dcmKeyStorePin"), null));
        device.setKeyStorePinProperty(LdapUtils.stringValue(attrs.get("dcmKeyStorePinProperty"), null));
        device.setKeyStoreKeyPin(LdapUtils.stringValue(attrs.get("dcmKeyStoreKeyPin"), null));
        device.setKeyStoreKeyPinProperty(LdapUtils.stringValue(attrs.get("dcmKeyStoreKeyPinProperty"), null));
        device.setTimeZoneOfDevice(LdapUtils.timeZoneValue(attrs.get("dcmTimeZoneOfDevice"), null));
        for (LdapDicomConfigurationExtension ext : this.extensions) {
            ext.loadFrom(device, attrs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadConnections(Device device, String deviceDN) throws NamingException {
        NamingEnumeration<SearchResult> ne = this.search(deviceDN, "(objectclass=dicomNetworkConnection)");
        try {
            while (ne.hasMore()) {
                SearchResult sr = ne.next();
                Attributes attrs = sr.getAttributes();
                Connection conn = new Connection();
                this.loadFrom(conn, attrs, LdapUtils.hasObjectClass(attrs, "dcmNetworkConnection"));
                device.addConnection(conn);
            }
        }
        finally {
            LdapUtils.safeClose(ne);
        }
    }

    public NamingEnumeration<SearchResult> search(String dn, String filter) throws NamingException {
        return this.search(dn, filter, (String[])null);
    }

    public NamingEnumeration<SearchResult> search(String dn, String filter, String ... attrs) throws NamingException {
        SearchControls ctls = new SearchControls();
        ctls.setSearchScope(1);
        ctls.setReturningObjFlag(false);
        ctls.setReturningAttributes(attrs);
        return this.ctx.search(dn, filter, ctls);
    }

    private void loadFrom(Connection conn, Attributes attrs, boolean extended) throws NamingException {
        conn.setCommonName(LdapUtils.stringValue(attrs.get("cn"), null));
        conn.setHostname(LdapUtils.stringValue(attrs.get("dicomHostname"), null));
        conn.setPort(LdapUtils.intValue(attrs.get("dicomPort"), -1));
        conn.setTlsCipherSuites(LdapUtils.stringArray(attrs.get("dicomTLSCipherSuite"), new String[0]));
        conn.setInstalled(LdapUtils.booleanValue(attrs.get("dicomInstalled"), null));
        if (!extended) {
            return;
        }
        conn.setProtocol(LdapUtils.enumValue(Connection.Protocol.class, attrs.get("dcmProtocol"), Connection.Protocol.DICOM));
        conn.setHttpProxy(LdapUtils.stringValue(attrs.get("dcmHTTPProxy"), null));
        conn.setBlacklist(LdapUtils.stringArray(attrs.get("dcmBlacklistedHostname"), new String[0]));
        conn.setBacklog(LdapUtils.intValue(attrs.get("dcmTCPBacklog"), 50));
        conn.setConnectTimeout(LdapUtils.intValue(attrs.get("dcmTCPConnectTimeout"), 0));
        conn.setRequestTimeout(LdapUtils.intValue(attrs.get("dcmAARQTimeout"), 0));
        conn.setAcceptTimeout(LdapUtils.intValue(attrs.get("dcmAAACTimeout"), 0));
        conn.setReleaseTimeout(LdapUtils.intValue(attrs.get("dcmARRPTimeout"), 0));
        conn.setSendTimeout(LdapUtils.intValue(attrs.get("dcmSendTimeout"), 0));
        conn.setStoreTimeout(LdapUtils.intValue(attrs.get("dcmStoreTimeout"), 0));
        conn.setResponseTimeout(LdapUtils.intValue(attrs.get("dcmResponseTimeout"), 0));
        conn.setRetrieveTimeout(LdapUtils.intValue(attrs.get("dcmRetrieveTimeout"), 0));
        conn.setRetrieveTimeoutTotal(LdapUtils.booleanValue(attrs.get("dcmRetrieveTimeoutTotal"), false));
        conn.setIdleTimeout(LdapUtils.intValue(attrs.get("dcmIdleTimeout"), 0));
        conn.setAbortTimeout(LdapUtils.intValue(attrs.get("dcmAATimeout"), 1000));
        conn.setSocketCloseDelay(LdapUtils.intValue(attrs.get("dcmTCPCloseDelay"), 50));
        conn.setSendBufferSize(LdapUtils.intValue(attrs.get("dcmTCPSendBufferSize"), 0));
        conn.setReceiveBufferSize(LdapUtils.intValue(attrs.get("dcmTCPReceiveBufferSize"), 0));
        conn.setTcpNoDelay(LdapUtils.booleanValue(attrs.get("dcmTCPNoDelay"), true));
        conn.setBindAddress(LdapUtils.stringValue(attrs.get("dcmBindAddress"), null));
        conn.setClientBindAddress(LdapUtils.stringValue(attrs.get("dcmClientBindAddress"), null));
        conn.setTlsNeedClientAuth(LdapUtils.booleanValue(attrs.get("dcmTLSNeedClientAuth"), true));
        conn.setTlsProtocols(LdapUtils.stringArray(attrs.get("dcmTLSProtocol"), Connection.DEFAULT_TLS_PROTOCOLS));
        conn.setTlsEndpointIdentificationAlgorithm((Connection.EndpointIdentificationAlgorithm)LdapUtils.enumValue(Connection.EndpointIdentificationAlgorithm.class, attrs.get("dcmTLSEndpointIdentificationAlgorithm"), null));
        conn.setSendPDULength(LdapUtils.intValue(attrs.get("dcmSendPDULength"), 16378));
        conn.setReceivePDULength(LdapUtils.intValue(attrs.get("dcmReceivePDULength"), 16378));
        conn.setMaxOpsPerformed(LdapUtils.intValue(attrs.get("dcmMaxOpsPerformed"), 1));
        conn.setMaxOpsInvoked(LdapUtils.intValue(attrs.get("dcmMaxOpsInvoked"), 1));
        conn.setPackPDV(LdapUtils.booleanValue(attrs.get("dcmPackPDV"), true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadApplicationEntities(Device device, String deviceDN) throws NamingException, ConfigurationException {
        NamingEnumeration<SearchResult> ne = this.search(deviceDN, "(objectclass=dicomNetworkAE)");
        try {
            while (ne.hasMore()) {
                device.addApplicationEntity(this.loadApplicationEntity(ne.next(), deviceDN, device));
            }
        }
        finally {
            LdapUtils.safeClose(ne);
        }
    }

    private ApplicationEntity loadApplicationEntity(SearchResult sr, String deviceDN, Device device) throws NamingException, ConfigurationException {
        Attributes attrs = sr.getAttributes();
        ApplicationEntity ae = new ApplicationEntity(LdapUtils.stringValue(attrs.get("dicomAETitle"), null));
        this.loadFrom(ae, attrs);
        for (String connDN : LdapUtils.stringArray(attrs.get("dicomNetworkConnectionReference"), new String[0])) {
            ae.addConnection(LdapUtils.findConnection(connDN, deviceDN, device));
        }
        this.loadChilds(ae, sr.getNameInNamespace());
        return ae;
    }

    private void loadFrom(ApplicationEntity ae, Attributes attrs) throws NamingException {
        ae.setDescription(LdapUtils.stringValue(attrs.get("dicomDescription"), null));
        ae.setVendorData(LdapDicomConfiguration.byteArrays(attrs.get("dicomVendorData")));
        ae.setApplicationClusters(LdapUtils.stringArray(attrs.get("dicomApplicationCluster"), new String[0]));
        ae.setPreferredCallingAETitles(LdapUtils.stringArray(attrs.get("dicomPreferredCallingAETitle"), new String[0]));
        ae.setPreferredCalledAETitles(LdapUtils.stringArray(attrs.get("dicomPreferredCalledAETitle"), new String[0]));
        ae.setAssociationInitiator(LdapUtils.booleanValue(attrs.get("dicomAssociationInitiator"), false));
        ae.setAssociationAcceptor(LdapUtils.booleanValue(attrs.get("dicomAssociationAcceptor"), false));
        ae.setSupportedCharacterSets(LdapUtils.stringArray(attrs.get("dicomSupportedCharacterSet"), new String[0]));
        ae.setInstalled(LdapUtils.booleanValue(attrs.get("dicomInstalled"), null));
        if (!LdapUtils.hasObjectClass(attrs, "dcmNetworkAE")) {
            return;
        }
        ae.setRoleSelectionNegotiationLenient(LdapUtils.booleanValue(attrs.get("dcmRoleSelectionNegotiationLenient"), null));
        ae.setAcceptedCallingAETitles(LdapUtils.stringArray(attrs.get("dcmAcceptedCallingAETitle"), new String[0]));
        ae.setPreferredTransferSyntaxes(LdapUtils.removeOrdinalPrefix(LdapUtils.stringArray(attrs.get("dcmPreferredTransferSyntax"), new String[0])));
        ae.setOtherAETitles(LdapUtils.stringArray(attrs.get("dcmOtherAETitle"), new String[0]));
        ae.setNoAsyncModeCalledAETitles(LdapUtils.stringArray(attrs.get("dcmNoAsyncModeCalledAETitle"), new String[0]));
        ae.setMasqueradeCallingAETitles(LdapUtils.stringArray(attrs.get("dcmMasqueradeCallingAETitle"), new String[0]));
        ae.setMasqueradeCalledAETitles(LdapUtils.stringArray(attrs.get("dcmMasqueradeCalledAETitle"), new String[0]));
        ae.setShareTransferCapabilitiesFromAETitle(LdapUtils.stringValue(attrs.get("dcmShareTransferCapabilitiesFromAETitle"), null));
        ae.setHl7ApplicationName(LdapUtils.stringValue(attrs.get("hl7ApplicationName"), null));
        for (LdapDicomConfigurationExtension ext : this.extensions) {
            ext.loadFrom(ae, attrs);
        }
    }

    private void loadChilds(ApplicationEntity ae, String aeDN) throws NamingException, ConfigurationException {
        this.loadTransferCapabilities(ae, aeDN);
        for (LdapDicomConfigurationExtension ext : this.extensions) {
            ext.loadChilds(ae, aeDN);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadWebApplications(Device device, String deviceDN) throws NamingException, ConfigurationException {
        NamingEnumeration<SearchResult> ne = this.search(deviceDN, "(objectclass=dcmWebApp)");
        try {
            while (ne.hasMore()) {
                device.addWebApplication(this.loadWebApplication(ne.next(), deviceDN, device));
            }
        }
        finally {
            LdapUtils.safeClose(ne);
        }
    }

    private WebApplication loadWebApplication(SearchResult sr, String deviceDN, Device device) throws NamingException, ConfigurationException {
        Attributes attrs = sr.getAttributes();
        WebApplication webapp = new WebApplication(LdapUtils.stringValue(attrs.get("dcmWebAppName"), null));
        this.loadFrom(webapp, attrs);
        for (String connDN : LdapUtils.stringArray(attrs.get("dicomNetworkConnectionReference"), new String[0])) {
            webapp.addConnection(LdapUtils.findConnection(connDN, deviceDN, device));
        }
        return webapp;
    }

    private void loadFrom(WebApplication webapp, Attributes attrs) throws NamingException {
        webapp.setDescription(LdapUtils.stringValue(attrs.get("dicomDescription"), null));
        webapp.setServicePath(LdapUtils.stringValue(attrs.get("dcmWebServicePath"), null));
        webapp.setKeycloakClientID(LdapUtils.stringValue(attrs.get("dcmKeycloakClientID"), null));
        webapp.setServiceClasses((WebApplication.ServiceClass[])LdapUtils.enumArray(WebApplication.ServiceClass.class, (Attribute)attrs.get("dcmWebServiceClass")));
        webapp.setAETitle(LdapUtils.stringValue(attrs.get("dicomAETitle"), null));
        webapp.setApplicationClusters(LdapUtils.stringArray(attrs.get("dicomApplicationCluster"), new String[0]));
        webapp.setProperties(LdapUtils.stringArray(attrs.get("dcmProperty"), new String[0]));
        webapp.setInstalled(LdapUtils.booleanValue(attrs.get("dicomInstalled"), null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadKeycloakClients(Device device, String deviceDN) throws NamingException {
        NamingEnumeration<SearchResult> ne = this.search(deviceDN, "(objectclass=dcmKeycloakClient)");
        try {
            while (ne.hasMore()) {
                device.addKeycloakClient(this.loadKeycloakClient(ne.next()));
            }
        }
        finally {
            LdapUtils.safeClose(ne);
        }
    }

    private KeycloakClient loadKeycloakClient(SearchResult sr) throws NamingException {
        Attributes attrs = sr.getAttributes();
        KeycloakClient client = new KeycloakClient(LdapUtils.stringValue(attrs.get("dcmKeycloakClientID"), null));
        this.loadFrom(client, attrs);
        return client;
    }

    private void loadFrom(KeycloakClient client, Attributes attrs) throws NamingException {
        client.setKeycloakServerURL(LdapUtils.stringValue(attrs.get("dcmURI"), null));
        client.setKeycloakRealm(LdapUtils.stringValue(attrs.get("dcmKeycloakRealm"), null));
        client.setKeycloakGrantType(LdapUtils.enumValue(KeycloakClient.GrantType.class, attrs.get("dcmKeycloakGrantType"), KeycloakClient.GrantType.client_credentials));
        client.setKeycloakClientSecret(LdapUtils.stringValue(attrs.get("dcmKeycloakClientSecret"), null));
        client.setTLSAllowAnyHostname(LdapUtils.booleanValue(attrs.get("dcmTLSAllowAnyHostname"), false));
        client.setTLSDisableTrustManager(LdapUtils.booleanValue(attrs.get("dcmTLSDisableTrustManager"), false));
        client.setUserID(LdapUtils.stringValue(attrs.get("uid"), null));
        client.setPassword(LdapUtils.stringValue(attrs.get("userPassword"), null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadTransferCapabilities(ApplicationEntity ae, String aeDN) throws NamingException {
        NamingEnumeration<SearchResult> ne = this.search(aeDN, "(objectclass=dicomTransferCapability)");
        try {
            while (ne.hasMore()) {
                ae.addTransferCapability(this.loadTransferCapability(ne.next()));
            }
        }
        finally {
            LdapUtils.safeClose(ne);
        }
    }

    private TransferCapability loadTransferCapability(SearchResult sr) throws NamingException {
        Attributes attrs = sr.getAttributes();
        TransferCapability tc = new TransferCapability();
        this.loadFrom(tc, attrs);
        return tc;
    }

    private List<ModificationItem> storeDiffs(ConfigurationChanges.ModifiedObject ldapObj, Device a, Device b, List<ModificationItem> mods, boolean preserveVendorData) {
        LdapUtils.storeDiffObject(ldapObj, mods, "dicomDescription", a.getDescription(), b.getDescription(), null);
        LdapUtils.storeDiffObject(ldapObj, mods, "dicomDeviceUID", a.getDeviceUID(), b.getDeviceUID(), null);
        LdapUtils.storeDiffObject(ldapObj, mods, "dicomManufacturer", a.getManufacturer(), b.getManufacturer(), null);
        LdapUtils.storeDiffObject(ldapObj, mods, "dicomManufacturerModelName", a.getManufacturerModelName(), b.getManufacturerModelName(), null);
        LdapUtils.storeDiff(ldapObj, mods, "dicomSoftwareVersion", a.getSoftwareVersions(), b.getSoftwareVersions(), new String[0]);
        LdapUtils.storeDiffObject(ldapObj, mods, "dicomStationName", a.getStationName(), b.getStationName(), null);
        LdapUtils.storeDiffObject(ldapObj, mods, "dicomDeviceSerialNumber", a.getDeviceSerialNumber(), b.getDeviceSerialNumber(), null);
        LdapUtils.storeDiffObject(ldapObj, mods, "dicomIssuerOfPatientID", a.getIssuerOfPatientID(), b.getIssuerOfPatientID(), null);
        LdapUtils.storeDiffObject(ldapObj, mods, "dicomIssuerOfAccessionNumber", a.getIssuerOfAccessionNumber(), b.getIssuerOfAccessionNumber(), null);
        LdapUtils.storeDiffObject(ldapObj, mods, "dicomOrderPlacerIdentifier", a.getOrderPlacerIdentifier(), b.getOrderPlacerIdentifier(), null);
        LdapUtils.storeDiffObject(ldapObj, mods, "dicomOrderFillerIdentifier", a.getOrderFillerIdentifier(), b.getOrderFillerIdentifier(), null);
        LdapUtils.storeDiffObject(ldapObj, mods, "dicomIssuerOfAdmissionID", a.getIssuerOfAdmissionID(), b.getIssuerOfAdmissionID(), null);
        LdapUtils.storeDiffObject(ldapObj, mods, "dicomIssuerOfServiceEpisodeID", a.getIssuerOfServiceEpisodeID(), b.getIssuerOfServiceEpisodeID(), null);
        LdapUtils.storeDiffObject(ldapObj, mods, "dicomIssuerOfContainerIdentifier", a.getIssuerOfContainerIdentifier(), b.getIssuerOfContainerIdentifier(), null);
        LdapUtils.storeDiffObject(ldapObj, mods, "dicomIssuerOfSpecimenIdentifier", a.getIssuerOfSpecimenIdentifier(), b.getIssuerOfSpecimenIdentifier(), null);
        LdapUtils.storeDiff(ldapObj, mods, "dicomInstitutionName", a.getInstitutionNames(), b.getInstitutionNames(), new String[0]);
        LdapUtils.storeDiff(ldapObj, mods, "dicomInstitutionCode", a.getInstitutionCodes(), b.getInstitutionCodes(), new Code[0]);
        LdapUtils.storeDiff(ldapObj, mods, "dicomInstitutionAddress", a.getInstitutionAddresses(), b.getInstitutionAddresses(), new String[0]);
        LdapUtils.storeDiff(ldapObj, mods, "dicomInstitutionDepartmentName", a.getInstitutionalDepartmentNames(), b.getInstitutionalDepartmentNames(), new String[0]);
        LdapUtils.storeDiff(ldapObj, mods, "dicomPrimaryDeviceType", a.getPrimaryDeviceTypes(), b.getPrimaryDeviceTypes(), new String[0]);
        LdapUtils.storeDiff(ldapObj, mods, "dicomRelatedDeviceReference", a.getRelatedDeviceRefs(), b.getRelatedDeviceRefs(), new String[0]);
        LdapUtils.storeDiff(ldapObj, mods, "dicomAuthorizedNodeCertificateReference", a.getAuthorizedNodeCertificateRefs(), b.getAuthorizedNodeCertificateRefs(), new String[0]);
        LdapUtils.storeDiff(ldapObj, mods, "dicomThisNodeCertificateReference", a.getThisNodeCertificateRefs(), b.getThisNodeCertificateRefs(), new String[0]);
        if (!preserveVendorData) {
            LdapDicomConfiguration.storeDiff(ldapObj, mods, "dicomVendorData", a.getVendorData(), b.getVendorData());
        }
        LdapUtils.storeDiffObject(ldapObj, mods, "dicomInstalled", a.isInstalled(), b.isInstalled(), null);
        if (!this.extended) {
            return mods;
        }
        LdapUtils.storeDiffObject(ldapObj, mods, "dcmRoleSelectionNegotiationLenient", a.isRoleSelectionNegotiationLenient(), b.isRoleSelectionNegotiationLenient(), false);
        LdapUtils.storeDiffObject(ldapObj, mods, "dcmLimitOpenAssociations", a.getLimitOpenAssociations(), b.getLimitOpenAssociations(), null);
        LdapUtils.storeDiff(ldapObj, mods, "dcmLimitAssociationsInitiatedBy", a.getLimitAssociationsInitiatedBy(), b.getLimitAssociationsInitiatedBy(), new String[0]);
        LdapUtils.storeDiffObject(ldapObj, mods, "dcmTrustStoreURL", a.getTrustStoreURL(), b.getTrustStoreURL(), null);
        LdapUtils.storeDiffObject(ldapObj, mods, "dcmTrustStoreType", a.getTrustStoreType(), b.getTrustStoreType(), null);
        LdapUtils.storeDiffObject(ldapObj, mods, "dcmTrustStorePin", a.getTrustStorePin(), b.getTrustStorePin(), null);
        LdapUtils.storeDiffObject(ldapObj, mods, "dcmTrustStorePinProperty", a.getTrustStorePinProperty(), b.getTrustStorePinProperty(), null);
        LdapUtils.storeDiffObject(ldapObj, mods, "dcmKeyStoreURL", a.getKeyStoreURL(), b.getKeyStoreURL(), null);
        LdapUtils.storeDiffObject(ldapObj, mods, "dcmKeyStoreType", a.getKeyStoreType(), b.getKeyStoreType(), null);
        LdapUtils.storeDiffObject(ldapObj, mods, "dcmKeyStorePin", a.getKeyStorePin(), b.getKeyStorePin(), null);
        LdapUtils.storeDiffObject(ldapObj, mods, "dcmKeyStorePinProperty", a.getKeyStorePinProperty(), b.getKeyStorePinProperty(), null);
        LdapUtils.storeDiffObject(ldapObj, mods, "dcmKeyStoreKeyPin", a.getKeyStoreKeyPin(), b.getKeyStoreKeyPin(), null);
        LdapUtils.storeDiffObject(ldapObj, mods, "dcmKeyStoreKeyPinProperty", a.getKeyStoreKeyPinProperty(), b.getKeyStoreKeyPinProperty(), null);
        LdapUtils.storeDiffObject(ldapObj, mods, "dcmTimeZoneOfDevice", a.getTimeZoneOfDevice(), b.getTimeZoneOfDevice(), null);
        for (LdapDicomConfigurationExtension ext : this.extensions) {
            ext.storeDiffs(ldapObj, a, b, mods);
        }
        return mods;
    }

    private List<ModificationItem> storeDiffs(ConfigurationChanges.ModifiedObject ldapObj, Connection a, Connection b, List<ModificationItem> mods) {
        LdapUtils.storeDiffObject(ldapObj, mods, "dicomHostname", a.getHostname(), b.getHostname(), null);
        LdapUtils.storeDiff(ldapObj, mods, "dicomPort", a.getPort(), b.getPort(), -1);
        LdapUtils.storeDiff(ldapObj, mods, "dicomTLSCipherSuite", a.getTlsCipherSuites(), b.getTlsCipherSuites(), new String[0]);
        LdapUtils.storeDiffObject(ldapObj, mods, "dicomInstalled", a.getInstalled(), b.getInstalled(), null);
        if (!this.extended) {
            return mods;
        }
        LdapUtils.storeDiffObject(ldapObj, mods, "dcmProtocol", a.getProtocol(), b.getProtocol(), Connection.Protocol.DICOM);
        LdapUtils.storeDiffObject(ldapObj, mods, "dcmHTTPProxy", a.getHttpProxy(), b.getHttpProxy(), null);
        LdapUtils.storeDiff(ldapObj, mods, "dcmBlacklistedHostname", a.getBlacklist(), b.getBlacklist(), new String[0]);
        LdapUtils.storeDiff(ldapObj, mods, "dcmTCPBacklog", a.getBacklog(), b.getBacklog(), 50);
        LdapUtils.storeDiff(ldapObj, mods, "dcmTCPConnectTimeout", a.getConnectTimeout(), b.getConnectTimeout(), 0);
        LdapUtils.storeDiff(ldapObj, mods, "dcmAARQTimeout", a.getRequestTimeout(), b.getRequestTimeout(), 0);
        LdapUtils.storeDiff(ldapObj, mods, "dcmAAACTimeout", a.getAcceptTimeout(), b.getAcceptTimeout(), 0);
        LdapUtils.storeDiff(ldapObj, mods, "dcmARRPTimeout", a.getReleaseTimeout(), b.getReleaseTimeout(), 0);
        LdapUtils.storeDiff(ldapObj, mods, "dcmSendTimeout", a.getSendTimeout(), b.getSendTimeout(), 0);
        LdapUtils.storeDiff(ldapObj, mods, "dcmStoreTimeout", a.getStoreTimeout(), b.getStoreTimeout(), 0);
        LdapUtils.storeDiff(ldapObj, mods, "dcmResponseTimeout", a.getResponseTimeout(), b.getResponseTimeout(), 0);
        LdapUtils.storeDiff(ldapObj, mods, "dcmRetrieveTimeout", a.getRetrieveTimeout(), b.getRetrieveTimeout(), 0);
        LdapUtils.storeDiff(ldapObj, mods, "dcmRetrieveTimeoutTotal", a.isRetrieveTimeoutTotal(), b.isRetrieveTimeoutTotal(), false);
        LdapUtils.storeDiff(ldapObj, mods, "dcmIdleTimeout", a.getIdleTimeout(), b.getIdleTimeout(), 0);
        LdapUtils.storeDiff(ldapObj, mods, "dcmAATimeout", a.getAbortTimeout(), b.getAbortTimeout(), 1000);
        LdapUtils.storeDiff(ldapObj, mods, "dcmTCPCloseDelay", a.getSocketCloseDelay(), b.getSocketCloseDelay(), 50);
        LdapUtils.storeDiff(ldapObj, mods, "dcmTCPSendBufferSize", a.getSendBufferSize(), b.getSendBufferSize(), 0);
        LdapUtils.storeDiff(ldapObj, mods, "dcmTCPReceiveBufferSize", a.getReceiveBufferSize(), b.getReceiveBufferSize(), 0);
        LdapUtils.storeDiff(ldapObj, mods, "dcmTCPNoDelay", a.isTcpNoDelay(), b.isTcpNoDelay(), true);
        LdapUtils.storeDiffObject(ldapObj, mods, "dcmBindAddress", a.getBindAddress(), b.getBindAddress(), null);
        LdapUtils.storeDiffObject(ldapObj, mods, "dcmClientBindAddress", a.getClientBindAddress(), b.getClientBindAddress(), null);
        LdapUtils.storeDiff(ldapObj, mods, "dcmTLSProtocol", a.getTlsProtocols(), b.getTlsProtocols(), Connection.DEFAULT_TLS_PROTOCOLS);
        LdapUtils.storeDiff(ldapObj, mods, "dcmTLSNeedClientAuth", a.isTlsNeedClientAuth(), b.isTlsNeedClientAuth(), true);
        LdapUtils.storeDiffObject(ldapObj, mods, "dcmTLSEndpointIdentificationAlgorithm", a.getTlsEndpointIdentificationAlgorithm(), b.getTlsEndpointIdentificationAlgorithm(), null);
        LdapUtils.storeDiff(ldapObj, mods, "dcmSendPDULength", a.getSendPDULength(), b.getSendPDULength(), 16378);
        LdapUtils.storeDiff(ldapObj, mods, "dcmReceivePDULength", a.getReceivePDULength(), b.getReceivePDULength(), 16378);
        LdapUtils.storeDiff(ldapObj, mods, "dcmMaxOpsPerformed", a.getMaxOpsPerformed(), b.getMaxOpsPerformed(), 1);
        LdapUtils.storeDiff(ldapObj, mods, "dcmMaxOpsInvoked", a.getMaxOpsInvoked(), b.getMaxOpsInvoked(), 1);
        LdapUtils.storeDiff(ldapObj, mods, "dcmPackPDV", a.isPackPDV(), b.isPackPDV(), true);
        return mods;
    }

    private List<ModificationItem> storeDiffs(ConfigurationChanges.ModifiedObject ldapObj, ApplicationEntity a, ApplicationEntity b, String deviceDN, List<ModificationItem> mods, boolean preserveVendorData) {
        LdapUtils.storeDiffObject(ldapObj, mods, "dicomDescription", a.getDescription(), b.getDescription(), null);
        if (!preserveVendorData) {
            LdapDicomConfiguration.storeDiff(ldapObj, mods, "dicomVendorData", a.getVendorData(), b.getVendorData());
        }
        LdapUtils.storeDiff(ldapObj, mods, "dicomApplicationCluster", a.getApplicationClusters(), b.getApplicationClusters(), new String[0]);
        LdapUtils.storeDiff(ldapObj, mods, "dicomPreferredCallingAETitle", a.getPreferredCallingAETitles(), b.getPreferredCallingAETitles(), new String[0]);
        LdapUtils.storeDiff(ldapObj, mods, "dicomPreferredCalledAETitle", a.getPreferredCalledAETitles(), b.getPreferredCalledAETitles(), new String[0]);
        LdapUtils.storeDiffObject(ldapObj, mods, "dicomAssociationInitiator", a.isAssociationInitiator(), b.isAssociationInitiator(), null);
        LdapUtils.storeDiffObject(ldapObj, mods, "dicomAssociationAcceptor", a.isAssociationAcceptor(), b.isAssociationAcceptor(), null);
        LdapUtils.storeDiff(ldapObj, mods, "dicomNetworkConnectionReference", a.getConnections(), b.getConnections(), deviceDN);
        LdapUtils.storeDiff(ldapObj, mods, "dicomSupportedCharacterSet", a.getSupportedCharacterSets(), b.getSupportedCharacterSets(), new String[0]);
        LdapUtils.storeDiffObject(ldapObj, mods, "dicomInstalled", a.getInstalled(), b.getInstalled(), null);
        if (!this.extended) {
            return mods;
        }
        LdapUtils.storeDiffObject(ldapObj, mods, "dcmRoleSelectionNegotiationLenient", a.isRoleSelectionNegotiationLenient(), b.isRoleSelectionNegotiationLenient(), null);
        LdapUtils.storeDiffWithOrdinalPrefix(ldapObj, mods, "dcmPreferredTransferSyntax", a.getPreferredTransferSyntaxes(), b.getPreferredTransferSyntaxes());
        LdapUtils.storeDiff(ldapObj, mods, "dcmAcceptedCallingAETitle", a.getAcceptedCallingAETitles(), b.getAcceptedCallingAETitles(), new String[0]);
        LdapUtils.storeDiff(ldapObj, mods, "dcmOtherAETitle", a.getOtherAETitles(), b.getOtherAETitles(), new String[0]);
        LdapUtils.storeDiff(ldapObj, mods, "dcmNoAsyncModeCalledAETitle", a.getNoAsyncModeCalledAETitles(), b.getNoAsyncModeCalledAETitles(), new String[0]);
        LdapUtils.storeDiff(ldapObj, mods, "dcmMasqueradeCallingAETitle", a.getMasqueradeCallingAETitles(), b.getMasqueradeCallingAETitles(), new String[0]);
        LdapUtils.storeDiff(ldapObj, mods, "dcmMasqueradeCalledAETitle", a.getMasqueradeCalledAETitles(), b.getMasqueradeCalledAETitles(), new String[0]);
        LdapUtils.storeDiffObject(ldapObj, mods, "dcmShareTransferCapabilitiesFromAETitle", a.getShareTransferCapabilitiesFromAETitle(), b.getShareTransferCapabilitiesFromAETitle(), null);
        LdapUtils.storeDiffObject(ldapObj, mods, "hl7ApplicationName", a.getHl7ApplicationName(), b.getHl7ApplicationName(), null);
        for (LdapDicomConfigurationExtension ext : this.extensions) {
            ext.storeDiffs(ldapObj, a, b, mods);
        }
        return mods;
    }

    private List<ModificationItem> storeDiffs(ConfigurationChanges.ModifiedObject ldapObj, TransferCapability a, TransferCapability b, List<ModificationItem> mods) {
        LdapUtils.storeDiffObject(ldapObj, mods, "dicomSOPClass", a.getSopClass(), b.getSopClass(), null);
        LdapUtils.storeDiffObject(ldapObj, mods, "dicomTransferRole", a.getRole(), b.getRole(), null);
        LdapUtils.storeDiff(ldapObj, mods, "dicomTransferSyntax", a.getTransferSyntaxes(), b.getTransferSyntaxes(), new String[0]);
        if (!this.extended) {
            return mods;
        }
        LdapUtils.storeDiffWithOrdinalPrefix(ldapObj, mods, "dcmPreferredTransferSyntax", a.getPreferredTransferSyntaxes(), b.getPreferredTransferSyntaxes());
        this.storeDiffs(ldapObj, a.getQueryOptions(), b.getQueryOptions(), mods);
        this.storeDiffs(ldapObj, a.getStorageOptions(), b.getStorageOptions(), mods);
        return mods;
    }

    private void storeDiffs(ConfigurationChanges.ModifiedObject ldapObj, EnumSet<QueryOption> prev, EnumSet<QueryOption> val, List<ModificationItem> mods) {
        if (prev != null ? prev.equals(val) : val == null) {
            return;
        }
        LdapUtils.storeDiff(ldapObj, mods, "dcmRelationalQueries", prev != null && prev.contains(QueryOption.RELATIONAL), val != null && val.contains(QueryOption.RELATIONAL), false);
        LdapUtils.storeDiff(ldapObj, mods, "dcmCombinedDateTimeMatching", prev != null && prev.contains(QueryOption.DATETIME), val != null && val.contains(QueryOption.DATETIME), false);
        LdapUtils.storeDiff(ldapObj, mods, "dcmFuzzySemanticMatching", prev != null && prev.contains(QueryOption.FUZZY), val != null && val.contains(QueryOption.FUZZY), false);
        LdapUtils.storeDiff(ldapObj, mods, "dcmTimezoneQueryAdjustment", prev != null && prev.contains(QueryOption.TIMEZONE), val != null && val.contains(QueryOption.TIMEZONE), false);
    }

    private void storeDiffs(ConfigurationChanges.ModifiedObject ldapObj, StorageOptions prev, StorageOptions val, List<ModificationItem> mods) {
        if (prev != null ? prev.equals((Object)val) : val == null) {
            return;
        }
        LdapUtils.storeDiff(ldapObj, mods, "dcmStorageConformance", prev != null ? prev.getLevelOfSupport().ordinal() : -1, val != null ? val.getLevelOfSupport().ordinal() : -1, -1);
        LdapUtils.storeDiff(ldapObj, mods, "dcmDigitalSignatureSupport", prev != null ? prev.getDigitalSignatureSupport().ordinal() : -1, val != null ? val.getDigitalSignatureSupport().ordinal() : -1, -1);
        LdapUtils.storeDiff(ldapObj, mods, "dcmDataElementCoercion", prev != null ? prev.getElementCoercion().ordinal() : -1, val != null ? val.getElementCoercion().ordinal() : -1, -1);
    }

    private List<ModificationItem> storeDiffs(ConfigurationChanges.ModifiedObject ldapObj, WebApplication a, WebApplication b, String deviceDN, List<ModificationItem> mods) {
        LdapUtils.storeDiffObject(ldapObj, mods, "dicomDescription", a.getDescription(), b.getDescription(), null);
        LdapUtils.storeDiffObject(ldapObj, mods, "dcmWebServicePath", a.getServicePath(), b.getServicePath(), null);
        LdapUtils.storeDiff(ldapObj, mods, "dcmWebServiceClass", a.getServiceClasses(), b.getServiceClasses(), new WebApplication.ServiceClass[0]);
        LdapUtils.storeDiffObject(ldapObj, mods, "dicomAETitle", a.getAETitle(), b.getAETitle(), null);
        LdapUtils.storeDiffObject(ldapObj, mods, "dcmKeycloakClientID", a.getKeycloakClientID(), b.getKeycloakClientID(), null);
        LdapUtils.storeDiff(ldapObj, mods, "dicomApplicationCluster", a.getApplicationClusters(), b.getApplicationClusters(), new String[0]);
        LdapUtils.storeDiffProperties(ldapObj, mods, "dcmProperty", a.getProperties(), b.getProperties());
        LdapUtils.storeDiff(ldapObj, mods, "dicomNetworkConnectionReference", a.getConnections(), b.getConnections(), deviceDN);
        LdapUtils.storeDiffObject(ldapObj, mods, "dicomInstalled", a.getInstalled(), b.getInstalled(), null);
        return mods;
    }

    private List<ModificationItem> storeDiffs(ConfigurationChanges.ModifiedObject ldapObj, KeycloakClient a, KeycloakClient b, List<ModificationItem> mods) {
        LdapUtils.storeDiffObject(ldapObj, mods, "dcmURI", a.getKeycloakServerURL(), b.getKeycloakServerURL(), null);
        LdapUtils.storeDiffObject(ldapObj, mods, "dcmKeycloakRealm", a.getKeycloakRealm(), b.getKeycloakRealm(), null);
        LdapUtils.storeDiffObject(ldapObj, mods, "dcmKeycloakGrantType", a.getKeycloakGrantType(), b.getKeycloakGrantType(), KeycloakClient.GrantType.client_credentials);
        LdapUtils.storeDiffObject(ldapObj, mods, "dcmKeycloakClientSecret", a.getKeycloakClientSecret(), b.getKeycloakClientSecret(), null);
        LdapUtils.storeDiff(ldapObj, mods, "dcmTLSAllowAnyHostname", a.isTLSAllowAnyHostname(), b.isTLSAllowAnyHostname(), false);
        LdapUtils.storeDiff(ldapObj, mods, "dcmTLSDisableTrustManager", a.isTLSDisableTrustManager(), b.isTLSDisableTrustManager(), false);
        LdapUtils.storeDiffObject(ldapObj, mods, "uid", a.getUserID(), b.getUserID(), null);
        LdapUtils.storeDiffObject(ldapObj, mods, "userPassword", a.getPassword(), b.getPassword(), null);
        return mods;
    }

    private static byte[][] byteArrays(Attribute attr) throws NamingException {
        if (attr == null) {
            return new byte[0][];
        }
        byte[][] bb = new byte[attr.size()][];
        for (int i = 0; i < bb.length; ++i) {
            bb[i] = (byte[])attr.get(i);
        }
        return bb;
    }

    private void mergeAEs(ConfigurationChanges diffs, Device prevDev, Device dev, String deviceDN, boolean preserveVendorData) throws NamingException {
        Collection aets = dev.getApplicationAETitles();
        for (String aet : prevDev.getApplicationAETitles()) {
            if (aets.contains(aet)) continue;
            String aetDN = LdapDicomConfiguration.aetDN(aet, deviceDN);
            this.destroySubcontextWithChilds(aetDN);
            ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)aetDN, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.D);
        }
        Collection prevAETs = prevDev.getApplicationAETitles();
        for (ApplicationEntity ae : dev.getApplicationEntities()) {
            String aet = ae.getAETitle();
            if (!prevAETs.contains(aet)) {
                this.store(diffs, ae, deviceDN);
                continue;
            }
            this.merge(diffs, prevDev.getApplicationEntity(aet), ae, deviceDN, preserveVendorData);
        }
    }

    private void merge(ConfigurationChanges diffs, ApplicationEntity prev, ApplicationEntity ae, String deviceDN, boolean preserveVendorData) throws NamingException {
        String aeDN = LdapDicomConfiguration.aetDN(ae.getAETitle(), deviceDN);
        ConfigurationChanges.ModifiedObject ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)aeDN, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.U);
        this.modifyAttributes(aeDN, this.storeDiffs(ldapObj, prev, ae, deviceDN, new ArrayList<ModificationItem>(), preserveVendorData));
        ConfigurationChanges.removeLastIfEmpty((ConfigurationChanges)diffs, (ConfigurationChanges.ModifiedObject)ldapObj);
        this.mergeChilds(diffs, prev, ae, aeDN);
    }

    private void mergeChilds(ConfigurationChanges diffs, ApplicationEntity prev, ApplicationEntity ae, String aeDN) throws NamingException {
        this.merge(diffs, prev.getTransferCapabilities(), ae.getTransferCapabilities(), aeDN);
        for (LdapDicomConfigurationExtension ext : this.extensions) {
            ext.mergeChilds(diffs, prev, ae, aeDN);
        }
    }

    private void mergeWebApps(ConfigurationChanges diffs, Device prevDev, Device dev, String deviceDN) throws NamingException {
        Collection names = dev.getWebApplicationNames();
        for (String webAppName : prevDev.getWebApplicationNames()) {
            if (names.contains(webAppName)) continue;
            String webAppDN = LdapDicomConfiguration.webAppDN(webAppName, deviceDN);
            this.destroySubcontextWithChilds(webAppDN);
            ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)webAppDN, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.D);
        }
        Collection prevNames = prevDev.getWebApplicationNames();
        for (WebApplication webapp : dev.getWebApplications()) {
            String name = webapp.getApplicationName();
            if (!prevNames.contains(name)) {
                this.store(diffs, webapp, deviceDN);
                continue;
            }
            this.merge(diffs, prevDev.getWebApplication(name), webapp, deviceDN);
        }
    }

    private void merge(ConfigurationChanges diffs, WebApplication prev, WebApplication webapp, String deviceDN) throws NamingException {
        String webappDN = LdapDicomConfiguration.webAppDN(webapp.getApplicationName(), deviceDN);
        ConfigurationChanges.ModifiedObject ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)webappDN, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.U);
        this.modifyAttributes(webappDN, this.storeDiffs(ldapObj, prev, webapp, deviceDN, new ArrayList<ModificationItem>()));
        ConfigurationChanges.removeLastIfEmpty((ConfigurationChanges)diffs, (ConfigurationChanges.ModifiedObject)ldapObj);
    }

    private void mergeKeycloakClients(ConfigurationChanges diffs, Device prevDev, Device dev, String deviceDN) throws NamingException {
        Collection clientIDs = dev.getKeycloakClientIDs();
        for (String clientID : prevDev.getKeycloakClientIDs()) {
            if (clientIDs.contains(clientID)) continue;
            String keycloakClientDN = LdapDicomConfiguration.keycloakClientDN(clientID, deviceDN);
            this.destroySubcontextWithChilds(keycloakClientDN);
            ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)keycloakClientDN, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.D);
        }
        Collection prevClientIDs = prevDev.getKeycloakClientIDs();
        for (KeycloakClient client : dev.getKeycloakClients()) {
            String clientID = client.getKeycloakClientID();
            if (!prevClientIDs.contains(clientID)) {
                this.store(diffs, client, deviceDN);
                continue;
            }
            this.merge(diffs, prevDev.getKeycloakClient(clientID), client, deviceDN);
        }
    }

    private void merge(ConfigurationChanges diffs, KeycloakClient prev, KeycloakClient client, String deviceDN) throws NamingException {
        String clientDN = LdapDicomConfiguration.keycloakClientDN(client.getKeycloakClientID(), deviceDN);
        ConfigurationChanges.ModifiedObject ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)clientDN, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.U);
        this.modifyAttributes(clientDN, this.storeDiffs(ldapObj, prev, client, new ArrayList<ModificationItem>()));
        ConfigurationChanges.removeLastIfEmpty((ConfigurationChanges)diffs, (ConfigurationChanges.ModifiedObject)ldapObj);
    }

    public void modifyAttributes(String dn, List<ModificationItem> mods) throws NamingException {
        if (!mods.isEmpty()) {
            this.ctx.modifyAttributes(dn, mods.toArray(new ModificationItem[mods.size()]));
        }
    }

    public void replaceAttributes(String dn, Attributes attrs) throws NamingException {
        this.ctx.modifyAttributes(dn, 2, attrs);
    }

    private void merge(ConfigurationChanges diffs, Collection<TransferCapability> prevs, Collection<TransferCapability> tcs, String aeDN) throws NamingException {
        String dn;
        for (TransferCapability tc : prevs) {
            dn = LdapDicomConfiguration.dnOf(tc, aeDN);
            if (LdapDicomConfiguration.findByDN(aeDN, tcs, dn) != null) continue;
            this.destroySubcontext(dn);
            ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.D);
        }
        for (TransferCapability tc : tcs) {
            ConfigurationChanges.ModifiedObject ldapObj;
            dn = LdapDicomConfiguration.dnOf(tc, aeDN);
            TransferCapability prev = LdapDicomConfiguration.findByDN(aeDN, prevs, dn);
            if (prev == null) {
                ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
                this.createSubcontext(dn, this.storeTo((ConfigurationChanges.ModifiedObject)ConfigurationChanges.nullifyIfNotVerbose((ConfigurationChanges)diffs, (Object)ldapObj), tc, (Attributes)new BasicAttributes(true)));
                continue;
            }
            ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.U);
            this.modifyAttributes(dn, this.storeDiffs(ldapObj, prev, tc, new ArrayList<ModificationItem>()));
            ConfigurationChanges.removeLastIfEmpty((ConfigurationChanges)diffs, (ConfigurationChanges.ModifiedObject)ldapObj);
        }
    }

    private void mergeConnections(ConfigurationChanges diffs, Device prevDev, Device device, String deviceDN) throws NamingException {
        String dn;
        List prevs = prevDev.listConnections();
        List conns = device.listConnections();
        for (Connection prev : prevs) {
            dn = LdapUtils.dnOf(prev, deviceDN);
            if (LdapUtils.findByDN(deviceDN, conns, dn) != null) continue;
            this.destroySubcontext(dn);
            ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.D);
        }
        for (Connection conn : conns) {
            ConfigurationChanges.ModifiedObject ldapObj;
            dn = LdapUtils.dnOf(conn, deviceDN);
            Connection prev = LdapUtils.findByDN(deviceDN, prevs, dn);
            if (prev == null) {
                ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
                this.createSubcontext(dn, this.storeTo((ConfigurationChanges.ModifiedObject)ConfigurationChanges.nullifyIfNotVerbose((ConfigurationChanges)diffs, (Object)ldapObj), conn, (Attributes)new BasicAttributes(true)));
                continue;
            }
            ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.U);
            this.modifyAttributes(dn, this.storeDiffs(ldapObj, prev, conn, new ArrayList<ModificationItem>()));
            ConfigurationChanges.removeLastIfEmpty((ConfigurationChanges)diffs, (ConfigurationChanges.ModifiedObject)ldapObj);
        }
    }

    private static TransferCapability findByDN(String aeDN, Collection<TransferCapability> tcs, String dn) {
        for (TransferCapability tc : tcs) {
            if (!dn.equals(LdapDicomConfiguration.dnOf(tc, aeDN))) continue;
            return tc;
        }
        return null;
    }

    private static void storeDiff(ConfigurationChanges.ModifiedObject ldapObj, List<ModificationItem> mods, String attrId, byte[][] prevs, byte[][] vals) {
        if (!LdapDicomConfiguration.equals(prevs, vals)) {
            mods.add(vals.length == 0 ? new ModificationItem(3, new BasicAttribute(attrId)) : new ModificationItem(2, LdapDicomConfiguration.attr(attrId, vals)));
            if (ldapObj != null) {
                ConfigurationChanges.ModifiedAttribute attribute = new ConfigurationChanges.ModifiedAttribute(attrId);
                for (byte[] val : vals) {
                    attribute.addValue((Object)(val.length + " bytes"));
                }
                for (byte[] prev : prevs) {
                    attribute.removeValue((Object)(prev.length + " bytes"));
                }
                ldapObj.add(attribute);
            }
        }
    }

    private static boolean equals(byte[][] a, byte[][] a2) {
        int length = a.length;
        if (a2.length != length) {
            return false;
        }
        block0: for (byte[] o1 : a) {
            for (byte[] o2 : a2) {
                if (Arrays.equals(o1, o2)) continue block0;
            }
            return false;
        }
        return true;
    }

    private static String aetDN(String aet, String parentDN) {
        return LdapUtils.dnOf("dicomAETitle", aet, parentDN);
    }

    private static String webAppDN(String webAppName, String parentDN) {
        return LdapUtils.dnOf("dcmWebAppName", webAppName, parentDN);
    }

    private static String keycloakClientDN(String keycloakClientID, String parentDN) {
        return LdapUtils.dnOf("dcmKeycloakClientID", keycloakClientID, parentDN);
    }

    public String deviceRef(String name) {
        return LdapUtils.dnOf("dicomDeviceName", name, this.devicesDN);
    }

    private static String dnOf(TransferCapability tc, String aeDN) {
        String cn = tc.getCommonName();
        return cn != null ? LdapUtils.dnOf("cn", cn, aeDN) : LdapUtils.dnOf("dicomSOPClass", tc.getSopClass(), "dicomTransferRole", tc.getRole().toString(), aeDN);
    }

    private static void storeNotEmpty(ConfigurationChanges.ModifiedObject ldapObj, Attributes attrs, String attrID, byte[] ... vals) {
        if (vals != null && vals.length > 0) {
            attrs.put(LdapDicomConfiguration.attr(attrID, vals));
            if (ldapObj != null) {
                ConfigurationChanges.ModifiedAttribute attribute = new ConfigurationChanges.ModifiedAttribute(attrID);
                for (byte[] val : vals) {
                    attribute.addValue((Object)(val.length + " bytes"));
                }
                ldapObj.add(attribute);
            }
        }
    }

    private static Attribute attr(String attrID, byte[] ... vals) {
        BasicAttribute attr = new BasicAttribute(attrID);
        for (byte[] val : vals) {
            attr.add(val);
        }
        return attr;
    }

    public void store(ConfigurationChanges diffs, Map<String, BasicBulkDataDescriptor> descriptors, String parentDN) throws NamingException {
        for (BasicBulkDataDescriptor descriptor : descriptors.values()) {
            String dn = LdapUtils.dnOf("dcmBulkDataDescriptorID", descriptor.getBulkDataDescriptorID(), parentDN);
            ConfigurationChanges.ModifiedObject ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
            this.createSubcontext(dn, LdapDicomConfiguration.storeTo(ldapObj, descriptor, new BasicAttributes(true)));
        }
    }

    private static Attributes storeTo(ConfigurationChanges.ModifiedObject ldapObj, BasicBulkDataDescriptor descriptor, BasicAttributes attrs) {
        attrs.put("objectclass", "dcmBulkDataDescriptor");
        LdapUtils.storeNotNullOrDef(ldapObj, attrs, "dcmBulkDataDescriptorID", descriptor.getBulkDataDescriptorID(), null);
        LdapUtils.storeNotDef(ldapObj, (Attributes)attrs, "dcmBulkDataExcludeDefaults", descriptor.isExcludeDefaults(), false);
        LdapUtils.storeNotEmpty(ldapObj, (Attributes)attrs, "dcmAttributeSelector", descriptor.getAttributeSelectors(), new AttributeSelector[0]);
        LdapUtils.storeNotEmpty(ldapObj, (Attributes)attrs, "dcmBulkDataVRLengthThreshold", descriptor.getLengthsThresholdsAsStrings(), new String[0]);
        return attrs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(Map<String, BasicBulkDataDescriptor> descriptors, String parentDN) throws NamingException {
        NamingEnumeration<SearchResult> ne = this.search(parentDN, "(objectclass=dcmBulkDataDescriptor)");
        try {
            while (ne.hasMore()) {
                BasicBulkDataDescriptor descriptor = this.loadBulkDataDescriptor(ne.next());
                descriptors.put(descriptor.getBulkDataDescriptorID(), descriptor);
            }
        }
        finally {
            LdapUtils.safeClose(ne);
        }
    }

    private BasicBulkDataDescriptor loadBulkDataDescriptor(SearchResult sr) throws NamingException {
        Attributes attrs = sr.getAttributes();
        BasicBulkDataDescriptor descriptor = new BasicBulkDataDescriptor(LdapUtils.stringValue(attrs.get("dcmBulkDataDescriptorID"), null));
        descriptor.excludeDefaults(LdapUtils.booleanValue(attrs.get("dcmBulkDataExcludeDefaults"), false));
        descriptor.setAttributeSelectorsFromStrings(LdapUtils.stringArray(attrs.get("dcmAttributeSelector"), new String[0]));
        descriptor.setLengthsThresholdsFromStrings(LdapUtils.stringArray(attrs.get("dcmBulkDataVRLengthThreshold"), new String[0]));
        return descriptor;
    }

    public void merge(ConfigurationChanges diffs, Map<String, BasicBulkDataDescriptor> prevs, Map<String, BasicBulkDataDescriptor> descriptors, String parentDN) throws NamingException {
        String dn;
        for (String string : prevs.keySet()) {
            if (descriptors.containsKey(string)) continue;
            dn = LdapUtils.dnOf("dcmBulkDataDescriptorID", string, parentDN);
            this.destroySubcontext(dn);
            ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.D);
        }
        for (Map.Entry entry : descriptors.entrySet()) {
            ConfigurationChanges.ModifiedObject ldapObj;
            dn = LdapUtils.dnOf("dcmBulkDataDescriptorID", (String)entry.getKey(), parentDN);
            BasicBulkDataDescriptor prev = prevs.get(entry.getKey());
            if (prev == null) {
                ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
                this.createSubcontext(dn, LdapDicomConfiguration.storeTo(ldapObj, (BasicBulkDataDescriptor)entry.getValue(), new BasicAttributes(true)));
                continue;
            }
            ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.U);
            this.modifyAttributes(dn, this.storeDiffs(ldapObj, prev, (BasicBulkDataDescriptor)entry.getValue(), new ArrayList<ModificationItem>()));
            ConfigurationChanges.removeLastIfEmpty((ConfigurationChanges)diffs, (ConfigurationChanges.ModifiedObject)ldapObj);
        }
    }

    private List<ModificationItem> storeDiffs(ConfigurationChanges.ModifiedObject ldapObj, BasicBulkDataDescriptor prev, BasicBulkDataDescriptor descriptor, ArrayList<ModificationItem> mods) {
        LdapUtils.storeDiff(ldapObj, mods, "dcmBulkDataExcludeDefaults", prev.isExcludeDefaults(), descriptor.isExcludeDefaults(), false);
        LdapUtils.storeDiff(ldapObj, mods, "dcmAttributeSelector", prev.getAttributeSelectors(), descriptor.getAttributeSelectors(), new AttributeSelector[0]);
        LdapUtils.storeDiff(ldapObj, mods, "dcmBulkDataVRLengthThreshold", prev.getLengthsThresholdsAsStrings(), descriptor.getLengthsThresholdsAsStrings(), new String[0]);
        return mods;
    }

    public void store(AttributeCoercions coercions, String parentDN) throws NamingException {
        for (AttributeCoercion ac : coercions) {
            this.createSubcontext(LdapUtils.dnOf("cn", ac.getCommonName(), parentDN), LdapDicomConfiguration.storeTo(ac, new BasicAttributes(true)));
        }
    }

    private static Attributes storeTo(AttributeCoercion ac, BasicAttributes attrs) {
        attrs.put("objectclass", "dcmAttributeCoercion");
        attrs.put("cn", ac.getCommonName());
        LdapUtils.storeNotNullOrDef(attrs, "dcmDIMSE", ac.getDIMSE(), null);
        LdapUtils.storeNotNullOrDef(attrs, "dicomTransferRole", ac.getRole(), null);
        LdapUtils.storeNotEmpty((Attributes)attrs, "dcmAETitle", ac.getAETitles(), new String[0]);
        LdapUtils.storeNotEmpty((Attributes)attrs, "dcmSOPClass", ac.getSOPClasses(), new String[0]);
        LdapUtils.storeNotNullOrDef(attrs, "dcmURI", ac.getURI(), null);
        return attrs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(AttributeCoercions acs, String dn) throws NamingException {
        NamingEnumeration<SearchResult> ne = this.search(dn, "(objectclass=dcmAttributeCoercion)");
        try {
            while (ne.hasMore()) {
                SearchResult sr = ne.next();
                Attributes attrs = sr.getAttributes();
                acs.add(new AttributeCoercion(LdapUtils.stringValue(attrs.get("cn"), null), LdapUtils.stringArray(attrs.get("dcmSOPClass"), new String[0]), Dimse.valueOf((String)LdapUtils.stringValue(attrs.get("dcmDIMSE"), null)), TransferCapability.Role.valueOf((String)LdapUtils.stringValue(attrs.get("dicomTransferRole"), null)), LdapUtils.stringArray(attrs.get("dcmAETitle"), new String[0]), LdapUtils.stringValue(attrs.get("dcmURI"), null)));
            }
        }
        finally {
            LdapUtils.safeClose(ne);
        }
    }

    public void merge(ConfigurationChanges diffs, AttributeCoercions prevs, AttributeCoercions acs, String parentDN) throws NamingException {
        String dn;
        String cn;
        for (AttributeCoercion prev : prevs) {
            cn = prev.getCommonName();
            if (acs.findByCommonName(cn) != null) continue;
            dn = LdapUtils.dnOf("cn", cn, parentDN);
            this.destroySubcontext(dn);
            ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.D);
        }
        for (AttributeCoercion ac : acs) {
            ConfigurationChanges.ModifiedObject ldapObj;
            cn = ac.getCommonName();
            dn = LdapUtils.dnOf("cn", cn, parentDN);
            AttributeCoercion prev = prevs.findByCommonName(cn);
            if (prev == null) {
                ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
                this.createSubcontext(dn, LdapDicomConfiguration.storeTo(ac, new BasicAttributes(true)));
                continue;
            }
            ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.U);
            this.modifyAttributes(dn, this.storeDiffs(ldapObj, prev, ac, new ArrayList<ModificationItem>()));
            ConfigurationChanges.removeLastIfEmpty((ConfigurationChanges)diffs, (ConfigurationChanges.ModifiedObject)ldapObj);
        }
    }

    private List<ModificationItem> storeDiffs(ConfigurationChanges.ModifiedObject ldapObj, AttributeCoercion prev, AttributeCoercion ac, ArrayList<ModificationItem> mods) {
        LdapUtils.storeDiffObject(ldapObj, mods, "dcmDIMSE", prev.getDIMSE(), ac.getDIMSE(), null);
        LdapUtils.storeDiffObject(ldapObj, mods, "dicomTransferRole", prev.getRole(), ac.getRole(), null);
        LdapUtils.storeDiff(ldapObj, mods, "dcmAETitle", prev.getAETitles(), ac.getAETitles(), new String[0]);
        LdapUtils.storeDiff(ldapObj, mods, "dcmSOPClass", prev.getSOPClasses(), ac.getSOPClasses(), new String[0]);
        LdapUtils.storeDiffObject(ldapObj, mods, "dcmURI", prev.getURI(), ac.getURI(), null);
        return mods;
    }

    public void sync() throws ConfigurationException {
    }

    public synchronized ApplicationEntityInfo[] listAETInfos(ApplicationEntityInfo keys) throws ConfigurationException {
        if (!this.configurationExists()) {
            return new ApplicationEntityInfo[0];
        }
        ArrayList<ApplicationEntityInfo> results = new ArrayList<ApplicationEntityInfo>();
        NamingEnumeration<SearchResult> ne = null;
        try {
            String deviceName = keys.getDeviceName();
            ne = this.search(deviceName, AE_ATTRS, LdapDicomConfiguration.toFilter(keys));
            HashMap<String, Connection> connCache = new HashMap<String, Connection>();
            while (ne.hasMore()) {
                ApplicationEntityInfo aetInfo = new ApplicationEntityInfo();
                SearchResult ne1 = ne.next();
                this.loadFrom(aetInfo, ne1.getAttributes(), deviceName != null ? deviceName : LdapUtils.cutDeviceName(ne1.getName()), connCache);
                results.add(aetInfo);
            }
        }
        catch (NameNotFoundException e) {
            ApplicationEntityInfo[] applicationEntityInfoArray = new ApplicationEntityInfo[]{};
            return applicationEntityInfoArray;
        }
        catch (NamingException e) {
            throw new ConfigurationException((Throwable)e);
        }
        finally {
            LdapUtils.safeClose(ne);
        }
        return results.toArray(new ApplicationEntityInfo[results.size()]);
    }

    public synchronized WebApplicationInfo[] listWebApplicationInfos(WebApplicationInfo keys) throws ConfigurationException {
        if (!this.configurationExists()) {
            return new WebApplicationInfo[0];
        }
        ArrayList<WebApplicationInfo> results = new ArrayList<WebApplicationInfo>();
        NamingEnumeration<SearchResult> ne = null;
        try {
            String deviceName = keys.getDeviceName();
            ne = this.search(deviceName, WEBAPP_ATTRS, LdapDicomConfiguration.toFilter(keys));
            HashMap<String, Connection> connCache = new HashMap<String, Connection>();
            HashMap<String, KeycloakClient> keycloakClientCache = new HashMap<String, KeycloakClient>();
            while (ne.hasMore()) {
                WebApplicationInfo webappInfo = new WebApplicationInfo();
                SearchResult ne1 = ne.next();
                this.loadFrom(webappInfo, ne1.getAttributes(), deviceName != null ? deviceName : LdapUtils.cutDeviceName(ne1.getName()), connCache, keycloakClientCache);
                results.add(webappInfo);
            }
        }
        catch (NameNotFoundException e) {
            WebApplicationInfo[] webApplicationInfoArray = new WebApplicationInfo[]{};
            return webApplicationInfoArray;
        }
        catch (NamingException e) {
            throw new ConfigurationException((Throwable)e);
        }
        finally {
            LdapUtils.safeClose(ne);
        }
        return results.toArray(new WebApplicationInfo[results.size()]);
    }

    public NamingEnumeration<SearchResult> search(String deviceName, String[] attrsArray, String filter) throws NamingException {
        return deviceName != null ? this.search(this.deviceRef(deviceName), filter, attrsArray) : this.ctx.search(this.devicesDN, filter, this.searchControlSubtreeScope(0, attrsArray, true));
    }

    private static String toFilter(ApplicationEntityInfo keys) {
        if (keys == null) {
            return "(objectclass=dicomNetworkAE)";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("(&(objectclass=dicomNetworkAE)");
        if (keys.getAETitle() != null) {
            sb.append("(|");
            LdapDicomConfiguration.appendFilter("dicomAETitle", keys.getAETitle(), sb);
            LdapDicomConfiguration.appendFilter("dcmOtherAETitle", keys.getAETitle(), sb);
            sb.append(")");
        }
        LdapDicomConfiguration.appendFilter("dicomDescription", keys.getDescription(), sb);
        LdapDicomConfiguration.appendFilter("dicomAssociationInitiator", keys.getAssociationInitiator(), sb);
        LdapDicomConfiguration.appendFilter("dicomAssociationAcceptor", keys.getAssociationAcceptor(), sb);
        LdapDicomConfiguration.appendFilter("dicomApplicationCluster", keys.getApplicationClusters(), sb);
        sb.append(")");
        return sb.toString();
    }

    private static String toFilter(WebApplicationInfo keys) {
        if (keys == null) {
            return "(objectclass=dcmWebApp)";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("(&(objectclass=dcmWebApp)");
        LdapDicomConfiguration.appendFilter("dcmWebAppName", keys.getApplicationName(), sb);
        LdapDicomConfiguration.appendFilter("dicomDescription", keys.getDescription(), sb);
        LdapDicomConfiguration.appendFilter("dcmWebServicePath", keys.getServicePath(), sb);
        LdapDicomConfiguration.appendFilter("dcmWebServiceClass", keys.getServiceClasses(), sb);
        LdapDicomConfiguration.appendFilter("dicomAETitle", keys.getAETitle(), sb);
        LdapDicomConfiguration.appendFilter("dicomApplicationCluster", keys.getApplicationClusters(), sb);
        LdapDicomConfiguration.appendFilter("dcmKeycloakClientID", keys.getKeycloakClientID(), sb);
        sb.append(")");
        return sb.toString();
    }
}

