/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.conf.ldap;

import java.io.Closeable;
import java.util.Hashtable;
import javax.naming.CommunicationException;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.ServiceUnavailableException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ReconnectDirContext
implements Closeable {
    static final Logger LOG = LoggerFactory.getLogger(ReconnectDirContext.class);
    private final Hashtable env;
    private volatile DirContext ctx;

    public DirContext getDirCtx() {
        return this.ctx;
    }

    public ReconnectDirContext(Hashtable<?, ?> env) throws NamingException {
        this.env = (Hashtable)env.clone();
        this.ctx = new InitialDirContext(env);
    }

    private void reconnect() throws NamingException {
        LOG.info("Connection to {} broken - reconnect", this.env.get("java.naming.provider.url"));
        this.close();
        this.ctx = new InitialDirContext(this.env);
    }

    @Override
    public void close() {
        try {
            this.ctx.close();
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }

    public Attributes getAttributes(String name) throws NamingException {
        try {
            return this.ctx.getAttributes(name);
        }
        catch (NamingException e) {
            if (!ReconnectDirContext.isLdap_connection_has_been_closed(e)) {
                throw e;
            }
            this.reconnect();
            return this.ctx.getAttributes(name);
        }
    }

    public Attributes getAttributes(String name, String[] attrIds) throws NamingException {
        try {
            return this.ctx.getAttributes(name, attrIds);
        }
        catch (NamingException e) {
            if (!ReconnectDirContext.isLdap_connection_has_been_closed(e)) {
                throw e;
            }
            this.reconnect();
            return this.ctx.getAttributes(name, attrIds);
        }
    }

    public void destroySubcontext(String name) throws NamingException {
        try {
            this.ctx.destroySubcontext(name);
        }
        catch (NamingException e) {
            if (!ReconnectDirContext.isLdap_connection_has_been_closed(e)) {
                throw e;
            }
            this.reconnect();
            this.ctx.destroySubcontext(name);
        }
    }

    public NamingEnumeration<SearchResult> search(String name, String filter, SearchControls cons) throws NamingException {
        try {
            return this.ctx.search(name, filter, cons);
        }
        catch (NamingException e) {
            if (!ReconnectDirContext.isLdap_connection_has_been_closed(e)) {
                throw e;
            }
            this.reconnect();
            return this.ctx.search(name, filter, cons);
        }
    }

    public void createSubcontextAndClose(String name, Attributes attrs) throws NamingException {
        try {
            this.ctx.createSubcontext(name, attrs).close();
        }
        catch (NamingException e) {
            if (!ReconnectDirContext.isLdap_connection_has_been_closed(e)) {
                throw e;
            }
            this.reconnect();
            this.ctx.createSubcontext(name, attrs).close();
        }
    }

    public NamingEnumeration<NameClassPair> list(String name) throws NamingException {
        try {
            return this.ctx.list(name);
        }
        catch (NamingException e) {
            if (!ReconnectDirContext.isLdap_connection_has_been_closed(e)) {
                throw e;
            }
            this.reconnect();
            return this.ctx.list(name);
        }
    }

    public void modifyAttributes(String name, ModificationItem ... mods) throws NamingException {
        try {
            this.ctx.modifyAttributes(name, mods);
        }
        catch (NamingException e) {
            if (!ReconnectDirContext.isLdap_connection_has_been_closed(e)) {
                throw e;
            }
            this.reconnect();
            this.ctx.modifyAttributes(name, mods);
        }
    }

    public void modifyAttributes(String name, int mod_op, Attributes attrs) throws NamingException {
        try {
            this.ctx.modifyAttributes(name, mod_op, attrs);
        }
        catch (NamingException e) {
            if (!ReconnectDirContext.isLdap_connection_has_been_closed(e)) {
                throw e;
            }
            this.reconnect();
            this.ctx.modifyAttributes(name, mod_op, attrs);
        }
    }

    private static boolean isLdap_connection_has_been_closed(NamingException e) {
        return e instanceof CommunicationException || e instanceof ServiceUnavailableException || e instanceof NotContextException || e.getMessage().startsWith("LDAP connection has been closed");
    }
}

