/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.conf.ldap;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;
import java.util.WeakHashMap;
import org.dcm4che3.conf.api.ConfigurationException;
import org.dcm4che3.util.SafeClose;

final class ResourceManager {
    private static final String APP_RESOURCE_FILE_NAME = "ldap.properties";
    private static final WeakHashMap<ClassLoader, Properties> propertiesCache = new WeakHashMap(11);

    ResourceManager() {
    }

    private static ClassLoader getContextClassLoader() {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    private static InputStream getResourceAsStream(final ClassLoader cl, final String name) {
        return AccessController.doPrivileged(new PrivilegedAction<InputStream>(){

            @Override
            public InputStream run() {
                return cl.getResourceAsStream(name);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getInitialEnvironment() throws ConfigurationException {
        ClassLoader cl = ResourceManager.getContextClassLoader();
        WeakHashMap<ClassLoader, Properties> weakHashMap = propertiesCache;
        synchronized (weakHashMap) {
            Properties props = propertiesCache.get(cl);
            if (props != null) {
                return props;
            }
            props = new Properties();
            InputStream is = ResourceManager.getResourceAsStream(cl, APP_RESOURCE_FILE_NAME);
            if (is == null) {
                throw new ConfigurationException("Failed to access resource: ldap.properties");
            }
            try {
                props.load(is);
            }
            catch (IOException e) {
                throw new ConfigurationException("Failed to parse resource: ldap.properties");
            }
            finally {
                SafeClose.close((Closeable)is);
            }
            propertiesCache.put(cl, props);
            return props;
        }
    }
}

