/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.conf.ldap.hl7;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchResult;
import org.dcm4che3.conf.api.ConfigurationChanges;
import org.dcm4che3.conf.api.ConfigurationException;
import org.dcm4che3.conf.api.hl7.HL7ApplicationAlreadyExistsException;
import org.dcm4che3.conf.api.hl7.HL7Configuration;
import org.dcm4che3.conf.ldap.LdapDicomConfigurationExtension;
import org.dcm4che3.conf.ldap.LdapUtils;
import org.dcm4che3.conf.ldap.hl7.LdapHL7ConfigurationExtension;
import org.dcm4che3.net.Connection;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.DeviceExtension;
import org.dcm4che3.net.hl7.HL7Application;
import org.dcm4che3.net.hl7.HL7ApplicationInfo;
import org.dcm4che3.net.hl7.HL7DeviceExtension;
import org.dcm4che3.util.StringUtils;

public class LdapHL7Configuration
extends LdapDicomConfigurationExtension
implements HL7Configuration {
    private static final String CN_UNIQUE_HL7_APPLICATION_NAMES_REGISTRY = "cn=Unique HL7 Application Names Registry,";
    private String appNamesRegistryDN;
    private final List<LdapHL7ConfigurationExtension> extensions = new ArrayList<LdapHL7ConfigurationExtension>();
    static final String[] HL7_ATTRS = new String[]{"dicomDeviceName", "hl7ApplicationName", "hl7OtherApplicationName", "dicomDescription", "dicomApplicationCluster", "dicomInstalled", "dicomNetworkConnectionReference"};

    public void addHL7ConfigurationExtension(LdapHL7ConfigurationExtension ext) {
        ext.setHL7Configuration(this);
        this.extensions.add(ext);
    }

    public boolean removeHL7ConfigurationExtension(LdapHL7ConfigurationExtension ext) {
        if (!this.extensions.remove(ext)) {
            return false;
        }
        ext.setHL7Configuration(null);
        return true;
    }

    public boolean registerHL7Application(String name) throws ConfigurationException {
        try {
            this.registerHL7App(name);
            return true;
        }
        catch (HL7ApplicationAlreadyExistsException e) {
            return false;
        }
    }

    private String registerHL7App(String name) throws ConfigurationException {
        this.ensureAppNamesRegistryExists();
        try {
            String dn = this.hl7appDN(name, this.appNamesRegistryDN);
            this.config.createSubcontext(dn, LdapUtils.attrs((String)"hl7UniqueApplicationName", (String)"hl7ApplicationName", (String)name));
            return dn;
        }
        catch (NameAlreadyBoundException e) {
            throw new HL7ApplicationAlreadyExistsException("HL7 Application '" + name + "' already exists");
        }
        catch (NamingException e) {
            throw new ConfigurationException((Throwable)e);
        }
    }

    public void unregisterHL7Application(String name) throws ConfigurationException {
        if (this.appNamesRegistryExists()) {
            try {
                this.config.destroySubcontext(this.hl7appDN(name, this.appNamesRegistryDN));
            }
            catch (NameNotFoundException nameNotFoundException) {
            }
            catch (NamingException e) {
                throw new ConfigurationException((Throwable)e);
            }
        }
    }

    private void ensureAppNamesRegistryExists() throws ConfigurationException {
        if (this.appNamesRegistryDN != null) {
            return;
        }
        this.config.ensureConfigurationExists();
        String dn = CN_UNIQUE_HL7_APPLICATION_NAMES_REGISTRY + this.config.getConfigurationDN();
        try {
            if (!this.config.exists(dn)) {
                this.config.createSubcontext(dn, LdapUtils.attrs((String)"hl7UniqueApplicationNamesRegistryRoot", (String)"cn", (String)"Unique HL7 Application Names Registry"));
            }
        }
        catch (NamingException e) {
            throw new ConfigurationException((Throwable)e);
        }
        this.appNamesRegistryDN = dn;
    }

    private boolean appNamesRegistryExists() throws ConfigurationException {
        if (this.appNamesRegistryDN != null) {
            return true;
        }
        if (!this.config.configurationExists()) {
            return false;
        }
        String dn = CN_UNIQUE_HL7_APPLICATION_NAMES_REGISTRY + this.config.getConfigurationDN();
        try {
            if (!this.config.exists(dn)) {
                return false;
            }
        }
        catch (NamingException e) {
            throw new ConfigurationException((Throwable)e);
        }
        this.appNamesRegistryDN = dn;
        return true;
    }

    public String[] listRegisteredHL7ApplicationNames() throws ConfigurationException {
        if (!this.appNamesRegistryExists()) {
            return StringUtils.EMPTY_STRING;
        }
        return this.config.list(this.appNamesRegistryDN, "(objectclass=hl7UniqueApplicationName)", "hl7ApplicationName");
    }

    public HL7Application findHL7Application(String name) throws ConfigurationException {
        Device device = this.config.findDevice("(&(objectclass=hl7Application)(hl7ApplicationName=" + name + "))", name);
        HL7DeviceExtension hl7Ext = (HL7DeviceExtension)device.getDeviceExtension(HL7DeviceExtension.class);
        return hl7Ext.getHL7Application(name);
    }

    /*
     * Loose catch block
     */
    public synchronized HL7ApplicationInfo[] listHL7AppInfos(HL7ApplicationInfo keys) throws ConfigurationException {
        if (!this.config.configurationExists()) {
            return new HL7ApplicationInfo[0];
        }
        ArrayList<HL7ApplicationInfo> results = new ArrayList<HL7ApplicationInfo>();
        NamingEnumeration ne = null;
        try {
            String deviceName = keys.getDeviceName();
            ne = this.config.search(deviceName, HL7_ATTRS, this.toFilter(keys));
            HashMap<String, Connection> connCache = new HashMap<String, Connection>();
            while (ne.hasMore()) {
                HL7ApplicationInfo hl7AppInfo = new HL7ApplicationInfo();
                SearchResult ne1 = (SearchResult)ne.next();
                this.loadFrom(hl7AppInfo, ne1.getAttributes(), deviceName != null ? deviceName : LdapUtils.cutDeviceName((String)ne1.getName()), connCache);
                results.add(hl7AppInfo);
            }
            LdapUtils.safeClose((NamingEnumeration)ne);
        }
        catch (NameNotFoundException e) {
            HL7ApplicationInfo[] hL7ApplicationInfoArray = new HL7ApplicationInfo[]{};
            return hL7ApplicationInfoArray;
        }
        catch (NamingException e2) {
            throw new ConfigurationException((Throwable)e2);
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            LdapUtils.safeClose(ne);
        }
        return results.toArray(new HL7ApplicationInfo[results.size()]);
    }

    private void loadFrom(HL7ApplicationInfo hl7AppInfo, Attributes attrs, String deviceName, Map<String, Connection> connCache) throws NamingException, ConfigurationException {
        hl7AppInfo.setDeviceName(deviceName);
        hl7AppInfo.setHl7ApplicationName(LdapUtils.stringValue((Attribute)attrs.get("hl7ApplicationName"), null));
        hl7AppInfo.setHl7OtherApplicationName(LdapUtils.stringArray((Attribute)attrs.get("hl7OtherApplicationName"), (String[])new String[0]));
        hl7AppInfo.setDescription(LdapUtils.stringValue((Attribute)attrs.get("dicomDescription"), null));
        hl7AppInfo.setApplicationClusters(LdapUtils.stringArray((Attribute)attrs.get("dicomApplicationCluster"), (String[])new String[0]));
        hl7AppInfo.setInstalled(LdapUtils.booleanValue((Attribute)attrs.get("dicomInstalled"), null));
        for (String connDN : LdapUtils.stringArray((Attribute)attrs.get("dicomNetworkConnectionReference"), (String[])new String[0])) {
            hl7AppInfo.getConnections().add(this.config.findConnection(connDN, connCache));
        }
    }

    private String toFilter(HL7ApplicationInfo keys) {
        if (keys == null) {
            return "(objectclass=hl7Application)";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("(&(objectclass=hl7Application)");
        this.appendFilter("hl7ApplicationName", keys.getHl7ApplicationName(), sb);
        this.appendFilter("hl7OtherApplicationName", keys.getHl7ApplicationName(), sb);
        this.appendFilter("dicomApplicationCluster", keys.getApplicationClusters(), sb);
        sb.append(")");
        return sb.toString();
    }

    private void appendFilter(String attrid, String value, StringBuilder sb) {
        if (value == null) {
            return;
        }
        sb.append('(').append(attrid).append('=').append(value).append(')');
    }

    private void appendFilter(String attrid, String[] values, StringBuilder sb) {
        if (values.length == 0) {
            return;
        }
        if (values.length == 1) {
            this.appendFilter(attrid, values[0], sb);
            return;
        }
        sb.append("(|");
        for (String value : values) {
            this.appendFilter(attrid, value, sb);
        }
        sb.append(")");
    }

    protected void storeChilds(ConfigurationChanges diffs, String deviceDN, Device device) throws NamingException {
        HL7DeviceExtension hl7Ext = (HL7DeviceExtension)device.getDeviceExtension(HL7DeviceExtension.class);
        if (hl7Ext == null) {
            return;
        }
        for (HL7Application hl7App : hl7Ext.getHL7Applications()) {
            this.store(diffs, hl7App, deviceDN);
        }
    }

    private void store(ConfigurationChanges diffs, HL7Application hl7App, String deviceDN) throws NamingException {
        String appDN = this.hl7appDN(hl7App.getApplicationName(), deviceDN);
        ConfigurationChanges.ModifiedObject ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)appDN, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
        this.config.createSubcontext(appDN, this.storeTo((ConfigurationChanges.ModifiedObject)ConfigurationChanges.nullifyIfNotVerbose((ConfigurationChanges)diffs, (Object)ldapObj), hl7App, deviceDN, new BasicAttributes(true)));
        for (LdapHL7ConfigurationExtension ext : this.extensions) {
            ext.storeChilds((ConfigurationChanges)ConfigurationChanges.nullifyIfNotVerbose((ConfigurationChanges)diffs, (Object)diffs), appDN, hl7App);
        }
    }

    private String hl7appDN(String name, String deviceDN) {
        return LdapUtils.dnOf((String)"hl7ApplicationName", (String)name, (String)deviceDN);
    }

    private Attributes storeTo(ConfigurationChanges.ModifiedObject ldapObj, HL7Application hl7App, String deviceDN, Attributes attrs) {
        attrs.put(new BasicAttribute("objectclass", "hl7Application"));
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"hl7ApplicationName", (Object)hl7App.getApplicationName(), null);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"hl7AcceptedSendingApplication", (Object[])hl7App.getAcceptedSendingApplications(), (Object[])new String[0]);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"hl7OtherApplicationName", (Object[])hl7App.getOtherApplicationNames(), (Object[])new String[0]);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"hl7AcceptedMessageType", (Object[])hl7App.getAcceptedMessageTypes(), (Object[])new String[0]);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"hl7DefaultCharacterSet", (Object)hl7App.getHL7DefaultCharacterSet(), (Object)"ASCII");
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"hl7SendingCharacterSet", (Object)hl7App.getHL7SendingCharacterSet(), (Object)"ASCII");
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"hl7OptionalMSHField", (int[])hl7App.getOptionalMSHFields());
        LdapUtils.storeConnRefs((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (Collection)hl7App.getConnections(), (String)deviceDN);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dicomDescription", (Object)hl7App.getDescription(), null);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dicomApplicationCluster", (Object[])hl7App.getApplicationClusters(), (Object[])new String[0]);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dicomInstalled", (Object)hl7App.getInstalled(), null);
        for (LdapHL7ConfigurationExtension ext : this.extensions) {
            ext.storeTo(ldapObj, hl7App, deviceDN, attrs);
        }
        return attrs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadChilds(Device device, String deviceDN) throws NamingException, ConfigurationException {
        NamingEnumeration ne = this.config.search(deviceDN, "(objectclass=hl7Application)");
        try {
            if (!ne.hasMore()) {
                return;
            }
            HL7DeviceExtension hl7Ext = new HL7DeviceExtension();
            device.addDeviceExtension((DeviceExtension)hl7Ext);
            do {
                hl7Ext.addHL7Application(this.loadHL7Application((SearchResult)ne.next(), deviceDN, device));
            } while (ne.hasMore());
        }
        finally {
            LdapUtils.safeClose((NamingEnumeration)ne);
        }
    }

    private HL7Application loadHL7Application(SearchResult sr, String deviceDN, Device device) throws NamingException, ConfigurationException {
        Attributes attrs = sr.getAttributes();
        HL7Application hl7app = new HL7Application(LdapUtils.stringValue((Attribute)attrs.get("hl7ApplicationName"), null));
        this.loadFrom(hl7app, attrs);
        for (String connDN : LdapUtils.stringArray((Attribute)attrs.get("dicomNetworkConnectionReference"), (String[])new String[0])) {
            hl7app.addConnection(LdapUtils.findConnection((String)connDN, (String)deviceDN, (Device)device));
        }
        for (LdapHL7ConfigurationExtension ext : this.extensions) {
            ext.loadChilds(hl7app, sr.getNameInNamespace());
        }
        return hl7app;
    }

    private void loadFrom(HL7Application hl7app, Attributes attrs) throws NamingException {
        hl7app.setAcceptedSendingApplications(LdapUtils.stringArray((Attribute)attrs.get("hl7AcceptedSendingApplication"), (String[])new String[0]));
        hl7app.setOtherApplicationNames(LdapUtils.stringArray((Attribute)attrs.get("hl7OtherApplicationName"), (String[])new String[0]));
        hl7app.setAcceptedMessageTypes(LdapUtils.stringArray((Attribute)attrs.get("hl7AcceptedMessageType"), (String[])new String[0]));
        hl7app.setHL7DefaultCharacterSet(LdapUtils.stringValue((Attribute)attrs.get("hl7DefaultCharacterSet"), (String)"ASCII"));
        hl7app.setHL7SendingCharacterSet(LdapUtils.stringValue((Attribute)attrs.get("hl7SendingCharacterSet"), (String)"ASCII"));
        hl7app.setOptionalMSHFields(LdapUtils.intArray((Attribute)attrs.get("hl7OptionalMSHField")));
        hl7app.setDescription(LdapUtils.stringValue((Attribute)attrs.get("dicomDescription"), null));
        hl7app.setApplicationClusters(LdapUtils.stringArray((Attribute)attrs.get("dicomApplicationCluster"), (String[])new String[0]));
        hl7app.setInstalled(LdapUtils.booleanValue((Attribute)attrs.get("dicomInstalled"), null));
        for (LdapHL7ConfigurationExtension ext : this.extensions) {
            ext.loadFrom(hl7app, attrs);
        }
    }

    protected void mergeChilds(ConfigurationChanges diffs, Device prev, Device device, String deviceDN) throws NamingException {
        HL7DeviceExtension prevHL7Ext = (HL7DeviceExtension)prev.getDeviceExtension(HL7DeviceExtension.class);
        HL7DeviceExtension hl7Ext = (HL7DeviceExtension)device.getDeviceExtension(HL7DeviceExtension.class);
        if (prevHL7Ext != null) {
            for (String appName : prevHL7Ext.getHL7ApplicationNames()) {
                if (hl7Ext != null && hl7Ext.containsHL7Application(appName)) continue;
                this.config.destroySubcontextWithChilds(this.hl7appDN(appName, deviceDN));
                ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)this.hl7appDN(appName, deviceDN), (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.D);
            }
        }
        if (hl7Ext == null) {
            return;
        }
        for (HL7Application hl7app : hl7Ext.getHL7Applications()) {
            String appName = hl7app.getApplicationName();
            if (prevHL7Ext == null || !prevHL7Ext.containsHL7Application(appName)) {
                this.store(diffs, hl7app, deviceDN);
                continue;
            }
            this.merge(diffs, prevHL7Ext.getHL7Application(appName), hl7app, deviceDN);
        }
    }

    private void merge(ConfigurationChanges diffs, HL7Application prev, HL7Application app, String deviceDN) throws NamingException {
        String appDN = this.hl7appDN(app.getApplicationName(), deviceDN);
        ConfigurationChanges.ModifiedObject ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)appDN, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.U);
        this.config.modifyAttributes(appDN, this.storeDiffs(ldapObj, prev, app, deviceDN, new ArrayList<ModificationItem>()));
        ConfigurationChanges.removeLastIfEmpty((ConfigurationChanges)diffs, (ConfigurationChanges.ModifiedObject)ldapObj);
        for (LdapHL7ConfigurationExtension ext : this.extensions) {
            ext.mergeChilds(diffs, prev, app, appDN);
        }
    }

    private List<ModificationItem> storeDiffs(ConfigurationChanges.ModifiedObject ldapObj, HL7Application a, HL7Application b, String deviceDN, List<ModificationItem> mods) {
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"hl7AcceptedSendingApplication", (Object[])a.getAcceptedSendingApplications(), (Object[])b.getAcceptedSendingApplications(), (Object[])new String[0]);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"hl7OtherApplicationName", (Object[])a.getOtherApplicationNames(), (Object[])b.getOtherApplicationNames(), (Object[])new String[0]);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"hl7AcceptedMessageType", (Object[])a.getAcceptedMessageTypes(), (Object[])b.getAcceptedMessageTypes(), (Object[])new String[0]);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"hl7DefaultCharacterSet", (Object)a.getHL7DefaultCharacterSet(), (Object)b.getHL7DefaultCharacterSet(), (Object)"ASCII");
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"hl7SendingCharacterSet", (Object)a.getHL7SendingCharacterSet(), (Object)b.getHL7SendingCharacterSet(), (Object)"ASCII");
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"hl7OptionalMSHField", (int[])a.getOptionalMSHFields(), (int[])b.getOptionalMSHFields(), (int[])new int[0]);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dicomNetworkConnectionReference", (List)a.getConnections(), (List)b.getConnections(), (String)deviceDN);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dicomDescription", (Object)a.getDescription(), (Object)b.getDescription(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dicomApplicationCluster", (Object[])a.getApplicationClusters(), (Object[])b.getApplicationClusters(), (Object[])new String[0]);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dicomInstalled", (Object)a.getInstalled(), (Object)b.getInstalled(), null);
        for (LdapHL7ConfigurationExtension ext : this.extensions) {
            ext.storeDiffs(ldapObj, a, b, mods);
        }
        return mods;
    }

    protected void register(Device device, List<String> dns) throws ConfigurationException {
        HL7DeviceExtension hl7Ext = (HL7DeviceExtension)device.getDeviceExtension(HL7DeviceExtension.class);
        if (hl7Ext == null) {
            return;
        }
        for (String name : hl7Ext.getHL7ApplicationNames()) {
            if (name.equals("*")) continue;
            dns.add(this.registerHL7App(name));
        }
    }

    protected void registerDiff(Device prev, Device device, List<String> dns) throws ConfigurationException {
        HL7DeviceExtension prevHL7Ext = (HL7DeviceExtension)prev.getDeviceExtension(HL7DeviceExtension.class);
        if (prevHL7Ext == null) {
            this.register(device, dns);
            return;
        }
        HL7DeviceExtension hl7Ext = (HL7DeviceExtension)device.getDeviceExtension(HL7DeviceExtension.class);
        if (hl7Ext == null) {
            return;
        }
        for (String name : hl7Ext.getHL7ApplicationNames()) {
            if (name.equals("*") || prevHL7Ext.getHL7Application(name) != null) continue;
            dns.add(this.registerHL7App(name));
        }
    }

    protected void markForUnregister(Device prev, Device device, List<String> dns) {
        HL7DeviceExtension prevHL7Ext = (HL7DeviceExtension)prev.getDeviceExtension(HL7DeviceExtension.class);
        if (prevHL7Ext == null) {
            return;
        }
        HL7DeviceExtension hl7Ext = (HL7DeviceExtension)device.getDeviceExtension(HL7DeviceExtension.class);
        for (String name : prevHL7Ext.getHL7ApplicationNames()) {
            if (name.equals("*") || hl7Ext != null && hl7Ext.getHL7Application(name) != null) continue;
            dns.add(this.hl7appDN(name, this.appNamesRegistryDN));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void markForUnregister(String deviceDN, List<String> dns) throws NamingException, ConfigurationException {
        if (!this.appNamesRegistryExists()) {
            return;
        }
        NamingEnumeration ne = this.config.search(deviceDN, "(objectclass=hl7Application)", StringUtils.EMPTY_STRING);
        try {
            while (ne.hasMore()) {
                String rdn = ((SearchResult)ne.next()).getName();
                if (rdn.equals("hl7ApplicationName=*")) continue;
                dns.add(rdn + ',' + this.appNamesRegistryDN);
            }
        }
        finally {
            LdapUtils.safeClose((NamingEnumeration)ne);
        }
    }
}

