/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.conf.ldap.imageio;

import java.util.ArrayList;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchResult;
import org.dcm4che3.conf.api.ConfigurationChanges;
import org.dcm4che3.conf.ldap.LdapDicomConfiguration;
import org.dcm4che3.conf.ldap.LdapUtils;
import org.dcm4che3.image.PhotometricInterpretation;
import org.dcm4che3.imageio.codec.CompressionRule;
import org.dcm4che3.imageio.codec.CompressionRules;
import org.dcm4che3.util.Property;

public class LdapCompressionRulesConfiguration {
    private LdapDicomConfiguration config;

    public LdapCompressionRulesConfiguration(LdapDicomConfiguration config) {
        this.config = config;
    }

    public void store(CompressionRules rules, String parentDN) throws NamingException {
        for (CompressionRule rule : rules) {
            this.config.createSubcontext(LdapUtils.dnOf((String)"cn", (String)rule.getCommonName(), (String)parentDN), LdapCompressionRulesConfiguration.storeTo(rule, new BasicAttributes(true)));
        }
    }

    private static Attributes storeTo(CompressionRule rule, BasicAttributes attrs) {
        attrs.put("objectclass", "dcmCompressionRule");
        attrs.put("cn", rule.getCommonName());
        LdapUtils.storeNotEmpty((Attributes)attrs, (String)"dcmPhotometricInterpretation", (Object[])rule.getPhotometricInterpretations(), (Object[])new PhotometricInterpretation[0]);
        LdapUtils.storeNotEmpty((Attributes)attrs, (String)"dcmBitsStored", (int[])rule.getBitsStored());
        LdapUtils.storeNotDef((Attributes)attrs, (String)"dcmPixelRepresentation", (int)rule.getPixelRepresentation(), (int)-1);
        LdapUtils.storeNotEmpty((Attributes)attrs, (String)"dcmAETitle", (Object[])rule.getAETitles(), (Object[])new String[0]);
        LdapUtils.storeNotEmpty((Attributes)attrs, (String)"dcmSOPClass", (Object[])rule.getSOPClasses(), (Object[])new String[0]);
        LdapUtils.storeNotEmpty((Attributes)attrs, (String)"dcmBodyPartExamined", (Object[])rule.getBodyPartExamined(), (Object[])new String[0]);
        attrs.put("dicomTransferSyntax", rule.getTransferSyntax());
        LdapUtils.storeNotEmpty((Attributes)attrs, (String)"dcmImageWriteParam", (Object[])rule.getImageWriteParams(), (Object[])new Property[0]);
        return attrs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(CompressionRules rules, String dn) throws NamingException {
        NamingEnumeration ne = this.config.search(dn, "(objectclass=dcmCompressionRule)");
        try {
            while (ne.hasMore()) {
                rules.add(this.compressionRule(((SearchResult)ne.next()).getAttributes()));
            }
        }
        finally {
            LdapUtils.safeClose((NamingEnumeration)ne);
        }
    }

    private CompressionRule compressionRule(Attributes attrs) throws NamingException {
        return new CompressionRule(LdapUtils.stringValue((Attribute)attrs.get("cn"), null), LdapUtils.stringArray((Attribute)attrs.get("dcmPhotometricInterpretation"), (String[])new String[0]), LdapUtils.intArray((Attribute)attrs.get("dcmBitsStored")), LdapUtils.intValue((Attribute)attrs.get("dcmPixelRepresentation"), (int)-1), LdapUtils.stringArray((Attribute)attrs.get("dcmAETitle"), (String[])new String[0]), LdapUtils.stringArray((Attribute)attrs.get("dcmSOPClass"), (String[])new String[0]), LdapUtils.stringArray((Attribute)attrs.get("dcmBodyPartExamined"), (String[])new String[0]), LdapUtils.stringValue((Attribute)attrs.get("dicomTransferSyntax"), null), LdapUtils.stringArray((Attribute)attrs.get("dcmImageWriteParam"), (String[])new String[0]));
    }

    public void merge(ConfigurationChanges diffs, CompressionRules prevRules, CompressionRules rules, String parentDN) throws NamingException {
        String dn;
        String cn;
        for (CompressionRule prevRule : prevRules) {
            cn = prevRule.getCommonName();
            if (rules != null && rules.findByCommonName(cn) != null) continue;
            dn = LdapUtils.dnOf((String)"cn", (String)cn, (String)parentDN);
            this.config.destroySubcontext(dn);
            ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.D);
        }
        for (CompressionRule rule : rules) {
            ConfigurationChanges.ModifiedObject ldapObj;
            CompressionRule prevRule;
            cn = rule.getCommonName();
            dn = LdapUtils.dnOf((String)"cn", (String)cn, (String)parentDN);
            CompressionRule compressionRule = prevRule = prevRules != null ? prevRules.findByCommonName(cn) : null;
            if (prevRule == null) {
                ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
                this.config.createSubcontext(dn, LdapCompressionRulesConfiguration.storeTo(rule, new BasicAttributes(true)));
                continue;
            }
            ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.U);
            this.config.modifyAttributes(dn, this.storeDiffs(ldapObj, prevRule, rule, new ArrayList<ModificationItem>()));
            ConfigurationChanges.removeLastIfEmpty((ConfigurationChanges)diffs, (ConfigurationChanges.ModifiedObject)ldapObj);
        }
    }

    private List<ModificationItem> storeDiffs(ConfigurationChanges.ModifiedObject ldapObj, CompressionRule prev, CompressionRule rule, List<ModificationItem> mods) {
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmPhotometricInterpretation", (Object[])prev.getPhotometricInterpretations(), (Object[])rule.getPhotometricInterpretations(), (Object[])new PhotometricInterpretation[0]);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmBitsStored", (Object)prev.getBitsStored(), (Object)rule.getBitsStored(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmPixelRepresentation", (int)prev.getPixelRepresentation(), (int)rule.getPixelRepresentation(), (int)-1);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmAETitle", (Object[])prev.getAETitles(), (Object[])rule.getAETitles(), (Object[])new String[0]);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmSOPClass", (Object[])prev.getSOPClasses(), (Object[])rule.getSOPClasses(), (Object[])new String[0]);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmBodyPartExamined", (Object[])prev.getBodyPartExamined(), (Object[])rule.getBodyPartExamined(), (Object[])new String[0]);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dicomTransferSyntax", (Object)prev.getTransferSyntax(), (Object)rule.getTransferSyntax(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmImageWriteParam", (Object[])prev.getImageWriteParams(), (Object[])rule.getImageWriteParams(), (Object[])new Property[0]);
        return mods;
    }
}

