/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.conf.ldap.imageio;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchResult;
import org.dcm4che3.conf.api.ConfigurationChanges;
import org.dcm4che3.conf.api.ConfigurationException;
import org.dcm4che3.conf.ldap.LdapDicomConfigurationExtension;
import org.dcm4che3.conf.ldap.LdapUtils;
import org.dcm4che3.imageio.codec.ImageReaderFactory;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.DeviceExtension;
import org.dcm4che3.net.imageio.ImageReaderExtension;
import org.dcm4che3.util.Property;

public class LdapImageReaderConfiguration
extends LdapDicomConfigurationExtension {
    private static final String CN_IMAGE_READER_FACTORY = "cn=Image Reader Factory,";

    protected void storeChilds(ConfigurationChanges diffs, String deviceDN, Device device) throws NamingException {
        ImageReaderExtension ext = (ImageReaderExtension)device.getDeviceExtension(ImageReaderExtension.class);
        if (ext != null) {
            this.store(diffs, deviceDN, ext.getImageReaderFactory());
        }
    }

    private String dnOf(String tsuid, String imageReadersDN) {
        return LdapUtils.dnOf((String)"dicomTransferSyntax", (String)tsuid, (String)imageReadersDN);
    }

    private void store(ConfigurationChanges diffs, String deviceDN, ImageReaderFactory factory) throws NamingException {
        String imageReadersDN = CN_IMAGE_READER_FACTORY + deviceDN;
        ConfigurationChanges.ModifiedObject ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)imageReadersDN, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
        this.config.createSubcontext(imageReadersDN, LdapUtils.attrs((String)"dcmImageReaderFactory", (String)"cn", (String)"Image Reader Factory"));
        for (Map.Entry entry : factory.getEntries()) {
            String tsuid = (String)entry.getKey();
            String dn = this.dnOf(tsuid, imageReadersDN);
            ConfigurationChanges.ModifiedObject ldapObj1 = ConfigurationChanges.addModifiedObjectIfVerbose((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
            this.config.createSubcontext(dn, this.storeTo(ldapObj1, tsuid, (ImageReaderFactory.ImageReaderParam)entry.getValue(), new BasicAttributes(true)));
        }
    }

    private Attributes storeTo(ConfigurationChanges.ModifiedObject ldapObj, String tsuid, ImageReaderFactory.ImageReaderParam param, Attributes attrs) {
        attrs.put("objectclass", "dcmImageReader");
        attrs.put("dicomTransferSyntax", tsuid);
        attrs.put("dcmIIOFormatName", param.formatName);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmJavaClassName", (Object)param.className, null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmPatchJPEGLS", (Object)param.patchJPEGLS, null);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmImageReadParam", (Object[])param.getImageReadParams(), (Object[])new Property[0]);
        return attrs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadChilds(Device device, String deviceDN) throws NamingException, ConfigurationException {
        String imageReadersDN = CN_IMAGE_READER_FACTORY + deviceDN;
        try {
            this.config.getAttributes(imageReadersDN);
        }
        catch (NameNotFoundException e) {
            return;
        }
        ImageReaderFactory factory = new ImageReaderFactory();
        NamingEnumeration ne = this.config.search(imageReadersDN, "(objectclass=dcmImageReader)");
        try {
            while (ne.hasMore()) {
                SearchResult sr = (SearchResult)ne.next();
                Attributes attrs = sr.getAttributes();
                factory.put(LdapUtils.stringValue((Attribute)attrs.get("dicomTransferSyntax"), null), new ImageReaderFactory.ImageReaderParam(LdapUtils.stringValue((Attribute)attrs.get("dcmIIOFormatName"), null), LdapUtils.stringValue((Attribute)attrs.get("dcmJavaClassName"), null), LdapUtils.stringValue((Attribute)attrs.get("dcmPatchJPEGLS"), null), LdapUtils.stringArray((Attribute)attrs.get("dcmImageReadParam"), (String[])new String[0])));
            }
        }
        finally {
            LdapUtils.safeClose((NamingEnumeration)ne);
        }
        device.addDeviceExtension((DeviceExtension)new ImageReaderExtension(factory));
    }

    protected void mergeChilds(ConfigurationChanges diffs, Device prev, Device device, String deviceDN) throws NamingException {
        ImageReaderExtension prevExt = (ImageReaderExtension)prev.getDeviceExtension(ImageReaderExtension.class);
        ImageReaderExtension ext = (ImageReaderExtension)device.getDeviceExtension(ImageReaderExtension.class);
        if (ext == null && prevExt == null) {
            return;
        }
        String dn = CN_IMAGE_READER_FACTORY + deviceDN;
        if (ext == null) {
            this.config.destroySubcontextWithChilds(dn);
            ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.D);
        } else if (prevExt == null) {
            this.store(diffs, deviceDN, ext.getImageReaderFactory());
        } else {
            this.merge(diffs, prevExt.getImageReaderFactory(), ext.getImageReaderFactory(), dn);
        }
    }

    private void merge(ConfigurationChanges diffs, ImageReaderFactory prev, ImageReaderFactory factory, String imageReadersDN) throws NamingException {
        String dn;
        String tsuid;
        for (Map.Entry entry : prev.getEntries()) {
            tsuid = (String)entry.getKey();
            if (factory.get(tsuid) != null) continue;
            dn = this.dnOf(tsuid, imageReadersDN);
            this.config.destroySubcontext(dn);
            ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.D);
        }
        for (Map.Entry entry : factory.getEntries()) {
            ConfigurationChanges.ModifiedObject ldapObj;
            tsuid = (String)entry.getKey();
            dn = this.dnOf(tsuid, imageReadersDN);
            ImageReaderFactory.ImageReaderParam prevParam = prev.get(tsuid);
            if (prevParam == null) {
                ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
                this.config.createSubcontext(dn, this.storeTo((ConfigurationChanges.ModifiedObject)ConfigurationChanges.nullifyIfNotVerbose((ConfigurationChanges)diffs, (Object)ldapObj), tsuid, (ImageReaderFactory.ImageReaderParam)entry.getValue(), new BasicAttributes(true)));
                continue;
            }
            ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.U);
            this.config.modifyAttributes(dn, this.storeDiffs(ldapObj, prevParam, (ImageReaderFactory.ImageReaderParam)entry.getValue(), new ArrayList<ModificationItem>()));
            ConfigurationChanges.removeLastIfEmpty((ConfigurationChanges)diffs, (ConfigurationChanges.ModifiedObject)ldapObj);
        }
    }

    private List<ModificationItem> storeDiffs(ConfigurationChanges.ModifiedObject ldapObj, ImageReaderFactory.ImageReaderParam prevParam, ImageReaderFactory.ImageReaderParam param, List<ModificationItem> mods) {
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmIIOFormatName", (Object)prevParam.formatName, (Object)param.formatName, null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmJavaClassName", (Object)prevParam.className, (Object)param.className, null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmPatchJPEGLS", (Object)prevParam.patchJPEGLS, (Object)param.patchJPEGLS, null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmImageReadParam", (Object[])prevParam.getImageReadParams(), (Object[])param.getImageReadParams(), (Object[])new Property[0]);
        return mods;
    }
}

