/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.conf.ldap.imageio;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchResult;
import org.dcm4che3.conf.api.ConfigurationChanges;
import org.dcm4che3.conf.api.ConfigurationException;
import org.dcm4che3.conf.ldap.LdapDicomConfigurationExtension;
import org.dcm4che3.conf.ldap.LdapUtils;
import org.dcm4che3.imageio.codec.ImageWriterFactory;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.DeviceExtension;
import org.dcm4che3.net.imageio.ImageWriterExtension;
import org.dcm4che3.util.Property;

public class LdapImageWriterConfiguration
extends LdapDicomConfigurationExtension {
    private static final String CN_IMAGE_WRITER_FACTORY = "cn=Image Writer Factory,";

    protected void storeChilds(ConfigurationChanges diffs, String deviceDN, Device device) throws NamingException {
        ImageWriterExtension ext = (ImageWriterExtension)device.getDeviceExtension(ImageWriterExtension.class);
        if (ext != null) {
            this.store(diffs, deviceDN, ext.getImageWriterFactory());
        }
    }

    private String dnOf(String tsuid, String imageWritersDN) {
        return LdapUtils.dnOf((String)"dicomTransferSyntax", (String)tsuid, (String)imageWritersDN);
    }

    private void store(ConfigurationChanges diffs, String deviceDN, ImageWriterFactory factory) throws NamingException {
        String imageWritersDN = CN_IMAGE_WRITER_FACTORY + deviceDN;
        ConfigurationChanges.ModifiedObject ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)imageWritersDN, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
        this.config.createSubcontext(imageWritersDN, LdapUtils.attrs((String)"dcmImageWriterFactory", (String)"cn", (String)"Image Writer Factory"));
        for (Map.Entry entry : factory.getEntries()) {
            String tsuid = (String)entry.getKey();
            ConfigurationChanges.ModifiedObject ldapObj1 = ConfigurationChanges.addModifiedObjectIfVerbose((ConfigurationChanges)diffs, (String)imageWritersDN, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
            this.config.createSubcontext(this.dnOf(tsuid, imageWritersDN), this.storeTo(ldapObj1, tsuid, (ImageWriterFactory.ImageWriterParam)entry.getValue(), new BasicAttributes(true)));
        }
    }

    private Attributes storeTo(ConfigurationChanges.ModifiedObject ldapObj, String tsuid, ImageWriterFactory.ImageWriterParam param, Attributes attrs) {
        attrs.put("objectclass", "dcmImageWriter");
        attrs.put("dicomTransferSyntax", tsuid);
        attrs.put("dcmIIOFormatName", param.formatName);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmJavaClassName", (Object)param.className, null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmPatchJPEGLS", (Object)param.patchJPEGLS, null);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmImageWriteParam", (Object[])param.getImageWriteParams(), (Object[])new Property[0]);
        return attrs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadChilds(Device device, String deviceDN) throws NamingException, ConfigurationException {
        String imageWritersDN = CN_IMAGE_WRITER_FACTORY + deviceDN;
        try {
            this.config.getAttributes(imageWritersDN);
        }
        catch (NameNotFoundException e) {
            return;
        }
        ImageWriterFactory factory = new ImageWriterFactory();
        NamingEnumeration ne = this.config.search(imageWritersDN, "(objectclass=dcmImageWriter)");
        try {
            while (ne.hasMore()) {
                SearchResult sr = (SearchResult)ne.next();
                Attributes attrs = sr.getAttributes();
                factory.put(LdapUtils.stringValue((Attribute)attrs.get("dicomTransferSyntax"), null), new ImageWriterFactory.ImageWriterParam(LdapUtils.stringValue((Attribute)attrs.get("dcmIIOFormatName"), null), LdapUtils.stringValue((Attribute)attrs.get("dcmJavaClassName"), null), LdapUtils.stringValue((Attribute)attrs.get("dcmPatchJPEGLS"), null), LdapUtils.stringArray((Attribute)attrs.get("dcmImageWriteParam"), (String[])new String[0])));
            }
        }
        finally {
            LdapUtils.safeClose((NamingEnumeration)ne);
        }
        device.addDeviceExtension((DeviceExtension)new ImageWriterExtension(factory));
    }

    protected void mergeChilds(ConfigurationChanges diffs, Device prev, Device device, String deviceDN) throws NamingException {
        ImageWriterExtension prevExt = (ImageWriterExtension)prev.getDeviceExtension(ImageWriterExtension.class);
        ImageWriterExtension ext = (ImageWriterExtension)device.getDeviceExtension(ImageWriterExtension.class);
        if (ext == null && prevExt == null) {
            return;
        }
        String dn = CN_IMAGE_WRITER_FACTORY + deviceDN;
        if (ext == null) {
            this.config.destroySubcontextWithChilds(dn);
            ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.D);
        } else if (prevExt == null) {
            this.store(diffs, deviceDN, ext.getImageWriterFactory());
        } else {
            this.merge(diffs, prevExt.getImageWriterFactory(), ext.getImageWriterFactory(), dn);
        }
    }

    private void merge(ConfigurationChanges diffs, ImageWriterFactory prev, ImageWriterFactory factory, String imageWritersDN) throws NamingException {
        String dn;
        String tsuid;
        for (Map.Entry entry : prev.getEntries()) {
            tsuid = (String)entry.getKey();
            if (factory.get(tsuid) != null) continue;
            dn = this.dnOf(tsuid, imageWritersDN);
            this.config.destroySubcontext(dn);
            ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.D);
        }
        for (Map.Entry entry : factory.getEntries()) {
            ConfigurationChanges.ModifiedObject ldapObj;
            tsuid = (String)entry.getKey();
            dn = this.dnOf(tsuid, imageWritersDN);
            ImageWriterFactory.ImageWriterParam prevParam = prev.get(tsuid);
            if (prevParam == null) {
                ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
                this.config.createSubcontext(dn, this.storeTo((ConfigurationChanges.ModifiedObject)ConfigurationChanges.nullifyIfNotVerbose((ConfigurationChanges)diffs, (Object)ldapObj), tsuid, (ImageWriterFactory.ImageWriterParam)entry.getValue(), new BasicAttributes(true)));
                continue;
            }
            ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.U);
            this.config.modifyAttributes(dn, this.storeDiffs(ldapObj, prevParam, (ImageWriterFactory.ImageWriterParam)entry.getValue(), new ArrayList<ModificationItem>()));
            ConfigurationChanges.removeLastIfEmpty((ConfigurationChanges)diffs, (ConfigurationChanges.ModifiedObject)ldapObj);
        }
    }

    private List<ModificationItem> storeDiffs(ConfigurationChanges.ModifiedObject ldapObj, ImageWriterFactory.ImageWriterParam prevParam, ImageWriterFactory.ImageWriterParam param, List<ModificationItem> mods) {
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmIIOFormatName", (Object)prevParam.formatName, (Object)param.formatName, null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmJavaClassName", (Object)prevParam.className, (Object)param.className, null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmPatchJPEGLS", (Object)prevParam.patchJPEGLS, (Object)param.patchJPEGLS, null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmImageWriteParam", (Object[])prevParam.getImageWriteParams(), (Object[])param.getImageWriteParams(), (Object[])new Property[0]);
        return mods;
    }
}

