/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.hl7;

import org.dcm4che3.hl7.HL7Segment;

public class HL7Exception
extends Exception {
    private static final long serialVersionUID = 5814384748456212615L;
    public static final String AA = "AA";
    public static final String AR = "AR";
    public static final String AE = "AE";
    private final String ack;
    private final HL7Segment err;

    public HL7Exception(String ack) {
        this.ack = ack;
        this.err = null;
    }

    public HL7Exception(String ack, String message) {
        super(message);
        this.ack = ack;
        this.err = null;
    }

    public HL7Exception(String ack, Throwable cause) {
        super(cause);
        this.ack = ack;
        this.err = null;
    }

    public HL7Exception(HL7Segment err) {
        super(err.getField(8, null));
        this.ack = HL7Exception.toAck(err);
        this.err = err;
    }

    public HL7Exception(HL7Segment err, Throwable cause) {
        super(err.getField(8, null), cause);
        this.ack = HL7Exception.toAck(err);
        this.err = err;
    }

    private static String toAck(HL7Segment err) {
        return err.getField(3, "").startsWith("1") ? AE : AR;
    }

    public final String getAcknowledgmentCode() {
        return this.ack;
    }

    public String getErrorMessage() {
        return this.getMessage();
    }

    public HL7Segment getErrorSegment() {
        return this.err;
    }
}

