/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.hl7;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.net.Socket;
import org.dcm4che3.hl7.MLLPInputStream;
import org.dcm4che3.hl7.MLLPOutputStream;
import org.dcm4che3.hl7.MLLPRelease;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MLLPConnection
implements Closeable {
    private static Logger LOG = LoggerFactory.getLogger(MLLPConnection.class);
    private static final byte ACK = 6;
    private static final byte NAK = 21;
    private final Socket sock;
    private final MLLPInputStream mllpIn;
    private final MLLPOutputStream mllpOut;
    private final MLLPRelease mllpRelease;

    public MLLPConnection(Socket sock) throws IOException {
        this(sock, MLLPRelease.MLLP1);
    }

    public MLLPConnection(Socket sock, MLLPRelease mllpRelease) throws IOException {
        this.sock = sock;
        this.mllpIn = new MLLPInputStream(sock.getInputStream());
        this.mllpOut = new MLLPOutputStream(sock.getOutputStream());
        this.mllpRelease = mllpRelease;
    }

    public MLLPConnection(Socket sock, int bufferSize) throws IOException {
        this(sock, MLLPRelease.MLLP1, bufferSize);
    }

    public MLLPConnection(Socket sock, MLLPRelease mllpRelease, int bufferSize) throws IOException {
        this.sock = sock;
        this.mllpIn = new MLLPInputStream(sock.getInputStream());
        this.mllpOut = new MLLPOutputStream(new BufferedOutputStream(sock.getOutputStream(), bufferSize));
        this.mllpRelease = mllpRelease;
    }

    public final Socket getSocket() {
        return this.sock;
    }

    public void writeMessage(byte[] b) throws IOException {
        this.writeMessage(b, 0, b.length);
    }

    public void writeMessage(byte[] b, int off, int len) throws IOException {
        this.log("{} << {}", b, off, len);
        this.mllpOut.writeMessage(b, off, len);
        if (this.mllpRelease == MLLPRelease.MLLP2) {
            this.readACK();
        }
    }

    public byte[] readMessage() throws IOException {
        byte[] b = this.mllpIn.readMessage();
        if (b != null) {
            this.log("{} >> {}", b, 0, b.length);
            if (this.mllpRelease == MLLPRelease.MLLP2) {
                this.writeACK();
            }
        }
        return b;
    }

    private void writeACK() throws IOException {
        LOG.debug("{} << <ACK>", (Object)this.sock);
        this.mllpOut.write(6);
        this.mllpOut.finish();
    }

    private void readACK() throws IOException {
        byte[] b = this.mllpIn.readMessage();
        if (b == null) {
            throw new IOException("Connection closed by receiver");
        }
        if (b.length == 1) {
            switch (b[0]) {
                case 6: {
                    LOG.debug("{} >> <ACK>", (Object)this.sock);
                    return;
                }
                case 21: {
                    LOG.info("{} >> <NAK>", (Object)this.sock);
                    throw new IOException("NAK received");
                }
            }
        }
        LOG.info("{}: <ACK> or <NAK> expected, but received {} bytes", (Object)this.sock, (Object)b.length);
        throw new IOException("<ACK> or <NAK> expected, but received " + b.length + " bytes");
    }

    private void log(String format, byte[] b, int off, int len) {
        int mshlen;
        if (!LOG.isInfoEnabled()) {
            return;
        }
        for (mshlen = 0; mshlen < len && b[off + mshlen] != 13; ++mshlen) {
        }
        LOG.info(format, (Object)this.sock, (Object)new String(b, off, mshlen));
        if (LOG.isDebugEnabled()) {
            LOG.debug(format, (Object)this.sock, (Object)new String(b, off, len).replace('\r', '\n'));
        }
    }

    @Override
    public void close() throws IOException {
        this.sock.close();
    }
}

