/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.image;

import org.dcm4che3.image.LookupTable;
import org.dcm4che3.image.ShortLookupTable;
import org.dcm4che3.image.StoredValue;

public class ByteLookupTable
extends LookupTable {
    private final byte[] lut;

    ByteLookupTable(StoredValue inBits, int outBits, int offset, byte[] lut) {
        super(inBits, outBits, offset);
        this.lut = lut;
    }

    ByteLookupTable(StoredValue inBits, int outBits, int offset, int size, boolean flip) {
        this(inBits, outBits, offset, new byte[size]);
        int maxOut = (1 << outBits) - 1;
        int maxIndex = size - 1;
        int midIndex = maxIndex / 2;
        if (flip) {
            for (int i = 0; i < size; ++i) {
                this.lut[maxIndex - i] = (byte)((i * maxOut + midIndex) / maxIndex);
            }
        } else {
            for (int i = 0; i < size; ++i) {
                this.lut[i] = (byte)((i * maxOut + midIndex) / maxIndex);
            }
        }
    }

    @Override
    public int length() {
        return this.lut.length;
    }

    @Override
    public void lookup(byte[] src, int srcPos, byte[] dest, int destPos, int length) {
        int i = srcPos;
        int endPos = srcPos + length;
        int j = destPos;
        while (i < endPos) {
            dest[j++] = this.lut[this.index(src[i++])];
        }
    }

    private int index(int pixel) {
        int index = this.inBits.valueOf(pixel) - this.offset;
        return Math.min(Math.max(0, index), this.lut.length - 1);
    }

    @Override
    public void lookup(short[] src, int srcPos, byte[] dest, int destPos, int length) {
        int i = srcPos;
        int endPos = srcPos + length;
        int j = destPos;
        while (i < endPos) {
            dest[j++] = this.lut[this.index(src[i++])];
        }
    }

    @Override
    public void lookup(byte[] src, int srcPos, short[] dest, int destPos, int length) {
        int i = srcPos;
        int endPos = srcPos + length;
        int j = destPos;
        while (i < endPos) {
            dest[j++] = (short)(this.lut[this.index(src[i++])] & 0xFF);
        }
    }

    @Override
    public void lookup(short[] src, int srcPos, short[] dest, int destPos, int length) {
        int i = srcPos;
        int endPos = srcPos + length;
        int j = destPos;
        while (i < endPos) {
            dest[j++] = (short)(this.lut[this.index(src[i++])] & 0xFF);
        }
    }

    @Override
    public LookupTable adjustOutBits(int outBits) {
        int diff = outBits - this.outBits;
        if (diff != 0) {
            byte[] lut = this.lut;
            if (outBits > 8) {
                short[] ss = new short[lut.length];
                for (int i = 0; i < lut.length; ++i) {
                    ss[i] = (short)((lut[i] & 0xFF) << diff);
                }
                return new ShortLookupTable(this.inBits, outBits, this.offset, ss);
            }
            if (diff < 0) {
                diff = -diff;
                for (int i = 0; i < lut.length; ++i) {
                    lut[i] = (byte)((lut[i] & 0xFF) >> diff);
                }
            } else {
                int i = 0;
                while (i < lut.length) {
                    int n = i++;
                    lut[n] = (byte)(lut[n] << diff);
                }
            }
            this.outBits = outBits;
        }
        return this;
    }

    @Override
    public void inverse() {
        byte[] lut = this.lut;
        int maxOut = (1 << this.outBits) - 1;
        for (int i = 0; i < lut.length; ++i) {
            lut[i] = (byte)(maxOut - lut[i]);
        }
    }

    @Override
    public LookupTable combine(LookupTable other) {
        byte[] lut = this.lut;
        if (other.outBits > 8) {
            short[] ss = new short[lut.length];
            other.lookup(lut, 0, ss, 0, lut.length);
            return new ShortLookupTable(this.inBits, other.outBits, this.offset, ss);
        }
        other.lookup(lut, 0, lut, 0, lut.length);
        this.outBits = other.outBits;
        return this;
    }
}

