/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.imageio.codec.jpeg;

import org.dcm4che3.imageio.codec.jpeg.JPEGHeader;
import org.dcm4che3.imageio.codec.jpeg.JPEGLSCodingParam;

public enum PatchJPEGLS {
    JAI2ISO,
    JAI2ISO_IF_NO_APP_OR_COM,
    ISO2JAI,
    ISO2JAI_IF_APP_OR_COM;


    public JPEGLSCodingParam createJPEGLSCodingParam(byte[] jpeg) {
        boolean additionalMarkers;
        JPEGHeader jpegHeader = new JPEGHeader(jpeg, 218);
        int soiOff = jpegHeader.offsetOf(216);
        int sof55Off = jpegHeader.offsetOf(247);
        int lseOff = jpegHeader.offsetOf(248);
        int sosOff = jpegHeader.offsetOf(218);
        if (soiOff == -1) {
            return null;
        }
        if (sof55Off == -1) {
            return null;
        }
        if (lseOff != -1) {
            return null;
        }
        if (sosOff == -1) {
            return null;
        }
        boolean bl = additionalMarkers = jpegHeader.numberOfMarkers() > 3;
        if (this == ISO2JAI_IF_APP_OR_COM && !additionalMarkers) {
            return null;
        }
        if (this == JAI2ISO_IF_NO_APP_OR_COM && additionalMarkers) {
            return null;
        }
        int p = jpeg[sof55Off + 3] & 0xFF;
        if (p <= 12) {
            return null;
        }
        JPEGLSCodingParam param = this == JAI2ISO ? JPEGLSCodingParam.getJAIJPEGLSCodingParam(p) : JPEGLSCodingParam.getDefaultJPEGLSCodingParam(p, jpeg[sosOff + 6] & 0xFF);
        param.setOffset(sosOff - 1);
        return param;
    }
}

