/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.opencv;

import java.io.File;
import org.dcm4che3.imageio.codec.ImageDescriptor;

public class ExtendSegmentedInputImageStream {
    private final File file;
    private final long[] segmentPositions;
    private final long[] segmentLengths;
    private final ImageDescriptor imageDescriptor;

    public ExtendSegmentedInputImageStream(File file, long[] segmentPositions, int[] segmentLengths, ImageDescriptor imageDescriptor) {
        this.file = file;
        this.segmentPositions = segmentPositions;
        this.segmentLengths = segmentLengths == null ? null : ExtendSegmentedInputImageStream.getDoubleArray(segmentLengths);
        this.imageDescriptor = imageDescriptor;
    }

    public long[] getSegmentPositions() {
        return this.segmentPositions;
    }

    public long[] getSegmentLengths() {
        return this.segmentLengths;
    }

    public File getFile() {
        return this.file;
    }

    public static double[] getDoubleArray(long[] array) {
        double[] a = new double[array.length];
        for (int i = 0; i < a.length; ++i) {
            a[i] = array[i];
        }
        return a;
    }

    public static long[] getDoubleArray(int[] array) {
        long[] a = new long[array.length];
        for (int i = 0; i < a.length; ++i) {
            a[i] = array[i];
        }
        return a;
    }

    public ImageDescriptor getImageDescriptor() {
        return this.imageDescriptor;
    }
}

