/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.opencv;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import javax.imageio.ImageReadParam;
import javax.imageio.stream.FileCacheImageInputStream;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;
import org.dcm4che3.data.BulkData;
import org.dcm4che3.imageio.codec.BytesWithImageImageDescriptor;
import org.dcm4che3.imageio.codec.ImageDescriptor;
import org.dcm4che3.imageio.stream.SegmentedInputImageStream;
import org.dcm4che3.opencv.ExtendSegmentedInputImageStream;
import org.dcm4che3.opencv.FileStreamSegment;
import org.dcm4che3.opencv.MemoryStreamSegment;
import org.opencv.osgi.OpenCVNativeLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StreamSegment {
    private static final Logger LOGGER = LoggerFactory.getLogger(StreamSegment.class);
    private final long[] segPosition;
    private final long[] segLength;
    private final ImageDescriptor imageDescriptor;

    StreamSegment(long[] startPos, long[] length, ImageDescriptor imageDescriptor) {
        this.segPosition = startPos;
        this.segLength = length;
        this.imageDescriptor = imageDescriptor;
    }

    public ImageDescriptor getImageDescriptor() {
        return this.imageDescriptor;
    }

    public static StreamSegment getStreamSegment(ImageInputStream iis, ImageReadParam param) throws IOException {
        if (iis instanceof ExtendSegmentedInputImageStream) {
            return new FileStreamSegment((ExtendSegmentedInputImageStream)((Object)iis));
        }
        if (iis instanceof SegmentedInputImageStream) {
            return StreamSegment.getFileStreamSegment((SegmentedInputImageStream)iis);
        }
        if (iis instanceof FileCacheImageInputStream) {
            throw new IllegalArgumentException("No adaptor implemented yet for FileCacheImageInputStream");
        }
        if (iis instanceof BytesWithImageImageDescriptor) {
            BytesWithImageImageDescriptor stream = (BytesWithImageImageDescriptor)iis;
            return new MemoryStreamSegment(stream.getBytes(), stream.getImageDescriptor());
        }
        throw new IllegalArgumentException("No stream adaptor found for " + iis.getClass().getName() + "!");
    }

    public static boolean supportsInputStream(Object iis) {
        return iis instanceof ExtendSegmentedInputImageStream || iis instanceof SegmentedInputImageStream || iis instanceof BytesWithImageImageDescriptor;
    }

    private static StreamSegment getFileStreamSegment(SegmentedInputImageStream iis) {
        try {
            long[][] seg;
            MemoryCacheImageInputStream mstream;
            byte[] b;
            ImageInputStream fstream = iis.getStream();
            Field fRaf = null;
            if (fstream instanceof FileImageInputStream) {
                fRaf = FileImageInputStream.class.getDeclaredField("raf");
            } else if (fstream instanceof FileCacheImageInputStream) {
                fRaf = FileCacheImageInputStream.class.getDeclaredField("cache");
            }
            if (fRaf != null) {
                fRaf.setAccessible(true);
                long[][] seg2 = StreamSegment.getSegments(iis);
                if (seg2 != null) {
                    RandomAccessFile raf = (RandomAccessFile)fRaf.get(fstream);
                    return new FileStreamSegment(raf, seg2[0], seg2[1], iis.getImageDescriptor());
                }
            }
            if (fstream instanceof MemoryCacheImageInputStream && (b = MemoryStreamSegment.getByte(MemoryStreamSegment.getByteArrayInputStream(mstream = (MemoryCacheImageInputStream)fstream))) != null && (seg = StreamSegment.getSegments(iis)) != null) {
                int offset = (int)seg[0][0];
                return new MemoryStreamSegment(ByteBuffer.wrap(Arrays.copyOfRange(b, offset, offset + (int)seg[1][0])), iis.getImageDescriptor());
            }
            LOGGER.error("Cannot read SegmentedInputImageStream with {} ", fstream.getClass());
        }
        catch (Exception e) {
            LOGGER.error("Building FileStreamSegment from SegmentedInputImageStream", (Throwable)e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long[][] getSegments(SegmentedInputImageStream iis) throws IOException {
        Integer curSegment = iis.getCurSegment();
        if (curSegment != null && curSegment >= 0) {
            ImageDescriptor desc = iis.getImageDescriptor();
            List fragments = iis.getFragments();
            Integer lastSegment = iis.getLastSegment();
            if (!desc.isMultiframe() && lastSegment < fragments.size()) {
                lastSegment = fragments.size();
            }
            long[] segPositions = new long[lastSegment - curSegment];
            long[] segLength = new long[segPositions.length];
            long beforePos = 0L;
            for (int i = curSegment.intValue(); i < lastSegment; ++i) {
                List list = fragments;
                synchronized (list) {
                    if (i < fragments.size()) {
                        Object fragment = fragments.get(i);
                        int k = i - curSegment;
                        if (fragment instanceof BulkData) {
                            BulkData bulk = (BulkData)fragment;
                            segPositions[k] = bulk.offset();
                            segLength[k] = bulk.length();
                        } else {
                            byte[] byteFrag = (byte[])fragment;
                            segPositions[k] = beforePos;
                            segLength[k] = byteFrag.length;
                        }
                        beforePos += segLength[k] & 0xFFFFFFFFL;
                    }
                    continue;
                }
            }
            return new long[][]{segPositions, segLength};
        }
        return null;
    }

    public long[] getSegPosition() {
        return this.segPosition;
    }

    public long[] getSegLength() {
        return this.segLength;
    }

    public static byte[] getByte(ByteArrayInputStream inputStream) {
        if (inputStream != null) {
            try {
                Field fid = ByteArrayInputStream.class.getDeclaredField("buf");
                if (fid != null) {
                    fid.setAccessible(true);
                    return (byte[])fid.get(inputStream);
                }
            }
            catch (Exception e) {
                LOGGER.error("Cannot get bytes from inputstream", (Throwable)e);
            }
        }
        return null;
    }

    static {
        OpenCVNativeLoader loader = new OpenCVNativeLoader();
        loader.init();
    }
}

