/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.net.audit;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.management.ManagementFactory;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.TimeZone;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.dcm4che3.audit.ActiveParticipant;
import org.dcm4che3.audit.AuditMessage;
import org.dcm4che3.audit.AuditMessages;
import org.dcm4che3.audit.AuditSourceIdentification;
import org.dcm4che3.audit.AuditSourceTypeCode;
import org.dcm4che3.net.Connection;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.IncompatibleConnectionException;
import org.dcm4che3.net.audit.AuditLoggerDeviceExtension;
import org.dcm4che3.net.audit.AuditRecordRepository;
import org.dcm4che3.net.audit.AuditSuppressCriteria;
import org.dcm4che3.util.ReverseDNS;
import org.dcm4che3.util.SafeClose;
import org.dcm4che3.util.StreamUtils;
import org.dcm4che3.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditLogger {
    private static final long serialVersionUID = 1595714214186063103L;
    private static final int MSG_PROMPT_LEN = 8192;
    private static Logger LOG = LoggerFactory.getLogger(AuditLogger.class);
    public static final String MESSAGE_ID = "IHE+RFC-3881";
    private static final int[] DIGITS_0X = new int[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57};
    private static final int[] DIGITS_X0 = new int[]{48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 53, 53, 53, 53, 53, 53, 53, 53, 53, 53, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57};
    private static final byte[] BOM = new byte[]{-17, -69, -65};
    private static final char SYSLOG_VERSION = '1';
    private static final InetAddress localHost = AuditLogger.localHost();
    private static final String processID = AuditLogger.processID();
    private static volatile AuditLogger defaultLogger;
    private String commonName;
    private Device arrDevice;
    private String arrDeviceName;
    private Device device;
    private Facility facility = Facility.authpriv;
    private Severity successSeverity = Severity.notice;
    private Severity minorFailureSeverity = Severity.warning;
    private Severity seriousFailureSeverity = Severity.err;
    private Severity majorFailureSeverity = Severity.crit;
    private String applicationName;
    private String auditSourceID;
    private String auditEnterpriseSiteID;
    private String[] auditSourceTypeCodes = new String[0];
    private String messageID = "IHE+RFC-3881";
    private String encoding = "UTF-8";
    private String schemaURI = "http://www.dcm4che.org/DICOM/audit-message.rnc";
    private boolean timestampInUTC = false;
    private boolean includeBOM = true;
    private boolean formatXML = false;
    private Boolean installed;
    private boolean includeInstanceUID = false;
    private File spoolDirectory;
    private String spoolDirectoryURI;
    private String spoolFileNamePrefix = "audit";
    private String spoolFileNameSuffix = ".log";
    private int retryInterval;
    private final List<AuditSuppressCriteria> suppressAuditMessageFilters = new ArrayList<AuditSuppressCriteria>(0);
    private final List<Connection> conns = new ArrayList<Connection>(1);
    private transient ActiveConnection activeConnection;
    private transient ScheduledFuture<?> retryTimer;
    private transient Exception lastException;
    private transient long lastSentTimeInMillis;
    private final transient FilenameFilter FILENAME_FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return name.startsWith(AuditLogger.this.spoolFileNamePrefix) && name.endsWith(AuditLogger.this.spoolFileNameSuffix);
        }
    };

    public AuditLogger() {
    }

    public AuditLogger(String name) {
        this.setCommonName(name);
    }

    public String getCommonName() {
        return this.commonName;
    }

    public void setCommonName(String commonName) {
        AuditLoggerDeviceExtension ext;
        if (commonName.isEmpty()) {
            throw new IllegalArgumentException("name cannot be empty");
        }
        AuditLoggerDeviceExtension auditLoggerDeviceExtension = ext = this.device != null ? (AuditLoggerDeviceExtension)this.device.getDeviceExtension(AuditLoggerDeviceExtension.class) : null;
        if (ext != null) {
            ext.removeAuditLogger(this.commonName);
        }
        this.commonName = commonName;
        if (ext != null) {
            ext.addAuditLogger(this);
        }
    }

    public String toString() {
        return "AuditLogger{" + this.commonName + '}';
    }

    public final Device getAuditRecordRepositoryDevice() {
        return this.arrDevice;
    }

    public void setAuditRecordRepositoryDevice(Device arrDevice) {
        SafeClose.close((Closeable)this.activeConnection);
        this.activeConnection = null;
        this.arrDevice = arrDevice;
        this.arrDeviceName = arrDevice != null ? arrDevice.getDeviceName() : null;
    }

    public String getAuditRecordRepositoryDeviceName() {
        return this.arrDeviceName;
    }

    public String getAuditRecordRepositoryDeviceNameNotNull() {
        if (this.arrDeviceName == null) {
            throw new IllegalStateException("AuditRecordRepositoryDevice not initialized");
        }
        return this.arrDeviceName;
    }

    public void setAuditRecordRepositoryDeviceName(String arrDeviceName) {
        this.arrDeviceName = arrDeviceName;
    }

    public final Facility getFacility() {
        return this.facility;
    }

    public final void setFacility(Facility facility) {
        if (facility == null) {
            throw new NullPointerException();
        }
        this.facility = facility;
    }

    public final Severity getSuccessSeverity() {
        return this.successSeverity;
    }

    public final void setSuccessSeverity(Severity severity) {
        if (severity == null) {
            throw new NullPointerException();
        }
        this.successSeverity = severity;
    }

    public final Severity getMinorFailureSeverity() {
        return this.minorFailureSeverity;
    }

    public final void setMinorFailureSeverity(Severity severity) {
        if (severity == null) {
            throw new NullPointerException();
        }
        this.minorFailureSeverity = severity;
    }

    public final Severity getSeriousFailureSeverity() {
        return this.seriousFailureSeverity;
    }

    public final void setSeriousFailureSeverity(Severity severity) {
        if (severity == null) {
            throw new NullPointerException();
        }
        this.seriousFailureSeverity = severity;
    }

    public final Severity getMajorFailureSeverity() {
        return this.majorFailureSeverity;
    }

    public final void setMajorFailureSeverity(Severity severity) {
        if (severity == null) {
            throw new NullPointerException();
        }
        this.majorFailureSeverity = severity;
    }

    public final String getApplicationName() {
        return this.applicationName;
    }

    private String applicationName() {
        return this.applicationName != null ? this.applicationName : this.auditSourceID();
    }

    public final void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public final String getAuditSourceID() {
        return this.auditSourceID;
    }

    public final void setAuditSourceID(String auditSourceID) {
        this.auditSourceID = auditSourceID;
    }

    private String auditSourceID() {
        return this.auditSourceID != null ? this.auditSourceID : this.device.getDeviceName();
    }

    public final String getAuditEnterpriseSiteID() {
        return this.auditEnterpriseSiteID;
    }

    public final void setAuditEnterpriseSiteID(String auditEnterpriseSiteID) {
        this.auditEnterpriseSiteID = auditEnterpriseSiteID;
    }

    public String[] getAuditSourceTypeCodes() {
        return this.auditSourceTypeCodes;
    }

    public void setAuditSourceTypeCodes(String ... auditSourceTypeCode) {
        this.auditSourceTypeCodes = auditSourceTypeCode;
    }

    public ActiveParticipant createActiveParticipant(boolean requestor, AuditMessages.RoleIDCode ... roleIDs) {
        Collection aets = this.device.getApplicationAETitles();
        return this.createActiveParticipant(requestor, AuditLogger.processID(), AuditMessages.alternativeUserIDForAETitle((String[])aets.toArray(new String[aets.size()])), this.applicationName(), ReverseDNS.hostNameOf((InetAddress)AuditLogger.localHost()), roleIDs);
    }

    public ActiveParticipant createActiveParticipant(boolean requestor, String userID, String alternativeUserID, String userName, String hostName, AuditMessages.RoleIDCode ... roleIDs) {
        ActiveParticipant ap = new ActiveParticipant();
        ap.setUserID(userID);
        ap.setAlternativeUserID(alternativeUserID);
        ap.setUserName(userName);
        ap.setUserIsRequestor(requestor);
        ap.setNetworkAccessPointID(hostName);
        ap.setNetworkAccessPointTypeCode(AuditMessages.isIP((String)hostName) ? "2" : "1");
        for (AuditMessages.RoleIDCode roleID : roleIDs) {
            ap.getRoleIDCode().add(roleID);
        }
        return ap;
    }

    public AuditSourceIdentification createAuditSourceIdentification() {
        AuditSourceIdentification asi = new AuditSourceIdentification();
        asi.setAuditSourceID(this.auditSourceID());
        if (this.auditEnterpriseSiteID != null) {
            if (this.auditEnterpriseSiteID.equals("dicomInstitutionName")) {
                String[] institutionNames = this.device.getInstitutionNames();
                if (institutionNames.length > 0) {
                    asi.setAuditEnterpriseSiteID(institutionNames[0]);
                }
            } else {
                asi.setAuditEnterpriseSiteID(this.auditEnterpriseSiteID);
            }
        }
        for (String code : this.auditSourceTypeCodes) {
            AuditSourceTypeCode asc = new AuditSourceTypeCode();
            if (code.equals("dicomPrimaryDeviceType")) {
                for (String type : this.device.getPrimaryDeviceTypes()) {
                    asc.setCsdCode(type);
                    asc.setCodeSystemName("DCM");
                    asi.getAuditSourceTypeCode().add(asc);
                }
                continue;
            }
            asc.setCsdCode(code);
            asi.getAuditSourceTypeCode().add(asc);
        }
        return asi;
    }

    public final String getMessageID() {
        return this.messageID;
    }

    public final void setMessageID(String messageID) {
        this.messageID = messageID;
    }

    public final String getEncoding() {
        return this.encoding;
    }

    public final void setEncoding(String encoding) {
        if (!Charset.isSupported(encoding)) {
            throw new IllegalArgumentException("Charset not supported: " + encoding);
        }
        this.encoding = encoding;
    }

    public final String getSchemaURI() {
        return this.schemaURI;
    }

    public final void setSchemaURI(String schemaURI) {
        this.schemaURI = schemaURI;
    }

    public final boolean isTimestampInUTC() {
        return this.timestampInUTC;
    }

    public final void setTimestampInUTC(boolean timestampInUTC) {
        this.timestampInUTC = timestampInUTC;
    }

    public final boolean isIncludeBOM() {
        return this.includeBOM;
    }

    public final void setIncludeBOM(boolean includeBOM) {
        this.includeBOM = includeBOM;
    }

    public final boolean isFormatXML() {
        return this.formatXML;
    }

    public final void setFormatXML(boolean formatXML) {
        this.formatXML = formatXML;
    }

    public boolean isInstalled() {
        return this.device != null && this.device.isInstalled() && (this.installed == null || this.installed != false);
    }

    public final Boolean getInstalled() {
        return this.installed;
    }

    public void setInstalled(Boolean installed) {
        if (installed != null && installed.booleanValue() && this.device != null && !this.device.isInstalled()) {
            throw new IllegalStateException("owning device not installed");
        }
        this.installed = installed;
    }

    public boolean isIncludeInstanceUID() {
        return this.includeInstanceUID;
    }

    public void setIncludeInstanceUID(boolean includeInstanceUID) {
        this.includeInstanceUID = includeInstanceUID;
    }

    public File getSpoolDirectory() {
        return this.spoolDirectory();
    }

    public void setSpoolDirectory(File directory) {
        this.spoolDirectory = directory;
        this.spoolDirectoryURI = directory != null ? directory.toURI().toString() : null;
    }

    public String getSpoolDirectoryURI() {
        return this.spoolDirectoryURI;
    }

    public void setSpoolDirectoryURI(String uri) {
        this.spoolDirectory = uri != null ? new File(URI.create(StringUtils.replaceSystemProperties((String)uri))) : null;
        this.spoolDirectoryURI = uri;
    }

    public String getSpoolNameFilePrefix() {
        return this.spoolFileNamePrefix;
    }

    public void setSpoolFileNamePrefix(String prefix) {
        if (prefix.length() < 3) {
            throw new IllegalArgumentException("Spool file name prefix too short");
        }
        this.spoolFileNamePrefix = prefix;
    }

    public String getSpoolFileNameSuffix() {
        return this.spoolFileNameSuffix;
    }

    public void setSpoolFileNameSuffix(String suffix) {
        if (suffix.isEmpty()) {
            throw new IllegalArgumentException("Spool file name suffix cannot be empty");
        }
        this.spoolFileNameSuffix = suffix;
    }

    public int getRetryInterval() {
        return this.retryInterval;
    }

    public void setRetryInterval(int interval) {
        this.retryInterval = interval;
    }

    public void addConnection(Connection conn) {
        if (!conn.getProtocol().isSyslog()) {
            throw new IllegalArgumentException("Audit Logger does not support protocol " + conn.getProtocol());
        }
        if (this.device != null && this.device != conn.getDevice()) {
            throw new IllegalStateException(conn + " not contained by " + this.device.getDeviceName());
        }
        this.conns.add(conn);
    }

    public boolean removeConnection(Connection conn) {
        return this.conns.remove(conn);
    }

    public List<Connection> getConnections() {
        return this.conns;
    }

    public List<AuditSuppressCriteria> getAuditSuppressCriteriaList() {
        return this.suppressAuditMessageFilters;
    }

    public AuditSuppressCriteria findAuditSuppressCriteriaByCommonName(String cn) {
        for (AuditSuppressCriteria criteria : this.suppressAuditMessageFilters) {
            if (!criteria.getCommonName().equals(cn)) continue;
            return criteria;
        }
        return null;
    }

    public void setAuditSuppressCriteriaList(List<AuditSuppressCriteria> filters) {
        this.suppressAuditMessageFilters.clear();
        this.suppressAuditMessageFilters.addAll(filters);
    }

    public void addAuditSuppressCriteria(AuditSuppressCriteria criteria) {
        this.suppressAuditMessageFilters.add(criteria);
    }

    public void clearAllAuditSuppressCriteria() {
        this.suppressAuditMessageFilters.clear();
    }

    public boolean isAuditMessageSuppressed(AuditMessage msg) {
        for (AuditSuppressCriteria criteria : this.suppressAuditMessageFilters) {
            if (!criteria.match(msg)) continue;
            return true;
        }
        return false;
    }

    void reconfigure(AuditLogger from) {
        this.setFacility(from.facility);
        this.setSuccessSeverity(from.successSeverity);
        this.setMinorFailureSeverity(from.minorFailureSeverity);
        this.setSeriousFailureSeverity(from.seriousFailureSeverity);
        this.setMajorFailureSeverity(from.majorFailureSeverity);
        this.setApplicationName(from.applicationName);
        this.setAuditSourceID(from.auditSourceID);
        this.setAuditEnterpriseSiteID(from.auditEnterpriseSiteID);
        this.setAuditSourceTypeCodes(from.auditSourceTypeCodes);
        this.setMessageID(from.messageID);
        this.setEncoding(from.encoding);
        this.setSchemaURI(from.schemaURI);
        this.setTimestampInUTC(from.timestampInUTC);
        this.setIncludeBOM(from.includeBOM);
        this.setFormatXML(from.formatXML);
        this.setIncludeInstanceUID(from.includeInstanceUID);
        this.setSpoolDirectoryURI(from.spoolDirectoryURI);
        this.setSpoolFileNamePrefix(from.spoolFileNamePrefix);
        this.setSpoolFileNameSuffix(from.spoolFileNameSuffix);
        this.setRetryInterval(from.retryInterval);
        this.setInstalled(from.installed);
        this.arrDevice = from.arrDevice;
        this.arrDeviceName = from.arrDeviceName;
        this.setAuditSuppressCriteriaList(from.suppressAuditMessageFilters);
        this.device.reconfigureConnections(this.conns, from.conns);
        this.closeActiveConnection();
    }

    public Calendar timeStamp() {
        return this.timestampInUTC ? new GregorianCalendar(TimeZone.getTimeZone("UTC"), Locale.ENGLISH) : new GregorianCalendar(Locale.ENGLISH);
    }

    public SendStatus write(Calendar timeStamp, AuditMessage msg) throws IncompatibleConnectionException, GeneralSecurityException, IOException {
        if (this.isAuditMessageSuppressed(msg)) {
            return SendStatus.SUPPRESSED;
        }
        return this.sendMessage(new MessageBuilder().createMessage(timeStamp, msg));
    }

    public SendStatus write(Calendar timeStamp, Severity severity, byte[] data, int off, int len) throws IncompatibleConnectionException, GeneralSecurityException, IOException {
        return this.sendMessage(new MessageBuilder().createMessage(timeStamp, severity, data, off, len));
    }

    private SendStatus sendMessage(DatagramPacket msg) throws IncompatibleConnectionException, GeneralSecurityException, IOException {
        if (this.getNumberOfQueuedMessages() > 0) {
            this.spoolMessage(msg);
            this.scheduleRetry();
        } else {
            try {
                this.activeConnection().sendMessage(msg);
                this.lastSentTimeInMillis = System.currentTimeMillis();
                return SendStatus.SENT;
            }
            catch (IOException e) {
                this.lastException = e;
                if (this.retryInterval > 0) {
                    LOG.info("Failed to send audit message:", (Throwable)e);
                    this.spoolMessage(msg);
                    this.scheduleRetry();
                }
                throw e;
            }
        }
        return SendStatus.QUEUED;
    }

    private synchronized void scheduleRetry() {
        if (this.retryTimer != null || this.retryInterval <= 0) {
            return;
        }
        LOG.debug("Scheduled retry in {} s", (Object)this.retryInterval);
        this.retryTimer = this.device.schedule(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                AuditLogger auditLogger = AuditLogger.this;
                synchronized (auditLogger) {
                    AuditLogger.this.retryTimer = null;
                }
                AuditLogger.this.sendQueuedMessages();
            }
        }, (long)this.retryInterval, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void spoolMessage(DatagramPacket msg) throws IOException {
        if (this.spoolDirectory != null) {
            this.spoolDirectory.mkdirs();
        }
        File f = null;
        try {
            f = File.createTempFile(this.spoolFileNamePrefix, this.spoolFileNameSuffix, this.spoolDirectory());
            LOG.info("Spool audit message to {}", (Object)f);
            FileOutputStream out = new FileOutputStream(f);
            try {
                out.write(msg.getData(), msg.getOffset(), msg.getLength());
            }
            finally {
                SafeClose.close((Closeable)out);
            }
            f = null;
        }
        catch (IOException e) {
            throw new IOException("Failed to spool audit message", e);
        }
        finally {
            if (f != null) {
                f.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendQueuedMessages() {
        File dir = this.spoolDirectory();
        try {
            File[] queuedMessages = dir.listFiles(this.FILENAME_FILTER);
            byte[] b = null;
            while (queuedMessages != null && queuedMessages.length > 0) {
                for (CompareableFile compareableFile : this.sortFiles(dir.listFiles(this.FILENAME_FILTER))) {
                    File file = compareableFile.file;
                    LOG.debug("Read audit message from {}", (Object)file);
                    int len = (int)file.length();
                    if (b == null || b.length < len) {
                        b = new byte[len];
                    }
                    try {
                        FileInputStream in = new FileInputStream(file);
                        try {
                            StreamUtils.readFully((InputStream)in, (byte[])b, (int)0, (int)len);
                        }
                        finally {
                            SafeClose.close((Closeable)in);
                        }
                    }
                    catch (IOException e) {
                        LOG.warn("Failed to read audit message from {}", (Object)file, (Object)e);
                        File dest = new File(file.getParent(), file.getPath() + ".err");
                        file.renameTo(dest);
                        continue;
                    }
                    this.activeConnection().sendMessage(new DatagramPacket(b, 0, len));
                    this.lastSentTimeInMillis = System.currentTimeMillis();
                    if (file.delete()) {
                        LOG.debug("Delete spool file {}", (Object)file);
                        continue;
                    }
                    LOG.warn("Failed to delete spool file {}", (Object)file);
                }
                queuedMessages = dir.listFiles(this.FILENAME_FILTER);
            }
        }
        catch (Exception e) {
            this.lastException = e;
            LOG.info("Failed to send audit message:", (Throwable)e);
            this.scheduleRetry();
        }
        AuditLogger auditLogger = this;
        synchronized (auditLogger) {
            this.notify();
        }
    }

    private CompareableFile[] sortFiles(File[] files) {
        Object[] queuedMessages = new CompareableFile[files.length];
        for (int i = 0; i < files.length; ++i) {
            queuedMessages[i] = new CompareableFile(files[i]);
        }
        Arrays.sort(queuedMessages);
        return queuedMessages;
    }

    public Exception getLastException() {
        return this.lastException;
    }

    public long getLastSentTimeInMillis() {
        return this.lastSentTimeInMillis;
    }

    public int getNumberOfQueuedMessages() {
        String[] fnames = this.spoolDirectory().list(this.FILENAME_FILTER);
        return fnames == null ? 0 : fnames.length;
    }

    public File[] getQueuedMessages() {
        return this.spoolDirectory().listFiles(this.FILENAME_FILTER);
    }

    public synchronized void waitForNoQueuedMessages(long timeout) throws InterruptedException {
        while (this.getNumberOfQueuedMessages() > 0) {
            this.wait(timeout);
        }
    }

    public synchronized void closeActiveConnection() {
        ActiveConnection activeConnection = this.activeConnection;
        if (activeConnection != null) {
            try {
                activeConnection.close();
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
            this.activeConnection = null;
        }
    }

    private synchronized ActiveConnection activeConnection() throws IncompatibleConnectionException {
        ActiveConnection activeConnection = this.activeConnection;
        if (activeConnection != null) {
            return activeConnection;
        }
        Device arrDev = this.arrDevice;
        if (this.arrDevice == null) {
            throw new IllegalStateException("No AuditRecordRepositoryDevice initalized");
        }
        AuditRecordRepository arr = (AuditRecordRepository)arrDev.getDeviceExtension(AuditRecordRepository.class);
        if (arr == null) {
            throw new IllegalStateException("AuditRecordRepositoryDevice " + this.arrDevice.getDeviceName() + " does not provide Audit Record Repository");
        }
        for (Connection remoteConn : arr.getConnections()) {
            if (!remoteConn.isInstalled() || !remoteConn.isServer()) continue;
            for (Connection conn : this.conns) {
                if (!conn.isInstalled() || !conn.isCompatible(remoteConn)) continue;
                this.activeConnection = conn.getProtocol().isTCP() ? new TCPConnection(conn, remoteConn) : new UDPConnection(conn, remoteConn);
                return this.activeConnection;
            }
        }
        throw new IncompatibleConnectionException("No compatible connection to AuditRecordRepository @ Device " + arr.getDevice().getDeviceName() + " available on AuditLogger @ Device " + this.device.getDeviceName());
    }

    public static String processID() {
        String s = ManagementFactory.getRuntimeMXBean().getName();
        int atPos = s.indexOf(64);
        return atPos > 0 ? s.substring(0, atPos) : Integer.toString(new Random().nextInt() & Integer.MAX_VALUE);
    }

    public static InetAddress localHost() {
        try {
            return InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    private Severity severityOf(AuditMessage msg) {
        String eventOutcomeIndicator = msg.getEventIdentification().getEventOutcomeIndicator();
        if (eventOutcomeIndicator.length() == 1) {
            switch (eventOutcomeIndicator.charAt(0)) {
                case '0': {
                    return this.successSeverity;
                }
                case '4': {
                    return this.minorFailureSeverity;
                }
                case '8': {
                    return this.seriousFailureSeverity;
                }
            }
        } else if (eventOutcomeIndicator.equals("12")) {
            return this.majorFailureSeverity;
        }
        throw new IllegalArgumentException("Illegal eventOutcomeIndicator: " + eventOutcomeIndicator);
    }

    private int prival(Severity severity) {
        return this.facility.ordinal() << 3 | severity.ordinal();
    }

    public static AuditLogger getDefaultLogger() {
        return defaultLogger;
    }

    public static void setDefaultLogger(AuditLogger defaultLogger) {
        AuditLogger.defaultLogger = defaultLogger;
    }

    private static String toString(DatagramPacket packet) {
        try {
            int len = packet.getLength();
            boolean truncate = len > 8192;
            String s = new String(packet.getData(), 0, truncate ? 8192 : len, "UTF-8");
            if (truncate) {
                s = s + "...";
            }
            return s;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    void setDevice(Device device) {
        if (device != null) {
            if (this.device != null) {
                throw new IllegalStateException("already owned by " + this.device.getDeviceName());
            }
            for (Connection conn : this.conns) {
                if (conn.getDevice() == device) continue;
                throw new IllegalStateException(conn + " not owned by " + device.getDeviceName());
            }
        }
        this.device = device;
    }

    public final Device getDevice() {
        return this.device;
    }

    private File spoolDirectory() {
        return this.spoolDirectory != null ? this.spoolDirectory : LazyHolder.tmpdir;
    }

    public static enum Severity {
        emerg,
        alert,
        crit,
        err,
        warning,
        notice,
        info,
        debug;

    }

    public static enum Facility {
        kern,
        user,
        mail,
        daemon,
        auth,
        syslog,
        lpr,
        news,
        uucp,
        cron,
        authpriv,
        ftp,
        ntp,
        audit,
        console,
        cron2,
        local0,
        local1,
        local2,
        local3,
        local4,
        local5,
        local6,
        local7;

    }

    private abstract class ActiveConnection
    implements Closeable {
        final Connection conn;
        final Connection remoteConn;

        ActiveConnection(Connection conn, Connection remoteConn) {
            this.conn = conn;
            this.remoteConn = remoteConn;
        }

        abstract void sendMessage(DatagramPacket var1) throws IOException, IncompatibleConnectionException, GeneralSecurityException;
    }

    public static enum SendStatus {
        SENT,
        QUEUED,
        SUPPRESSED;

    }

    private class MessageBuilder
    extends ByteArrayOutputStream {
        private MessageBuilder() {
        }

        DatagramPacket createMessage(Calendar timeStamp, AuditMessage msg) {
            block2: {
                try {
                    this.reset();
                    this.writeHeader(AuditLogger.this.severityOf(msg), timeStamp);
                    AuditMessages.toXML((AuditMessage)msg, (OutputStream)this, (boolean)AuditLogger.this.formatXML, (String)AuditLogger.this.encoding, (String)AuditLogger.this.schemaURI);
                }
                catch (IOException e) {
                    if ($assertionsDisabled) break block2;
                    throw new AssertionError((Object)e);
                }
            }
            return new DatagramPacket(this.buf, 0, this.count);
        }

        DatagramPacket createMessage(Calendar timeStamp, Severity severity, byte[] data, int off, int len) {
            block2: {
                try {
                    this.reset();
                    this.writeHeader(severity, timeStamp);
                    this.write(data, off, len);
                }
                catch (IOException e) {
                    if ($assertionsDisabled) break block2;
                    throw new AssertionError((Object)e);
                }
            }
            return new DatagramPacket(this.buf, 0, this.count);
        }

        void writeHeader(Severity severity, Calendar timeStamp) throws IOException {
            this.write(60);
            this.writeInt(AuditLogger.this.prival(severity));
            this.write(62);
            this.write(49);
            this.write(32);
            this.write(timeStamp);
            this.write(32);
            if (localHost != null) {
                this.write(localHost.getCanonicalHostName().getBytes(AuditLogger.this.encoding));
            } else {
                this.write(45);
            }
            this.write(32);
            this.write(StringUtils.replaceNonPrintASCII((String)StringUtils.truncate((String)AuditLogger.this.applicationName().trim(), (int)48), (char)'_').getBytes(AuditLogger.this.encoding));
            this.write(32);
            this.write(processID.getBytes(AuditLogger.this.encoding));
            this.write(32);
            if (AuditLogger.this.messageID != null) {
                this.write(AuditLogger.this.messageID.getBytes(AuditLogger.this.encoding));
            } else {
                this.write(45);
            }
            this.write(32);
            this.write(45);
            this.write(32);
            if (AuditLogger.this.includeBOM && AuditLogger.this.encoding.equals("UTF-8")) {
                this.write(BOM);
            }
        }

        void writeInt(int i) {
            if (i >= 100) {
                this.writeNNN(i);
            } else if (i >= 10) {
                this.writeNN(i);
            } else {
                this.writeN(i);
            }
        }

        void write(Calendar timeStamp) {
            this.writeNNNN(timeStamp.get(1));
            this.write(45);
            this.writeNN(timeStamp.get(2) + 1);
            this.write(45);
            this.writeNN(timeStamp.get(5));
            this.write(84);
            this.writeNN(timeStamp.get(11));
            this.write(58);
            this.writeNN(timeStamp.get(12));
            this.write(58);
            this.writeNN(timeStamp.get(13));
            this.write(46);
            this.writeNNN(timeStamp.get(14));
            int tzOffset = timeStamp.get(15) + timeStamp.get(16);
            if (tzOffset == 0) {
                this.write(90);
            } else {
                if ((tzOffset /= 60000) > 0) {
                    this.write(43);
                } else {
                    this.write(45);
                    tzOffset = -tzOffset;
                }
                this.writeNN(tzOffset / 60);
                this.write(58);
                this.writeNN(tzOffset % 60);
            }
        }

        void writeNNNN(int i) {
            this.writeNN(i / 100);
            this.writeNN(i % 100);
        }

        void writeNNN(int i) {
            this.writeN(i / 100);
            this.writeNN(i % 100);
        }

        void writeNN(int i) {
            this.write(DIGITS_X0[i]);
            this.write(DIGITS_0X[i]);
        }

        void writeN(int i) {
            this.write(DIGITS_0X[i]);
        }
    }

    private static final class CompareableFile
    implements Comparable<CompareableFile> {
        final File file;
        final long lastModified;

        private CompareableFile(File file) {
            this.file = file;
            this.lastModified = file.lastModified();
        }

        @Override
        public int compareTo(CompareableFile o) {
            long diff = this.lastModified - o.lastModified;
            return diff < 0L ? -1 : (diff > 0L ? 1 : 0);
        }
    }

    private class TCPConnection
    extends ActiveConnection {
        Socket sock;
        OutputStream out;
        ScheduledFuture<?> idleTimer;

        TCPConnection(Connection conn, Connection remoteConn) {
            super(conn, remoteConn);
        }

        void connect() throws IOException, IncompatibleConnectionException, GeneralSecurityException {
            if (this.sock == null) {
                this.sock = this.conn.connect(this.remoteConn);
                this.out = this.sock.getOutputStream();
            }
        }

        @Override
        synchronized void sendMessage(DatagramPacket packet) throws IOException, IncompatibleConnectionException, GeneralSecurityException {
            this.stopIdleTimer();
            this.connect();
            try {
                this.trySendMessage(packet);
            }
            catch (IOException e) {
                LOG.info("Failed to send audit message to {} - reconnect", (Object)this.sock, (Object)e);
                this.close();
                this.connect();
                this.trySendMessage(packet);
            }
            this.startIdleTimer();
        }

        void trySendMessage(DatagramPacket packet) throws IOException {
            LOG.info("Send audit message to {}", (Object)this.sock);
            if (LOG.isDebugEnabled()) {
                LOG.debug(AuditLogger.toString(packet));
            }
            this.out.write(Integer.toString(packet.getLength()).getBytes(AuditLogger.this.encoding));
            this.out.write(32);
            this.out.write(packet.getData(), packet.getOffset(), packet.getLength());
            this.out.flush();
        }

        private void startIdleTimer() {
            int idleTimeout = this.conn.getIdleTimeout();
            if (idleTimeout > 0) {
                LOG.debug("Start Idle timeout of {} ms for {}", (Object)idleTimeout, (Object)this.sock);
                try {
                    this.idleTimer = this.conn.getDevice().schedule(new Runnable(){

                        @Override
                        public void run() {
                            TCPConnection.this.onIdleTimerExpired();
                        }
                    }, (long)idleTimeout, TimeUnit.MILLISECONDS);
                }
                catch (Exception e) {
                    LOG.warn("Failed to start Idle timeout", (Throwable)e);
                }
            }
        }

        private void stopIdleTimer() {
            if (this.idleTimer != null) {
                LOG.debug("Stop Idle timer for {}", (Object)this.sock);
                this.idleTimer.cancel(false);
                this.idleTimer = null;
            }
        }

        @Override
        public synchronized void close() {
            this.stopIdleTimer();
            this.closeSocket();
        }

        private void closeSocket() {
            if (this.sock != null) {
                this.conn.close(this.sock);
            }
            this.sock = null;
            this.out = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onIdleTimerExpired() {
            ScheduledFuture<?> expiredIdleTimer = this.idleTimer;
            TCPConnection tCPConnection = this;
            synchronized (tCPConnection) {
                if (expiredIdleTimer != this.idleTimer) {
                    LOG.debug("Detect restart of Idle timer for {}", (Object)this.sock);
                } else {
                    LOG.info("Idle timeout for {} expired", (Object)this.sock);
                    this.idleTimer = null;
                    this.closeSocket();
                }
            }
        }
    }

    private class UDPConnection
    extends ActiveConnection {
        DatagramSocket ds;

        UDPConnection(Connection conn, Connection remoteConn) {
            super(conn, remoteConn);
        }

        @Override
        void sendMessage(DatagramPacket msg) throws IOException {
            if (this.ds == null) {
                this.ds = this.conn.createDatagramSocket();
            }
            InetSocketAddress endPoint = this.remoteConn.getEndPoint();
            LOG.info("Send audit message to {}", (Object)endPoint);
            if (LOG.isDebugEnabled()) {
                LOG.debug(AuditLogger.toString(msg));
            }
            msg.setSocketAddress(endPoint);
            this.ds.send(msg);
        }

        @Override
        public void close() {
            if (this.ds != null) {
                this.ds.close();
                this.ds = null;
            }
        }
    }

    private static class LazyHolder {
        static final File tmpdir = new File(AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("java.io.tmpdir");
            }
        }));

        private LazyHolder() {
        }
    }
}

