/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.net.audit;

import java.util.Collection;
import java.util.LinkedHashMap;
import org.dcm4che3.net.Connection;
import org.dcm4che3.net.DeviceExtension;
import org.dcm4che3.net.audit.AuditLogger;

public class AuditLoggerDeviceExtension
extends DeviceExtension {
    private final LinkedHashMap<String, AuditLogger> loggers = new LinkedHashMap();

    public void addAuditLogger(AuditLogger logger) {
        logger.setDevice(this.device);
        this.loggers.put(logger.getCommonName(), logger);
    }

    public AuditLogger removeAuditLogger(String name) {
        AuditLogger logger = (AuditLogger)this.loggers.remove(name);
        if (logger != null) {
            logger.setDevice(null);
        }
        return logger;
    }

    public void verifyNotUsed(Connection conn) {
        for (AuditLogger logger : this.loggers.values()) {
            if (!logger.getConnections().contains(conn)) continue;
            throw new IllegalStateException(conn + " used by Audit Logger" + logger.getCommonName());
        }
    }

    public void reconfigure(DeviceExtension from) {
        this.reconfigure((AuditLoggerDeviceExtension)from);
    }

    private void reconfigure(AuditLoggerDeviceExtension from) {
        this.loggers.keySet().retainAll(from.loggers.keySet());
        for (AuditLogger src : from.loggers.values()) {
            AuditLogger logger = this.loggers.get(src.getApplicationName());
            if (logger == null) {
                logger = new AuditLogger(src.getCommonName());
                this.addAuditLogger(logger);
            }
            logger.reconfigure(src);
        }
    }

    public Collection<AuditLogger> getAuditLoggers() {
        return this.loggers.values();
    }

    public boolean containsAuditLogger(String name) {
        return this.loggers.containsKey(name);
    }

    public AuditLogger getAuditLogger(String name) {
        return this.loggers.get(name);
    }

    public Collection<String> getAuditLoggerNames() {
        return this.loggers.keySet();
    }
}

