/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.net.audit;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import org.dcm4che3.net.Connection;
import org.dcm4che3.net.DeviceExtension;
import org.dcm4che3.net.TCPProtocolHandler;
import org.dcm4che3.net.UDPProtocolHandler;
import org.dcm4che3.net.audit.AuditRecordHandler;
import org.dcm4che3.net.audit.SyslogProtocolHandler;

public class AuditRecordRepository
extends DeviceExtension {
    private static final long serialVersionUID = -2279487409324427161L;
    private Boolean installed;
    private final List<Connection> conns = new ArrayList<Connection>(1);
    private transient AuditRecordHandler handler;

    public boolean isInstalled() {
        return this.device != null && this.device.isInstalled() && (this.installed == null || this.installed != false);
    }

    public final Boolean getInstalled() {
        return this.installed;
    }

    public void setInstalled(Boolean installed) {
        if (installed != null && installed.booleanValue() && this.device != null && !this.device.isInstalled()) {
            throw new IllegalStateException("owning device not installed");
        }
        this.installed = installed;
    }

    public void addConnection(Connection conn) {
        if (!conn.getProtocol().isSyslog()) {
            throw new IllegalArgumentException("Audit Record Repository does not support protocol " + conn.getProtocol());
        }
        if (this.device != null && this.device != conn.getDevice()) {
            throw new IllegalStateException(conn + " not contained by " + this.device.getDeviceName());
        }
        this.conns.add(conn);
    }

    public boolean removeConnection(Connection conn) {
        return this.conns.remove(conn);
    }

    public List<Connection> getConnections() {
        return this.conns;
    }

    public AuditRecordHandler getAuditRecordHandler() {
        return this.handler;
    }

    public void setAuditRecordHandler(AuditRecordHandler handler) {
        this.handler = handler;
    }

    public void reconfigure(DeviceExtension from) {
        this.reconfigure((AuditRecordRepository)from);
    }

    private void reconfigure(AuditRecordRepository from) {
        this.setInstalled(from.installed);
        this.device.reconfigureConnections(this.conns, from.conns);
    }

    public void onMessage(byte[] data, int xmlOffset, int xmlLength, Connection conn, InetAddress from) {
        if (this.handler == null) {
            throw new IllegalStateException("No AuditRecordHandler initialized");
        }
        this.handler.onMessage(data, xmlOffset, xmlLength, conn, from);
    }

    static {
        Connection.registerTCPProtocolHandler((Connection.Protocol)Connection.Protocol.SYSLOG_TLS, (TCPProtocolHandler)SyslogProtocolHandler.INSTANCE);
        Connection.registerUDPProtocolHandler((Connection.Protocol)Connection.Protocol.SYSLOG_UDP, (UDPProtocolHandler)SyslogProtocolHandler.INSTANCE);
    }
}

