/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.net.hl7;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.VR;
import org.dcm4che3.hl7.HL7Charset;
import org.dcm4che3.hl7.HL7ContentHandler;
import org.dcm4che3.hl7.HL7Parser;
import org.dcm4che3.io.ContentHandlerAdapter;
import org.dcm4che3.io.SAXTransformer;
import org.dcm4che3.io.SAXWriter;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class HL7SAXTransformer {
    private static SAXTransformerFactory factory = (SAXTransformerFactory)TransformerFactory.newInstance();

    private HL7SAXTransformer() {
    }

    public static Attributes transform(byte[] data, String hl7charset, String dicomCharset, Templates templates, SAXTransformer.SetupTransformer setup) throws TransformerConfigurationException, IOException, SAXException {
        Attributes attrs = new Attributes();
        if (dicomCharset != null) {
            attrs.setString(524293, VR.CS, dicomCharset);
        }
        TransformerHandler th = factory.newTransformerHandler(templates);
        th.setResult(new SAXResult((ContentHandler)new ContentHandlerAdapter(attrs)));
        if (setup != null) {
            setup.setup(th.getTransformer());
        }
        new HL7Parser((ContentHandler)th).parse((Reader)new InputStreamReader((InputStream)new ByteArrayInputStream(data), HL7Charset.toCharsetName((String)hl7charset)));
        return attrs;
    }

    public static byte[] transform(Attributes attrs, String hl7charset, Templates templates, boolean includeNameSpaceDeclaration, boolean includeKeword, SAXTransformer.SetupTransformer setup) throws TransformerConfigurationException, SAXException, UnsupportedEncodingException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        TransformerHandler th = factory.newTransformerHandler(templates);
        th.setResult(new SAXResult((ContentHandler)new HL7ContentHandler((Writer)new OutputStreamWriter((OutputStream)out, HL7Charset.toCharsetName((String)hl7charset)))));
        if (setup != null) {
            setup.setup(th.getTransformer());
        }
        SAXWriter saxWriter = new SAXWriter((ContentHandler)th);
        saxWriter.setIncludeKeyword(includeKeword);
        saxWriter.setIncludeNamespaceDeclaration(includeNameSpaceDeclaration);
        saxWriter.write(attrs);
        return out.toByteArray();
    }
}

