/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.net.hl7.service;

import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import org.dcm4che3.hl7.HL7Exception;
import org.dcm4che3.net.Connection;
import org.dcm4che3.net.hl7.DefaultHL7MessageListener;
import org.dcm4che3.net.hl7.HL7Application;
import org.dcm4che3.net.hl7.HL7MessageListener;
import org.dcm4che3.net.hl7.UnparsedHL7Message;
import org.dcm4che3.net.hl7.service.HL7Service;

public class HL7ServiceRegistry
extends DefaultHL7MessageListener {
    private final ArrayList<HL7Service> services = new ArrayList();
    private final HashMap<String, HL7MessageListener> listeners = new HashMap();

    public synchronized void addHL7Service(HL7Service service) {
        this.services.add(service);
        for (String messageType : service.getMessageTypes()) {
            this.listeners.put(messageType, service);
        }
    }

    public synchronized boolean removeHL7Service(HL7Service service) {
        if (!this.services.remove(service)) {
            return false;
        }
        for (String messageType : service.getMessageTypes()) {
            this.listeners.remove(messageType);
        }
        return true;
    }

    @Override
    public UnparsedHL7Message onMessage(HL7Application hl7App, Connection conn, Socket s, UnparsedHL7Message msg) throws HL7Exception {
        HL7MessageListener listener = this.listeners.get(msg.msh().getMessageType());
        if (listener == null && (listener = this.listeners.get("*")) == null) {
            return super.onMessage(hl7App, conn, s, msg);
        }
        return listener.onMessage(hl7App, conn, s, msg);
    }
}

