/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.qstar;

import jakarta.xml.ws.BindingProvider;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.transport.http.HTTPConduit;
import org.dcm4che3.net.Device;
import org.dcm4che3.qstar.ObjectFactory;
import org.dcm4che3.qstar.WSBatchFileRetrieveRequest;
import org.dcm4che3.qstar.WSBatchFileRetrieveResponse;
import org.dcm4che3.qstar.WSBatchJobObjectStatusRequest;
import org.dcm4che3.qstar.WSBatchJobObjectStatusResponse;
import org.dcm4che3.qstar.WSBatchJobStatusRequest;
import org.dcm4che3.qstar.WSBatchJobStatusResponse;
import org.dcm4che3.qstar.WSFileExtentCopyInfo;
import org.dcm4che3.qstar.WSFileExtentInfo;
import org.dcm4che3.qstar.WSFileInfo;
import org.dcm4che3.qstar.WSFileList;
import org.dcm4che3.qstar.WSGetFileInfoRequest;
import org.dcm4che3.qstar.WSGetFileInfoResponse;
import org.dcm4che3.qstar.WSMMPurgeFileRequest;
import org.dcm4che3.qstar.WSMMPurgeFileResponse;
import org.dcm4che3.qstar.WSUserLoginRequest;
import org.dcm4che3.qstar.WSUserLoginResponse;
import org.dcm4che3.qstar.WSUserLogoutRequest;
import org.dcm4che3.qstar.WSUserLogoutResponse;
import org.dcm4che3.qstar.WSWebService;
import org.dcm4che3.qstar.WSWebServiceSoapPort;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QStarUtils {
    private static final Logger LOG = LoggerFactory.getLogger(QStarUtils.class);
    private static final WSWebService service = new WSWebService();
    private static final ObjectFactory factory = new ObjectFactory();
    private static final String[] ACCESS_STATES = new String[]{"0 - ACCESS_STATE_NONE", "1 - ACCESS_STATE_EMPTY", "2 - ACCESS_STATE_UNSTABLE", "3 - ACCESS_STATE_STABLE", "4 - ACCESS_STATE_OUT_OF_CACHE", "5 - ACCESS_STATE_OFFLINE"};
    private static final String[] DETAILED_ACCESS_STATES = new String[]{"0 - DETAILED_ACCESS_STATE_NONE", "1 - DETAILED_ACCESS_STATE_EMPTY", "2 - DETAILED_ACCESS_STATE_CACHED_PRIMARY", "3 - DETAILED_ACCESS_STATE_CACHED_MIG", "4 - DETAILED_ACCESS_STATE_CACHED_MIG_OUT", "5 - DETAILED_ACCESS_STATE_CACHED_MIG_REP", "6 - DETAILED_ACCESS_STATE_CACHED_REP_OUT", "7 - DETAILED_ACCESS_STATE_MIGRATED", "8 - DETAILED_ACCESS_STATE_MIGRATED_OUT", "9 - DETAILED_ACCESS_STATE_ARCHIVED_REP", "10 - DETAILED_ACCESS_STATE_ARCHIVED_OUT", "11 - DETAILED_ACCESS_STATE_REPLICATED_OUT", "12 - DETAILED_ACCESS_STATE_REPLICATED", "13 - DETAILED_ACCESS_STATE_OUT_OF_CACHE", "14 - DETAILED_ACCESS_STATE_OFFLINE"};
    private static final String[] JOB_STATUS_NAMES = new String[]{"0", "1 - INQUEUE", "2 - PROCESSING", "3 - COMPLETED", "4 - FAILED", "5 - PARTIALLY_COMPLETED"};

    private QStarUtils() {
    }

    public static WSWebServiceSoapPort getWSWebServiceSoapPort(String url) {
        WSWebServiceSoapPort port = service.getWSWebServiceSoapPort();
        BindingProvider bindingProvider = (BindingProvider)port;
        Map reqCtx = bindingProvider.getRequestContext();
        reqCtx.put("jakarta.xml.ws.service.endpoint.address", url);
        return port;
    }

    public static void setTlsClientParameters(WSWebServiceSoapPort port, Device device, String tlsProtocol, String[] cipherSuites, boolean disableCNCheck) throws GeneralSecurityException, IOException {
        Client client = ClientProxy.getClient((Object)port);
        HTTPConduit conduit = (HTTPConduit)client.getConduit();
        conduit.setTlsClientParameters(QStarUtils.createTLSClientParameters(device, tlsProtocol, cipherSuites, disableCNCheck));
    }

    private static TLSClientParameters createTLSClientParameters(Device device, String tlsProtocol, String[] cipherSuites, boolean disableCNCheck) throws GeneralSecurityException, IOException {
        TLSClientParameters params = new TLSClientParameters();
        params.setKeyManagers(device.keyManagers());
        params.setTrustManagers(device.trustManagers());
        params.setSecureSocketProtocol(tlsProtocol);
        for (String cipherSuite : cipherSuites) {
            params.getCipherSuites().add(cipherSuite.trim());
        }
        params.setDisableCNCheck(disableCNCheck);
        return params;
    }

    public static WSUserLoginResponse login(WSWebServiceSoapPort port, String userName, String userPassword) {
        WSUserLoginRequest rq = factory.createWSUserLoginRequest();
        rq.setUserName(userName);
        rq.setUserPassword(userPassword);
        LOG.debug("<< WSUserLoginRequest{userName='{}', userPassword='{}'}", (Object)userName, (Object)userPassword);
        WSUserLoginResponse userLogin = port.wsUserLogin(rq);
        LOG.debug(">> WSUserLoginResponse{result={}, resultString='{}', wsdlVersion='{}', userToken='{}'}", new Object[]{userLogin.getResult(), userLogin.getResultString(), userLogin.getWsdlVersion(), userLogin.getUserToken()});
        return userLogin;
    }

    public static WSUserLogoutResponse logout(WSWebServiceSoapPort port, WSUserLoginResponse userLogin) {
        WSUserLogoutRequest rq = factory.createWSUserLogoutRequest();
        rq.setUserToken(userLogin.getUserToken());
        LOG.debug("<< WSUserLogoutRequest{userToken='{}'}", (Object)userLogin.getUserToken());
        WSUserLogoutResponse userLogout = port.wsUserLogout(rq);
        LOG.debug(">> WSUserLogoutResponse{result={}}", (Object)userLogout.getResult());
        return userLogout;
    }

    public static WSGetFileInfoResponse getFileInfo(WSWebServiceSoapPort port, WSUserLoginResponse userLogin, String filePath) {
        WSGetFileInfoRequest rq = factory.createWSGetFileInfoRequest();
        rq.setSFileFullPath(filePath);
        rq.setUserToken(userLogin.getUserToken());
        LOG.debug("<< WSGetFileInfoRequest{sFileFullPath='{}', userToken='{}'}", (Object)filePath, (Object)userLogin.getUserToken());
        WSGetFileInfoResponse fileInfo = port.wsGetFileInfo(rq);
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> WSGetFileInfoResponse{status={}, info={}}", (Object)fileInfo.getStatus(), (Object)QStarUtils.toString(fileInfo.getInfo()));
        }
        return fileInfo;
    }

    public static WSBatchFileRetrieveResponse batchFileRetrieve(WSWebServiceSoapPort port, WSUserLoginResponse userLogin, long jobPriority, List<String> fileList, String targetDir) {
        WSBatchFileRetrieveRequest rq = factory.createWSBatchFileRetrieveRequest();
        rq.setJobPriority(jobPriority);
        rq.setFileCount(BigInteger.valueOf(fileList.size()));
        rq.setFileList(QStarUtils.createWSFileList(fileList));
        rq.setTargetDir(targetDir);
        rq.setUserToken(userLogin.getUserToken());
        LOG.debug("<< WSBatchFileRetrieveRequest{jobPriority={}, fileCount='{}', targetDir='{}', userToken='{}'}", new Object[]{jobPriority, fileList.size(), targetDir, userLogin.getUserToken()});
        WSBatchFileRetrieveResponse fileRetrieve = port.wsBatchFileRetrieve(rq);
        LOG.debug(">> WSBatchFileRetrieveResponse{jobId={}}", (Object)fileRetrieve.getJobId());
        return fileRetrieve;
    }

    private static WSFileList createWSFileList(List<String> fileList) {
        WSFileList wsFileList = factory.createWSFileList();
        wsFileList.getFileName().addAll(fileList);
        return wsFileList;
    }

    public static WSBatchJobStatusResponse batchJobStatus(WSWebServiceSoapPort port, WSUserLoginResponse userLogin, BigInteger jobId) {
        WSBatchJobStatusRequest rq = factory.createWSBatchJobStatusRequest();
        rq.setJobId(jobId);
        rq.setUserToken(userLogin.getUserToken());
        LOG.debug("<< WSBatchJobStatusRequest{jobId={}, userToken='{}'}", (Object)jobId, (Object)userLogin.getUserToken());
        WSBatchJobStatusResponse jobStatus = port.wsBatchJobStatus(rq);
        LOG.debug(">> WSBatchJobStatusResponse{jobStatus={}}", (Object)QStarUtils.jobStatusAsString(jobStatus.getJobStatus()));
        return jobStatus;
    }

    public static String jobStatusAsString(long jobStatus) {
        return QStarUtils.toString(jobStatus, JOB_STATUS_NAMES);
    }

    public static WSBatchJobObjectStatusResponse batchJobObjectStatus(WSWebServiceSoapPort port, WSUserLoginResponse userLogin, BigInteger jobId, String file) {
        WSBatchJobObjectStatusRequest rq = factory.createWSBatchJobObjectStatusRequest();
        rq.setJobId(jobId);
        rq.setJobObjectName(file);
        rq.setUserToken(userLogin.getUserToken());
        LOG.debug("<< WSBatchJobObjectStatusRequest{jobId={}, jobObjectName='{}', userToken='{}'}", new Object[]{jobId, file, userLogin.getUserToken()});
        WSBatchJobObjectStatusResponse jobObjectStatus = port.wsBatchJobObjectStatus(rq);
        LOG.debug(">> WSBatchJobObjectStatusResponse{jobObjectStatus={}}", (Object)QStarUtils.jobObjectStatusAsString(jobObjectStatus.getJobObjectStatus()));
        return jobObjectStatus;
    }

    public static String jobObjectStatusAsString(long jobObjectStatus) {
        return QStarUtils.toString(jobObjectStatus, JOB_STATUS_NAMES);
    }

    public static WSMMPurgeFileResponse purgeFile(WSWebServiceSoapPort port, WSUserLoginResponse userLogin, String filePath) {
        WSMMPurgeFileRequest rq = factory.createWSMMPurgeFileRequest();
        rq.setFileName(filePath);
        rq.setUserToken(userLogin.getUserToken());
        LOG.debug("<< WSMMPurgeFileRequest{fileName='{}', userToken='{}'}", (Object)filePath, (Object)userLogin.getUserToken());
        WSMMPurgeFileResponse purgeFile = port.wsmmPurgeFile(rq);
        LOG.debug(">> WSMMPurgeFileResponse{error={}, description={}}", (Object)purgeFile.getError(), (Object)purgeFile.getDescription());
        return purgeFile;
    }

    private static String toString(long i, String[] values) {
        try {
            return values[(int)i];
        }
        catch (IndexOutOfBoundsException e) {
            return Long.toString(i);
        }
    }

    private static String toString(WSFileInfo info) {
        if (info == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder(1024);
        sb.append("\n  WSFileInfo{\n    size=").append(info.getSize());
        sb.append(",\n    mode=").append(info.getMode());
        sb.append(",\n    uid=").append(info.getUid());
        sb.append(",\n    gid=").append(info.getGid());
        sb.append(",\n    nlink=").append(info.getNlink());
        sb.append(",\n    flags=").append(info.getFlags());
        sb.append(",\n    presentCount=").append(info.getPresentCount());
        sb.append(",\n    primaryCount=").append(info.getPrimaryCount());
        sb.append(",\n    replicatedCount=").append(info.getReplicatedCount());
        sb.append(",\n    archivedCount=").append(info.getArchivedCount());
        sb.append(",\n    pageSize=").append(info.getPageSize());
        sb.append(",\n    aTime=").append(QStarUtils.toInstant(info.getATime()));
        sb.append(",\n    mTime=").append(QStarUtils.toInstant(info.getMTime()));
        sb.append(",\n    cTime=").append(QStarUtils.toInstant(info.getCTime()));
        sb.append(",\n    crTime=").append(QStarUtils.toInstant(info.getCrTime()));
        sb.append(",\n    cmTime=").append(QStarUtils.toInstant(info.getCmTime()));
        sb.append(",\n    onOff=").append(info.getOnOff());
        sb.append(",\n    retentionEndTime=").append(QStarUtils.toInstant(info.getRetentionEndTime()));
        sb.append(",\n    digest=").append(QStarUtils.quote(info.getDigest()));
        sb.append(",\n    objectId=").append(QStarUtils.quote(info.getObjectId()));
        sb.append(",\n    objectIdLength=").append(info.getObjectIdLength());
        sb.append(",\n    digestType=").append(info.getDigestType());
        sb.append(",\n    encryptionType=").append(info.getEncryptionType());
        sb.append(",\n    cryptoFlags=").append(info.getCryptoFlags());
        sb.append(",\n    flocExtents=[");
        for (WSFileExtentInfo extent : info.getFlocExtents().getExtent()) {
            sb.append("\n      WSFileExtentInfo{\n        offset=").append(extent.getOffset());
            sb.append(",\n        size=").append(extent.getSize());
            sb.append(",\n        vol=").append(extent.getVol());
            sb.append(",\n        pos=").append(extent.getPos());
            sb.append(",\n        isOffline=").append(extent.getIsOffline());
            sb.append(",\n        mediaBarcode=").append(QStarUtils.quote(extent.getMediaBarcode()));
            sb.append(",\n        libraryName=").append(QStarUtils.quote(extent.getLibraryName()));
            sb.append(",\n        offlineLocation=").append(QStarUtils.quote(extent.getOfflineLocation()));
            sb.append(",\n        extentCopies=[");
            for (WSFileExtentCopyInfo copy : extent.getExtentCopies().getCopies()) {
                sb.append("\n          WSFileExtentCopyInfo{\n            isOffline=").append(copy.getIsOffline());
                sb.append(",\n            mediaBarcode=").append(QStarUtils.quote(copy.getMediaBarcode()));
                sb.append(",\n            offlineLocation=").append(QStarUtils.quote(copy.getOfflineLocation()));
                sb.append(",\n            copyNumber=").append(copy.getCopyNumber());
                sb.append(",\n            deviceName=").append(QStarUtils.quote(copy.getDeviceName()));
                sb.append(",\n            slotNumber=").append(copy.getSlotNumber());
                sb.append(",\n            side=").append(QStarUtils.quote(copy.getSide()));
                sb.append(",\n            copyInSet=").append(copy.getCopyInSet());
                sb.append(",\n            copyInDB=").append(copy.getCopyInDB());
                sb.append(",\n            copyInDevice=").append(copy.getCopyInDevice());
                sb.append('}');
            }
            sb.append("],\n        copiesCount=").append(extent.getCopiesCount());
            sb.append('}');
        }
        sb.append("],\n    extCount=").append(info.getExtCount());
        sb.append(",\n    flocError=").append(QStarUtils.quote(info.getFlocError()));
        sb.append(",\n    stateAccess=").append(QStarUtils.stateAccessAsString(info.getStateAccess()));
        sb.append(",\n    stateAccessDetailed=").append(QStarUtils.stateAccessDetailedAsString(info.getStateAccessDetailed()));
        sb.append('}');
        return sb.toString();
    }

    public static String stateAccessAsString(long stateAccess) {
        return QStarUtils.toString(stateAccess, ACCESS_STATES);
    }

    public static String stateAccessDetailedAsString(long stateAccessdDetailed) {
        return QStarUtils.toString(stateAccessdDetailed, DETAILED_ACCESS_STATES);
    }

    private static Object toInstant(BigInteger value) {
        return value.signum() == 0 ? "" : Instant.ofEpochSecond(value.longValue());
    }

    private static String quote(String value) {
        return value == null ? "" : '\'' + value + '\'';
    }
}

