/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.soundex;

import org.dcm4che3.soundex.FuzzyStr;

public class Soundex
implements FuzzyStr {
    protected static final String MAP_6 = "\u0000123\u000012\u0001\u000022455\u000012623\u00001\u00012\u00002";
    protected static final String MAP_9 = "\u0000136\u000024\u0001\u000043788\u000015936\u00002\u00015\u00005";
    private final boolean encodeFirst;
    private final int codeLength;
    private final int padLength;
    private final char[] map;

    public Soundex() {
        this(false, 4, 4, MAP_6);
    }

    public Soundex(boolean encodeFirst, int codeLength, int padLength, String map) {
        this.encodeFirst = encodeFirst;
        this.codeLength = codeLength;
        this.padLength = padLength;
        this.map = map.toCharArray();
    }

    @Override
    public String toFuzzy(String s) {
        if (s == null || s.length() == 0) {
            return "";
        }
        char[] in = s.toCharArray();
        char[] out = in.length < this.padLength ? new char[this.padLength] : in;
        int i = 0;
        int j = 0;
        char prevout = '\u0000';
        if (!this.encodeFirst) {
            while (!Character.isLetter(in[i])) {
                if (++i < in.length) continue;
                return "";
            }
            int n = j++;
            char c = Character.toUpperCase(in[i++]);
            out[n] = c;
            prevout = this.map(c);
        }
        char curout = '\u0000';
        while (i < in.length && j < this.codeLength) {
            curout = this.map(in[i]);
            switch (curout) {
                case '\u0000': {
                    prevout = curout;
                }
                case '\u0001': {
                    break;
                }
                default: {
                    if (curout == prevout) break;
                    out[j++] = prevout = curout;
                }
            }
            ++i;
        }
        while (j < this.padLength) {
            out[j++] = 48;
        }
        return new String(out, 0, j);
    }

    private char map(char c) {
        try {
            return this.map[c >= 'a' ? c - 97 : c - 65];
        }
        catch (IndexOutOfBoundsException e) {
            return c == '\u00df' || c == '\u00c7' || c == '\u00e7' ? this.map[2] : (char)'\u0000';
        }
    }

    public static void main(String[] args) {
        Soundex inst = new Soundex();
        for (String arg : args) {
            System.out.println(inst.toFuzzy(arg));
        }
    }
}

