/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.tool.agfa2dcm;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.io.DicomInputStream;
import org.dcm4che3.tool.common.CLIUtils;
import org.dcm4che3.util.AttributesFormat;
import org.dcm4che3.util.StreamUtils;

public class Agfa2Dcm {
    private static ResourceBundle rb = ResourceBundle.getBundle("org.dcm4che3.tool.agfa2dcm.messages");
    private static final byte[] ARCHIVE_BLOB = new byte[]{65, 82, 67, 72, 73, 86, 69, 45, 66, 76, 79, 66};
    private static final int ARCHIVE_BLOB_TAG_LE = 1380010051;
    private static final int ARCHIVE_BLOB_TAG_BE = 1095910216;

    private static boolean isArchiveBlobTag(DicomInputStream dis) {
        int tag = dis.tag();
        return tag == 1380010051 || tag == 1095910216;
    }

    public static void main(String[] args) {
        try {
            CommandLine cl = Agfa2Dcm.parseComandLine(args);
            Agfa2Dcm.extract(Paths.get(Agfa2Dcm.fname(cl.getArgList()), new String[0]), cl.getOptionValue("d", "."), new AttributesFormat(cl.getOptionValue("p", "{00080018}")));
        }
        catch (ParseException e) {
            System.err.println("agfa2dcm: " + e.getMessage());
            System.err.println(rb.getString("try"));
            System.exit(2);
        }
        catch (Exception e) {
            System.err.println("agfa2dcm: " + e.getMessage());
            e.printStackTrace();
            System.exit(2);
        }
    }

    private static CommandLine parseComandLine(String[] args) throws ParseException {
        Options opts = new Options();
        CLIUtils.addCommonOptions((Options)opts);
        Agfa2Dcm.addStorageDirectoryOptions(opts);
        return CLIUtils.parseComandLine((String[])args, (Options)opts, (ResourceBundle)rb, Agfa2Dcm.class);
    }

    private static void addStorageDirectoryOptions(Options opts) {
        opts.addOption(Option.builder((String)"d").hasArg().argName("out-dir").desc(rb.getString("out-dir")).build());
        opts.addOption(Option.builder((String)"p").hasArg().argName("pattern").desc(rb.getString("pattern")).build());
    }

    private static String fname(List<String> argList) throws ParseException {
        int numArgs = argList.size();
        if (numArgs == 0) {
            throw new ParseException(rb.getString("missing"));
        }
        if (numArgs > 1) {
            throw new ParseException(rb.getString("too-many"));
        }
        return argList.get(0);
    }

    private static void extract(Path blobPath, String outDir, AttributesFormat format) throws IOException {
        byte[] buffer = new byte[16384];
        ArrayList<Part> list = new ArrayList<Part>();
        try (InputStream in = new BufferedInputStream(Files.newInputStream(blobPath, new OpenOption[0]));){
            StreamUtils.readFully((InputStream)in, (byte[])buffer, (int)0, (int)16384);
            byte[] header = new byte[12];
            StreamUtils.readFully((InputStream)in, (byte[])header, (int)0, (int)12);
            if (!Arrays.equals(header, ARCHIVE_BLOB)) {
                throw new IOException("Missing ARCHIVE-BLOB header");
            }
            DicomInputStream dis = null;
            Part part = null;
            int headerLength = 12;
            while (dis == null || Agfa2Dcm.isArchiveBlobTag(dis)) {
                if (part != null) {
                    part.length -= (long)headerLength;
                }
                dis = new DicomInputStream(in, 128 - headerLength);
                dis.setIncludeBulkData(DicomInputStream.IncludeBulkData.NO);
                Attributes attrs = dis.readDataset(Agfa2Dcm::isArchiveBlobTag);
                part = new Part(format.format((Object)attrs), dis.getPosition() + (long)headerLength);
                list.add(part);
                headerLength = dis.explicitVR() ? 12 : 8;
            }
        }
        in = Files.newInputStream(blobPath, new OpenOption[0]);
        try {
            StreamUtils.skipFully((InputStream)in, (long)16384L);
            for (Part part : list) {
                Path outPath = Paths.get(outDir, part.path);
                Files.createDirectories(outPath.getParent(), new FileAttribute[0]);
                try (OutputStream out = Files.newOutputStream(outPath, new OpenOption[0]);){
                    StreamUtils.copy((InputStream)in, (OutputStream)out, (long)part.length, (byte[])buffer);
                }
                System.out.println(part.path);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    private static class Part {
        String path;
        long length;

        private Part(String path, long length) {
            this.path = path;
            this.length = length;
        }
    }
}

