/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.tool.dcm2pdf;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.UID;
import org.dcm4che3.io.DicomInputStream;
import org.dcm4che3.tool.common.CLIUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Dcm2Pdf {
    private static final Logger LOG = LoggerFactory.getLogger(Dcm2Pdf.class);
    private static final ResourceBundle rb = ResourceBundle.getBundle("org.dcm4che3.tool.dcm2pdf.messages");

    public static void main(String[] args) {
        try {
            CommandLine cl = Dcm2Pdf.parseComandLine(args);
            Dcm2Pdf dcm2pdf = new Dcm2Pdf();
            List argList = cl.getArgList();
            int argc = argList.size();
            if (argc < 2) {
                throw new ParseException(rb.getString("missing"));
            }
            File dest = new File((String)argList.get(argc - 1));
            if ((argc > 2 || new File((String)argList.get(0)).isDirectory()) && !dest.isDirectory()) {
                throw new ParseException(MessageFormat.format(rb.getString("nodestdir"), dest));
            }
            dcm2pdf.convert(cl.getArgList());
        }
        catch (ParseException e) {
            System.err.println("dcm2pdf: " + e.getMessage());
            System.err.println(rb.getString("try"));
            System.exit(2);
        }
        catch (Exception e) {
            System.err.println("dcm2pdf: " + e.getMessage());
            e.printStackTrace();
            System.exit(2);
        }
    }

    private static CommandLine parseComandLine(String[] args) throws ParseException {
        Options opts = new Options();
        CLIUtils.addCommonOptions((Options)opts);
        return CLIUtils.parseComandLine((String[])args, (Options)opts, (ResourceBundle)rb, Dcm2Pdf.class);
    }

    private void convert(List<String> args) throws IOException {
        int argsSize = args.size();
        Path destPath = Paths.get(args.get(argsSize - 1), new String[0]);
        boolean destIsDir = Files.isDirectory(destPath, new LinkOption[0]);
        for (String src : args.subList(0, argsSize - 1)) {
            Path srcPath = Paths.get(src, new String[0]);
            if (Files.isDirectory(srcPath, new LinkOption[0])) {
                Files.walkFileTree(srcPath, new Dcm2PdfFileVisitor(srcPath, destPath, destIsDir));
                continue;
            }
            this.convert(srcPath, destPath, destIsDir);
        }
    }

    private void convert(Path src, Path dest, boolean destIsDir) {
        try (DicomInputStream dis = new DicomInputStream(src.toFile());){
            Attributes attributes = dis.readDataset();
            String sopCUID = attributes.getString(524310);
            String ext = FileType.getFileExt(sopCUID);
            if (ext == null) {
                LOG.info("DICOM file {} with {} SOP Class cannot be converted to bulkdata file", (Object)src, (Object)UID.nameOf((String)sopCUID));
                return;
            }
            File destFile = destIsDir ? dest.resolve(src.getFileName() + ext).toFile() : dest.toFile();
            FileOutputStream fos = new FileOutputStream(destFile);
            byte[] value = (byte[])attributes.getValue(4325393);
            fos.write(value, 0, value.length - 1);
            byte lastByte = value[value.length - 1];
            if (lastByte != 0) {
                fos.write(lastByte);
            }
            System.out.println(MessageFormat.format(rb.getString("converted"), src, destIsDir ? destFile.getPath() : dest));
        }
        catch (Exception e) {
            System.out.println(MessageFormat.format(rb.getString("failed"), src, e.getMessage()));
            e.printStackTrace(System.out);
        }
    }

    class Dcm2PdfFileVisitor
    extends SimpleFileVisitor<Path> {
        private final Path srcPath;
        private final Path destPath;
        private final boolean destIsDir;

        Dcm2PdfFileVisitor(Path srcPath, Path destPath, boolean destIsDir) {
            this.srcPath = srcPath;
            this.destPath = destPath;
            this.destIsDir = destIsDir;
        }

        @Override
        public FileVisitResult visitFile(Path srcFilePath, BasicFileAttributes attrs) throws IOException {
            Path destFilePath = this.resolveDestFilePath(srcFilePath);
            if (!Files.isDirectory(destFilePath, new LinkOption[0])) {
                Files.createDirectories(destFilePath, new FileAttribute[0]);
            }
            Dcm2Pdf.this.convert(srcFilePath, destFilePath, this.destIsDir);
            return FileVisitResult.CONTINUE;
        }

        private Path resolveDestFilePath(Path srcFilePath) {
            int srcFilePathNameCount;
            int srcPathNameCount = this.srcPath.getNameCount();
            if (srcPathNameCount == (srcFilePathNameCount = srcFilePath.getNameCount() - 1)) {
                return this.destPath;
            }
            return this.destPath.resolve(srcFilePath.subpath(srcPathNameCount, srcFilePathNameCount));
        }
    }

    static enum FileType {
        PDF("1.2.840.10008.5.1.4.1.1.104.1", ".pdf"),
        CDA("1.2.840.10008.5.1.4.1.1.104.2", ".xml"),
        MTL("1.2.840.10008.5.1.4.1.1.104.5", ".mtl"),
        OBJ("1.2.840.10008.5.1.4.1.1.104.4", ".obj"),
        STL("1.2.840.10008.5.1.4.1.1.104.3", ".stl"),
        GENOZIP("1.2.40.0.13.1.5.1.4.1.1.104.1", ".genozip"),
        VCF_BZIP2("1.2.40.0.13.1.5.1.4.1.1.104.2", ".vcfbz2"),
        DOC_BZIP2("1.2.40.0.13.1.5.1.4.1.1.104.3", ".bz2");

        private final String sopClass;
        private final String fileExt;

        private FileType(String sopClass, String fileExt) {
            this.sopClass = sopClass;
            this.fileExt = fileExt;
        }

        private String getSOPClass() {
            return this.sopClass;
        }

        public static String getFileExt(String sopCUID) {
            for (FileType fileType : FileType.values()) {
                if (!fileType.getSOPClass().equals(sopCUID)) continue;
                return fileType.getFileExt();
            }
            return null;
        }

        private String getFileExt() {
            return this.fileExt;
        }
    }
}

