/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.tool.dcm2str;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.EnumSet;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.io.DicomInputStream;
import org.dcm4che3.tool.common.CLIUtils;
import org.dcm4che3.util.AttributesFormat;

public class Dcm2Str
extends SimpleFileVisitor<Path> {
    private static final ResourceBundle rb = ResourceBundle.getBundle("org.dcm4che3.tool.dcm2str.messages");
    private final AttributesFormat format;
    private final Attributes cliAttrs;

    public Dcm2Str(AttributesFormat format, Attributes cliAttrs) {
        this.format = format;
        this.cliAttrs = cliAttrs;
    }

    public static void main(String[] args) {
        try {
            CommandLine cl = Dcm2Str.parseComandLine(args);
            AttributesFormat format = new AttributesFormat(cl.getOptionValue("p"));
            Attributes cliAttrs = new Attributes();
            CLIUtils.addAttributes((Attributes)cliAttrs, (String[])cl.getOptionValues("s"));
            List pathNames = cl.getArgList();
            if (pathNames.isEmpty()) {
                System.out.println(format.format((Object)cliAttrs));
            } else {
                for (String pathName : pathNames) {
                    Files.walkFileTree(Paths.get(pathName, new String[0]), EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, new Dcm2Str(format, cliAttrs));
                }
            }
        }
        catch (ParseException e) {
            System.err.println("dcm2str: " + e.getMessage());
            System.err.println(rb.getString("try"));
            System.exit(2);
        }
        catch (Exception e) {
            System.err.println("dcm2str: " + e.getMessage());
            e.printStackTrace();
            System.exit(2);
        }
    }

    private static CommandLine parseComandLine(String[] args) throws ParseException {
        Options opts = new Options();
        CLIUtils.addCommonOptions((Options)opts);
        opts.addOption(Option.builder((String)"p").hasArg().argName("pattern").desc(rb.getString("pattern")).build());
        opts.addOption(Option.builder((String)"s").hasArgs().argName("[seq.]attr=value").desc(rb.getString("str")).build());
        CommandLine cl = CLIUtils.parseComandLine((String[])args, (Options)opts, (ResourceBundle)rb, Dcm2Str.class);
        if (!cl.hasOption("p")) {
            throw new MissingOptionException(rb.getString("missing-pattern-opt"));
        }
        return cl;
    }

    @Override
    public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) {
        try (DicomInputStream dis = new DicomInputStream(path.toFile());){
            Attributes dataset = dis.readDataset();
            dataset.addAll(this.cliAttrs);
            System.out.println(this.format.format((Object)dataset));
        }
        catch (IOException e) {
            System.err.println("Failed to parse DICOM file " + path);
            e.printStackTrace();
        }
        return FileVisitResult.CONTINUE;
    }
}

