/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.tool.dcm2xml;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.ResourceBundle;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.dcm4che3.io.BasicBulkDataDescriptor;
import org.dcm4che3.io.BulkDataDescriptor;
import org.dcm4che3.io.DicomInputHandler;
import org.dcm4che3.io.DicomInputStream;
import org.dcm4che3.io.SAXWriter;
import org.dcm4che3.tool.common.CLIUtils;
import org.xml.sax.ContentHandler;

public class Dcm2Xml {
    private static final String XML_1_0 = "1.0";
    private static final String XML_1_1 = "1.1";
    private static ResourceBundle rb = ResourceBundle.getBundle("org.dcm4che3.tool.dcm2xml.messages");
    private String xsltURL;
    private boolean indent = false;
    private boolean includeKeyword = true;
    private boolean includeNamespaceDeclaration = false;
    private DicomInputStream.IncludeBulkData includeBulkData = DicomInputStream.IncludeBulkData.URI;
    private boolean catBlkFiles = false;
    private String blkFilePrefix = "blk";
    private String blkFileSuffix;
    private File blkDirectory;
    private BasicBulkDataDescriptor bulkDataDescriptor = new BasicBulkDataDescriptor();
    private String xmlVersion = "1.0";

    public final void setXSLTURL(String xsltURL) {
        this.xsltURL = xsltURL;
    }

    public final void setIndent(boolean indent) {
        this.indent = indent;
    }

    public final void setIncludeKeyword(boolean includeKeyword) {
        this.includeKeyword = includeKeyword;
    }

    public final void setIncludeNamespaceDeclaration(boolean includeNamespaceDeclaration) {
        this.includeNamespaceDeclaration = includeNamespaceDeclaration;
    }

    public final void setIncludeBulkData(DicomInputStream.IncludeBulkData includeBulkData) {
        this.includeBulkData = includeBulkData;
    }

    public final void setConcatenateBulkDataFiles(boolean catBlkFiles) {
        this.catBlkFiles = catBlkFiles;
    }

    public final void setBulkDataFilePrefix(String blkFilePrefix) {
        this.blkFilePrefix = blkFilePrefix;
    }

    public final void setBulkDataFileSuffix(String blkFileSuffix) {
        this.blkFileSuffix = blkFileSuffix;
    }

    public final void setBulkDataDirectory(File blkDirectory) {
        this.blkDirectory = blkDirectory;
    }

    public void setBulkDataNoDefaults(boolean excludeDefaults) {
        this.bulkDataDescriptor.excludeDefaults(excludeDefaults);
    }

    public void setBulkDataLengthsThresholdsFromStrings(String[] thresholds) {
        this.bulkDataDescriptor.setLengthsThresholdsFromStrings(thresholds);
    }

    public final void setXMLVersion(String xmlVersion) {
        this.xmlVersion = xmlVersion;
    }

    private static CommandLine parseComandLine(String[] args) throws ParseException {
        Options opts = new Options();
        CLIUtils.addCommonOptions((Options)opts);
        opts.addOption(Option.builder((String)"x").longOpt("xsl").hasArg().argName("xsl-file").desc(rb.getString("xsl")).build());
        opts.addOption("I", "indent", false, rb.getString("indent"));
        opts.addOption("K", "no-keyword", false, rb.getString("no-keyword"));
        opts.addOption(null, "xmlns", false, rb.getString("xmlns"));
        opts.addOption(null, "xml11", false, rb.getString("xml11"));
        Dcm2Xml.addBulkdataOptions(opts);
        return CLIUtils.parseComandLine((String[])args, (Options)opts, (ResourceBundle)rb, Dcm2Xml.class);
    }

    private static void addBulkdataOptions(Options opts) {
        OptionGroup group = new OptionGroup();
        group.addOption(Option.builder((String)"B").longOpt("no-bulkdata").desc(rb.getString("no-bulkdata")).build());
        group.addOption(Option.builder((String)"b").longOpt("with-bulkdata").desc(rb.getString("with-bulkdata")).build());
        opts.addOptionGroup(group);
        opts.addOption(Option.builder((String)"d").longOpt("blk-file-dir").hasArg().argName("directory").desc(rb.getString("blk-file-dir")).build());
        opts.addOption(Option.builder().longOpt("blk-file-prefix").hasArg().argName("prefix").desc(rb.getString("blk-file-prefix")).build());
        opts.addOption(Option.builder().longOpt("blk-file-suffix").hasArg().argName("suffix").desc(rb.getString("blk-file-dir")).build());
        opts.addOption("c", "cat-blk-files", false, rb.getString("cat-blk-files"));
        opts.addOption(null, "blk-nodefs", false, rb.getString("blk-nodefs"));
        opts.addOption(Option.builder(null).longOpt("blk").hasArgs().argName("[seq.]attr").desc(rb.getString("blk")).build());
        opts.addOption(Option.builder(null).longOpt("blk-vr").hasArgs().argName("vr[,...]=length").desc(rb.getString("blk-vr")).build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        block9: {
            try {
                CommandLine cl = Dcm2Xml.parseComandLine(args);
                Dcm2Xml main = new Dcm2Xml();
                if (cl.hasOption("x")) {
                    main.setXSLTURL(Dcm2Xml.toURL(cl.getOptionValue("x")));
                }
                main.setIndent(cl.hasOption("I"));
                main.setIncludeKeyword(!cl.hasOption("K"));
                main.setIncludeNamespaceDeclaration(cl.hasOption("xmlns"));
                if (cl.hasOption("xml11")) {
                    main.setXMLVersion(XML_1_1);
                }
                Dcm2Xml.configureBulkdata(main, cl);
                String fname = Dcm2Xml.fname(cl.getArgList());
                if (fname.equals("-")) {
                    main.parse(new DicomInputStream(System.in));
                    break block9;
                }
                try (DicomInputStream dis = new DicomInputStream(new File(fname));){
                    main.parse(dis);
                }
            }
            catch (ParseException e) {
                System.err.println("dcm2xml: " + e.getMessage());
                System.err.println(rb.getString("try"));
                System.exit(2);
            }
            catch (Exception e) {
                System.err.println("dcm2xml: " + e.getMessage());
                e.printStackTrace();
                System.exit(2);
            }
        }
    }

    private static String toURL(String fileOrURL) {
        try {
            new URL(fileOrURL);
            return fileOrURL;
        }
        catch (MalformedURLException e) {
            return new File(fileOrURL).toURI().toString();
        }
    }

    private static void configureBulkdata(Dcm2Xml dcm2xml, CommandLine cl) throws Exception {
        if (cl.hasOption("b")) {
            dcm2xml.setIncludeBulkData(DicomInputStream.IncludeBulkData.YES);
        }
        if (cl.hasOption("B")) {
            dcm2xml.setIncludeBulkData(DicomInputStream.IncludeBulkData.NO);
        }
        if (cl.hasOption("blk-file-prefix")) {
            dcm2xml.setBulkDataFilePrefix(cl.getOptionValue("blk-file-prefix"));
        }
        if (cl.hasOption("blk-file-suffix")) {
            dcm2xml.setBulkDataFileSuffix(cl.getOptionValue("blk-file-suffix"));
        }
        if (cl.hasOption("d")) {
            File tempDir = new File(cl.getOptionValue("d"));
            dcm2xml.setBulkDataDirectory(tempDir);
        }
        dcm2xml.setConcatenateBulkDataFiles(cl.hasOption("c"));
        dcm2xml.setBulkDataNoDefaults(cl.hasOption("blk-nodefs"));
        if (cl.hasOption("blk")) {
            CLIUtils.addTagPaths((BasicBulkDataDescriptor)dcm2xml.bulkDataDescriptor, (String[])cl.getOptionValues("blk"));
        }
        if (cl.hasOption("blk-vr")) {
            dcm2xml.setBulkDataLengthsThresholdsFromStrings(cl.getOptionValues("blk-vr"));
        }
    }

    private static String fname(List<String> argList) throws ParseException {
        int numArgs = argList.size();
        if (numArgs == 0) {
            throw new ParseException(rb.getString("missing"));
        }
        if (numArgs > 1) {
            throw new ParseException(rb.getString("too-many"));
        }
        return argList.get(0);
    }

    public void parse(DicomInputStream dis) throws IOException, TransformerConfigurationException {
        dis.setIncludeBulkData(this.includeBulkData);
        dis.setBulkDataDescriptor((BulkDataDescriptor)this.bulkDataDescriptor);
        dis.setBulkDataDirectory(this.blkDirectory);
        dis.setBulkDataFilePrefix(this.blkFilePrefix);
        dis.setBulkDataFileSuffix(this.blkFileSuffix);
        dis.setConcatenateBulkDataFiles(this.catBlkFiles);
        TransformerHandler th = this.getTransformerHandler();
        Transformer t = th.getTransformer();
        t.setOutputProperty("indent", this.indent ? "yes" : "no");
        if (this.indent) {
            t.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        }
        t.setOutputProperty("version", this.xmlVersion);
        th.setResult(new StreamResult(System.out));
        SAXWriter saxWriter = new SAXWriter((ContentHandler)th);
        saxWriter.setIncludeKeyword(this.includeKeyword);
        saxWriter.setIncludeNamespaceDeclaration(this.includeNamespaceDeclaration);
        dis.setDicomInputHandler((DicomInputHandler)saxWriter);
        dis.readDataset();
    }

    private TransformerHandler getTransformerHandler() throws TransformerConfigurationException, IOException {
        SAXTransformerFactory tf = (SAXTransformerFactory)TransformerFactory.newInstance();
        if (this.xsltURL == null) {
            return tf.newTransformerHandler();
        }
        TransformerHandler th = tf.newTransformerHandler(new StreamSource(this.xsltURL));
        return th;
    }
}

