/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.tool.dcmassoc;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.net.Association;
import org.dcm4che3.net.Connection;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.IncompatibleConnectionException;
import org.dcm4che3.net.pdu.AAssociateRQ;
import org.dcm4che3.net.pdu.PresentationContext;
import org.dcm4che3.tool.common.CLIUtils;
import org.dcm4che3.util.StringUtils;

public class DcmAssoc {
    private static ResourceBundle rb = ResourceBundle.getBundle("org.dcm4che3.tool.dcmassoc.messages");
    private final ApplicationEntity ae;
    private final Connection remote;
    private final AAssociateRQ rq = new AAssociateRQ();
    private Association as;

    public DcmAssoc(ApplicationEntity ae) throws IOException {
        this.remote = new Connection();
        this.ae = ae;
    }

    public AAssociateRQ getAAssociateRQ() {
        return this.rq;
    }

    public Connection getRemoteConnection() {
        return this.remote;
    }

    private static CommandLine parseComandLine(String[] args) throws ParseException {
        Options opts = new Options();
        CLIUtils.addConnectOption((Options)opts);
        CLIUtils.addBindClientOption((Options)opts, (String)"DCMASSOC");
        CLIUtils.addAEOptions((Options)opts);
        CLIUtils.addCommonOptions((Options)opts);
        DcmAssoc.addPCOptions(opts);
        return CLIUtils.parseComandLine((String[])args, (Options)opts, (ResourceBundle)rb, DcmAssoc.class);
    }

    private static void addPCOptions(Options opts) {
        opts.addOption(Option.builder().hasArg().argName("number:cuid:tsuid[(,|;)...]").desc(rb.getString("pc")).longOpt("pc").build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            CommandLine cl = DcmAssoc.parseComandLine(args);
            Device device = new Device("dcmassoc");
            Connection conn = new Connection();
            device.addConnection(conn);
            ApplicationEntity ae = new ApplicationEntity("DCMASSOC");
            device.addApplicationEntity(ae);
            ae.addConnection(conn);
            DcmAssoc main = new DcmAssoc(ae);
            CLIUtils.configureConnect((Connection)main.remote, (AAssociateRQ)main.rq, (CommandLine)cl);
            CLIUtils.configureBind((Connection)conn, (ApplicationEntity)ae, (CommandLine)cl);
            CLIUtils.configure((Connection)conn, (CommandLine)cl);
            main.remote.setTlsProtocols(conn.getTlsProtocols());
            main.remote.setTlsCipherSuites(conn.getTlsCipherSuites());
            DcmAssoc.configureStorageSOPClasses(main, cl);
            ExecutorService executorService = Executors.newSingleThreadExecutor();
            ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
            device.setExecutor((Executor)executorService);
            device.setScheduledExecutor(scheduledExecutorService);
            try {
                long t1 = System.currentTimeMillis();
                main.open();
                long t2 = System.currentTimeMillis();
                System.out.println(MessageFormat.format(rb.getString("connected"), main.as.getRemoteAET(), t2 - t1));
            }
            finally {
                main.close();
                executorService.shutdown();
                scheduledExecutorService.shutdown();
            }
        }
        catch (ParseException e) {
            System.err.println("dcmassoc: " + e.getMessage());
            System.err.println(rb.getString("try"));
            System.exit(2);
        }
        catch (Exception e) {
            System.err.println("dcmassoc: " + e.getMessage());
            e.printStackTrace();
            System.exit(2);
        }
    }

    private static void configureStorageSOPClasses(DcmAssoc main, CommandLine cl) throws Exception {
        String[] pcs = cl.getOptionValues("pc");
        if (pcs != null) {
            for (String pc : pcs) {
                String[] ss = StringUtils.split((String)pc, (char)':');
                DcmAssoc.configureStorageSOPClass(main, Integer.parseInt(ss[0]), ss[1], ss[2]);
            }
        } else {
            DcmAssoc.configureStorageSOPClass(main, 1, "1.2.840.10008.1.1", "1.2.840.10008.1.2");
        }
    }

    private static void configureStorageSOPClass(DcmAssoc main, int pos, String cuid, String tsuids0) {
        for (String tsuids2 : StringUtils.split((String)tsuids0, (char)';')) {
            main.addOfferedStorageSOPClass(pos, CLIUtils.toUID((String)cuid), CLIUtils.toUIDs((String)tsuids2));
        }
    }

    public void addOfferedStorageSOPClass(int pos, String cuid, String ... tsuids) {
        this.rq.addPresentationContext(new PresentationContext(pos, cuid, tsuids));
    }

    public void close() throws IOException, InterruptedException {
        if (this.as != null) {
            if (this.as.isReadyForDataTransfer()) {
                this.as.release();
            }
            this.as.waitForSocketClose();
        }
    }

    public void open() throws IOException, InterruptedException, IncompatibleConnectionException, GeneralSecurityException {
        this.as = this.ae.connect(this.remote, this.rq);
    }
}

