/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.tool.dcmdump;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.ElementDictionary;
import org.dcm4che3.data.Fragments;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.data.VR;
import org.dcm4che3.io.DicomInputHandler;
import org.dcm4che3.io.DicomInputStream;
import org.dcm4che3.tool.common.CLIUtils;
import org.dcm4che3.util.ByteUtils;
import org.dcm4che3.util.TagUtils;

public class DcmDump
implements DicomInputHandler {
    private static ResourceBundle rb = ResourceBundle.getBundle("org.dcm4che3.tool.dcmdump.messages");
    private static final int DEFAULT_WIDTH = 78;
    private int width = 78;

    public final int getWidth() {
        return this.width;
    }

    public final void setWidth(int width) {
        if (width < 40) {
            throw new IllegalArgumentException();
        }
        this.width = width;
    }

    public void parse(DicomInputStream dis) throws IOException {
        dis.setDicomInputHandler((DicomInputHandler)this);
        dis.readDataset();
    }

    public void startDataset(DicomInputStream dis) throws IOException {
        this.promptPreamble(dis.getPreamble());
    }

    public void endDataset(DicomInputStream dis) throws IOException {
    }

    public void readValue(DicomInputStream dis, Attributes attrs) throws IOException {
        StringBuilder line = new StringBuilder(this.width + 30);
        this.appendPrefix(dis, line);
        this.appendHeader(dis, line);
        VR vr = dis.vr();
        int vallen = dis.length();
        boolean undeflen = vallen == -1;
        int tag = dis.tag();
        String privateCreator = attrs.getPrivateCreator(tag);
        if (vr == VR.SQ || undeflen) {
            this.appendKeyword(dis, privateCreator, line);
            System.out.println(line);
            dis.readValue(dis, attrs);
            if (undeflen) {
                line.setLength(0);
                this.appendPrefix(dis, line);
                this.appendHeader(dis, line);
                this.appendKeyword(dis, privateCreator, line);
                System.out.println(line);
            }
            return;
        }
        byte[] b = this.probeValue(dis);
        line.append(" [");
        if (vr.prompt((Object)b, dis.bigEndian(), attrs.getSpecificCharacterSet(), this.width - line.length() - 1, line)) {
            line.append(']');
            this.appendKeyword(dis, privateCreator, line);
        }
        System.out.println(line);
        if (tag == 131072) {
            dis.setFileMetaInformationGroupLength(b);
        } else if (tag == 131088 || tag == 524293 || tag == 2621699 || TagUtils.isPrivateCreator((int)tag)) {
            attrs.setBytes(tag, vr, b);
        }
    }

    private byte[] probeValue(DicomInputStream dis) throws IOException {
        long len = dis.unsignedLength();
        if (len == 0L) {
            return ByteUtils.EMPTY_BYTES;
        }
        int read = (int)Math.min(len, (long)(this.width + 7 & 0xFFFFFFF8));
        byte[] b = new byte[read];
        dis.readFully(b);
        dis.skipFully(len - (long)read);
        return b;
    }

    public void readValue(DicomInputStream dis, Sequence seq) throws IOException {
        String privateCreator = seq.getParent().getPrivateCreator(dis.tag());
        StringBuilder line = new StringBuilder(this.width);
        this.appendPrefix(dis, line);
        this.appendHeader(dis, line);
        this.appendKeyword(dis, privateCreator, line);
        this.appendNumber(seq.size() + 1, line);
        System.out.println(line);
        boolean undeflen = dis.length() == -1;
        dis.readValue(dis, seq);
        if (undeflen) {
            line.setLength(0);
            this.appendPrefix(dis, line);
            this.appendHeader(dis, line);
            this.appendKeyword(dis, privateCreator, line);
            System.out.println(line);
        }
    }

    public void readValue(DicomInputStream dis, Fragments frags) throws IOException {
        StringBuilder line = new StringBuilder(this.width + 20);
        this.appendPrefix(dis, line);
        this.appendHeader(dis, line);
        this.appendFragment(line, dis, frags.vr());
        System.out.println(line);
    }

    private void appendPrefix(DicomInputStream dis, StringBuilder line) {
        line.append(dis.getTagPosition()).append(": ");
        int level = dis.level();
        while (level-- > 0) {
            line.append('>');
        }
    }

    private void appendHeader(DicomInputStream dis, StringBuilder line) {
        line.append(TagUtils.toString((int)dis.tag())).append(' ');
        VR vr = dis.vr();
        if (vr != null) {
            line.append(vr).append(' ');
        }
        line.append('#').append(dis.unsignedLength());
    }

    private void appendKeyword(DicomInputStream dis, String privateCreator, StringBuilder line) {
        if (line.length() < this.width) {
            line.append(" ");
            line.append(ElementDictionary.keywordOf((int)dis.tag(), (String)privateCreator));
            if (line.length() > this.width) {
                line.setLength(this.width);
            }
        }
    }

    private void appendNumber(int number, StringBuilder line) {
        if (line.length() < this.width) {
            line.append(" #");
            line.append(number);
            if (line.length() > this.width) {
                line.setLength(this.width);
            }
        }
    }

    private void appendFragment(StringBuilder line, DicomInputStream dis, VR vr) throws IOException {
        byte[] b = this.probeValue(dis);
        line.append(" [");
        if (vr.prompt((Object)b, dis.bigEndian(), null, this.width - line.length() - 1, line)) {
            line.append(']');
            this.appendKeyword(dis, null, line);
        }
    }

    private void promptPreamble(byte[] preamble) {
        if (preamble == null) {
            return;
        }
        StringBuilder line = new StringBuilder(this.width);
        line.append("0: [");
        if (VR.OB.prompt((Object)preamble, false, null, this.width - 5, line)) {
            line.append(']');
        }
        System.out.println(line);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        block10: {
            try {
                String fname;
                CommandLine cl = DcmDump.parseComandLine(args);
                DcmDump main = new DcmDump();
                if (cl.hasOption("w")) {
                    String s = cl.getOptionValue("w");
                    try {
                        main.setWidth(Integer.parseInt(s));
                    }
                    catch (IllegalArgumentException e) {
                        throw new ParseException(MessageFormat.format(rb.getString("illegal-width"), s));
                    }
                }
                if ((fname = DcmDump.fname(cl.getArgList())).equals("-")) {
                    main.parse(new DicomInputStream(System.in));
                    break block10;
                }
                try (DicomInputStream dis = new DicomInputStream(new File(fname));){
                    main.parse(dis);
                }
            }
            catch (ParseException e) {
                System.err.println("dcmdump: " + e.getMessage());
                System.err.println(rb.getString("try"));
                System.exit(2);
            }
            catch (IOException e) {
                System.err.println("dcmdump: " + e.getMessage());
                System.exit(2);
            }
        }
    }

    private static String fname(List<String> argList) throws ParseException {
        int numArgs = argList.size();
        if (numArgs == 0) {
            throw new ParseException(rb.getString("missing"));
        }
        if (numArgs > 1) {
            throw new ParseException(rb.getString("too-many"));
        }
        return argList.get(0);
    }

    private static CommandLine parseComandLine(String[] args) throws ParseException {
        Options opts = new Options();
        CLIUtils.addCommonOptions((Options)opts);
        opts.addOption(Option.builder((String)"w").longOpt("width").hasArg().argName("col").desc(rb.getString("width")).build());
        return CLIUtils.parseComandLine((String[])args, (Options)opts, (ResourceBundle)rb, DcmDump.class);
    }
}

