/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.tool.dcmvalidate;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.IOD;
import org.dcm4che3.data.ValidationResult;
import org.dcm4che3.io.DicomInputStream;
import org.dcm4che3.tool.common.CLIUtils;
import org.dcm4che3.util.SafeClose;

public class DcmValidate {
    private static ResourceBundle rb = ResourceBundle.getBundle("org.dcm4che3.tool.dcmvalidate.messages");
    private IOD iod;

    public final void setIOD(IOD iod) {
        this.iod = iod;
    }

    public static void main(String[] args) {
        try {
            CommandLine cl = DcmValidate.parseComandLine(args);
            DcmValidate main = new DcmValidate();
            String iodFile = cl.getOptionValue("iod");
            if (iodFile == null) {
                throw new MissingOptionException(Arrays.asList("iod"));
            }
            main.setIOD(IOD.load((String)iodFile));
            List fnames = cl.getArgList();
            if (fnames.isEmpty()) {
                throw new ParseException(rb.getString("missing"));
            }
            for (String fname : fnames) {
                DcmValidate.validate(main, new File(fname));
            }
        }
        catch (ParseException e) {
            System.err.println("DcmValidate: " + e.getMessage());
            System.err.println(rb.getString("try"));
            System.exit(2);
        }
        catch (IOException e) {
            System.err.println("DcmValidate: " + e.getMessage());
            System.exit(2);
        }
    }

    private static void validate(DcmValidate main, File file) {
        if (file.isDirectory()) {
            for (File f : file.listFiles()) {
                DcmValidate.validate(main, f);
            }
        }
        main.validate(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate(File file) {
        if (this.iod == null) {
            throw new IllegalStateException("IOD net initialized");
        }
        DicomInputStream dis = null;
        try {
            System.out.print("Validate: " + file + " ... ");
            dis = new DicomInputStream(file);
            Attributes attrs = dis.readDataset();
            ValidationResult result = attrs.validate(this.iod);
            if (result.isValid()) {
                System.out.println("OK");
            } else {
                System.out.println("FAILED:");
                System.out.println(result.asText(attrs));
            }
            SafeClose.close((Closeable)dis);
        }
        catch (IOException e) {
            System.out.println("FAILED: " + e.getMessage());
        }
        finally {
            SafeClose.close(dis);
        }
    }

    private static CommandLine parseComandLine(String[] args) throws ParseException {
        Options opts = new Options();
        CLIUtils.addCommonOptions((Options)opts);
        opts.addOption(Option.builder().longOpt("iod").hasArg().argName("iod-file").desc(rb.getString("iod")).build());
        return CLIUtils.parseComandLine((String[])args, (Options)opts, (ResourceBundle)rb, DcmValidate.class);
    }
}

