/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.tool.deidentify;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.EnumSet;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.ElementDictionary;
import org.dcm4che3.data.VR;
import org.dcm4che3.deident.DeIdentifier;
import org.dcm4che3.io.DicomEncodingOptions;
import org.dcm4che3.io.DicomInputStream;
import org.dcm4che3.io.DicomOutputStream;
import org.dcm4che3.tool.common.CLIUtils;

public class Deidentify {
    private static ResourceBundle rb = ResourceBundle.getBundle("org.dcm4che3.tool.deidentify.messages");
    private final DeIdentifier deidentifier;
    private DicomEncodingOptions encOpts = DicomEncodingOptions.DEFAULT;

    public Deidentify(DeIdentifier.Option ... options) {
        this.deidentifier = new DeIdentifier(options);
    }

    public void setEncodingOptions(DicomEncodingOptions encOpts) {
        this.encOpts = encOpts;
    }

    private static CommandLine parseComandLine(String[] args) throws ParseException {
        Options opts = new Options();
        CLIUtils.addCommonOptions((Options)opts);
        CLIUtils.addEncodingOptions((Options)opts);
        opts.addOption(Option.builder().desc(rb.getString("retain-date")).longOpt("retain-date").build());
        opts.addOption(Option.builder().desc(rb.getString("retain-org")).longOpt("retain-org").build());
        opts.addOption(Option.builder().desc(rb.getString("retain-dev")).longOpt("retain-dev").build());
        opts.addOption(Option.builder().desc(rb.getString("retain-uid")).longOpt("retain-uid").build());
        opts.addOption(Option.builder().desc(rb.getString("retain-pid-hash")).longOpt("retain-pid-hash").build());
        opts.addOption(Option.builder((String)"s").hasArgs().argName("attr=value").valueSeparator('=').desc(rb.getString("set")).build());
        CommandLine cl = CLIUtils.parseComandLine((String[])args, (Options)opts, (ResourceBundle)rb, Deidentify.class);
        return cl;
    }

    public static void main(String[] args) {
        try {
            CommandLine cl = Deidentify.parseComandLine(args);
            Deidentify main = new Deidentify(Deidentify.options(cl));
            main.setEncodingOptions(CLIUtils.encodingOptionsOf((CommandLine)cl));
            main.setDummyValues(cl.getOptionValues("s"));
            List argList = cl.getArgList();
            int argc = argList.size();
            if (argc < 2) {
                throw new ParseException(rb.getString("missing"));
            }
            File dest = new File((String)argList.get(argc - 1));
            if ((argc > 2 || new File((String)argList.get(0)).isDirectory()) && !dest.isDirectory()) {
                throw new ParseException(MessageFormat.format(rb.getString("nodestdir"), dest));
            }
            for (String src : argList.subList(0, argc - 1)) {
                main.mtranscode(new File(src), dest);
            }
        }
        catch (ParseException e) {
            System.err.println("deidentify: " + e.getMessage());
            System.err.println(rb.getString("try"));
            System.exit(2);
        }
        catch (Exception e) {
            System.err.println("deidentify: " + e.getMessage());
            e.printStackTrace();
            System.exit(2);
        }
    }

    private void setDummyValues(String[] optVals) {
        if (optVals != null) {
            for (int i = 1; i < optVals.length; ++i) {
                int tag = CLIUtils.toTag((String)optVals[i - 1]);
                VR vr = ElementDictionary.getStandardElementDictionary().vrOf(tag);
                this.deidentifier.setDummyValue(tag, vr, optVals[i]);
                ++i;
            }
        }
    }

    private static DeIdentifier.Option[] options(CommandLine cl) {
        EnumSet<DeIdentifier.Option> options = EnumSet.noneOf(DeIdentifier.Option.class);
        if (cl.hasOption("retain-date")) {
            options.add(DeIdentifier.Option.RetainLongitudinalTemporalInformationFullDatesOption);
        }
        if (cl.hasOption("retain-dev")) {
            options.add(DeIdentifier.Option.RetainDeviceIdentityOption);
        }
        if (cl.hasOption("retain-org")) {
            options.add(DeIdentifier.Option.RetainInstitutionIdentityOption);
        }
        if (cl.hasOption("retain-uid")) {
            options.add(DeIdentifier.Option.RetainUIDsOption);
        }
        if (cl.hasOption("retain-pid-hash")) {
            options.add(DeIdentifier.Option.RetainPatientIDHashOption);
        }
        return options.toArray(new DeIdentifier.Option[0]);
    }

    private void mtranscode(File src, File dest) {
        if (src.isDirectory()) {
            dest.mkdir();
            for (File file : src.listFiles()) {
                this.mtranscode(file, new File(dest, file.getName()));
            }
            return;
        }
        if (dest.isDirectory()) {
            dest = new File(dest, src.getName());
        }
        try {
            this.transcode(src, dest);
            System.out.println(MessageFormat.format(rb.getString("deidentified"), src, dest));
        }
        catch (Exception e) {
            System.out.println(MessageFormat.format(rb.getString("failed"), src, e.getMessage()));
            e.printStackTrace(System.out);
        }
    }

    public void transcode(File src, File dest) throws IOException {
        Attributes dataset;
        Attributes fmi;
        try (DicomInputStream dis = new DicomInputStream(src);){
            dis.setIncludeBulkData(DicomInputStream.IncludeBulkData.URI);
            fmi = dis.readFileMetaInformation();
            dataset = dis.readDataset();
        }
        this.deidentifier.deidentify(dataset);
        if (fmi != null) {
            fmi = dataset.createFileMetaInformation(fmi.getString(131088));
        }
        try (DicomOutputStream dos = new DicomOutputStream(dest);){
            dos.setEncodingOptions(this.encOpts);
            dos.writeDataset(fmi, dataset);
        }
    }
}

