/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.tool.emf2sf;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.emf.MultiframeExtractor;
import org.dcm4che3.io.DicomInputStream;
import org.dcm4che3.io.DicomOutputStream;
import org.dcm4che3.tool.common.CLIUtils;
import org.dcm4che3.util.SafeClose;

public class Emf2sf {
    private static ResourceBundle rb = ResourceBundle.getBundle("org.dcm4che3.tool.emf2sf.messages");
    private MultiframeExtractor extractor = new MultiframeExtractor();
    private int[] frames;
    private DecimalFormat outFileFormat;
    private File outDir;

    public final void setOutputDirectory(File outDir) {
        outDir.mkdirs();
        this.outDir = outDir;
    }

    public final void setOutputFileFormat(String outFileFormat) {
        this.outFileFormat = new DecimalFormat(outFileFormat);
    }

    public final void setFrames(int[] frames) {
        this.frames = frames;
    }

    public void setPreserveSeriesInstanceUID(boolean PreserveSeriesInstanceUID) {
        this.extractor.setPreserveSeriesInstanceUID(PreserveSeriesInstanceUID);
    }

    public void setInstanceNumberFormat(String instanceNumberFormat) {
        this.extractor.setInstanceNumberFormat(instanceNumberFormat);
    }

    public static void main(String[] args) {
        try {
            CommandLine cl = Emf2sf.parseComandLine(args);
            Emf2sf main = new Emf2sf();
            if (cl.hasOption("frame")) {
                main.setFrames(Emf2sf.toFrames(cl.getOptionValues("frame")));
            }
            main.setPreserveSeriesInstanceUID(cl.hasOption("not-chseries"));
            main.setOutputDirectory(new File(cl.getOptionValue("out-dir", ".")));
            if (cl.hasOption("out-file")) {
                main.setOutputFileFormat(cl.getOptionValue("out-file"));
            }
            long start = System.currentTimeMillis();
            int n = main.extract(new File(Emf2sf.fname(cl.getArgList())));
            long end = System.currentTimeMillis();
            System.out.println();
            System.out.println(MessageFormat.format(rb.getString("extracted"), n, Float.valueOf((float)(end - start) / 1000.0f)));
        }
        catch (ParseException e) {
            System.err.println("emf2sf: " + e.getMessage());
            System.err.println(rb.getString("try"));
            System.exit(2);
        }
        catch (Exception e) {
            System.err.println("emf2sf: " + e.getMessage());
            e.printStackTrace();
            System.exit(2);
        }
    }

    private static int[] toFrames(String[] ss) throws ParseException {
        if (ss == null) {
            return null;
        }
        int[] is = new int[ss.length];
        for (int i = 0; i < is.length; ++i) {
            try {
                is[i] = Integer.parseInt(ss[i]) - 1;
                continue;
            }
            catch (NumberFormatException e) {
                throw new ParseException("Invalid argument of option --frame: " + ss[i]);
            }
        }
        return is;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String fname(File srcFile, int frame) {
        if (this.outFileFormat != null) {
            DecimalFormat decimalFormat = this.outFileFormat;
            synchronized (decimalFormat) {
                return this.outFileFormat.format(frame);
            }
        }
        return String.format(srcFile.getName() + "-%04d", frame);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int extract(File file) throws IOException {
        Attributes src;
        DicomInputStream dis = new DicomInputStream(file);
        try {
            dis.setIncludeBulkData(DicomInputStream.IncludeBulkData.URI);
            src = dis.readDataset();
        }
        finally {
            SafeClose.close((Closeable)dis);
        }
        Attributes fmi = dis.getFileMetaInformation();
        if (this.frames == null) {
            int n = src.getInt(0x280008, 1);
            for (int frame = 0; frame < n; ++frame) {
                this.extract(file, fmi, src, frame);
            }
            return n;
        }
        for (int frame : this.frames) {
            this.extract(file, fmi, src, frame);
        }
        return this.frames.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extract(File file, Attributes fmi, Attributes src, int frame) throws IOException {
        Attributes sf = this.extractor.extract(src, frame);
        DicomOutputStream out = new DicomOutputStream(new File(this.outDir, this.fname(file, frame + 1)));
        try {
            out.writeDataset(fmi != null ? sf.createFileMetaInformation(fmi.getString(131088)) : null, sf);
            System.out.print('.');
        }
        finally {
            SafeClose.close((Closeable)out);
        }
    }

    private static CommandLine parseComandLine(String[] args) throws ParseException {
        Options opts = new Options();
        CLIUtils.addCommonOptions((Options)opts);
        opts.addOption(Option.builder((String)"f").longOpt("frame").hasArgs().argName("no[,..]").valueSeparator(',').desc(rb.getString("frame")).build());
        opts.addOption(null, "not-chseries", false, rb.getString("not-chseries"));
        opts.addOption(Option.builder().longOpt("inst-no").hasArg().argName("format").desc(rb.getString("inst-no")).build());
        opts.addOption(Option.builder().longOpt("out-dir").hasArg().argName("directory").desc(rb.getString("out-dir")).build());
        opts.addOption(Option.builder().longOpt("out-file").hasArg().argName("name").desc(rb.getString("out-file")).build());
        return CLIUtils.parseComandLine((String[])args, (Options)opts, (ResourceBundle)rb, Emf2sf.class);
    }

    private static String fname(List<String> argList) throws ParseException {
        int numArgs = argList.size();
        if (numArgs == 0) {
            throw new ParseException(rb.getString("missing"));
        }
        if (numArgs > 1) {
            throw new ParseException(rb.getString("too-many"));
        }
        return argList.get(0);
    }
}

