/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.tool.findscu;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.EnumSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.data.VR;
import org.dcm4che3.io.DicomInputStream;
import org.dcm4che3.io.DicomOutputStream;
import org.dcm4che3.io.SAXReader;
import org.dcm4che3.io.SAXWriter;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.net.Association;
import org.dcm4che3.net.Connection;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.DimseRSPHandler;
import org.dcm4che3.net.IncompatibleConnectionException;
import org.dcm4che3.net.QueryOption;
import org.dcm4che3.net.Status;
import org.dcm4che3.net.pdu.AAssociateRQ;
import org.dcm4che3.net.pdu.ExtendedNegotiation;
import org.dcm4che3.net.pdu.PresentationContext;
import org.dcm4che3.tool.common.CLIUtils;
import org.dcm4che3.util.SafeClose;
import org.xml.sax.ContentHandler;

public class FindSCU {
    private static ResourceBundle rb = ResourceBundle.getBundle("org.dcm4che3.tool.findscu.messages");
    private static SAXTransformerFactory saxtf;
    private final Device device = new Device("findscu");
    private final ApplicationEntity ae = new ApplicationEntity("FINDSCU");
    private final Connection conn = new Connection();
    private final Connection remote = new Connection();
    private final AAssociateRQ rq = new AAssociateRQ();
    private int priority;
    private int cancelAfter;
    private InformationModel model;
    private File outDir;
    private DecimalFormat outFileFormat;
    private int[] inFilter;
    private Attributes keys = new Attributes();
    private boolean catOut = false;
    private boolean xml = false;
    private boolean xmlIndent = false;
    private boolean xmlIncludeKeyword = true;
    private boolean xmlIncludeNamespaceDeclaration = false;
    private File xsltFile;
    private Templates xsltTpls;
    private OutputStream out;
    private Association as;
    private AtomicInteger totNumMatches = new AtomicInteger();

    public FindSCU() throws IOException {
        this.device.addConnection(this.conn);
        this.device.addApplicationEntity(this.ae);
        this.ae.addConnection(this.conn);
    }

    public final void setPriority(int priority) {
        this.priority = priority;
    }

    public final void setInformationModel(InformationModel model, String[] tss, EnumSet<QueryOption> queryOptions) {
        this.model = model;
        this.rq.addPresentationContext(new PresentationContext(1, model.cuid, tss));
        if (!queryOptions.isEmpty()) {
            model.adjustQueryOptions(queryOptions);
            this.rq.addExtendedNegotiation(new ExtendedNegotiation(model.cuid, QueryOption.toExtendedNegotiationInformation(queryOptions)));
        }
        if (model.level != null) {
            this.addLevel(model.level);
        }
    }

    public void addLevel(String s) {
        this.keys.setString(524370, VR.CS, s);
    }

    public final void setCancelAfter(int cancelAfter) {
        this.cancelAfter = cancelAfter;
    }

    public final void setOutputDirectory(File outDir) {
        outDir.mkdirs();
        this.outDir = outDir;
    }

    public final void setOutputFileFormat(String outFileFormat) {
        this.outFileFormat = new DecimalFormat(outFileFormat);
    }

    public final void setXSLT(File xsltFile) {
        this.xsltFile = xsltFile;
    }

    public final void setXML(boolean xml) {
        this.xml = xml;
    }

    public final void setXMLIndent(boolean indent) {
        this.xmlIndent = indent;
    }

    public final void setXMLIncludeKeyword(boolean includeKeyword) {
        this.xmlIncludeKeyword = includeKeyword;
    }

    public final void setXMLIncludeNamespaceDeclaration(boolean includeNamespaceDeclaration) {
        this.xmlIncludeNamespaceDeclaration = includeNamespaceDeclaration;
    }

    public final void setConcatenateOutputFiles(boolean catOut) {
        this.catOut = catOut;
    }

    public final void setInputFilter(int[] inFilter) {
        this.inFilter = inFilter;
    }

    private static CommandLine parseComandLine(String[] args) throws ParseException {
        Options opts = new Options();
        FindSCU.addServiceClassOptions(opts);
        FindSCU.addKeyOptions(opts);
        FindSCU.addOutputOptions(opts);
        FindSCU.addQueryLevelOption(opts);
        FindSCU.addCancelOption(opts);
        CLIUtils.addConnectOption((Options)opts);
        CLIUtils.addBindClientOption((Options)opts, (String)"FINDSCU");
        CLIUtils.addAEOptions((Options)opts);
        CLIUtils.addSendTimeoutOption((Options)opts);
        CLIUtils.addResponseTimeoutOption((Options)opts);
        CLIUtils.addPriorityOption((Options)opts);
        CLIUtils.addCommonOptions((Options)opts);
        return CLIUtils.parseComandLine((String[])args, (Options)opts, (ResourceBundle)rb, FindSCU.class);
    }

    private static void addServiceClassOptions(Options opts) {
        opts.addOption(Option.builder((String)"M").hasArg().argName("name").desc(rb.getString("model")).build());
        CLIUtils.addTransferSyntaxOptions((Options)opts);
        opts.addOption(null, "relational", false, rb.getString("relational"));
        opts.addOption(null, "datetime", false, rb.getString("datetime"));
        opts.addOption(null, "fuzzy", false, rb.getString("fuzzy"));
        opts.addOption(null, "timezone", false, rb.getString("timezone"));
    }

    private static void addQueryLevelOption(Options opts) {
        opts.addOption(Option.builder((String)"L").hasArg().argName("PATIENT|STUDY|SERIES|IMAGE").desc(rb.getString("level")).build());
    }

    private static void addCancelOption(Options opts) {
        opts.addOption(Option.builder().longOpt("cancel").hasArg().argName("num-matches").desc(rb.getString("cancel")).build());
    }

    private static void addKeyOptions(Options opts) {
        opts.addOption(Option.builder((String)"m").hasArgs().argName("[seq.]attr=value").desc(rb.getString("match")).build());
        opts.addOption(Option.builder((String)"r").hasArgs().argName("[seq.]attr").desc(rb.getString("return")).build());
        opts.addOption(Option.builder((String)"i").hasArgs().argName("attr").desc(rb.getString("in-attr")).build());
    }

    private static void addOutputOptions(Options opts) {
        opts.addOption(Option.builder().longOpt("out-dir").hasArg().argName("directory").desc(rb.getString("out-dir")).build());
        opts.addOption(Option.builder().longOpt("out-file").hasArg().argName("name").desc(rb.getString("out-file")).build());
        opts.addOption("X", "xml", false, rb.getString("xml"));
        opts.addOption(Option.builder((String)"x").longOpt("xsl").hasArg().argName("xsl-file").desc(rb.getString("xsl")).build());
        opts.addOption("I", "indent", false, rb.getString("indent"));
        opts.addOption("K", "no-keyword", false, rb.getString("no-keyword"));
        opts.addOption(null, "xmlns", false, rb.getString("xmlns"));
        opts.addOption(null, "out-cat", false, rb.getString("out-cat"));
    }

    public ApplicationEntity getApplicationEntity() {
        return this.ae;
    }

    public Connection getRemoteConnection() {
        return this.remote;
    }

    public AAssociateRQ getAAssociateRQ() {
        return this.rq;
    }

    public Association getAssociation() {
        return this.as;
    }

    public Device getDevice() {
        return this.device;
    }

    public Attributes getKeys() {
        return this.keys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            CommandLine cl = FindSCU.parseComandLine(args);
            FindSCU main = new FindSCU();
            CLIUtils.configureConnect((Connection)main.remote, (AAssociateRQ)main.rq, (CommandLine)cl);
            CLIUtils.configureBind((Connection)main.conn, (ApplicationEntity)main.ae, (CommandLine)cl);
            CLIUtils.configure((Connection)main.conn, (CommandLine)cl);
            main.remote.setTlsProtocols(main.conn.getTlsProtocols());
            main.remote.setTlsCipherSuites(main.conn.getTlsCipherSuites());
            FindSCU.configureServiceClass(main, cl);
            FindSCU.configureKeys(main, cl);
            FindSCU.configureOutput(main, cl);
            FindSCU.configureCancel(main, cl);
            main.setPriority(CLIUtils.priorityOf((CommandLine)cl));
            ExecutorService executorService = Executors.newSingleThreadExecutor();
            ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
            main.device.setExecutor((Executor)executorService);
            main.device.setScheduledExecutor(scheduledExecutorService);
            try {
                main.open();
                List argList = cl.getArgList();
                if (argList.isEmpty()) {
                    main.query();
                } else {
                    for (String arg : argList) {
                        main.query(new File(arg));
                    }
                }
            }
            finally {
                main.close();
                executorService.shutdown();
                scheduledExecutorService.shutdown();
            }
        }
        catch (ParseException e) {
            System.err.println("findscu: " + e.getMessage());
            System.err.println(rb.getString("try"));
            System.exit(2);
        }
        catch (Exception e) {
            System.err.println("findscu: " + e.getMessage());
            e.printStackTrace();
            System.exit(2);
        }
    }

    private static EnumSet<QueryOption> queryOptionsOf(FindSCU main, CommandLine cl) {
        EnumSet<QueryOption> queryOptions = EnumSet.noneOf(QueryOption.class);
        if (cl.hasOption("relational")) {
            queryOptions.add(QueryOption.RELATIONAL);
        }
        if (cl.hasOption("datetime")) {
            queryOptions.add(QueryOption.DATETIME);
        }
        if (cl.hasOption("fuzzy")) {
            queryOptions.add(QueryOption.FUZZY);
        }
        if (cl.hasOption("timezone")) {
            queryOptions.add(QueryOption.TIMEZONE);
        }
        return queryOptions;
    }

    private static void configureOutput(FindSCU main, CommandLine cl) {
        if (cl.hasOption("out-dir")) {
            main.setOutputDirectory(new File(cl.getOptionValue("out-dir")));
        }
        main.setOutputFileFormat(cl.getOptionValue("out-file", "000'.dcm'"));
        main.setConcatenateOutputFiles(cl.hasOption("out-cat"));
        main.setXML(cl.hasOption("X"));
        if (cl.hasOption("x")) {
            main.setXML(true);
            main.setXSLT(new File(cl.getOptionValue("x")));
        }
        main.setXMLIndent(cl.hasOption("I"));
        main.setXMLIncludeKeyword(!cl.hasOption("K"));
        main.setXMLIncludeNamespaceDeclaration(cl.hasOption("xmlns"));
    }

    private static void configureCancel(FindSCU main, CommandLine cl) {
        if (cl.hasOption("cancel")) {
            main.setCancelAfter(Integer.parseInt(cl.getOptionValue("cancel")));
        }
    }

    private static void configureKeys(FindSCU main, CommandLine cl) {
        CLIUtils.addEmptyAttributes((Attributes)main.keys, (String[])cl.getOptionValues("r"));
        CLIUtils.addAttributes((Attributes)main.keys, (String[])cl.getOptionValues("m"));
        if (cl.hasOption("L")) {
            main.addLevel(cl.getOptionValue("L"));
        }
        if (cl.hasOption("i")) {
            main.setInputFilter(CLIUtils.toTags((String[])cl.getOptionValues("i")));
        }
    }

    private static void configureServiceClass(FindSCU main, CommandLine cl) throws ParseException {
        main.setInformationModel(FindSCU.informationModelOf(cl), CLIUtils.transferSyntaxesOf((CommandLine)cl), FindSCU.queryOptionsOf(main, cl));
    }

    private static InformationModel informationModelOf(CommandLine cl) throws ParseException {
        try {
            return cl.hasOption("M") ? InformationModel.valueOf(cl.getOptionValue("M")) : InformationModel.StudyRoot;
        }
        catch (IllegalArgumentException e) {
            throw new ParseException(MessageFormat.format(rb.getString("invalid-model-name"), cl.getOptionValue("M")));
        }
    }

    public void open() throws IOException, InterruptedException, IncompatibleConnectionException, GeneralSecurityException {
        this.as = this.ae.connect(this.conn, this.remote, this.rq);
    }

    public void close() throws IOException, InterruptedException {
        if (this.as != null && this.as.isReadyForDataTransfer()) {
            this.as.waitForOutstandingRSP();
            this.as.release();
        }
        SafeClose.close((Closeable)this.out);
        this.out = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void query(File f) throws Exception {
        Attributes attrs;
        String filePath = f.getPath();
        String fileExt = filePath.substring(filePath.lastIndexOf(".") + 1).toLowerCase();
        Closeable dis = null;
        try {
            Attributes attributes = attrs = fileExt.equals("xml") ? SAXReader.parse((String)filePath) : new DicomInputStream(f).readDataset();
            if (this.inFilter != null) {
                attrs = new Attributes(this.inFilter.length + 1);
                attrs.addSelected(attrs, this.inFilter);
            }
        }
        finally {
            SafeClose.close(dis);
        }
        FindSCU.mergeKeys(attrs, this.keys);
        this.query(attrs);
    }

    static void mergeKeys(Attributes attrs, Attributes keys) {
        try {
            attrs.accept((Attributes.Visitor)new MergeNested(keys), false);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        attrs.addAll(keys);
    }

    public void query() throws IOException, InterruptedException {
        this.query(this.keys);
    }

    private void query(Attributes keys) throws IOException, InterruptedException {
        DimseRSPHandler rspHandler = new DimseRSPHandler(this.as.nextMessageID()){
            int cancelAfter;
            int numMatches;
            {
                this.cancelAfter = FindSCU.this.cancelAfter;
            }

            public void onDimseRSP(Association as, Attributes cmd, Attributes data) {
                super.onDimseRSP(as, cmd, data);
                int status = cmd.getInt(2304, -1);
                if (Status.isPending((int)status)) {
                    FindSCU.this.onResult(data);
                    ++this.numMatches;
                    if (this.cancelAfter != 0 && this.numMatches >= this.cancelAfter) {
                        try {
                            this.cancel(as);
                            this.cancelAfter = 0;
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        };
        this.query(keys, rspHandler);
    }

    public void query(DimseRSPHandler rspHandler) throws IOException, InterruptedException {
        this.query(this.keys, rspHandler);
    }

    private void query(Attributes keys, DimseRSPHandler rspHandler) throws IOException, InterruptedException {
        this.as.cfind(this.model.cuid, this.priority, keys, null, rspHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onResult(Attributes data) {
        int numMatches = this.totNumMatches.incrementAndGet();
        if (this.outDir == null) {
            return;
        }
        try {
            if (this.out == null) {
                File f = new File(this.outDir, this.fname(numMatches));
                this.out = new BufferedOutputStream(new FileOutputStream(f));
            }
            if (this.xml) {
                this.writeAsXML(data, this.out);
            } else {
                DicomOutputStream dos = new DicomOutputStream(this.out, "1.2.840.10008.1.2");
                dos.writeDataset(null, data);
            }
            this.out.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
            SafeClose.close((Closeable)this.out);
            this.out = null;
        }
        finally {
            if (!this.catOut) {
                SafeClose.close((Closeable)this.out);
                this.out = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String fname(int i) {
        DecimalFormat decimalFormat = this.outFileFormat;
        synchronized (decimalFormat) {
            return this.outFileFormat.format(i);
        }
    }

    private void writeAsXML(Attributes attrs, OutputStream out) throws Exception {
        TransformerHandler th = this.getTransformerHandler();
        th.getTransformer().setOutputProperty("indent", this.xmlIndent ? "yes" : "no");
        th.setResult(new StreamResult(out));
        SAXWriter saxWriter = new SAXWriter((ContentHandler)th);
        saxWriter.setIncludeKeyword(this.xmlIncludeKeyword);
        saxWriter.setIncludeNamespaceDeclaration(this.xmlIncludeNamespaceDeclaration);
        saxWriter.write(attrs);
    }

    private TransformerHandler getTransformerHandler() throws Exception {
        SAXTransformerFactory tf = saxtf;
        if (tf == null) {
            saxtf = tf = (SAXTransformerFactory)TransformerFactory.newInstance();
        }
        if (this.xsltFile == null) {
            return tf.newTransformerHandler();
        }
        Templates tpls = this.xsltTpls;
        if (tpls == null) {
            // empty if block
        }
        this.xsltTpls = tpls = tf.newTemplates(new StreamSource(this.xsltFile));
        return tf.newTransformerHandler(tpls);
    }

    public static enum InformationModel {
        PatientRoot("1.2.840.10008.5.1.4.1.2.1.1", "STUDY"),
        StudyRoot("1.2.840.10008.5.1.4.1.2.2.1", "STUDY"),
        PatientStudyOnly("1.2.840.10008.5.1.4.1.2.3.1", "STUDY"),
        MWL("1.2.840.10008.5.1.4.31", null),
        UPSPull("1.2.840.10008.5.1.4.34.6.3", null),
        UPSWatch("1.2.840.10008.5.1.4.34.6.2", null),
        UPSQuery("1.2.840.10008.5.1.4.34.6.5", null),
        HangingProtocol("1.2.840.10008.5.1.4.38.2", null),
        ColorPalette("1.2.840.10008.5.1.4.39.2", null);

        final String cuid;
        final String level;

        private InformationModel(String cuid, String level) {
            this.cuid = cuid;
            this.level = level;
        }

        public void adjustQueryOptions(EnumSet<QueryOption> queryOptions) {
            if (this.level == null) {
                queryOptions.add(QueryOption.RELATIONAL);
                queryOptions.add(QueryOption.DATETIME);
            }
        }
    }

    private static class MergeNested
    implements Attributes.Visitor {
        private final Attributes keys;

        MergeNested(Attributes keys) {
            this.keys = keys;
        }

        public boolean visit(Attributes attrs, int tag, VR vr, Object val) {
            Object o;
            if (MergeNested.isNotEmptySequence(val) && MergeNested.isNotEmptySequence(o = this.keys.remove(tag))) {
                ((Attributes)((Sequence)val).get(0)).addAll((Attributes)((Sequence)o).get(0));
            }
            return true;
        }

        private static boolean isNotEmptySequence(Object val) {
            return val instanceof Sequence && !((Sequence)val).isEmpty();
        }
    }
}

