/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.tool.getscu;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.ElementDictionary;
import org.dcm4che3.data.VR;
import org.dcm4che3.io.DicomInputStream;
import org.dcm4che3.io.DicomOutputStream;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.net.Association;
import org.dcm4che3.net.Connection;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.DimseRQHandler;
import org.dcm4che3.net.DimseRSPHandler;
import org.dcm4che3.net.IncompatibleConnectionException;
import org.dcm4che3.net.PDVInputStream;
import org.dcm4che3.net.pdu.AAssociateRQ;
import org.dcm4che3.net.pdu.ExtendedNegotiation;
import org.dcm4che3.net.pdu.PresentationContext;
import org.dcm4che3.net.pdu.RoleSelection;
import org.dcm4che3.net.service.BasicCStoreSCP;
import org.dcm4che3.net.service.DicomService;
import org.dcm4che3.net.service.DicomServiceException;
import org.dcm4che3.net.service.DicomServiceRegistry;
import org.dcm4che3.tool.common.CLIUtils;
import org.dcm4che3.util.SafeClose;
import org.dcm4che3.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetSCU {
    private static final Logger LOG = LoggerFactory.getLogger(GetSCU.class);
    private static ResourceBundle rb = ResourceBundle.getBundle("org.dcm4che3.tool.getscu.messages");
    private static final int[] DEF_IN_FILTER = new int[]{524312, 0x20000D, 0x20000E};
    private final Device device = new Device("getscu");
    private final ApplicationEntity ae;
    private final Connection conn = new Connection();
    private final Connection remote = new Connection();
    private final AAssociateRQ rq = new AAssociateRQ();
    private int priority;
    private InformationModel model;
    private File storageDir;
    private Attributes keys = new Attributes();
    private int[] inFilter = DEF_IN_FILTER;
    private Association as;
    private int cancelAfter;
    private BasicCStoreSCP storageSCP = new BasicCStoreSCP(new String[]{"*"}){

        protected void store(Association as, PresentationContext pc, Attributes rq, PDVInputStream data, Attributes rsp) throws IOException {
            if (GetSCU.this.storageDir == null) {
                return;
            }
            String iuid = rq.getString(4096);
            String cuid = rq.getString(2);
            String tsuid = pc.getTransferSyntax();
            File file = new File(GetSCU.this.storageDir, iuid);
            try {
                GetSCU.this.storeTo(as, as.createFileMetaInformation(iuid, cuid, tsuid), data, file);
            }
            catch (Exception e) {
                throw new DicomServiceException(272, (Throwable)e);
            }
        }
    };

    public GetSCU() throws IOException {
        this.ae = new ApplicationEntity("GETSCU");
        this.device.addConnection(this.conn);
        this.device.addApplicationEntity(this.ae);
        this.ae.addConnection(this.conn);
        this.device.setDimseRQHandler((DimseRQHandler)this.createServiceRegistry());
    }

    public ApplicationEntity getApplicationEntity() {
        return this.ae;
    }

    public Connection getRemoteConnection() {
        return this.remote;
    }

    public AAssociateRQ getAAssociateRQ() {
        return this.rq;
    }

    public Association getAssociation() {
        return this.as;
    }

    public Device getDevice() {
        return this.device;
    }

    public Attributes getKeys() {
        return this.keys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeTo(Association as, Attributes fmi, PDVInputStream data, File file) throws IOException {
        LOG.info("{}: M-WRITE {}", (Object)as, (Object)file);
        file.getParentFile().mkdirs();
        DicomOutputStream out = new DicomOutputStream(file);
        try {
            out.writeFileMetaInformation(fmi);
            data.copyTo((OutputStream)out);
        }
        finally {
            SafeClose.close((Closeable)out);
        }
    }

    private DicomServiceRegistry createServiceRegistry() {
        DicomServiceRegistry serviceRegistry = new DicomServiceRegistry();
        serviceRegistry.addDicomService((DicomService)this.storageSCP);
        return serviceRegistry;
    }

    public void setStorageDirectory(File storageDir) {
        if (storageDir != null && storageDir.mkdirs()) {
            System.out.println("M-WRITE " + storageDir);
        }
        this.storageDir = storageDir;
    }

    public final void setPriority(int priority) {
        this.priority = priority;
    }

    public void setCancelAfter(int cancelAfter) {
        this.cancelAfter = cancelAfter;
    }

    public final void setInformationModel(InformationModel model, String[] tss, boolean relational) {
        this.model = model;
        this.rq.addPresentationContext(new PresentationContext(1, model.cuid, tss));
        if (relational) {
            this.rq.addExtendedNegotiation(new ExtendedNegotiation(model.cuid, new byte[]{1}));
        }
        if (model.level != null) {
            this.addLevel(model.level);
        }
    }

    public void addLevel(String s) {
        this.keys.setString(524370, VR.CS, s);
    }

    public void addKey(int tag, String ... ss) {
        VR vr = ElementDictionary.vrOf((int)tag, (String)this.keys.getPrivateCreator(tag));
        this.keys.setString(tag, vr, ss);
    }

    public final void setInputFilter(int[] inFilter) {
        this.inFilter = inFilter;
    }

    private static CommandLine parseComandLine(String[] args) throws ParseException {
        Options opts = new Options();
        GetSCU.addServiceClassOptions(opts);
        GetSCU.addKeyOptions(opts);
        GetSCU.addRetrieveLevelOption(opts);
        GetSCU.addStorageDirectoryOptions(opts);
        GetSCU.addCancelAfterOption(opts);
        CLIUtils.addConnectOption((Options)opts);
        CLIUtils.addBindClientOption((Options)opts, (String)"GETSCU");
        CLIUtils.addAEOptions((Options)opts);
        CLIUtils.addSendTimeoutOption((Options)opts);
        CLIUtils.addRetrieveTimeoutOption((Options)opts);
        CLIUtils.addPriorityOption((Options)opts);
        CLIUtils.addCommonOptions((Options)opts);
        return CLIUtils.parseComandLine((String[])args, (Options)opts, (ResourceBundle)rb, GetSCU.class);
    }

    private static void addRetrieveLevelOption(Options opts) {
        opts.addOption(Option.builder((String)"L").hasArg().argName("PATIENT|STUDY|SERIES|IMAGE|FRAME").desc(rb.getString("level")).build());
    }

    private static void addStorageDirectoryOptions(Options opts) {
        opts.addOption(null, "ignore", false, rb.getString("ignore"));
        opts.addOption(Option.builder().hasArg().argName("path").desc(rb.getString("directory")).longOpt("directory").build());
    }

    private static void addCancelAfterOption(Options opts) {
        opts.addOption(Option.builder().hasArg().argName("ms").desc(rb.getString("cancel-after")).longOpt("cancel-after").build());
    }

    private static void addKeyOptions(Options opts) {
        opts.addOption(Option.builder((String)"m").hasArgs().argName("[seq.]attr=value").desc(rb.getString("match")).build());
        opts.addOption(Option.builder((String)"i").hasArgs().argName("attr").desc(rb.getString("in-attr")).build());
    }

    private static void addServiceClassOptions(Options opts) {
        opts.addOption(Option.builder((String)"M").hasArg().argName("name").desc(rb.getString("model")).build());
        opts.addOption(null, "relational", false, rb.getString("relational"));
        CLIUtils.addTransferSyntaxOptions((Options)opts);
        opts.addOption(Option.builder().hasArg().argName("cuid:tsuid[(,|;)...]").desc(rb.getString("store-tc")).longOpt("store-tc").build());
        opts.addOption(Option.builder().hasArg().argName("file|url").desc(rb.getString("store-tcs")).longOpt("store-tcs").build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            CommandLine cl = GetSCU.parseComandLine(args);
            GetSCU main = new GetSCU();
            CLIUtils.configureConnect((Connection)main.remote, (AAssociateRQ)main.rq, (CommandLine)cl);
            CLIUtils.configureBind((Connection)main.conn, (ApplicationEntity)main.ae, (CommandLine)cl);
            CLIUtils.configure((Connection)main.conn, (CommandLine)cl);
            main.remote.setTlsProtocols(main.conn.getTlsProtocols());
            main.remote.setTlsCipherSuites(main.conn.getTlsCipherSuites());
            GetSCU.configureServiceClass(main, cl);
            GetSCU.configureKeys(main, cl);
            main.setPriority(CLIUtils.priorityOf((CommandLine)cl));
            GetSCU.configureStorageDirectory(main, cl);
            main.setCancelAfter(CLIUtils.getIntOption((CommandLine)cl, (String)"cancel-after", (int)0));
            ExecutorService executorService = Executors.newSingleThreadExecutor();
            ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
            main.device.setExecutor((Executor)executorService);
            main.device.setScheduledExecutor(scheduledExecutorService);
            try {
                main.open();
                List argList = cl.getArgList();
                if (argList.isEmpty()) {
                    main.retrieve();
                } else {
                    for (String arg : argList) {
                        main.retrieve(new File(arg));
                    }
                }
            }
            finally {
                main.close();
                executorService.shutdown();
                scheduledExecutorService.shutdown();
            }
        }
        catch (ParseException e) {
            System.err.println("getscu: " + e.getMessage());
            System.err.println(rb.getString("try"));
            System.exit(2);
        }
        catch (Exception e) {
            System.err.println("getscu: " + e.getMessage());
            e.printStackTrace();
            System.exit(2);
        }
    }

    private static void configureServiceClass(GetSCU main, CommandLine cl) throws Exception {
        main.setInformationModel(GetSCU.informationModelOf(cl), CLIUtils.transferSyntaxesOf((CommandLine)cl), cl.hasOption("relational"));
        String[] pcs = cl.getOptionValues("store-tc");
        if (pcs != null) {
            for (String pc : pcs) {
                String[] ss = StringUtils.split((String)pc, (char)':');
                GetSCU.configureStorageSOPClass(main, ss[0], ss[1]);
            }
        }
        String[] files = cl.getOptionValues("store-tcs");
        if (pcs == null && files == null) {
            files = new String[]{"resource:store-tcs.properties"};
        }
        if (files != null) {
            for (String file : files) {
                Properties p = CLIUtils.loadProperties((String)file, null);
                Set<Map.Entry<Object, Object>> entrySet = p.entrySet();
                for (Map.Entry<Object, Object> entry : entrySet) {
                    GetSCU.configureStorageSOPClass(main, (String)entry.getKey(), (String)entry.getValue());
                }
            }
        }
    }

    private static void configureStorageSOPClass(GetSCU main, String cuid, String tsuids0) {
        String[] tsuids1;
        for (String tsuids2 : tsuids1 = StringUtils.split((String)tsuids0, (char)';')) {
            main.addOfferedStorageSOPClass(CLIUtils.toUID((String)cuid), CLIUtils.toUIDs((String)tsuids2));
        }
    }

    public void addOfferedStorageSOPClass(String cuid, String ... tsuids) {
        if (!this.rq.containsPresentationContextFor(cuid)) {
            this.rq.addRoleSelection(new RoleSelection(cuid, false, true));
        }
        this.rq.addPresentationContext(new PresentationContext(2 * this.rq.getNumberOfPresentationContexts() + 1, cuid, tsuids));
    }

    private static void configureStorageDirectory(GetSCU main, CommandLine cl) {
        if (!cl.hasOption("ignore")) {
            main.setStorageDirectory(new File(cl.getOptionValue("directory", ".")));
        }
    }

    private static void configureKeys(GetSCU main, CommandLine cl) {
        CLIUtils.addAttributes((Attributes)main.keys, (String[])cl.getOptionValues("m"));
        if (cl.hasOption("L")) {
            main.addLevel(cl.getOptionValue("L"));
        }
        if (cl.hasOption("i")) {
            main.setInputFilter(CLIUtils.toTags((String[])cl.getOptionValues("i")));
        }
    }

    private static InformationModel informationModelOf(CommandLine cl) throws ParseException {
        try {
            return cl.hasOption("M") ? InformationModel.valueOf(cl.getOptionValue("M")) : InformationModel.StudyRoot;
        }
        catch (IllegalArgumentException e) {
            throw new ParseException(MessageFormat.format(rb.getString("invalid-model-name"), cl.getOptionValue("M")));
        }
    }

    public void open() throws IOException, InterruptedException, IncompatibleConnectionException, GeneralSecurityException {
        this.as = this.ae.connect(this.conn, this.remote, this.rq);
    }

    public void close() throws IOException, InterruptedException {
        if (this.as != null && this.as.isReadyForDataTransfer()) {
            this.as.waitForOutstandingRSP();
            this.as.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retrieve(File f) throws IOException, InterruptedException {
        Attributes attrs = new Attributes();
        Closeable dis = null;
        try {
            attrs.addSelected(new DicomInputStream(f).readDataset(), this.inFilter);
        }
        finally {
            SafeClose.close(dis);
        }
        attrs.addAll(this.keys);
        this.retrieve(attrs);
    }

    public void retrieve() throws IOException, InterruptedException {
        this.retrieve(this.keys);
    }

    private void retrieve(Attributes keys) throws IOException, InterruptedException {
        final DimseRSPHandler rspHandler = new DimseRSPHandler(this.as.nextMessageID()){

            public void onDimseRSP(Association as, Attributes cmd, Attributes data) {
                super.onDimseRSP(as, cmd, data);
            }
        };
        this.retrieve(keys, rspHandler);
        if (this.cancelAfter > 0) {
            this.device.schedule(new Runnable(){

                @Override
                public void run() {
                    try {
                        rspHandler.cancel(GetSCU.this.as);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }, (long)this.cancelAfter, TimeUnit.MILLISECONDS);
        }
    }

    public void retrieve(DimseRSPHandler rspHandler) throws IOException, InterruptedException {
        this.retrieve(this.keys, rspHandler);
    }

    private void retrieve(Attributes keys, DimseRSPHandler rspHandler) throws IOException, InterruptedException {
        this.as.cget(this.model.cuid, this.priority, keys, null, rspHandler);
    }

    public static enum InformationModel {
        PatientRoot("1.2.840.10008.5.1.4.1.2.1.3", "STUDY"),
        StudyRoot("1.2.840.10008.5.1.4.1.2.2.3", "STUDY"),
        PatientStudyOnly("1.2.840.10008.5.1.4.1.2.3.3", "STUDY"),
        CompositeInstanceRoot("1.2.840.10008.5.1.4.1.2.4.3", "IMAGE"),
        WithoutBulkData("1.2.840.10008.5.1.4.1.2.5.3", null),
        HangingProtocol("1.2.840.10008.5.1.4.38.4", null),
        ColorPalette("1.2.840.10008.5.1.4.39.4", null);

        final String cuid;
        final String level;

        private InformationModel(String cuid, String level) {
            this.cuid = cuid;
            this.level = level;
        }
    }
}

