/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.tool.hl7rcv;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.Socket;
import java.net.URL;
import java.util.Date;
import java.util.ResourceBundle;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.dcm4che3.hl7.ERRSegment;
import org.dcm4che3.hl7.HL7Charset;
import org.dcm4che3.hl7.HL7ContentHandler;
import org.dcm4che3.hl7.HL7Exception;
import org.dcm4che3.hl7.HL7Message;
import org.dcm4che3.hl7.HL7Parser;
import org.dcm4che3.hl7.HL7Segment;
import org.dcm4che3.io.SAXTransformer;
import org.dcm4che3.net.Connection;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.DeviceExtension;
import org.dcm4che3.net.hl7.HL7Application;
import org.dcm4che3.net.hl7.HL7DeviceExtension;
import org.dcm4che3.net.hl7.HL7MessageListener;
import org.dcm4che3.net.hl7.UnparsedHL7Message;
import org.dcm4che3.tool.common.CLIUtils;
import org.dcm4che3.util.StringUtils;
import org.xml.sax.ContentHandler;

public class HL7Rcv {
    private static final ResourceBundle rb = ResourceBundle.getBundle("org.dcm4che3.tool.hl7rcv.messages");
    private static SAXTransformerFactory factory = (SAXTransformerFactory)TransformerFactory.newInstance();
    private final Device device = new Device("hl7rcv");
    private final HL7DeviceExtension hl7Ext = new HL7DeviceExtension();
    private final HL7Application hl7App = new HL7Application("*");
    private final Connection conn = new Connection();
    private String storageDir;
    private String charset;
    private Templates tpls;
    private String[] xsltParams;
    private boolean useUUIDForFilename;
    private int responseDelay;
    private final HL7MessageListener handler = new HL7MessageListener(){

        public UnparsedHL7Message onMessage(HL7Application hl7App, Connection conn, Socket s, UnparsedHL7Message msg) throws HL7Exception {
            try {
                return HL7Rcv.this.onMessage(msg);
            }
            catch (Exception e) {
                throw new HL7Exception((HL7Segment)new ERRSegment(msg.msh()).setUserMessage(e.getMessage()), (Throwable)e);
            }
        }
    };

    public HL7Rcv() throws IOException {
        this.conn.setProtocol(Connection.Protocol.HL7);
        this.device.addDeviceExtension((DeviceExtension)this.hl7Ext);
        this.device.addConnection(this.conn);
        this.hl7Ext.addHL7Application(this.hl7App);
        this.hl7App.setAcceptedMessageTypes(new String[]{"*"});
        this.hl7App.addConnection(this.conn);
        this.hl7App.setHL7MessageListener(this.handler);
    }

    public void setStorageDirectory(String storageDir) {
        this.storageDir = storageDir;
    }

    public void setXSLT(URL xslt) throws Exception {
        this.tpls = SAXTransformer.newTemplates((Source)new StreamSource(xslt.openStream(), xslt.toExternalForm()));
    }

    public void setXSLTParameters(String[] xsltParams) {
        this.xsltParams = xsltParams;
    }

    public void setCharacterSet(String charset) {
        this.charset = charset;
    }

    public void setUseUUIDForFilename(boolean useUUIDForFilename) {
        this.useUUIDForFilename = useUUIDForFilename;
    }

    private static CommandLine parseComandLine(String[] args) throws ParseException {
        Options opts = new Options();
        HL7Rcv.addOptions(opts);
        CLIUtils.addMLLP2Option((Options)opts);
        CLIUtils.addSocketOptions((Options)opts);
        CLIUtils.addTLSOptions((Options)opts);
        CLIUtils.addCommonOptions((Options)opts);
        return CLIUtils.parseComandLine((String[])args, (Options)opts, (ResourceBundle)rb, HL7Rcv.class);
    }

    public static void addOptions(Options opts) {
        opts.addOption(null, "ignore", false, rb.getString("ignore"));
        opts.addOption(null, "uuid", false, rb.getString("uuid"));
        opts.addOption(Option.builder().hasArg().argName("path").desc(rb.getString("directory")).longOpt("directory").build());
        opts.addOption(Option.builder((String)"x").longOpt("xsl").hasArg().argName("xsl-file").desc(rb.getString("xsl")).build());
        opts.addOption(Option.builder().longOpt("xsl-param").hasArgs().valueSeparator('=').argName("name=value").desc(rb.getString("xsl-param")).build());
        opts.addOption(Option.builder().longOpt("charset").hasArg().argName("name").desc(rb.getString("charset")).build());
        opts.addOption(Option.builder((String)"b").hasArg().argName("[ip:]port").desc(rb.getString("bind-server")).longOpt("bind").build());
        opts.addOption(Option.builder().hasArg().argName("ms").desc(rb.getString("idle-timeout")).longOpt("idle-timeout").build());
        opts.addOption(Option.builder().hasArg().argName("ms").desc(rb.getString("response-delay")).longOpt("response-delay").build());
    }

    public static void main(String[] args) {
        try {
            CommandLine cl = HL7Rcv.parseComandLine(args);
            HL7Rcv main = new HL7Rcv();
            HL7Rcv.configure(main, cl);
            ExecutorService executorService = Executors.newCachedThreadPool();
            ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
            main.device.setScheduledExecutor(scheduledExecutorService);
            main.device.setExecutor((Executor)executorService);
            main.device.bindConnections();
        }
        catch (ParseException e) {
            System.err.println("hl7rcv: " + e.getMessage());
            System.err.println(rb.getString("try"));
            System.exit(2);
        }
        catch (Exception e) {
            System.err.println("hl7rcv: " + e.getMessage());
            e.printStackTrace();
            System.exit(2);
        }
    }

    private static void configure(HL7Rcv main, CommandLine cl) throws Exception {
        main.setUseUUIDForFilename(cl.hasOption("uuid"));
        if (!cl.hasOption("ignore")) {
            main.setStorageDirectory(cl.getOptionValue("directory", "."));
        }
        if (cl.hasOption("x")) {
            String s = cl.getOptionValue("x");
            main.setXSLT(new File(s).toURI().toURL());
            main.setXSLTParameters(cl.getOptionValues("xsl-param"));
        }
        main.setCharacterSet(cl.getOptionValue("charset"));
        main.responseDelay = CLIUtils.getIntOption((CommandLine)cl, (String)"response-delay", (int)0);
        main.conn.setProtocol(CLIUtils.isMLLP2((CommandLine)cl) ? Connection.Protocol.HL7_MLLP2 : Connection.Protocol.HL7);
        HL7Rcv.configureBindServer(main.conn, cl);
        CLIUtils.configure((Connection)main.conn, (CommandLine)cl);
    }

    private static void configureBindServer(Connection conn, CommandLine cl) throws ParseException {
        if (!cl.hasOption("b")) {
            throw new MissingOptionException(CLIUtils.rb.getString("missing-bind-opt"));
        }
        String aeAtHostPort = cl.getOptionValue("b");
        String[] hostAndPort = StringUtils.split((String)aeAtHostPort, (char)':');
        int portIndex = hostAndPort.length - 1;
        conn.setPort(Integer.parseInt(hostAndPort[portIndex]));
        if (portIndex > 0) {
            conn.setHostname(hostAndPort[0]);
        }
    }

    private UnparsedHL7Message onMessage(UnparsedHL7Message msg) throws Exception {
        if (this.storageDir != null) {
            this.storeToFile(msg.data(), new File(new File(this.storageDir, msg.msh().getMessageType()), this.useUUIDForFilename ? UUID.randomUUID().toString() : msg.msh().getField(9, "_NULL_")));
        }
        if (this.responseDelay > 0) {
            try {
                Thread.sleep(this.responseDelay);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        return new UnparsedHL7Message(this.tpls == null ? HL7Message.makeACK((HL7Segment)msg.msh(), (String)"AA", null).getBytes(null) : this.xslt(msg));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeToFile(byte[] data, File f) throws IOException {
        Connection.LOG.info("M-WRITE {}", (Object)f);
        f.getParentFile().mkdirs();
        try (FileOutputStream out = new FileOutputStream(f);){
            out.write(data);
        }
    }

    private byte[] xslt(UnparsedHL7Message msg) throws Exception {
        String charsetName = HL7Charset.toCharsetName((String)msg.msh().getField(17, this.charset));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        TransformerHandler th = factory.newTransformerHandler(this.tpls);
        Transformer t = th.getTransformer();
        t.setParameter("MessageControlID", HL7Segment.nextMessageControlID());
        t.setParameter("DateTimeOfMessage", HL7Segment.timeStamp((Date)new Date()));
        if (this.xsltParams != null) {
            for (int i = 1; i < this.xsltParams.length; ++i) {
                t.setParameter(this.xsltParams[i - 1], this.xsltParams[i]);
                ++i;
            }
        }
        th.setResult(new SAXResult((ContentHandler)new HL7ContentHandler((Writer)new OutputStreamWriter((OutputStream)out, charsetName))));
        new HL7Parser((ContentHandler)th).parse((Reader)new InputStreamReader((InputStream)new ByteArrayInputStream(msg.data()), charsetName));
        return out.toByteArray();
    }

    public Device getDevice() {
        return this.device;
    }

    public Connection getConn() {
        return this.conn;
    }
}

