/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.tool.hl7snd;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.security.GeneralSecurityException;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.dcm4che3.hl7.MLLPConnection;
import org.dcm4che3.hl7.MLLPRelease;
import org.dcm4che3.net.Connection;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.IncompatibleConnectionException;
import org.dcm4che3.tool.common.CLIUtils;
import org.dcm4che3.util.SafeClose;
import org.dcm4che3.util.StreamUtils;
import org.dcm4che3.util.StringUtils;

public class HL7Snd
extends Device {
    private static ResourceBundle rb = ResourceBundle.getBundle("org.dcm4che3.tool.hl7snd.messages");
    private final Connection conn = new Connection();
    private final Connection remote = new Connection();
    private MLLPRelease mllpRelease;
    private Socket sock;
    private MLLPConnection mllp;

    public HL7Snd() throws IOException {
        super("hl7snd");
        this.addConnection(this.conn);
    }

    public void setMLLPRelease(MLLPRelease mllpRelease) {
        this.mllpRelease = mllpRelease;
    }

    private static CommandLine parseComandLine(String[] args) throws ParseException {
        Options opts = new Options();
        HL7Snd.addConnectOption(opts);
        HL7Snd.addBindOption(opts);
        CLIUtils.addMLLP2Option((Options)opts);
        CLIUtils.addResponseTimeoutOption((Options)opts);
        CLIUtils.addSocketOptions((Options)opts);
        CLIUtils.addTLSOptions((Options)opts);
        CLIUtils.addCommonOptions((Options)opts);
        return CLIUtils.parseComandLine((String[])args, (Options)opts, (ResourceBundle)rb, HL7Snd.class);
    }

    private static void addConnectOption(Options opts) {
        opts.addOption(Option.builder((String)"c").hasArg().argName("host:port").desc(rb.getString("connect")).longOpt("connect").build());
        opts.addOption(Option.builder().hasArg().argName("[user:password@]host:port").desc(rb.getString("proxy")).longOpt("proxy").build());
        CLIUtils.addConnectTimeoutOption((Options)opts);
    }

    private static void addBindOption(Options opts) {
        opts.addOption(Option.builder((String)"b").hasArg().argName("ip").desc(rb.getString("bind")).longOpt("bind").build());
    }

    private static void configureConnect(Connection conn, CommandLine cl) throws MissingOptionException, ParseException {
        if (!cl.hasOption("c")) {
            throw new MissingOptionException(CLIUtils.rb.getString("missing-connect-opt"));
        }
        String[] hostPort = StringUtils.split((String)cl.getOptionValue("c"), (char)':');
        if (hostPort.length != 2) {
            throw new ParseException(CLIUtils.rb.getString("invalid-connect-opt"));
        }
        conn.setHostname(hostPort[0]);
        conn.setPort(Integer.parseInt(hostPort[1]));
        conn.setHttpProxy(cl.getOptionValue("proxy"));
    }

    private static void configureBind(Connection conn, CommandLine cl) {
        if (cl.hasOption("b")) {
            conn.setHostname(cl.getOptionValue("b"));
        }
    }

    public static void main(String[] args) {
        try {
            CommandLine cl = HL7Snd.parseComandLine(args);
            HL7Snd main = new HL7Snd();
            HL7Snd.configureConnect(main.remote, cl);
            HL7Snd.configureBind(main.conn, cl);
            CLIUtils.configure((Connection)main.conn, (CommandLine)cl);
            main.setMLLPRelease(CLIUtils.isMLLP2((CommandLine)cl) ? MLLPRelease.MLLP2 : MLLPRelease.MLLP1);
            main.remote.setTlsProtocols(main.conn.getTlsProtocols());
            main.remote.setTlsCipherSuites(main.conn.getTlsCipherSuites());
            try {
                main.open();
                main.sendFiles(cl.getArgList());
            }
            finally {
                main.close();
            }
        }
        catch (ParseException e) {
            System.err.println("hl7snd: " + e.getMessage());
            System.err.println(rb.getString("try"));
            System.exit(2);
        }
        catch (Exception e) {
            System.err.println("hl7snd: " + e.getMessage());
            e.printStackTrace();
            System.exit(2);
        }
    }

    public void open() throws IOException, IncompatibleConnectionException, GeneralSecurityException {
        this.sock = this.conn.connect(this.remote);
        this.sock.setSoTimeout(this.conn.getResponseTimeout());
        this.mllp = new MLLPConnection(this.sock, this.mllpRelease);
    }

    public void close() {
        this.conn.close(this.sock);
    }

    public void sendFiles(List<String> pathnames) throws IOException {
        for (String pathname : pathnames) {
            if (pathname.equals("-")) {
                this.send(this.readFromStdIn());
                continue;
            }
            Path path = Paths.get(pathname, new String[0]);
            if (Files.isDirectory(path, new LinkOption[0])) {
                Files.walkFileTree(path, new HL7Send());
                continue;
            }
            this.send(this.readFromFile(path));
        }
    }

    private void send(byte[] data) throws IOException {
        this.mllp.writeMessage(data);
        if (this.mllp.readMessage() == null) {
            throw new IOException("Connection closed by receiver");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readFromStdIn() throws IOException {
        byte[] byArray;
        FileInputStream in = null;
        try {
            in = new FileInputStream(FileDescriptor.in);
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            StreamUtils.copy((InputStream)in, (OutputStream)buf);
            byArray = buf.toByteArray();
        }
        catch (Throwable throwable) {
            SafeClose.close(in);
            throw throwable;
        }
        SafeClose.close((Closeable)in);
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readFromFile(Path path) throws IOException {
        byte[] byArray;
        FileInputStream in = null;
        try {
            File f = path.toFile();
            in = new FileInputStream(f);
            byte[] b = new byte[(int)f.length()];
            StreamUtils.readFully((InputStream)in, (byte[])b, (int)0, (int)b.length);
            byArray = b;
        }
        catch (Throwable throwable) {
            SafeClose.close(in);
            throw throwable;
        }
        SafeClose.close((Closeable)in);
        return byArray;
    }

    class HL7Send
    extends SimpleFileVisitor<Path> {
        HL7Send() {
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            HL7Snd.this.send(HL7Snd.this.readFromFile(file));
            return FileVisitResult.CONTINUE;
        }
    }
}

