/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.tool.ianscu;

import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.data.VR;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.net.Association;
import org.dcm4che3.net.Connection;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.DimseRSPHandler;
import org.dcm4che3.net.IncompatibleConnectionException;
import org.dcm4che3.net.pdu.AAssociateRQ;
import org.dcm4che3.net.pdu.PresentationContext;
import org.dcm4che3.tool.common.CLIUtils;
import org.dcm4che3.tool.common.DicomFiles;

public class IanSCU {
    private static ResourceBundle rb = ResourceBundle.getBundle("org.dcm4che3.tool.ianscu.messages");
    private final Device device = new Device("ianscu");
    private final ApplicationEntity ae = new ApplicationEntity("IANSCU");
    private final Connection conn = new Connection();
    private final Connection remote = new Connection();
    private final AAssociateRQ rq = new AAssociateRQ();
    private final Attributes attrs = new Attributes();
    private String uidSuffix;
    private String refPpsIUID;
    private String refPpsCUID = "1.2.840.10008.3.1.2.3.3";
    private String availability = "ONLINE";
    private String retrieveAET;
    private String retrieveURI;
    private String retrieveURL;
    private String retrieveUID;
    private HashMap<String, Attributes> map = new HashMap();
    private Association as;

    public IanSCU() {
        this.device.addConnection(this.conn);
        this.device.addApplicationEntity(this.ae);
        this.ae.addConnection(this.conn);
    }

    public final void setUIDSuffix(String uidSuffix) {
        this.uidSuffix = uidSuffix;
    }

    public void setTransferSyntaxes(String[] tss) {
        this.rq.addPresentationContext(new PresentationContext(1, "1.2.840.10008.1.1", new String[]{"1.2.840.10008.1.2"}));
        this.rq.addPresentationContext(new PresentationContext(3, "1.2.840.10008.5.1.4.33", tss));
    }

    public void setRefPpsIUID(String refPpsIUID) {
        this.refPpsIUID = refPpsIUID;
    }

    public void setRefPpsCUID(String refPpsCUID) {
        this.refPpsCUID = refPpsCUID;
    }

    public void setAvailability(String availability) {
        this.availability = availability;
    }

    public void setRetrieveAET(String retrieveAET) {
        this.retrieveAET = retrieveAET;
    }

    public String getRetrieveAET() {
        return this.retrieveAET != null ? this.retrieveAET : this.ae.getAETitle();
    }

    public void setRetrieveURL(String retrieveURL) {
        this.retrieveURL = retrieveURL;
    }

    public void setRetrieveURI(String retrieveURI) {
        this.retrieveURI = retrieveURI;
    }

    public void setRetrieveUID(String retrieveUID) {
        this.retrieveUID = retrieveUID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            CommandLine cl = IanSCU.parseComandLine(args);
            final IanSCU main = new IanSCU();
            IanSCU.configureIAN(main, cl);
            CLIUtils.configureConnect((Connection)main.remote, (AAssociateRQ)main.rq, (CommandLine)cl);
            CLIUtils.configureBind((Connection)main.conn, (ApplicationEntity)main.ae, (CommandLine)cl);
            CLIUtils.configure((Connection)main.conn, (CommandLine)cl);
            main.remote.setTlsProtocols(main.conn.getTlsProtocols());
            main.remote.setTlsCipherSuites(main.conn.getTlsCipherSuites());
            main.setTransferSyntaxes(CLIUtils.transferSyntaxesOf((CommandLine)cl));
            CLIUtils.addAttributes((Attributes)main.attrs, (String[])cl.getOptionValues("s"));
            main.setUIDSuffix(cl.getOptionValue("uid-suffix"));
            List argList = cl.getArgList();
            boolean echo = argList.isEmpty();
            if (!echo) {
                System.out.println(rb.getString("scanning"));
                DicomFiles.scan((List)argList, (DicomFiles.Callback)new DicomFiles.Callback(){

                    public boolean dicomFile(File f, Attributes fmi, long dsPos, Attributes ds) {
                        if ("1.2.840.10008.5.1.4.33".equals(fmi.getString(131074))) {
                            return main.addIAN(fmi.getString(131075), ds);
                        }
                        return main.addInstance(ds);
                    }
                });
            }
            ExecutorService executorService = Executors.newSingleThreadExecutor();
            ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
            main.device.setExecutor((Executor)executorService);
            main.device.setScheduledExecutor(scheduledExecutorService);
            try {
                main.open();
                if (echo) {
                    main.echo();
                } else {
                    main.sendIans();
                }
            }
            finally {
                main.close();
                executorService.shutdown();
                scheduledExecutorService.shutdown();
            }
        }
        catch (ParseException e) {
            System.err.println("ianscu: " + e.getMessage());
            System.err.println(rb.getString("try"));
            System.exit(2);
        }
        catch (Exception e) {
            System.err.println("ianscu: " + e.getMessage());
            e.printStackTrace();
            System.exit(2);
        }
    }

    private static CommandLine parseComandLine(String[] args) throws ParseException {
        Options opts = new Options();
        CLIUtils.addTransferSyntaxOptions((Options)opts);
        CLIUtils.addConnectOption((Options)opts);
        CLIUtils.addBindClientOption((Options)opts, (String)"IANSCU");
        CLIUtils.addAEOptions((Options)opts);
        CLIUtils.addSendTimeoutOption((Options)opts);
        CLIUtils.addResponseTimeoutOption((Options)opts);
        CLIUtils.addCommonOptions((Options)opts);
        IanSCU.addIANOptions(opts);
        return CLIUtils.parseComandLine((String[])args, (Options)opts, (ResourceBundle)rb, IanSCU.class);
    }

    private static void addIANOptions(Options opts) {
        opts.addOption(Option.builder().hasArg().argName("uid").desc(rb.getString("pps-iuid")).longOpt("pps-iuid").build());
        opts.addOption(Option.builder().hasArg().argName("uid").desc(rb.getString("pps-cuid")).longOpt("pps-cuid").build());
        opts.addOption(Option.builder().hasArg().argName("code-string").desc(rb.getString("availability")).longOpt("availability").build());
        opts.addOption(Option.builder().hasArg().argName("aet").desc(rb.getString("retrieve-aet")).longOpt("retrieve-aet").build());
        opts.addOption(Option.builder().hasArg().argName("uri").desc(rb.getString("retrieve-url")).longOpt("retrieve-url").build());
        opts.addOption(Option.builder().hasArg().argName("uri").desc(rb.getString("retrieve-uri")).longOpt("retrieve-uri").build());
        opts.addOption(Option.builder().hasArg().argName("uid").desc(rb.getString("retrieve-uid")).longOpt("retrieve-uid").build());
        opts.addOption(Option.builder((String)"s").hasArgs().argName("[seq.]attr=value").desc(rb.getString("set")).build());
        opts.addOption(Option.builder().hasArg().argName("suffix").desc(rb.getString("uid-suffix")).longOpt("uid-suffix").build());
    }

    private static void configureIAN(IanSCU main, CommandLine cl) throws Exception {
        main.setRefPpsIUID(cl.getOptionValue("pps-iuid"));
        main.setRefPpsCUID(cl.getOptionValue("pps-cuid", "1.2.840.10008.3.1.2.3.3"));
        main.setAvailability(cl.getOptionValue("availability", "ONLINE"));
        main.setRetrieveAET(cl.getOptionValue("retrieve-aet"));
        main.setRetrieveURI(cl.getOptionValue("retrieve-uri"));
        main.setRetrieveURL(cl.getOptionValue("retrieve-url"));
        main.setRetrieveUID(cl.getOptionValue("retrieve-uid"));
    }

    public void open() throws IOException, InterruptedException, IncompatibleConnectionException, GeneralSecurityException {
        this.as = this.ae.connect(this.conn, this.remote, this.rq);
    }

    public void close() throws IOException, InterruptedException {
        if (this.as != null) {
            this.as.release();
        }
    }

    public void echo() throws IOException, InterruptedException {
        this.as.cecho().next();
    }

    public void sendIans() throws IOException, InterruptedException {
        for (Attributes ian : this.map.values()) {
            this.sendIan(ian);
        }
    }

    private void sendIan(Attributes ian) throws IOException, InterruptedException {
        this.as.ncreate("1.2.840.10008.5.1.4.33", null, ian, null, new DimseRSPHandler(this.as.nextMessageID()));
    }

    public boolean addInstance(Attributes inst) {
        CLIUtils.updateAttributes((Attributes)inst, (Attributes)this.attrs, (String)this.uidSuffix);
        String suid = inst.getString(0x20000D);
        if (suid == null) {
            return false;
        }
        Attributes ian = this.map.get(suid);
        if (ian == null) {
            ian = this.createIAN(inst);
            this.map.put(suid, ian);
        }
        this.updateIAN(ian, inst);
        return true;
    }

    public boolean addIAN(String iuid, Attributes ian) {
        this.map.put(iuid, ian);
        return true;
    }

    private Attributes createIAN(Attributes inst) {
        Attributes ian = new Attributes(3);
        Sequence refPpsSeq = ian.newSequence(528657, 1);
        if (this.refPpsIUID != null) {
            Attributes refPps = new Attributes(3);
            refPps.setString(528720, VR.UI, this.refPpsCUID);
            refPps.setString(528725, VR.UI, this.refPpsIUID);
            refPps.setNull(4210713, VR.SQ);
            refPpsSeq.add(refPps);
        }
        ian.newSequence(528661, 1);
        ian.setString(0x20000D, VR.UI, inst.getString(0x20000D));
        return ian;
    }

    private void updateIAN(Attributes mpps, Attributes inst) {
        Sequence refSeriesSeq = mpps.getSequence(528661);
        Attributes refSeries = this.getRefSeries(refSeriesSeq, inst);
        Sequence refSOPSeq = refSeries.getSequence(528793);
        Attributes refSOP = new Attributes(6);
        refSOP.setString(524372, VR.AE, this.getRetrieveAET());
        refSOP.setString(524374, VR.CS, this.availability);
        refSOP.setString(528720, VR.UI, inst.getString(524310));
        refSOP.setString(528725, VR.UI, inst.getString(524312));
        if (this.retrieveURL != null) {
            refSOP.setString(528784, VR.UR, this.retrieveURL);
        }
        if (this.retrieveURI != null) {
            refSOP.setString(4251664, VR.UR, this.retrieveURI);
        }
        if (this.retrieveUID != null) {
            refSOP.setString(4251665, VR.UI, this.retrieveUID);
        }
        refSOPSeq.add(refSOP);
    }

    private Attributes getRefSeries(Sequence refSeriesSeq, Attributes inst) {
        String suid = inst.getString(0x20000E);
        for (Attributes refSeries : refSeriesSeq) {
            if (!suid.equals(refSeries.getString(0x20000E))) continue;
            return refSeries;
        }
        Attributes refSeries = new Attributes(2);
        refSeries.newSequence(528793, 10);
        refSeries.setString(0x20000E, VR.CS, suid);
        refSeriesSeq.add(refSeries);
        return refSeries;
    }
}

