/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.tool.json2index;

import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import jakarta.json.JsonString;
import jakarta.json.stream.JsonGenerator;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.dcm4che3.tool.common.CLIUtils;

public class Json2Index {
    private static final ResourceBundle rb = ResourceBundle.getBundle("org.dcm4che3.tool.json2index.messages");
    private final File indir;
    private final Map<String, ParentRef> parents = new HashMap<String, ParentRef>();

    public Json2Index(File indir) {
        this.indir = indir;
    }

    private static CommandLine parseCommandLine(String[] args) throws ParseException {
        Options opts = new Options();
        CLIUtils.addCommonOptions((Options)opts);
        return CLIUtils.parseComandLine((String[])args, (Options)opts, (ResourceBundle)rb, Json2Index.class);
    }

    public static void main(String[] args) {
        try {
            CommandLine cl = Json2Index.parseCommandLine(args);
            Json2Index json2index = new Json2Index(new File((String)cl.getArgList().get(0)));
            json2index.process();
        }
        catch (ParseException e) {
            System.err.println("json2index: " + e.getMessage());
            System.err.println(rb.getString("try"));
            System.exit(2);
        }
        catch (Exception e) {
            System.err.println("json2index: " + e.getMessage());
            e.printStackTrace();
            System.exit(2);
        }
    }

    private void process() throws IOException {
        try (JsonGenerator gen = Json.createGenerator((OutputStream)System.out);){
            gen.writeStartObject();
            gen.writeStartObject("schemas");
            for (File file : this.indir.listFiles()) {
                if (file.isDirectory()) continue;
                gen.writeStartObject(file.getName());
                this.processFile(file, gen);
                gen.writeEnd();
            }
            gen.writeEnd();
            gen.writeStartObject("parents");
            for (Map.Entry entry : this.parents.entrySet()) {
                gen.writeStartObject((String)entry.getKey());
                ParentRef ref = (ParentRef)entry.getValue();
                gen.writeStartArray(ref.property);
                for (String schema : ref.schemas) {
                    gen.write(schema);
                }
                gen.writeEnd();
                gen.writeEnd();
            }
            gen.writeEnd();
            gen.writeEnd();
        }
    }

    private void processFile(File inFile, JsonGenerator gen) throws IOException {
        try (InputStreamReader is = new InputStreamReader(new FileInputStream(inFile));){
            JsonReader reader = Json.createReader((Reader)is);
            JsonObject doc = reader.readObject();
            gen.write("title", doc.getString("title"));
            gen.write("description", doc.getString("description"));
            gen.writeStartObject("properties");
            JsonObject properties = doc.getJsonObject("properties");
            for (String name : properties.keySet()) {
                gen.writeStartArray(name);
                JsonObject property = properties.getJsonObject(name);
                gen.write(property.getString("title"));
                gen.write(property.getString("description"));
                this.updateParents(inFile, name, property);
                gen.writeEnd();
            }
            gen.writeEnd();
        }
    }

    private void updateParents(File inFile, String name, JsonObject property) {
        JsonObject items = property.getJsonObject("items");
        JsonObject typeObj = items == null ? property : items;
        JsonString refObj = typeObj.getJsonString("$ref");
        if (refObj != null) {
            String ref = refObj.getString();
            ParentRef parentRefs = this.parents.get(ref);
            if (parentRefs == null) {
                parentRefs = new ParentRef(name);
                this.parents.put(ref, parentRefs);
            }
            parentRefs.schemas.add(inFile.getName());
        }
    }

    private class ParentRef {
        String property;
        List<String> schemas = new ArrayList<String>(2);

        public ParentRef(String property) {
            this.property = property;
        }
    }
}

