/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.tool.json2rst;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import jakarta.json.JsonValue;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.dcm4che3.tool.common.CLIUtils;

public class Json2Rst {
    private static final ResourceBundle rb = ResourceBundle.getBundle("org.dcm4che3.tool.json2rst.messages");
    private static final String UNDERLINE = "===============================================================";
    private final File indir;
    private final File outdir;
    private String tabularColumns = "|p{4cm}|l|p{8cm}|";
    private final LinkedList<File> inFiles = new LinkedList();
    private final HashSet<String> totRefs = new HashSet();

    public Json2Rst(File inFile, File outdir) {
        this.indir = inFile.getParentFile();
        this.outdir = outdir;
        this.inFiles.add(inFile);
    }

    public void setTabularColumns(String tabularColumns) {
        this.tabularColumns = tabularColumns;
    }

    private static CommandLine parseCommandLine(String[] args) throws ParseException {
        Options opts = new Options();
        CLIUtils.addCommonOptions((Options)opts);
        return CLIUtils.parseComandLine((String[])args, (Options)opts, (ResourceBundle)rb, Json2Rst.class);
    }

    public static void main(String[] args) throws Exception {
        try {
            CommandLine cl = Json2Rst.parseCommandLine(args);
            List argList = cl.getArgList();
            Json2Rst json2Rst = new Json2Rst(new File((String)argList.get(0)), new File((String)argList.get(1)));
            if (argList.size() > 2) {
                json2Rst.setTabularColumns((String)argList.get(2));
            }
            json2Rst.process();
        }
        catch (ParseException e) {
            System.err.println("json2rst: " + e.getMessage());
            System.err.println(rb.getString("try"));
            System.exit(2);
        }
        catch (Exception e) {
            System.err.println("json2rst: " + e.getMessage());
            e.printStackTrace();
            System.exit(2);
        }
    }

    private void process() throws IOException {
        while (!this.inFiles.isEmpty()) {
            this.transform(this.inFiles.remove());
        }
    }

    private void transform(File inFile) throws IOException {
        String outFileName = inFile.getName().replace(".schema.json", ".rst");
        File outFile = new File(this.outdir, outFileName);
        System.out.println(inFile + " => " + outFile);
        try (InputStreamReader is = new InputStreamReader(new FileInputStream(inFile));
             PrintStream out = new PrintStream(new FileOutputStream(outFile));){
            JsonReader reader = Json.createReader((Reader)is);
            this.writeTo(reader.readObject(), out, outFileName);
        }
    }

    private void writeTo(JsonObject doc, PrintStream out, String outFileName) throws IOException {
        this.writeHeader(doc, out, outFileName);
        ArrayList<String> refs = new ArrayList<String>();
        this.writePropertiesTo(doc, out, refs);
        if (!refs.isEmpty()) {
            this.writeTocTree(refs, out);
        }
    }

    private void writeHeader(JsonObject doc, PrintStream out, String outFileName) {
        String title = doc.getString("title");
        out.println(title);
        out.println(UNDERLINE.substring(0, title.length()));
        out.println(doc.getString("description"));
        out.println();
        out.print(".. tabularcolumns:: ");
        out.println(this.tabularColumns);
        out.print(".. csv-table:: ");
        out.print(title);
        out.print(" Attributes (LDAP Object: ");
        int endIndex = outFileName.length() - 4;
        if (outFileName.startsWith("hl7") || outFileName.startsWith("dcm")) {
            out.print(outFileName.substring(0, endIndex));
        } else if (outFileName.startsWith("id")) {
            out.print("dcmID");
            out.print(outFileName.substring(2, endIndex));
        } else {
            out.print(this.isDefinedByDicom(outFileName) ? "dicom" : "dcm");
            out.print(Character.toUpperCase(outFileName.charAt(0)));
            out.print(outFileName.substring(1, endIndex));
        }
        out.println(')');
        out.println("    :header: Name, Type, Description (LDAP Attribute)");
        out.println("    :widths: 23, 7, 70");
        out.println();
    }

    private boolean isDefinedByDicom(String outFileName) {
        switch (outFileName) {
            case "device.rst": 
            case "networkAE.rst": 
            case "networkConnection.rst": 
            case "transferCapability.rst": {
                return true;
            }
        }
        return false;
    }

    private void writeTocTree(ArrayList<String> refs, PrintStream out) {
        out.println();
        out.println(".. toctree::");
        out.println();
        for (String ref : refs) {
            out.print("    ");
            out.println(ref.substring(0, ref.length() - 12));
        }
    }

    private void writePropertiesTo(JsonObject doc, PrintStream out, ArrayList<String> refs) throws IOException {
        JsonObject properties = doc.getJsonObject("properties");
        for (String name : properties.keySet()) {
            JsonObject property = properties.getJsonObject(name);
            if (property.containsKey((Object)"properties")) {
                this.writePropertiesTo(property, out, refs);
                continue;
            }
            this.writePropertyTo(property, name, out, refs);
        }
    }

    private void writePropertyTo(JsonObject property, String name, PrintStream out, ArrayList<String> refs) throws IOException {
        JsonObject items = property.getJsonObject("items");
        JsonObject typeObj = items == null ? property : items;
        out.print("    \"");
        boolean isObj = typeObj.containsKey((Object)"$ref");
        if (isObj) {
            String ref = typeObj.getString("$ref");
            out.print(":doc:`");
            out.print(ref.substring(0, ref.length() - 12));
            out.print("` ");
            if (items != null) {
                out.print("(s)");
            }
            if (this.totRefs.add(ref)) {
                refs.add(ref);
                this.inFiles.add(new File(this.indir, ref));
            }
        } else {
            out.println();
            out.print("    .. _");
            out.print(name);
            out.println(':');
            out.println();
            out.print("    :ref:`");
            out.print(property.getString("title"));
            if (items != null) {
                out.print("(s)");
            }
            out.print(" <");
            out.print(name);
            out.print(">`");
        }
        out.print("\",");
        out.print(isObj ? "object" : typeObj.getString("type"));
        out.print(",\"");
        out.print(this.ensureNoUndefinedSubstitutionReferenced(this.formatURL(property.getString("description")).replace("\"", "\"\"").replaceAll("<br>", "\n\n\t").replaceAll("\\(hover on options to see their descriptions\\)", "")));
        JsonArray anEnum = typeObj.getJsonArray("enum");
        if (anEnum != null) {
            out.println();
            out.println();
            out.print("    ");
            out.print("Enumerated values:");
            int last = anEnum.size() - 1;
            for (int i = 0; i <= last; ++i) {
                out.println();
                out.println();
                out.print("    ");
                String enumOption = ((JsonValue)anEnum.get(i)).toString().replace("\"", "");
                out.print(enumOption.contains("|") ? enumOption.replaceAll("\\|", " (= ") + ")" : enumOption);
            }
        }
        if (!isObj) {
            out.println();
            out.println();
            out.print("    (");
            out.print(name);
            out.print(')');
        }
        out.println('\"');
    }

    private String formatURL(String desc) {
        int urlIndex = desc.indexOf("<a href");
        if (urlIndex == -1) {
            return desc;
        }
        String url = desc.substring(urlIndex + 9, desc.indexOf("\" target"));
        String placeholder = desc.substring(desc.indexOf("target=\"_blank\">") + 16, desc.indexOf("</a>"));
        String desc2 = desc.substring(0, urlIndex) + '`' + placeholder + " <" + url + ">`_" + desc.substring(desc.indexOf("</a>") + 4);
        return desc2.contains("<a href") ? this.formatURL(desc2) : desc2;
    }

    private String ensureNoUndefinedSubstitutionReferenced(String desc) {
        if (!desc.contains("|")) {
            return desc;
        }
        StringBuffer sb = new StringBuffer(desc.length());
        Matcher matcher = Pattern.compile(" \\|([^ ]*?)\\|").matcher(desc);
        while (matcher.find()) {
            matcher.appendReplacement(sb, " `|" + matcher.group(1) + "|`");
        }
        matcher.appendTail(sb);
        return sb.toString();
    }
}

