/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.tool.maskpxdata;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.BulkData;
import org.dcm4che3.data.VR;
import org.dcm4che3.io.DicomInputStream;
import org.dcm4che3.tool.common.CLIUtils;
import org.dcm4che3.util.ByteUtils;

public class MaskPxData {
    private static ResourceBundle rb = ResourceBundle.getBundle("org.dcm4che3.tool.maskpxdata.messages");
    private final int pxval;
    private final int[] regions;
    private int updated;
    private int skipped;
    private int failed;

    public MaskPxData(int pxval, int[] regions) {
        this.pxval = pxval;
        this.regions = regions;
    }

    public static void main(String[] args) {
        try {
            CommandLine cl = MaskPxData.parseComandLine(args);
            List argList = cl.getArgList();
            if (argList.isEmpty()) {
                throw new ParseException(rb.getString("missing"));
            }
            MaskPxData inst = new MaskPxData(MaskPxData.toPxVal(cl.getOptionValue("pxval")), MaskPxData.toRegions(cl.getOptionValues("r")));
            long start = System.currentTimeMillis();
            for (String arg : argList) {
                inst.processFileOrDirectory(new File(arg));
            }
            long stop = System.currentTimeMillis();
            System.out.println();
            MaskPxData.log(inst.updated, " files updated");
            MaskPxData.log(inst.skipped, " files skipped");
            MaskPxData.log(inst.failed, " files failed to update");
            System.out.println("in " + (stop - start) + " ms");
        }
        catch (ParseException e) {
            System.err.println("maskpxdata: " + e.getMessage());
            System.err.println(rb.getString("try"));
            System.exit(2);
        }
        catch (Exception e) {
            System.err.println("maskpxdata: " + e.getMessage());
            e.printStackTrace();
            System.exit(2);
        }
    }

    private static int[] toRegions(String[] ss) throws ParseException {
        if (ss == null) {
            throw new ParseException("Missing option: r");
        }
        if (ss.length % 4 != 0) {
            throw new ParseException("Missing argument for option: r");
        }
        int[] regions = new int[ss.length];
        try {
            for (int i = 0; i < regions.length; ++i) {
                regions[i] = Integer.parseUnsignedInt(ss[i]);
            }
        }
        catch (NumberFormatException e) {
            throw new ParseException("Invalid argument for option: r");
        }
        return regions;
    }

    private static int toPxVal(String s) throws ParseException {
        try {
            return s != null ? (s.charAt(0) == '#' ? Integer.parseInt(s.substring(1), 16) : Integer.parseInt(s)) : 0;
        }
        catch (NumberFormatException e) {
            throw new ParseException("Missing argument for option: pxval");
        }
    }

    private static CommandLine parseComandLine(String[] args) throws ParseException {
        Options opts = new Options();
        opts.addOption(Option.builder((String)"r").longOpt("region").hasArgs().valueSeparator(',').type(Number.class).argName("x>,<y>,<w>,<h").desc(rb.getString("region")).build());
        opts.addOption(null, "pxval", true, rb.getString("pxval"));
        CLIUtils.addCommonOptions((Options)opts);
        return CLIUtils.parseComandLine((String[])args, (Options)opts, (ResourceBundle)rb, MaskPxData.class);
    }

    private static void log(int n, String suffix) {
        if (n > 0) {
            System.out.println(n + suffix);
        }
    }

    private void processFileOrDirectory(File fileOrDir) {
        if (fileOrDir.isDirectory()) {
            for (File fileOrSubDir : fileOrDir.listFiles()) {
                this.processFileOrDirectory(fileOrSubDir);
            }
        } else {
            System.out.print(this.processFile(fileOrDir));
        }
    }

    private char processFile(File file) {
        try {
            Attributes attrs;
            boolean bigEndian;
            try (DicomInputStream is = new DicomInputStream(file);){
                is.setIncludeBulkData(DicomInputStream.IncludeBulkData.URI);
                Attributes fmi = is.readFileMetaInformation();
                bigEndian = fmi != null && "1.2.840.10008.1.2.2".equals(fmi.getString(131088));
                attrs = is.readDataset();
            }
            VR.Holder vr = new VR.Holder();
            Object value = attrs.getValue(2145386512, vr);
            if (value instanceof BulkData) {
                try (RandomAccessFile raf = new RandomAccessFile(file, "rw");){
                    this.maskPxData(raf, bigEndian, attrs, (BulkData)value);
                }
                ++this.updated;
                return '.';
            }
            ++this.skipped;
            return value == null ? (char)'p' : 'c';
        }
        catch (IOException e) {
            System.err.println("Failed to update " + file + ':');
            e.printStackTrace(System.err);
            ++this.failed;
            return 'E';
        }
    }

    private void maskPxData(RandomAccessFile raf, boolean bigEndian, Attributes attrs, BulkData bulkData) throws IOException {
        int rows = attrs.getInt(2621456, 0);
        int columns = attrs.getInt(2621457, 0);
        int frames = attrs.getInt(0x280008, 1);
        int samples = attrs.getInt(0x280002, 1);
        int planeSize = rows * columns;
        int bytesAllocated = attrs.getInt(2621696, 16) / 8;
        int planarConfig = attrs.getInt(2621446, 0);
        Mask mask = samples == 3 ? (planarConfig == 0 ? this::maskColorByPixel : this::maskColorByPlane) : (bytesAllocated == 1 ? this::maskByte : this::maskWord);
        int frameSize = planeSize * samples * bytesAllocated;
        byte[] b = new byte[frameSize];
        for (int f = 0; f < frames; ++f) {
            long pos = bulkData.offset() + (long)(f * frameSize);
            raf.seek(pos);
            raf.readFully(b);
            for (int i = 0; i < this.regions.length; i += 4) {
                for (int j = 0; j < this.regions[i + 3]; ++j) {
                    int off = (j + this.regions[i + 1]) * columns + this.regions[i];
                    for (int k = 0; k < this.regions[i + 2]; ++k) {
                        mask.apply(b, off + k, bigEndian, planeSize);
                    }
                }
            }
            raf.seek(pos);
            raf.write(b);
        }
    }

    private void maskByte(byte[] b, int off, boolean bigEndian, int planeSize) {
        b[off] = (byte)this.pxval;
    }

    private void maskWord(byte[] b, int off, boolean bigEndian, int planeSize) {
        ByteUtils.shortToBytes((int)this.pxval, (byte[])b, (int)(off * 2), (boolean)bigEndian);
    }

    private void maskColor(byte[] b, int i, int d) {
        b[i] = (byte)(this.pxval >> 16);
        b[i += d] = (byte)(this.pxval >> 8);
        b[i + d] = (byte)this.pxval;
    }

    private void maskColorByPixel(byte[] b, int off, boolean bigEndian, int planeSize) {
        this.maskColor(b, off * 3, 1);
    }

    private void maskColorByPlane(byte[] b, int off, boolean bigEndian, int planeSize) {
        this.maskColor(b, off, planeSize);
    }

    static interface Mask {
        public void apply(byte[] var1, int var2, boolean var3, int var4);
    }
}

