/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.tool.movescu;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.text.MessageFormat;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.ElementDictionary;
import org.dcm4che3.data.VR;
import org.dcm4che3.io.DicomInputStream;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.net.Association;
import org.dcm4che3.net.Connection;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.DimseRSPHandler;
import org.dcm4che3.net.IncompatibleConnectionException;
import org.dcm4che3.net.pdu.AAssociateRQ;
import org.dcm4che3.net.pdu.ExtendedNegotiation;
import org.dcm4che3.net.pdu.PresentationContext;
import org.dcm4che3.tool.common.CLIUtils;
import org.dcm4che3.util.SafeClose;

public class MoveSCU
extends Device {
    private static ResourceBundle rb = ResourceBundle.getBundle("org.dcm4che3.tool.movescu.messages");
    private static final int[] DEF_IN_FILTER = new int[]{524312, 0x20000D, 0x20000E};
    private final ApplicationEntity ae = new ApplicationEntity("MOVESCU");
    private final Connection conn = new Connection();
    private final Connection remote = new Connection();
    private final AAssociateRQ rq = new AAssociateRQ();
    private int priority;
    private String destination;
    private InformationModel model;
    private Attributes keys = new Attributes();
    private int[] inFilter = DEF_IN_FILTER;
    private Association as;
    private int cancelAfter;
    private boolean releaseEager;
    private ScheduledFuture<?> scheduledCancel;

    public MoveSCU() throws IOException {
        super("movescu");
        this.addConnection(this.conn);
        this.addApplicationEntity(this.ae);
        this.ae.addConnection(this.conn);
    }

    public final void setPriority(int priority) {
        this.priority = priority;
    }

    public void setCancelAfter(int cancelAfter) {
        this.cancelAfter = cancelAfter;
    }

    public void setReleaseEager(boolean releaseEager) {
        this.releaseEager = releaseEager;
    }

    public final void setInformationModel(InformationModel model, String[] tss, boolean relational) {
        this.model = model;
        this.rq.addPresentationContext(new PresentationContext(1, model.cuid, tss));
        if (relational) {
            this.rq.addExtendedNegotiation(new ExtendedNegotiation(model.cuid, new byte[]{1}));
        }
        if (model.level != null) {
            this.addLevel(model.level);
        }
    }

    public void addLevel(String s) {
        this.keys.setString(524370, VR.CS, s);
    }

    public final void setDestination(String destination) {
        this.destination = destination;
    }

    public void addKey(int tag, String ... ss) {
        VR vr = ElementDictionary.vrOf((int)tag, (String)this.keys.getPrivateCreator(tag));
        this.keys.setString(tag, vr, ss);
    }

    public final void setInputFilter(int[] inFilter) {
        this.inFilter = inFilter;
    }

    private static CommandLine parseComandLine(String[] args) throws ParseException {
        Options opts = new Options();
        MoveSCU.addServiceClassOptions(opts);
        MoveSCU.addKeyOptions(opts);
        MoveSCU.addRetrieveLevelOption(opts);
        MoveSCU.addDestinationOption(opts);
        MoveSCU.addCancelAfterOption(opts);
        MoveSCU.addRetrieveEagerOption(opts);
        CLIUtils.addConnectOption((Options)opts);
        CLIUtils.addBindClientOption((Options)opts, (String)"MOVESCU");
        CLIUtils.addAEOptions((Options)opts);
        CLIUtils.addSendTimeoutOption((Options)opts);
        CLIUtils.addRetrieveTimeoutOption((Options)opts);
        CLIUtils.addPriorityOption((Options)opts);
        CLIUtils.addCommonOptions((Options)opts);
        return CLIUtils.parseComandLine((String[])args, (Options)opts, (ResourceBundle)rb, MoveSCU.class);
    }

    private static void addRetrieveLevelOption(Options opts) {
        opts.addOption(Option.builder((String)"L").hasArg().argName("PATIENT|STUDY|SERIES|IMAGE|FRAME").desc(rb.getString("level")).build());
    }

    private static void addDestinationOption(Options opts) {
        opts.addOption(Option.builder().longOpt("dest").hasArg().argName("aet").desc(rb.getString("dest")).build());
    }

    private static void addCancelAfterOption(Options opts) {
        opts.addOption(Option.builder().hasArg().argName("ms").desc(rb.getString("cancel-after")).longOpt("cancel-after").build());
    }

    private static void addRetrieveEagerOption(Options opts) {
        opts.addOption(null, "release-eager", false, rb.getString("release-eager"));
    }

    private static void addKeyOptions(Options opts) {
        opts.addOption(Option.builder((String)"m").hasArgs().argName("[seq.]attr=value").desc(rb.getString("match")).build());
        opts.addOption(Option.builder((String)"i").hasArgs().argName("attr").desc(rb.getString("in-attr")).build());
    }

    private static void addServiceClassOptions(Options opts) {
        opts.addOption(Option.builder((String)"M").hasArg().argName("name").desc(rb.getString("model")).build());
        CLIUtils.addTransferSyntaxOptions((Options)opts);
        opts.addOption(null, "relational", false, rb.getString("relational"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            CommandLine cl = MoveSCU.parseComandLine(args);
            MoveSCU main = new MoveSCU();
            CLIUtils.configureConnect((Connection)main.remote, (AAssociateRQ)main.rq, (CommandLine)cl);
            CLIUtils.configureBind((Connection)main.conn, (ApplicationEntity)main.ae, (CommandLine)cl);
            CLIUtils.configure((Connection)main.conn, (CommandLine)cl);
            main.remote.setTlsProtocols(main.conn.getTlsProtocols());
            main.remote.setTlsCipherSuites(main.conn.getTlsCipherSuites());
            MoveSCU.configureServiceClass(main, cl);
            MoveSCU.configureKeys(main, cl);
            main.setPriority(CLIUtils.priorityOf((CommandLine)cl));
            main.setDestination(MoveSCU.destinationOf(cl));
            main.setCancelAfter(CLIUtils.getIntOption((CommandLine)cl, (String)"cancel-after", (int)0));
            main.setReleaseEager(cl.hasOption("release-eager"));
            ExecutorService executorService = Executors.newSingleThreadExecutor();
            ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
            main.setExecutor(executorService);
            main.setScheduledExecutor(scheduledExecutorService);
            try {
                main.open();
                List argList = cl.getArgList();
                if (argList.isEmpty()) {
                    main.retrieve();
                } else {
                    for (String arg : argList) {
                        main.retrieve(new File(arg));
                    }
                }
            }
            finally {
                main.close();
                executorService.shutdown();
                scheduledExecutorService.shutdown();
            }
        }
        catch (ParseException e) {
            System.err.println("movescu: " + e.getMessage());
            System.err.println(rb.getString("try"));
            System.exit(2);
        }
        catch (Exception e) {
            System.err.println("movescu: " + e.getMessage());
            e.printStackTrace();
            System.exit(2);
        }
    }

    private static void configureServiceClass(MoveSCU main, CommandLine cl) throws ParseException {
        main.setInformationModel(MoveSCU.informationModelOf(cl), CLIUtils.transferSyntaxesOf((CommandLine)cl), cl.hasOption("relational"));
    }

    private static String destinationOf(CommandLine cl) throws ParseException {
        if (cl.hasOption("dest")) {
            return cl.getOptionValue("dest");
        }
        throw new ParseException(rb.getString("missing-dest"));
    }

    private static void configureKeys(MoveSCU main, CommandLine cl) {
        CLIUtils.addAttributes((Attributes)main.keys, (String[])cl.getOptionValues("m"));
        if (cl.hasOption("L")) {
            main.addLevel(cl.getOptionValue("L"));
        }
        if (cl.hasOption("i")) {
            main.setInputFilter(CLIUtils.toTags((String[])cl.getOptionValues("i")));
        }
    }

    private static InformationModel informationModelOf(CommandLine cl) throws ParseException {
        try {
            return cl.hasOption("M") ? InformationModel.valueOf(cl.getOptionValue("M")) : InformationModel.StudyRoot;
        }
        catch (IllegalArgumentException e) {
            throw new ParseException(MessageFormat.format(rb.getString("invalid-model-name"), cl.getOptionValue("M")));
        }
    }

    public void open() throws IOException, InterruptedException, IncompatibleConnectionException, GeneralSecurityException {
        this.as = this.ae.connect(this.conn, this.remote, this.rq);
    }

    public void close() throws IOException, InterruptedException {
        if (this.scheduledCancel != null && this.releaseEager) {
            return;
        }
        if (this.as != null && this.as.isReadyForDataTransfer()) {
            if (!this.releaseEager) {
                this.as.waitForOutstandingRSP();
            }
            this.as.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retrieve(File f) throws IOException, InterruptedException {
        Attributes attrs = new Attributes();
        Closeable dis = null;
        try {
            attrs.addSelected(new DicomInputStream(f).readDataset(), this.inFilter);
        }
        finally {
            SafeClose.close(dis);
        }
        attrs.addAll(this.keys);
        this.retrieve(attrs);
    }

    public void retrieve() throws IOException, InterruptedException {
        this.retrieve(this.keys);
    }

    private void retrieve(Attributes keys) throws IOException, InterruptedException {
        final DimseRSPHandler rspHandler = new DimseRSPHandler(this.as.nextMessageID()){

            public void onDimseRSP(Association as, Attributes cmd, Attributes data) {
                super.onDimseRSP(as, cmd, data);
            }
        };
        this.as.cmove(this.model.cuid, this.priority, keys, null, this.destination, rspHandler);
        if (this.cancelAfter > 0) {
            this.scheduledCancel = this.schedule(new Runnable(){

                @Override
                public void run() {
                    try {
                        rspHandler.cancel(MoveSCU.this.as);
                        if (MoveSCU.this.releaseEager) {
                            MoveSCU.this.as.release();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }, this.cancelAfter, TimeUnit.MILLISECONDS);
        }
    }

    private static enum InformationModel {
        PatientRoot("1.2.840.10008.5.1.4.1.2.1.2", "STUDY"),
        StudyRoot("1.2.840.10008.5.1.4.1.2.2.2", "STUDY"),
        PatientStudyOnly("1.2.840.10008.5.1.4.1.2.3.2", "STUDY"),
        CompositeInstanceRoot("1.2.840.10008.5.1.4.1.2.4.2", "IMAGE"),
        HangingProtocol("1.2.840.10008.5.1.4.38.3", null),
        ColorPalette("1.2.840.10008.5.1.4.39.3", null);

        final String cuid;
        final String level;

        private InformationModel(String cuid, String level) {
            this.cuid = cuid;
            this.level = level;
        }
    }
}

