/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.tool.planarconfig;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.ResourceBundle;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.BulkData;
import org.dcm4che3.data.Fragments;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.data.VR;
import org.dcm4che3.image.YBR;
import org.dcm4che3.io.DicomInputHandler;
import org.dcm4che3.io.DicomInputStream;
import org.dcm4che3.tool.common.CLIUtils;

public class PlanarConfig
implements Closeable {
    private static final ResourceBundle rb = ResourceBundle.getBundle("org.dcm4che3.tool.planarconfig.messages");
    private static final char[] CORRECT_CH = new char[]{'0', '1'};
    private static final char[] WRONG_CH = new char[]{'O', 'I'};
    private final boolean uids;
    private final boolean[] fix;
    private final boolean verbose;
    private final float min3x3;
    private final float max3x3;
    private PrintWriter uidslog;
    private int[] correct = new int[2];
    private int[] wrong = new int[2];
    private int skipped;
    private int failed;

    public PlanarConfig(boolean uids, boolean verbose, float min3x3, float max3x3, boolean ... fix) {
        this.uids = uids;
        this.verbose = verbose;
        this.min3x3 = min3x3;
        this.max3x3 = max3x3;
        this.fix = fix;
    }

    private static CommandLine parseCommandLine(String[] args) throws ParseException {
        Options opts = new Options();
        opts.addOption(Option.builder().argName("uids").longOpt("uids").desc(rb.getString("uids")).build());
        opts.addOption(Option.builder().hasArgs().argName("MIN> <MAX").longOpt("3x3").desc(rb.getString("3x3")).build());
        opts.addOption(Option.builder().argName("fix").longOpt("fix").desc(rb.getString("fix")).build());
        opts.addOption(Option.builder().argName("fix0").longOpt("fix0").desc(rb.getString("fix0")).build());
        opts.addOption(Option.builder().argName("fix1").longOpt("fix1").desc(rb.getString("fix1")).build());
        opts.addOption(Option.builder((String)"v").argName("v").desc(rb.getString("v")).build());
        CLIUtils.addCommonOptions((Options)opts);
        return CLIUtils.parseComandLine((String[])args, (Options)opts, (ResourceBundle)rb, PlanarConfig.class);
    }

    public static void main(String[] args1) {
        boolean uids = false;
        boolean verbose = false;
        boolean fix0 = false;
        boolean fix1 = false;
        float min3x3 = 10.0f;
        float max3x3 = 20.0f;
        try {
            CommandLine cl = PlanarConfig.parseCommandLine(args1);
            String[] args = cl.getArgs();
            block28: for (int firstArg = 0; args.length > firstArg; ++firstArg) {
                switch (args[firstArg]) {
                    case "--uids": {
                        uids = true;
                        continue block28;
                    }
                    case "-v": {
                        verbose = true;
                        continue block28;
                    }
                    case "--3x3": {
                        try {
                            min3x3 = Float.parseFloat(args[++firstArg]);
                            max3x3 = Float.parseFloat(args[++firstArg]);
                            if (!(max3x3 < min3x3)) continue block28;
                            min3x3 = -1.0f;
                        }
                        catch (Exception e) {
                            min3x3 = -1.0f;
                        }
                        continue block28;
                    }
                    case "--fix": {
                        fix0 = true;
                        fix1 = true;
                        continue block28;
                    }
                    case "--fix0": {
                        fix0 = true;
                        continue block28;
                    }
                    case "--fix1": {
                        fix1 = true;
                        continue block28;
                    }
                }
            }
            if (uids && new File("uids.log").exists()) {
                System.out.println("uids.log already exists");
                System.exit(-1);
            }
            try (PlanarConfig inst = new PlanarConfig(uids, verbose, min3x3, max3x3, fix0, fix1);){
                long start = System.currentTimeMillis();
                for (int i = firstArg; i < args.length; ++i) {
                    inst.processFileOrDirectory(new File(args[i]));
                }
                long stop = System.currentTimeMillis();
                System.out.println();
                System.out.println("Processed");
                PlanarConfig.log(inst.correct[0], " files with color-by-pixel Planar Configuration with matching attribute value 0");
                PlanarConfig.log(inst.wrong[0], " files with color-by-pixel Planar Configuration with non-matching attribute value 1 (fixed=" + fix0 + ')');
                PlanarConfig.log(inst.correct[1], " files with color-by-plane Planar Configuration with matching attribute value 1");
                PlanarConfig.log(inst.wrong[1], " files with color-by-plane Planar Configuration with non-matching attribute value 0 (fixed=" + fix1 + ')');
                PlanarConfig.log(inst.skipped, " files skipped");
                PlanarConfig.log(inst.failed, " files failed to process");
                System.out.println("in " + (stop - start) + " ms");
                if (inst.uidslog != null) {
                    System.out.println("created uids.log");
                }
            }
            catch (IOException e) {
                System.err.println("Failed to close uids.log:\n");
                e.printStackTrace(System.err);
            }
        }
        catch (ParseException e) {
            System.err.println("planarconfig: " + e.getMessage());
            System.err.println(rb.getString("try"));
            System.exit(2);
        }
        catch (Exception e) {
            System.err.println("planarconfig: " + e.getMessage());
            e.printStackTrace();
            System.exit(2);
        }
    }

    private static void log(int n, String suffix) {
        if (n > 0) {
            System.out.println(n + suffix);
        }
    }

    private void processFileOrDirectory(File fileOrDir) {
        if (fileOrDir.isDirectory()) {
            for (File fileOrSubDir : fileOrDir.listFiles()) {
                this.processFileOrDirectory(fileOrSubDir);
            }
        } else {
            System.out.print(this.processFile(fileOrDir));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private char processFile(File file) {
        try {
            int pc;
            ColorPMI colorPMI;
            Attributes dataset;
            WritePlanarConfiguration writePlanarConfiguration = new WritePlanarConfiguration();
            try (DicomInputStream is = new DicomInputStream(file);){
                is.setIncludeBulkData(DicomInputStream.IncludeBulkData.URI);
                is.setDicomInputHandler((DicomInputHandler)writePlanarConfiguration);
                dataset = is.readDataset();
            }
            VR.Holder vr = new VR.Holder();
            Object value = dataset.getValue(2145386512, vr);
            if (value == null) {
                ++this.skipped;
                return 'p';
            }
            try {
                colorPMI = ColorPMI.valueOf(dataset.getString(2621444));
            }
            catch (IllegalArgumentException e) {
                ++this.skipped;
                return 'm';
            }
            if (!(value instanceof BulkData)) {
                ++this.skipped;
                return 'c';
            }
            try (RandomAccessFile raf = new RandomAccessFile(file, "rw");){
                pc = this.planarConfiguration(file, raf, (BulkData)value, dataset, colorPMI);
                if (pc == dataset.getInt(2621446, 0)) {
                    int n = pc;
                    this.correct[n] = this.correct[n] + 1;
                    char c = CORRECT_CH[pc];
                    return c;
                }
                if (this.fix[pc]) {
                    writePlanarConfiguration.writeTo(raf, pc);
                }
            }
            int n = pc;
            this.wrong[n] = this.wrong[n] + 1;
            if (!this.uids) return WRONG_CH[pc];
            if (!this.fix[pc]) {
                if (this.fix[1 - pc]) return WRONG_CH[pc];
            }
            this.uidslog().println(dataset.getString(524312));
            return WRONG_CH[pc];
        }
        catch (IOException e) {
            System.err.println("Failed to update " + file + ':');
            e.printStackTrace(System.err);
            ++this.failed;
            return 'E';
        }
    }

    private PrintWriter uidslog() throws IOException {
        if (this.uidslog == null) {
            this.uidslog = new PrintWriter("uids.log");
        }
        return this.uidslog;
    }

    private int planarConfiguration(File file, RandomAccessFile raf, BulkData bulkData, Attributes dataset, ColorPMI colorPMI) throws IOException {
        int diffPlanarConfig;
        byte[] b = new byte[bulkData.length()];
        raf.seek(bulkData.offset());
        raf.readFully(b);
        int rows = dataset.getInt(2621456, 1);
        int cols = dataset.getInt(2621457, 1);
        int plane = rows * cols;
        int plane2 = plane * 2;
        int[][] prevSamples = new int[][]{{b[0] & 0xFF, b[1] & 0xFF, b[2] & 0xFF}, {b[0] & 0xFF, b[plane] & 0xFF, b[plane2] & 0xFF}};
        long chromaPerPixel = colorPMI.chroma(prevSamples[0]);
        long chromaPerPlane = colorPMI.chroma(prevSamples[1]);
        long diffPerPixel = 0L;
        long diffPerPlane = 0L;
        for (int i = 1; i < plane; ++i) {
            int i3 = i * 3;
            int[] perPixel = new int[]{b[i3] & 0xFF, b[i3 + 1] & 0xFF, b[i3 + 2] & 0xFF};
            int[] perPlane = new int[]{b[i] & 0xFF, b[i + plane] & 0xFF, b[i + plane2] & 0xFF};
            chromaPerPixel += (long)colorPMI.chroma(perPixel);
            chromaPerPlane += (long)colorPMI.chroma(perPlane);
            if (!colorPMI.isWhite(prevSamples[0]) && !colorPMI.isWhite(prevSamples[0])) {
                diffPerPixel += (long)Math.abs(perPixel[0] - prevSamples[0][0]);
                diffPerPixel += (long)Math.abs(perPixel[1] - prevSamples[0][1]);
                diffPerPixel += (long)Math.abs(perPixel[2] - prevSamples[0][2]);
            }
            if (!colorPMI.isWhite(prevSamples[1]) && !colorPMI.isWhite(prevSamples[1])) {
                diffPerPlane += (long)Math.abs(perPlane[0] - prevSamples[1][0]);
                diffPerPlane += (long)Math.abs(perPlane[1] - prevSamples[1][1]);
                diffPerPlane += (long)Math.abs(perPlane[2] - prevSamples[1][2]);
            }
            prevSamples[0] = perPixel;
            prevSamples[1] = perPlane;
        }
        int chromaPlanarConfig = chromaPerPixel > chromaPerPlane ? 1 : 0;
        int n = diffPlanarConfig = diffPerPixel > diffPerPlane ? 1 : 0;
        if (!this.verbose && chromaPlanarConfig == diffPlanarConfig) {
            return diffPlanarConfig;
        }
        long minChroma = Math.min(chromaPerPixel, chromaPerPlane);
        long maxChroma = Math.max(chromaPerPixel, chromaPerPlane);
        long minDiff = Math.min(diffPerPixel, diffPerPlane);
        long maxDiff = Math.max(diffPerPixel, diffPerPlane);
        int cols2 = cols * 2;
        int cols3 = cols * 3;
        long diff9 = 0L;
        int r3 = rows / 3;
        int c3 = cols / 3;
        for (int r = 0; r < r3; ++r) {
            int i1 = r * cols3;
            int i2 = i1 + plane;
            int i3 = i2 + plane;
            for (int c = 0; c < c3; ++c) {
                diff9 += (long)this.diff3(b, i1++, cols, cols2);
                diff9 += (long)this.diff3(b, i1++, cols, cols2);
                diff9 += (long)this.diff3(b, i1++, cols, cols2);
                diff9 += (long)this.diff3(b, i2++, cols, cols2);
                diff9 += (long)this.diff3(b, i2++, cols, cols2);
                diff9 += (long)this.diff3(b, i2++, cols, cols2);
                diff9 += (long)this.diff3(b, i3++, cols, cols2);
                diff9 += (long)this.diff3(b, i3++, cols, cols2);
                diff9 += (long)this.diff3(b, i3++, cols, cols2);
            }
        }
        float diff9Float = (float)diff9 / (float)(c3 * r3 * 9);
        if (this.verbose) {
            float[] chroma = new float[]{(float)chromaPerPixel / (float)plane, (float)chromaPerPlane / (float)plane, 1.0f - (float)minChroma / (float)maxChroma};
            float[] diff = new float[]{(float)diffPerPixel / (float)plane, (float)diffPerPlane / (float)plane, 1.0f - (float)minDiff / (float)maxDiff};
            System.out.println();
            System.out.print(file + ": 3x3=" + diff9Float + ", chroma=" + Arrays.toString(chroma) + ", diff=" + Arrays.toString(diff) + " -> ");
        }
        if (chromaPlanarConfig == diffPlanarConfig) {
            return diffPlanarConfig;
        }
        if (diff9Float < this.min3x3) {
            return 1;
        }
        if (diff9Float > this.max3x3) {
            return 0;
        }
        return maxChroma * minDiff > minChroma * maxDiff ? chromaPlanarConfig : diffPlanarConfig;
    }

    private int diff3(byte[] b, int i, int cols, int cols2) {
        return PlanarConfig.diff3(b[i] & 0xFF, b[i + cols] & 0xFF, b[i + cols2] & 0xFF);
    }

    private static int diff3(int a, int b, int c) {
        return Math.max(Math.max(a, b), c) - Math.min(Math.min(a, b), c);
    }

    @Override
    public void close() throws IOException {
        if (this.uidslog != null) {
            this.uidslog.close();
        }
    }

    private static class WritePlanarConfiguration
    implements DicomInputHandler {
        Long pcPos;
        int shift;

        private WritePlanarConfiguration() {
        }

        public void readValue(DicomInputStream dis, Attributes attrs) throws IOException {
            if (dis.tag() == 2621446) {
                this.pcPos = dis.getPosition();
                this.shift = dis.bigEndian() ? 0 : 8;
            }
            dis.readValue(dis, attrs);
        }

        public void readValue(DicomInputStream dis, Sequence seq) throws IOException {
            dis.readValue(dis, seq);
        }

        public void readValue(DicomInputStream dis, Fragments frags) throws IOException {
            dis.readValue(dis, frags);
        }

        public void startDataset(DicomInputStream dis) throws IOException {
            dis.startDataset(dis);
        }

        public void endDataset(DicomInputStream dis) throws IOException {
            dis.endDataset(dis);
        }

        public void writeTo(RandomAccessFile raf, int pc) throws IOException {
            raf.seek(this.pcPos);
            raf.writeShort(pc << this.shift);
        }
    }

    private static enum ColorPMI {
        RGB{

            @Override
            boolean isWhite(int[] samples) {
                return samples[0] == 255 && samples[1] == 255 && samples[2] == 255;
            }
        }
        ,
        YBR_FULL{

            @Override
            boolean isWhite(int[] samples) {
                return samples[0] == 255 && samples[1] == 128 && samples[2] == 128;
            }

            @Override
            int chroma(int[] samples) {
                float[] ybr = new float[]{(float)samples[0] / 255.0f, (float)samples[1] / 255.0f, (float)samples[2] / 255.0f};
                float[] rgb = YBR.FULL.toRGB(ybr);
                return PlanarConfig.diff3((int)(rgb[0] * 255.0f), (int)(rgb[1] * 255.0f), (int)(rgb[2] * 255.0f));
            }
        };


        abstract boolean isWhite(int[] var1);

        int chroma(int[] samples) {
            return PlanarConfig.diff3(samples[0], samples[1], samples[2]);
        }
    }
}

